﻿using System;
using System.IO;
using System.Linq;
using CsvHelper;

namespace Curse.AGS.FileReaders
{
    public class CSVFileReader : IFileReader
    {
        public FileReaderResult<T> ReadFileDataFromStream<T>(Stream stream)
        {
            var result = new FileReaderResult<T>();
            try
            {
                using (var textReader = new StreamReader(stream))
                {
                    var csv = new CsvReader(textReader);
                    result.Result = csv.GetRecords<T>().ToArray();
                    result.Succeeded = true;
                }
            }
            catch (Exception ex)
            {
                result.Result = new T[0];
                result.Succeeded = false;
                result.Message = $"Error: {ex.Message}";
            }

            return result;
        }
    }
}
