﻿using System.Collections.Generic;
using System.Linq;
using Curse.AGS.Models;
using Curse.Cobalt.Data;
using Curse.Cobalt.Models;

namespace Curse.AGS.Forums
{
    public class ForumEmailMapRepository : IForumEmailMapRepository
    {
        public void DeleteForumEmailMapByID(int ID)
        {
            var map = AGSForumEmailMap.GetByID(ID);
            using(var conn = new CobaltDataConnection())
            {
                map?.Delete(conn);
            }
        }

        public void DeleteRoleEmailTriggerByID(int ID)
        {
            var map = AGSRoleEmailTrigger.GetByID(ID);
            using (var conn = new CobaltDataConnection())
            {
                map?.Delete(conn);
            }
        }

        public bool ForumHasEmailMapped(int forumID)
        {
            return AGSForumEmailMap.Query.Any(f => f.ForumID == forumID);
        }

        public AGSForumEmailMap GetForumEmailMap(int forumID)
        {
            return AGSForumEmailMap.Query.FirstOrDefault(f => f.ForumID == forumID);
        }

        public IEnumerable<Forum> GetForumsAvailableForMappingBySiteID(int siteID)
        {
            return Forum.GetQueryBySiteID(siteID)
                .Where(f => f.Status != ForumStatus.Deleted && !AGSForumEmailMap.Query.Any(m => m.ForumID == f.ID));
        }

        public IEnumerable<Role> GetRolesAvailableForMappingBySiteID(int siteID)
        {
            return (from f in Role.GetAllByEntityTypeIDAndEntityID(Site.ModelTypeID, siteID)
                where !AGSRoleEmailTrigger.Query.Any(m => m.RoleID == f.ID)
                select f);
        }

        public void SaveForumEmailMap(AGSForumEmailMap map)
        {
            using (var conn = new CobaltDataConnection())
            {
                map.Save(conn);
            }
        }

        public void SaveRoleEmailTrigger(AGSRoleEmailTrigger map)
        {
            using (var conn = new CobaltDataConnection())
            {
                map.Save(conn);
            }
        }
    }
}
