﻿using Curse.AGS.Models;
using Curse.Cobalt.Models;
using System.Collections.Generic;

namespace Curse.AGS.Forums
{
    public interface IForumEmailMapRepository
    {
        IEnumerable<Forum> GetForumsAvailableForMappingBySiteID(int siteID);
        IEnumerable<Role> GetRolesAvailableForMappingBySiteID(int siteID);
        void SaveForumEmailMap(AGSForumEmailMap map);
        void SaveRoleEmailTrigger(AGSRoleEmailTrigger map);
        void DeleteForumEmailMapByID(int ID);
        void DeleteRoleEmailTriggerByID(int ID);
        bool ForumHasEmailMapped(int forumID);
        AGSForumEmailMap GetForumEmailMap(int forumID);
    }
}
