﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Web;
using System.Text.RegularExpressions;
using System.Reflection;
using System.Linq.Expressions;

using Curse.Cobalt.Localization;
using Curse.Cobalt.Application;
using Curse.Cobalt.Extensions;
using Curse.Cobalt.Models;
using Curse.Cobalt.Utilities;
using Curse.Cobalt.Caching;

namespace Curse.AGS
{
	public sealed class L : LocalizationManager<L>
	{
		public L()
			: base(
				new Dictionary<string, Func<ILocalizationNamespace>>
				{
					{ "AGS", () => AGS },
					{ "ENUMS", () => Enums },
					{ "GLOBAL", () => Global },
					{ "NEWGLOBAL", () => NewGlobal },
				},
				new Dictionary<string, IDictionary<string, Func<ILocalizationSubNamespace>>>
				{
					{ "AGS", new Dictionary<string, Func<ILocalizationSubNamespace>>
						{
							{ "FOOTER", () => AGS.Footer },
						}
					},
					{ "ENUMS", new Dictionary<string, Func<ILocalizationSubNamespace>>
						{
							{ "DAYOFWEEK", () => Enums.DayOfWeek },
							{ "DISPLAYTYPE", () => Enums.DisplayType },
							{ "EACCOUNTRECOVERYSTATUS", () => Enums.EAccountRecoveryStatus },
							{ "FORUMTHREADASSOCIATIONTYPE", () => Enums.ForumThreadAssociationType },
							{ "FORUMTHREADDATERANGETYPE", () => Enums.ForumThreadDateRangeType },
							{ "FORUMTHREADMODERATIONACTION", () => Enums.ForumThreadModerationAction },
							{ "FORUMTHREADTYPE", () => Enums.ForumThreadType },
							{ "MARKUPTYPE", () => Enums.MarkupType },
							{ "NOTIFICATIONPREFERENCEGROUP", () => Enums.NotificationPreferenceGroup },
							{ "POLLTYPE", () => Enums.PollType },
							{ "SEARCHTYPE", () => Enums.SearchType },
							{ "TRANSLATIONREPORTREASON", () => Enums.TranslationReportReason },
							{ "USERTHROTTLEACTIONTYPE", () => Enums.UserThrottleActionType },
						}
					},
					{ "GLOBAL", new Dictionary<string, Func<ILocalizationSubNamespace>>
						{
							{ "ACCOUNT", () => Global.Account },
							{ "ACTIVITYLOG", () => Global.ActivityLog },
							{ "ANNOUNCEMENTS", () => Global.Announcements },
							{ "AUTHENTICATION", () => Global.Authentication },
							{ "BILLING", () => Global.Billing },
							{ "BUTTONS", () => Global.Buttons },
							{ "CAREER", () => Global.Career },
							{ "CMS", () => Global.CMS },
							{ "COMMENTS", () => Global.Comments },
							{ "COMMON", () => Global.Common },
							{ "CONTENTMANAGEMENT", () => Global.ContentManagement },
							{ "CONTROLPANEL", () => Global.ControlPanel },
							{ "COUNTRIES", () => Global.Countries },
							{ "DATES", () => Global.Dates },
							{ "DOMAINPOLICIES", () => Global.DomainPolicies },
							{ "EMOTES", () => Global.Emotes },
							{ "ERRORMESSAGES", () => Global.ErrorMessages },
							{ "FEEDBACK", () => Global.Feedback },
							{ "FILES", () => Global.Files },
							{ "FOOTER", () => Global.Footer },
							{ "FORUMS", () => Global.Forums },
							{ "GALLERY", () => Global.Gallery },
							{ "GAME", () => Global.Game },
							{ "GENDERS", () => Global.Genders },
							{ "GROUPS", () => Global.Groups },
							{ "INFRACTIONS", () => Global.Infractions },
							{ "JOBS", () => Global.Jobs },
							{ "KEYWORDS", () => Global.Keywords },
							{ "LANGUAGES", () => Global.Languages },
							{ "LISTINGS", () => Global.Listings },
							{ "MAILTEMPLATES", () => Global.MailTemplates },
							{ "MODAPPLICATIONS", () => Global.ModApplications },
							{ "MODPOSITIONREQUIREMENT", () => Global.ModPositionRequirement },
							{ "MODPOSITIONS", () => Global.ModPositions },
							{ "MODULES", () => Global.Modules },
							{ "NETBAR", () => Global.Netbar },
							{ "NEWS", () => Global.News },
							{ "NOTIFICATIONS", () => Global.Notifications },
							{ "PERMISSIONGROUPS", () => Global.PermissionGroups },
							{ "PERMISSIONS", () => Global.Permissions },
							{ "POLLS", () => Global.Polls },
							{ "POSTWIDGETS", () => Global.PostWidgets },
							{ "PRIVATEMESSAGES", () => Global.PrivateMessages },
							{ "RATINGS", () => Global.Ratings },
							{ "REGIONS", () => Global.Regions },
							{ "REPORTING", () => Global.Reporting },
							{ "ROLES", () => Global.Roles },
							{ "SEARCH", () => Global.Search },
							{ "SHOUTBOX", () => Global.Shoutbox },
							{ "SITESKINS", () => Global.SiteSkins },
							{ "SMILEY", () => Global.Smiley },
							{ "SOCIAL", () => Global.Social },
							{ "SUBSCRIPTIONS", () => Global.Subscriptions },
							{ "TEMPLATES", () => Global.Templates },
							{ "TINYMCE", () => Global.TinyMCE },
							{ "TOOLTIPS", () => Global.ToolTips },
							{ "TOURNAMENTS", () => Global.Tournaments },
							{ "UPSELLS", () => Global.Upsells },
							{ "USERMANAGEMENT", () => Global.UserManagement },
							{ "USERREGISTRATION", () => Global.UserRegistration },
							{ "USERTHROTTLES", () => Global.UserThrottles },
							{ "VOICE", () => Global.Voice },
							{ "WIDGETS", () => Global.Widgets },
						}
					},
					{ "NEWGLOBAL", new Dictionary<string, Func<ILocalizationSubNamespace>>
						{
							{ "NEWFORUMS", () => NewGlobal.NewForums },
						}
					},
				}
			)
		{ }
		
		#region Namespace Classes
		
		public sealed class AGSNamespace : NamespaceBase
		{
			public AGSNamespace() : base("AGS") { }
			
			#region SubNamespace Classes
			
			public sealed class FooterSubNamespace : SubNamespaceBase
			{
				public FooterSubNamespace() : base("AGS", "Footer") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AmazonCopyrightTemplate(object year)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "AmazonCopyrightTemplate", year);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AmazonCopyrightTemplate", "\u00a9 1996-{year}, Amazon.com, Inc. or its affiliates", year);
					}
				}
				
				public LocalizedTranslation AmazonCopyrightTemplate_ForLanguageID(int languageID, object year)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AmazonCopyrightTemplate", year);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AmazonCopyrightTemplate", "\u00a9 1996-{year}, Amazon.com, Inc. or its affiliates", year);
					}
				}
				
				public LazyLocalizedTranslation Lazy_AmazonCopyrightTemplate(object year)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "AmazonCopyrightTemplate", year);
				}
				
				public LazyLocalizedTranslation Lazy_AmazonCopyrightTemplate_ForLanguageID(int languageID, object year)
				{
					return this.CalculateLazyTranslation(languageID, "AmazonCopyrightTemplate", year);
				}
				
				public LocalizedTranslation AmazonLegalLabel
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AmazonLegalLabel");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AmazonLegalLabel", "Legal");
						}
					}
				}
				
				public LocalizedTranslation AmazonLegalLabel_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AmazonLegalLabel");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AmazonLegalLabel", "Legal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AmazonLegalLabel
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AmazonLegalLabel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AmazonLegalLabel_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AmazonLegalLabel");
				}
				
				public LocalizedTranslation AmazonLegalURL
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AmazonLegalURL");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AmazonLegalURL", "amazon.com");
						}
					}
				}
				
				public LocalizedTranslation AmazonLegalURL_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AmazonLegalURL");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AmazonLegalURL", "amazon.com");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AmazonLegalURL
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AmazonLegalURL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AmazonLegalURL_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AmazonLegalURL");
				}
				
				public LocalizedTranslation ConditionsOfUseLabel
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ConditionsOfUseLabel");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ConditionsOfUseLabel", "Conditions of Use");
						}
					}
				}
				
				public LocalizedTranslation ConditionsOfUseLabel_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ConditionsOfUseLabel");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ConditionsOfUseLabel", "Conditions of Use");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ConditionsOfUseLabel
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ConditionsOfUseLabel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ConditionsOfUseLabel_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ConditionsOfUseLabel");
				}
				
				public LocalizedTranslation ConditionsOfUseURL
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ConditionsOfUseURL");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ConditionsOfUseURL", "https://www.amazon.com/gp/help/customer/display.html/ref=ap_desktop_footer_cou?ie=UTF8&nodeId=508088");
						}
					}
				}
				
				public LocalizedTranslation ConditionsOfUseURL_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ConditionsOfUseURL");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ConditionsOfUseURL", "https://www.amazon.com/gp/help/customer/display.html/ref=ap_desktop_footer_cou?ie=UTF8&nodeId=508088");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ConditionsOfUseURL
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ConditionsOfUseURL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ConditionsOfUseURL_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ConditionsOfUseURL");
				}
				
				public LocalizedTranslation CookiesNoticeLabel
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CookiesNoticeLabel");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CookiesNoticeLabel", "Cookies & Internet Advertising\r\n");
						}
					}
				}
				
				public LocalizedTranslation CookiesNoticeLabel_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CookiesNoticeLabel");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CookiesNoticeLabel", "Cookies & Internet Advertising\r\n");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CookiesNoticeLabel
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CookiesNoticeLabel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CookiesNoticeLabel_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CookiesNoticeLabel");
				}
				
				public LocalizedTranslation CookiesNoticeURL
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CookiesNoticeURL");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CookiesNoticeURL", "amazon.com");
						}
					}
				}
				
				public LocalizedTranslation CookiesNoticeURL_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CookiesNoticeURL");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CookiesNoticeURL", "amazon.com");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CookiesNoticeURL
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CookiesNoticeURL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CookiesNoticeURL_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CookiesNoticeURL");
				}
				
				public LocalizedTranslation Help
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Help");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Help", "Help");
						}
					}
				}
				
				public LocalizedTranslation Help_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Help");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Help", "Help");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Help
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Help");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Help_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Help");
				}
				
				public LocalizedTranslation HelpURL
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HelpURL");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HelpURL", "https://www.amazon.com/help");
						}
					}
				}
				
				public LocalizedTranslation HelpURL_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HelpURL");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HelpURL", "https://www.amazon.com/help");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HelpURL
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HelpURL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HelpURL_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HelpURL");
				}
				
				public LocalizedTranslation PrivacyNoticeLabel
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PrivacyNoticeLabel");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PrivacyNoticeLabel", "Privacy Notice");
						}
					}
				}
				
				public LocalizedTranslation PrivacyNoticeLabel_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PrivacyNoticeLabel");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PrivacyNoticeLabel", "Privacy Notice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivacyNoticeLabel
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PrivacyNoticeLabel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivacyNoticeLabel_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PrivacyNoticeLabel");
				}
				
				public LocalizedTranslation PrivacyNoticeURL
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PrivacyNoticeURL");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PrivacyNoticeURL", "https://www.amazon.com/gp/help/customer/display.html/ref=ap_desktop_footer_privacy_notice?ie=UTF8&nodeId=468496");
						}
					}
				}
				
				public LocalizedTranslation PrivacyNoticeURL_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PrivacyNoticeURL");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PrivacyNoticeURL", "https://www.amazon.com/gp/help/customer/display.html/ref=ap_desktop_footer_privacy_notice?ie=UTF8&nodeId=468496");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivacyNoticeURL
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PrivacyNoticeURL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivacyNoticeURL_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PrivacyNoticeURL");
				}
				

				#endregion
			}
			
			private FooterSubNamespace _cacheFooter;
			public FooterSubNamespace Footer
			{
				get
				{
					if (_cacheFooter == null)
					{
						_cacheFooter = new FooterSubNamespace();
					}
					return _cacheFooter;
				}
			}

			#endregion
		}
		
		private static AGSNamespace _cacheAGS;
		public static AGSNamespace AGS
		{
			get
			{
				if (_cacheAGS == null)
				{
					_cacheAGS = new AGSNamespace();
				}
				return _cacheAGS;
			}
		}
		public sealed class EnumsNamespace : NamespaceBase
		{
			public EnumsNamespace() : base("Enums") { }
			
			#region SubNamespace Classes
			
			public sealed class DayOfWeekSubNamespace : SubNamespaceBase
			{
				public DayOfWeekSubNamespace() : base("Enums", "DayOfWeek") { }
				
				#region Phrase methods
				
				public LocalizedTranslation ArticlesAndComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ArticlesAndComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ArticlesAndComments", "Articles and Comments");
						}
					}
				}
				
				public LocalizedTranslation ArticlesAndComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ArticlesAndComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ArticlesAndComments", "Articles and Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ArticlesAndComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ArticlesAndComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ArticlesAndComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ArticlesAndComments");
				}
				
				public LocalizedTranslation Friday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Friday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Friday", "Friday");
						}
					}
				}
				
				public LocalizedTranslation Friday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Friday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Friday", "Friday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Friday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Friday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Friday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Friday");
				}
				
				public LocalizedTranslation Monday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Monday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Monday", "Monday");
						}
					}
				}
				
				public LocalizedTranslation Monday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Monday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Monday", "Monday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Monday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Monday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Monday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Monday");
				}
				
				public LocalizedTranslation Other
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Other");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Other", "Other");
						}
					}
				}
				
				public LocalizedTranslation Other_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Other");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Other", "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Other");
				}
				
				public LocalizedTranslation Saturday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Saturday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Saturday", "Saturday");
						}
					}
				}
				
				public LocalizedTranslation Saturday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Saturday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Saturday", "Saturday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Saturday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Saturday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Saturday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Saturday");
				}
				
				public LocalizedTranslation Sunday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Sunday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Sunday", "Sunday");
						}
					}
				}
				
				public LocalizedTranslation Sunday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Sunday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Sunday", "Sunday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Sunday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Sunday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Sunday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Sunday");
				}
				
				public LocalizedTranslation Thursday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Thursday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Thursday", "Thursday");
						}
					}
				}
				
				public LocalizedTranslation Thursday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Thursday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Thursday", "Thursday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Thursday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Thursday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Thursday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Thursday");
				}
				
				public LocalizedTranslation Tuesday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tuesday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tuesday", "Tuesday");
						}
					}
				}
				
				public LocalizedTranslation Tuesday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tuesday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tuesday", "Tuesday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tuesday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tuesday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tuesday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tuesday");
				}
				
				public LocalizedTranslation Wednesday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Wednesday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Wednesday", "Wednesday");
						}
					}
				}
				
				public LocalizedTranslation Wednesday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Wednesday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Wednesday", "Wednesday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Wednesday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Wednesday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Wednesday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Wednesday");
				}
				

				#endregion
			}
			
			private DayOfWeekSubNamespace _cacheDayOfWeek;
			public DayOfWeekSubNamespace DayOfWeek
			{
				get
				{
					if (_cacheDayOfWeek == null)
					{
						_cacheDayOfWeek = new DayOfWeekSubNamespace();
					}
					return _cacheDayOfWeek;
				}
			}
			public sealed class DisplayTypeSubNamespace : SubNamespaceBase
			{
				public DisplayTypeSubNamespace() : base("Enums", "DisplayType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Friday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Friday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Friday", "Friday");
						}
					}
				}
				
				public LocalizedTranslation Friday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Friday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Friday", "Friday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Friday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Friday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Friday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Friday");
				}
				
				public LocalizedTranslation Posts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Posts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Posts", "Posts");
						}
					}
				}
				
				public LocalizedTranslation Posts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Posts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Posts", "Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Posts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Posts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Posts");
				}
				
				public LocalizedTranslation Saturday
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Saturday");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Saturday", "Saturday");
						}
					}
				}
				
				public LocalizedTranslation Saturday_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Saturday");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Saturday", "Saturday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Saturday
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Saturday");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Saturday_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Saturday");
				}
				
				public LocalizedTranslation Threads
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Threads");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Threads", "Threads");
						}
					}
				}
				
				public LocalizedTranslation Threads_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Threads");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Threads", "Threads");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Threads
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Threads");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Threads_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Threads");
				}
				

				#endregion
			}
			
			private DisplayTypeSubNamespace _cacheDisplayType;
			public DisplayTypeSubNamespace DisplayType
			{
				get
				{
					if (_cacheDisplayType == null)
					{
						_cacheDisplayType = new DisplayTypeSubNamespace();
					}
					return _cacheDisplayType;
				}
			}
			public sealed class EAccountRecoveryStatusSubNamespace : SubNamespaceBase
			{
				public EAccountRecoveryStatusSubNamespace() : base("Enums", "EAccountRecoveryStatus") { }
				
				#region Phrase methods
				
				public LocalizedTranslation InvalidEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InvalidEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InvalidEmail", "The e-mail address you entered is invalid. Note: Extra dots in e-mail addresses are not supported (e.g. user@gmail..com).");
						}
					}
				}
				
				public LocalizedTranslation InvalidEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidEmail", "The e-mail address you entered is invalid. Note: Extra dots in e-mail addresses are not supported (e.g. user@gmail..com).");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidEmail");
				}
				
				public LocalizedTranslation InvalidPassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InvalidPassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InvalidPassword", "You must enter a new password, between 6 and 16 characters long.");
						}
					}
				}
				
				public LocalizedTranslation InvalidPassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidPassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidPassword", "You must enter a new password, between 6 and 16 characters long.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidPassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidPassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidPassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidPassword");
				}
				
				public LocalizedTranslation ResetAlreadyRequested(object cooldown, object name)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ResetAlreadyRequested", cooldown, name);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ResetAlreadyRequested", "A password reset link has already been sent to {name}. Password resets can only be requested every {cooldown} minutes.", cooldown, name);
					}
				}
				
				public LocalizedTranslation ResetAlreadyRequested_ForLanguageID(int languageID, object cooldown, object name)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ResetAlreadyRequested", cooldown, name);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ResetAlreadyRequested", "A password reset link has already been sent to {name}. Password resets can only be requested every {cooldown} minutes.", cooldown, name);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ResetAlreadyRequested(object cooldown, object name)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ResetAlreadyRequested", cooldown, name);
				}
				
				public LazyLocalizedTranslation Lazy_ResetAlreadyRequested_ForLanguageID(int languageID, object cooldown, object name)
				{
					return this.CalculateLazyTranslation(languageID, "ResetAlreadyRequested", cooldown, name);
				}
				
				public LocalizedTranslation UnknownEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UnknownEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UnknownEmail", "The e-mail address you entered is not in our database.");
						}
					}
				}
				
				public LocalizedTranslation UnknownEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownEmail", "The e-mail address you entered is not in our database.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownEmail");
				}
				
				public LocalizedTranslation UnknownUsername
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UnknownUsername");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UnknownUsername", "The username you entered is not in our database.");
						}
					}
				}
				
				public LocalizedTranslation UnknownUsername_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownUsername");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownUsername", "The username you entered is not in our database.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUsername
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownUsername");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUsername_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownUsername");
				}
				

				#endregion
			}
			
			private EAccountRecoveryStatusSubNamespace _cacheEAccountRecoveryStatus;
			public EAccountRecoveryStatusSubNamespace EAccountRecoveryStatus
			{
				get
				{
					if (_cacheEAccountRecoveryStatus == null)
					{
						_cacheEAccountRecoveryStatus = new EAccountRecoveryStatusSubNamespace();
					}
					return _cacheEAccountRecoveryStatus;
				}
			}
			public sealed class ForumThreadAssociationTypeSubNamespace : SubNamespaceBase
			{
				public ForumThreadAssociationTypeSubNamespace() : base("Enums", "ForumThreadAssociationType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation All
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "All");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("All", "All");
						}
					}
				}
				
				public LocalizedTranslation All_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "All");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("All", "All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "All");
				}
				
				public LocalizedTranslation PostedIn
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostedIn");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostedIn", "Posted In");
						}
					}
				}
				
				public LocalizedTranslation PostedIn_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostedIn");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedIn", "Posted In");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostedIn
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostedIn");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostedIn_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostedIn");
				}
				
				public LocalizedTranslation SubscribedTo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SubscribedTo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SubscribedTo", "Subscribed To");
						}
					}
				}
				
				public LocalizedTranslation SubscribedTo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubscribedTo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubscribedTo", "Subscribed To");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscribedTo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SubscribedTo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscribedTo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SubscribedTo");
				}
				

				#endregion
			}
			
			private ForumThreadAssociationTypeSubNamespace _cacheForumThreadAssociationType;
			public ForumThreadAssociationTypeSubNamespace ForumThreadAssociationType
			{
				get
				{
					if (_cacheForumThreadAssociationType == null)
					{
						_cacheForumThreadAssociationType = new ForumThreadAssociationTypeSubNamespace();
					}
					return _cacheForumThreadAssociationType;
				}
			}
			public sealed class ForumThreadDateRangeTypeSubNamespace : SubNamespaceBase
			{
				public ForumThreadDateRangeTypeSubNamespace() : base("Enums", "ForumThreadDateRangeType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation LastDay
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastDay");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastDay", "Last Day");
						}
					}
				}
				
				public LocalizedTranslation LastDay_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastDay");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastDay", "Last Day");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastDay
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastDay");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastDay_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastDay");
				}
				
				public LocalizedTranslation LastMonth
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastMonth");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastMonth", "Last Month");
						}
					}
				}
				
				public LocalizedTranslation LastMonth_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastMonth");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastMonth", "Last Month");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastMonth
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastMonth");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastMonth_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastMonth");
				}
				
				public LocalizedTranslation LastVisit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastVisit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastVisit", "Last Visit");
						}
					}
				}
				
				public LocalizedTranslation LastVisit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastVisit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastVisit", "Last Visit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastVisit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastVisit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastVisit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastVisit");
				}
				
				public LocalizedTranslation LastWeek
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastWeek");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastWeek", "Last Week");
						}
					}
				}
				
				public LocalizedTranslation LastWeek_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastWeek");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastWeek", "Last Week");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastWeek
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastWeek");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastWeek_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastWeek");
				}
				

				#endregion
			}
			
			private ForumThreadDateRangeTypeSubNamespace _cacheForumThreadDateRangeType;
			public ForumThreadDateRangeTypeSubNamespace ForumThreadDateRangeType
			{
				get
				{
					if (_cacheForumThreadDateRangeType == null)
					{
						_cacheForumThreadDateRangeType = new ForumThreadDateRangeTypeSubNamespace();
					}
					return _cacheForumThreadDateRangeType;
				}
			}
			public sealed class ForumThreadModerationActionSubNamespace : SubNamespaceBase
			{
				public ForumThreadModerationActionSubNamespace() : base("Enums", "ForumThreadModerationAction") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Delete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Delete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Delete", "Delete");
						}
					}
				}
				
				public LocalizedTranslation Delete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Delete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Delete", "Delete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Delete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Delete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Delete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Delete");
				}
				
				public LocalizedTranslation Lock
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Lock");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Lock", "Lock");
						}
					}
				}
				
				public LocalizedTranslation Lock_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Lock");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Lock", "Lock");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Lock
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Lock");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Lock_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Lock");
				}
				
				public LocalizedTranslation Merge
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Merge");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Merge", "Merge");
						}
					}
				}
				
				public LocalizedTranslation Merge_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Merge");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Merge", "Merge");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Merge
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Merge");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Merge_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Merge");
				}
				
				public LocalizedTranslation Move
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Move");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Move", "Move");
						}
					}
				}
				
				public LocalizedTranslation Move_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Move");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Move", "Move");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Move
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Move");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Move_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Move");
				}
				
				public LocalizedTranslation MoveThread
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MoveThread");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MoveThread", "Move thread");
						}
					}
				}
				
				public LocalizedTranslation MoveThread_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MoveThread");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MoveThread", "Move thread");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MoveThread
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MoveThread");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MoveThread_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MoveThread");
				}
				
				public LocalizedTranslation NotSpam
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotSpam");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotSpam", "Not Spam");
						}
					}
				}
				
				public LocalizedTranslation NotSpam_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotSpam");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotSpam", "Not Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotSpam
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotSpam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotSpam_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotSpam");
				}
				
				public LocalizedTranslation Pin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Pin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Pin", "Pin");
						}
					}
				}
				
				public LocalizedTranslation Pin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Pin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Pin", "Pin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Pin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Pin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Pin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Pin");
				}
				
				public LocalizedTranslation Spam
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Spam");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Spam", "Spam");
						}
					}
				}
				
				public LocalizedTranslation Spam_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Spam");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Spam", "Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Spam
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Spam_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Spam");
				}
				
				public LocalizedTranslation Undelete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Undelete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Undelete", "Undelete");
						}
					}
				}
				
				public LocalizedTranslation Undelete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Undelete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Undelete", "Undelete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undelete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Undelete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undelete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Undelete");
				}
				
				public LocalizedTranslation Unlock
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unlock");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unlock", "Unlock");
						}
					}
				}
				
				public LocalizedTranslation Unlock_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unlock");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unlock", "Unlock");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unlock
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unlock");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unlock_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unlock");
				}
				
				public LocalizedTranslation Unpin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unpin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unpin", "Unpin");
						}
					}
				}
				
				public LocalizedTranslation Unpin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unpin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unpin", "Unpin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unpin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unpin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unpin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unpin");
				}
				

				#endregion
			}
			
			private ForumThreadModerationActionSubNamespace _cacheForumThreadModerationAction;
			public ForumThreadModerationActionSubNamespace ForumThreadModerationAction
			{
				get
				{
					if (_cacheForumThreadModerationAction == null)
					{
						_cacheForumThreadModerationAction = new ForumThreadModerationActionSubNamespace();
					}
					return _cacheForumThreadModerationAction;
				}
			}
			public sealed class ForumThreadTypeSubNamespace : SubNamespaceBase
			{
				public ForumThreadTypeSubNamespace() : base("Enums", "ForumThreadType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Announcement
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Announcement");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Announcement", "Announcement");
						}
					}
				}
				
				public LocalizedTranslation Announcement_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Announcement");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Announcement", "Announcement");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Announcement
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Announcement");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Announcement_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Announcement");
				}
				
				public LocalizedTranslation Pinned
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Pinned");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Pinned", "Pinned");
						}
					}
				}
				
				public LocalizedTranslation Pinned_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Pinned");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Pinned", "Pinned");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Pinned
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Pinned");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Pinned_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Pinned");
				}
				
				public LocalizedTranslation Typical
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Typical");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Typical", "Typical");
						}
					}
				}
				
				public LocalizedTranslation Typical_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Typical");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Typical", "Typical");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Typical
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Typical");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Typical_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Typical");
				}
				

				#endregion
			}
			
			private ForumThreadTypeSubNamespace _cacheForumThreadType;
			public ForumThreadTypeSubNamespace ForumThreadType
			{
				get
				{
					if (_cacheForumThreadType == null)
					{
						_cacheForumThreadType = new ForumThreadTypeSubNamespace();
					}
					return _cacheForumThreadType;
				}
			}
			public sealed class MarkupTypeSubNamespace : SubNamespaceBase
			{
				public MarkupTypeSubNamespace() : base("Enums", "MarkupType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation WysiwygHtml
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WysiwygHtml");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WysiwygHtml", "WYSIWYG");
						}
					}
				}
				
				public LocalizedTranslation WysiwygHtml_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WysiwygHtml");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WysiwygHtml", "WYSIWYG");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WysiwygHtml
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WysiwygHtml");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WysiwygHtml_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WysiwygHtml");
				}
				

				#endregion
			}
			
			private MarkupTypeSubNamespace _cacheMarkupType;
			public MarkupTypeSubNamespace MarkupType
			{
				get
				{
					if (_cacheMarkupType == null)
					{
						_cacheMarkupType = new MarkupTypeSubNamespace();
					}
					return _cacheMarkupType;
				}
			}
			public sealed class NotificationPreferenceGroupSubNamespace : SubNamespaceBase
			{
				public NotificationPreferenceGroupSubNamespace() : base("Enums", "NotificationPreferenceGroup") { }
				
				#region Phrase methods
				
				public LocalizedTranslation ArticlesAndComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ArticlesAndComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ArticlesAndComments", "Articles and Comments");
						}
					}
				}
				
				public LocalizedTranslation ArticlesAndComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ArticlesAndComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ArticlesAndComments", "Articles and Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ArticlesAndComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ArticlesAndComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ArticlesAndComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ArticlesAndComments");
				}
				
				public LocalizedTranslation Forums
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Forums");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Forums", "Forums");
						}
					}
				}
				
				public LocalizedTranslation Forums_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Forums");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Forums", "Forums");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forums
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Forums");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forums_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Forums");
				}
				
				public LocalizedTranslation Other
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Other");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Other", "Other");
						}
					}
				}
				
				public LocalizedTranslation Other_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Other");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Other", "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Other");
				}
				

				#endregion
			}
			
			private NotificationPreferenceGroupSubNamespace _cacheNotificationPreferenceGroup;
			public NotificationPreferenceGroupSubNamespace NotificationPreferenceGroup
			{
				get
				{
					if (_cacheNotificationPreferenceGroup == null)
					{
						_cacheNotificationPreferenceGroup = new NotificationPreferenceGroupSubNamespace();
					}
					return _cacheNotificationPreferenceGroup;
				}
			}
			public sealed class PollTypeSubNamespace : SubNamespaceBase
			{
				public PollTypeSubNamespace() : base("Enums", "PollType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation MultiChoice
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MultiChoice");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MultiChoice", "Multi Choice");
						}
					}
				}
				
				public LocalizedTranslation MultiChoice_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MultiChoice");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MultiChoice", "Multi Choice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MultiChoice
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MultiChoice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MultiChoice_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MultiChoice");
				}
				
				public LocalizedTranslation Score
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Score");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Score", "Rating");
						}
					}
				}
				
				public LocalizedTranslation Score_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Score");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Score", "Rating");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Score
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Score");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Score_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Score");
				}
				
				public LocalizedTranslation SingleChoice
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SingleChoice");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SingleChoice", "Single Choice");
						}
					}
				}
				
				public LocalizedTranslation SingleChoice_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SingleChoice");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SingleChoice", "Single Choice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SingleChoice
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SingleChoice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SingleChoice_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SingleChoice");
				}
				

				#endregion
			}
			
			private PollTypeSubNamespace _cachePollType;
			public PollTypeSubNamespace PollType
			{
				get
				{
					if (_cachePollType == null)
					{
						_cachePollType = new PollTypeSubNamespace();
					}
					return _cachePollType;
				}
			}
			public sealed class SearchTypeSubNamespace : SubNamespaceBase
			{
				public SearchTypeSubNamespace() : base("Enums", "SearchType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation All
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "All");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("All", "All");
						}
					}
				}
				
				public LocalizedTranslation All_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "All");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("All", "All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "All");
				}
				
				public LocalizedTranslation Posts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Posts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Posts", "Posts");
						}
					}
				}
				
				public LocalizedTranslation Posts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Posts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Posts", "Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Posts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Posts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Posts");
				}
				
				public LocalizedTranslation Titles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Titles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Titles", "Titles");
						}
					}
				}
				
				public LocalizedTranslation Titles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Titles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Titles", "Titles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Titles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Titles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Titles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Titles");
				}
				

				#endregion
			}
			
			private SearchTypeSubNamespace _cacheSearchType;
			public SearchTypeSubNamespace SearchType
			{
				get
				{
					if (_cacheSearchType == null)
					{
						_cacheSearchType = new SearchTypeSubNamespace();
					}
					return _cacheSearchType;
				}
			}
			public sealed class TranslationReportReasonSubNamespace : SubNamespaceBase
			{
				public TranslationReportReasonSubNamespace() : base("Enums", "TranslationReportReason") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Inaccurate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Inaccurate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Inaccurate", "Translation is inaccurate.");
						}
					}
				}
				
				public LocalizedTranslation Inaccurate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Inaccurate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Inaccurate", "Translation is inaccurate.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Inaccurate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Inaccurate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Inaccurate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Inaccurate");
				}
				
				public LocalizedTranslation Incomplete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Incomplete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Incomplete", "Translation is incomplete.");
						}
					}
				}
				
				public LocalizedTranslation Incomplete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Incomplete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Incomplete", "Translation is incomplete.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Incomplete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Incomplete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Incomplete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Incomplete");
				}
				
				public LocalizedTranslation Innacurate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Innacurate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Innacurate", "Translation is inaccurate.");
						}
					}
				}
				
				public LocalizedTranslation Innacurate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Innacurate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Innacurate", "Translation is inaccurate.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Innacurate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Innacurate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Innacurate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Innacurate");
				}
				
				public LocalizedTranslation Offensive
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Offensive");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Offensive", "Translation is offensive or contains vulgarities.");
						}
					}
				}
				
				public LocalizedTranslation Offensive_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Offensive");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Offensive", "Translation is offensive or contains vulgarities.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Offensive
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Offensive");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Offensive_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Offensive");
				}
				

				#endregion
			}
			
			private TranslationReportReasonSubNamespace _cacheTranslationReportReason;
			public TranslationReportReasonSubNamespace TranslationReportReason
			{
				get
				{
					if (_cacheTranslationReportReason == null)
					{
						_cacheTranslationReportReason = new TranslationReportReasonSubNamespace();
					}
					return _cacheTranslationReportReason;
				}
			}
			public sealed class UserThrottleActionTypeSubNamespace : SubNamespaceBase
			{
				public UserThrottleActionTypeSubNamespace() : base("Enums", "UserThrottleActionType") { }
				
				#region Phrase methods
				
				public LocalizedTranslation CreateComment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateComment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateComment", "Create Post");
						}
					}
				}
				
				public LocalizedTranslation CreateComment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateComment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateComment", "Create Post");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateComment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateComment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateComment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateComment");
				}
				
				public LocalizedTranslation CreateForumThread
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateForumThread");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateForumThread", "Create Forum Thread");
						}
					}
				}
				
				public LocalizedTranslation CreateForumThread_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateForumThread");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateForumThread", "Create Forum Thread");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateForumThread
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateForumThread");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateForumThread_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateForumThread");
				}
				
				public LocalizedTranslation SyncRoster
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SyncRoster");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SyncRoster", "Sync Roster");
						}
					}
				}
				
				public LocalizedTranslation SyncRoster_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SyncRoster");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SyncRoster", "Sync Roster");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SyncRoster
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SyncRoster");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SyncRoster_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SyncRoster");
				}
				

				#endregion
			}
			
			private UserThrottleActionTypeSubNamespace _cacheUserThrottleActionType;
			public UserThrottleActionTypeSubNamespace UserThrottleActionType
			{
				get
				{
					if (_cacheUserThrottleActionType == null)
					{
						_cacheUserThrottleActionType = new UserThrottleActionTypeSubNamespace();
					}
					return _cacheUserThrottleActionType;
				}
			}

			#endregion
		}
		
		private static EnumsNamespace _cacheEnums;
		public static EnumsNamespace Enums
		{
			get
			{
				if (_cacheEnums == null)
				{
					_cacheEnums = new EnumsNamespace();
				}
				return _cacheEnums;
			}
		}
		public sealed class GlobalNamespace : NamespaceBase
		{
			public GlobalNamespace() : base("Global") { }
			
			#region SubNamespace Classes
			
			public sealed class AccountSubNamespace : SubNamespaceBase
			{
				public AccountSubNamespace() : base("Global", "Account") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Account_Creation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Account Creation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Account Creation", "Account Creation");
						}
					}
				}
				
				public LocalizedTranslation Account_Creation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Account Creation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Account Creation", "Account Creation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Account_Creation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Account Creation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Account_Creation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Account Creation");
				}
				
				public LocalizedTranslation AccountMergeProcess(object siteTitle)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "AccountMergeProcess", siteTitle);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountMergeProcess", "This process will merge your {siteTitle} account into your existing Curse account. Please only complete this process if your {siteTitle} account was not automatically merged into your Curse account.", siteTitle);
					}
				}
				
				public LocalizedTranslation AccountMergeProcess_ForLanguageID(int languageID, object siteTitle)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AccountMergeProcess", siteTitle);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountMergeProcess", "This process will merge your {siteTitle} account into your existing Curse account. Please only complete this process if your {siteTitle} account was not automatically merged into your Curse account.", siteTitle);
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountMergeProcess(object siteTitle)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "AccountMergeProcess", siteTitle);
				}
				
				public LazyLocalizedTranslation Lazy_AccountMergeProcess_ForLanguageID(int languageID, object siteTitle)
				{
					return this.CalculateLazyTranslation(languageID, "AccountMergeProcess", siteTitle);
				}
				
				public LocalizedTranslation AdvancedOptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AdvancedOptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AdvancedOptions", "Advanced Options");
						}
					}
				}
				
				public LocalizedTranslation AdvancedOptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AdvancedOptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AdvancedOptions", "Advanced Options");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdvancedOptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AdvancedOptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdvancedOptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AdvancedOptions");
				}
				
				public LocalizedTranslation AllowCurseSendEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AllowCurseSendEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AllowCurseSendEmail", "Allow Curse To Send You Email");
						}
					}
				}
				
				public LocalizedTranslation AllowCurseSendEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AllowCurseSendEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AllowCurseSendEmail", "Allow Curse To Send You Email");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllowCurseSendEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AllowCurseSendEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllowCurseSendEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AllowCurseSendEmail");
				}
				
				public LocalizedTranslation BanStats
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BanStats");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BanStats", "Bans (Active / Total)");
						}
					}
				}
				
				public LocalizedTranslation BanStats_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BanStats");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BanStats", "Bans (Active / Total)");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanStats
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BanStats");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanStats_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BanStats");
				}
				
				public LocalizedTranslation ChangeCustomTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ChangeCustomTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ChangeCustomTitle", "You currently have a custom title, if you'd like to change your title please contact an Administrator.");
						}
					}
				}
				
				public LocalizedTranslation ChangeCustomTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ChangeCustomTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ChangeCustomTitle", "You currently have a custom title, if you'd like to change your title please contact an Administrator.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeCustomTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ChangeCustomTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeCustomTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ChangeCustomTitle");
				}
				
				public LocalizedTranslation ChangesToAccountSaved
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ChangesToAccountSaved");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ChangesToAccountSaved", "Changes to your account were successfully saved.");
						}
					}
				}
				
				public LocalizedTranslation ChangesToAccountSaved_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ChangesToAccountSaved");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ChangesToAccountSaved", "Changes to your account were successfully saved.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangesToAccountSaved
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ChangesToAccountSaved");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangesToAccountSaved_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ChangesToAccountSaved");
				}
				
				public LocalizedTranslation ChangeTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ChangeTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ChangeTitle", "Change Title");
						}
					}
				}
				
				public LocalizedTranslation ChangeTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ChangeTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ChangeTitle", "Change Title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ChangeTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ChangeTitle");
				}
				
				public LocalizedTranslation CommentsOnAppeals
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CommentsOnAppeals");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CommentsOnAppeals", "Comments on my appeals");
						}
					}
				}
				
				public LocalizedTranslation CommentsOnAppeals_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentsOnAppeals");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentsOnAppeals", "Comments on my appeals");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsOnAppeals
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentsOnAppeals");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsOnAppeals_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CommentsOnAppeals");
				}
				
				public LocalizedTranslation CompleteMessage1
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CompleteMessage1");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CompleteMessage1", "Your account merge request will be processed shortly.");
						}
					}
				}
				
				public LocalizedTranslation CompleteMessage1_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CompleteMessage1");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CompleteMessage1", "Your account merge request will be processed shortly.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompleteMessage1
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CompleteMessage1");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompleteMessage1_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CompleteMessage1");
				}
				
				public LocalizedTranslation CompleteMessage2
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CompleteMessage2");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CompleteMessage2", "You will receive a notification when the account merge has completed.");
						}
					}
				}
				
				public LocalizedTranslation CompleteMessage2_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CompleteMessage2");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CompleteMessage2", "You will receive a notification when the account merge has completed.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompleteMessage2
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CompleteMessage2");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompleteMessage2_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CompleteMessage2");
				}
				
				public LocalizedTranslation CreateACustomTitle(object maxChars)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CreateACustomTitle", maxChars);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateACustomTitle", "Create a custom title (Max of {maxChars} characters):", maxChars);
					}
				}
				
				public LocalizedTranslation CreateACustomTitle_ForLanguageID(int languageID, object maxChars)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateACustomTitle", maxChars);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateACustomTitle", "Create a custom title (Max of {maxChars} characters):", maxChars);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateACustomTitle(object maxChars)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateACustomTitle", maxChars);
				}
				
				public LazyLocalizedTranslation Lazy_CreateACustomTitle_ForLanguageID(int languageID, object maxChars)
				{
					return this.CalculateLazyTranslation(languageID, "CreateACustomTitle", maxChars);
				}
				
				public LocalizedTranslation CurrentTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CurrentTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CurrentTitle", "Current Title:");
						}
					}
				}
				
				public LocalizedTranslation CurrentTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CurrentTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CurrentTitle", "Current Title:");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurrentTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CurrentTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurrentTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CurrentTitle");
				}
				
				public LocalizedTranslation CustomTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CustomTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CustomTitle", "Custom Title");
						}
					}
				}
				
				public LocalizedTranslation CustomTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CustomTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CustomTitle", "Custom Title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CustomTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CustomTitle");
				}
				
				public LocalizedTranslation DontHaveAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DontHaveAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DontHaveAccount", "Don't have an account?");
						}
					}
				}
				
				public LocalizedTranslation DontHaveAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DontHaveAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DontHaveAccount", "Don't have an account?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DontHaveAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DontHaveAccount");
				}
				
				public LocalizedTranslation EditProfile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EditProfile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EditProfile", "Edit Profile");
						}
					}
				}
				
				public LocalizedTranslation EditProfile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EditProfile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EditProfile", "Edit Profile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditProfile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EditProfile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditProfile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EditProfile");
				}
				
				public LocalizedTranslation Followers
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Followers");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Followers", "Followers");
						}
					}
				}
				
				public LocalizedTranslation Followers_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Followers");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Followers", "Followers");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Followers
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Followers");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Followers_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Followers");
				}
				
				public LocalizedTranslation GooglePlusProfileLink
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GooglePlusProfileLink");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GooglePlusProfileLink", "Google Plus Profile Link");
						}
					}
				}
				
				public LocalizedTranslation GooglePlusProfileLink_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GooglePlusProfileLink");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GooglePlusProfileLink", "Google Plus Profile Link");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GooglePlusProfileLink
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GooglePlusProfileLink");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GooglePlusProfileLink_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GooglePlusProfileLink");
				}
				
				public LocalizedTranslation Invisible
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Invisible");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Invisible", "Invisible?");
						}
					}
				}
				
				public LocalizedTranslation Invisible_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Invisible");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Invisible", "Invisible?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Invisible
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Invisible");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Invisible_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Invisible");
				}
				
				public LocalizedTranslation InvisibleToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InvisibleToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InvisibleToolTip", "When enabled, you will be hidden from user counts and listings.");
						}
					}
				}
				
				public LocalizedTranslation InvisibleToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvisibleToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvisibleToolTip", "When enabled, you will be hidden from user counts and listings.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvisibleToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InvisibleToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvisibleToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InvisibleToolTip");
				}
				
				public LocalizedTranslation JoinDate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "JoinDate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("JoinDate", "Join Date");
						}
					}
				}
				
				public LocalizedTranslation JoinDate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "JoinDate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("JoinDate", "Join Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_JoinDate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "JoinDate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_JoinDate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "JoinDate");
				}
				
				public LocalizedTranslation Login_to_
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Login to ");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Login to ", "Login to ");
						}
					}
				}
				
				public LocalizedTranslation Login_to__ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Login to ");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Login to ", "Login to ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Login_to_
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Login to ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Login_to__ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Login to ");
				}
				
				public LocalizedTranslation MarkupMode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MarkupMode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MarkupMode", "Markup Mode");
						}
					}
				}
				
				public LocalizedTranslation MarkupMode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MarkupMode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MarkupMode", "Markup Mode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MarkupMode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MarkupMode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MarkupMode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MarkupMode");
				}
				
				public LocalizedTranslation MemberList
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MemberList");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MemberList", "Member List");
						}
					}
				}
				
				public LocalizedTranslation MemberList_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MemberList");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MemberList", "Member List");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MemberList
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MemberList");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MemberList_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MemberList");
				}
				
				public LocalizedTranslation MobilePhoneCantChangeTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MobilePhoneCantChangeTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MobilePhoneCantChangeTooltip", "Your mobile phone number cannot be changed because you are accessing this web site from am untrusted IP Address.");
						}
					}
				}
				
				public LocalizedTranslation MobilePhoneCantChangeTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MobilePhoneCantChangeTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MobilePhoneCantChangeTooltip", "Your mobile phone number cannot be changed because you are accessing this web site from am untrusted IP Address.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneCantChangeTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MobilePhoneCantChangeTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneCantChangeTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MobilePhoneCantChangeTooltip");
				}
				
				public LocalizedTranslation MobilePhoneCountryCode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MobilePhoneCountryCode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MobilePhoneCountryCode", "Mobile Phone Country Code");
						}
					}
				}
				
				public LocalizedTranslation MobilePhoneCountryCode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MobilePhoneCountryCode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MobilePhoneCountryCode", "Mobile Phone Country Code");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneCountryCode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MobilePhoneCountryCode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneCountryCode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MobilePhoneCountryCode");
				}
				
				public LocalizedTranslation MobilePhoneNumber
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MobilePhoneNumber");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MobilePhoneNumber", "Mobile Phone Number");
						}
					}
				}
				
				public LocalizedTranslation MobilePhoneNumber_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MobilePhoneNumber");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MobilePhoneNumber", "Mobile Phone Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneNumber
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MobilePhoneNumber");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneNumber_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MobilePhoneNumber");
				}
				
				public LocalizedTranslation MobilePhoneTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MobilePhoneTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MobilePhoneTooltip", "Your mobile phone can be used to verify you account. Note: If you are outside of the United States please select your country code in the \"Mobile Phone Country Code\" dropdown.");
						}
					}
				}
				
				public LocalizedTranslation MobilePhoneTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MobilePhoneTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MobilePhoneTooltip", "Your mobile phone can be used to verify you account. Note: If you are outside of the United States please select your country code in the \"Mobile Phone Country Code\" dropdown.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MobilePhoneTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MobilePhoneTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MobilePhoneTooltip");
				}
				
				public LocalizedTranslation MustSelectATimeZone
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MustSelectATimeZone");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MustSelectATimeZone", "If you've selected a start time, you must select a time zone.");
						}
					}
				}
				
				public LocalizedTranslation MustSelectATimeZone_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MustSelectATimeZone");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MustSelectATimeZone", "If you've selected a start time, you must select a time zone.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustSelectATimeZone
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MustSelectATimeZone");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustSelectATimeZone_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MustSelectATimeZone");
				}
				
				public LocalizedTranslation MustSelectEndTime
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MustSelectEndTime");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MustSelectEndTime", "If you've selected a start time, you must select an end time.");
						}
					}
				}
				
				public LocalizedTranslation MustSelectEndTime_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MustSelectEndTime");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MustSelectEndTime", "If you've selected a start time, you must select an end time.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustSelectEndTime
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MustSelectEndTime");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustSelectEndTime_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MustSelectEndTime");
				}
				
				public LocalizedTranslation MyAppealComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyAppealComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyAppealComments", "My Appeal Comments");
						}
					}
				}
				
				public LocalizedTranslation MyAppealComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyAppealComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyAppealComments", "My Appeal Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyAppealComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyAppealComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyAppealComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyAppealComments");
				}
				
				public LocalizedTranslation MyContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyContent", "My Content");
						}
					}
				}
				
				public LocalizedTranslation MyContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyContent", "My Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyContent");
				}
				
				public LocalizedTranslation MyProfileComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyProfileComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyProfileComments", "My Profile Comments");
						}
					}
				}
				
				public LocalizedTranslation MyProfileComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyProfileComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyProfileComments", "My Profile Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyProfileComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyProfileComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyProfileComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyProfileComments");
				}
				
				public LocalizedTranslation MySubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MySubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MySubscriptions", "My Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation MySubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MySubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MySubscriptions", "My Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MySubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MySubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MySubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MySubscriptions");
				}
				
				public LocalizedTranslation NestQuotes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NestQuotes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NestQuotes", "Nest Quotes");
						}
					}
				}
				
				public LocalizedTranslation NestQuotes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NestQuotes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NestQuotes", "Nest Quotes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NestQuotes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NestQuotes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NestQuotes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NestQuotes");
				}
				
				public LocalizedTranslation NestQuotesTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NestQuotesTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NestQuotesTooltip", "If selected, quoting another user will reply with the entire post, including previous quotes.");
						}
					}
				}
				
				public LocalizedTranslation NestQuotesTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NestQuotesTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NestQuotesTooltip", "If selected, quoting another user will reply with the entire post, including previous quotes.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NestQuotesTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NestQuotesTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NestQuotesTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NestQuotesTooltip");
				}
				
				public LocalizedTranslation NewCommentOnYourProfile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NewCommentOnYourProfile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NewCommentOnYourProfile", "New comment on your Curse profile.");
						}
					}
				}
				
				public LocalizedTranslation NewCommentOnYourProfile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NewCommentOnYourProfile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NewCommentOnYourProfile", "New comment on your Curse profile.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NewCommentOnYourProfile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NewCommentOnYourProfile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NewCommentOnYourProfile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NewCommentOnYourProfile");
				}
				
				public LocalizedTranslation NoCurrentTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoCurrentTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoCurrentTitle", "no current title");
						}
					}
				}
				
				public LocalizedTranslation NoCurrentTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoCurrentTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoCurrentTitle", "no current title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoCurrentTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoCurrentTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoCurrentTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoCurrentTitle");
				}
				
				public LocalizedTranslation NoIgnoredUsers
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoIgnoredUsers");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoIgnoredUsers", "You have not ignored any users.");
						}
					}
				}
				
				public LocalizedTranslation NoIgnoredUsers_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoIgnoredUsers");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoIgnoredUsers", "You have not ignored any users.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoIgnoredUsers
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoIgnoredUsers");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoIgnoredUsers_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoIgnoredUsers");
				}
				
				public LocalizedTranslation NotificationSettings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotificationSettings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotificationSettings", "Notification Settings");
						}
					}
				}
				
				public LocalizedTranslation NotificationSettings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotificationSettings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotificationSettings", "Notification Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotificationSettings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotificationSettings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotificationSettings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotificationSettings");
				}
				
				public LocalizedTranslation NoTitlesMsg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoTitlesMsg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoTitlesMsg", "You currently have not earned any titles.  Get active in the community and post some comments!");
						}
					}
				}
				
				public LocalizedTranslation NoTitlesMsg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoTitlesMsg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoTitlesMsg", "You currently have not earned any titles.  Get active in the community and post some comments!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoTitlesMsg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoTitlesMsg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoTitlesMsg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoTitlesMsg");
				}
				
				public LocalizedTranslation ProfileComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ProfileComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ProfileComments", "<h3>Profile Comments</h3>");
						}
					}
				}
				
				public LocalizedTranslation ProfileComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ProfileComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ProfileComments", "<h3>Profile Comments</h3>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ProfileComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ProfileComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ProfileComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ProfileComments");
				}
				
				public LocalizedTranslation ReceiveAllNotificationsInEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ReceiveAllNotificationsInEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ReceiveAllNotificationsInEmail", "Receive All Notifications in an Email");
						}
					}
				}
				
				public LocalizedTranslation ReceiveAllNotificationsInEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ReceiveAllNotificationsInEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ReceiveAllNotificationsInEmail", "Receive All Notifications in an Email");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReceiveAllNotificationsInEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ReceiveAllNotificationsInEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReceiveAllNotificationsInEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ReceiveAllNotificationsInEmail");
				}
				
				public LocalizedTranslation RolesRequired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RolesRequired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RolesRequired", "Roles Required");
						}
					}
				}
				
				public LocalizedTranslation RolesRequired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RolesRequired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RolesRequired", "Roles Required");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RolesRequired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RolesRequired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RolesRequired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RolesRequired");
				}
				
				public LocalizedTranslation SelectATitleYouveEarned
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectATitleYouveEarned");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectATitleYouveEarned", "Select a title you've earned:");
						}
					}
				}
				
				public LocalizedTranslation SelectATitleYouveEarned_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectATitleYouveEarned");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectATitleYouveEarned", "Select a title you've earned:");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectATitleYouveEarned
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectATitleYouveEarned");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectATitleYouveEarned_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectATitleYouveEarned");
				}
				
				public LocalizedTranslation SendEmailNotificationsDaily
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SendEmailNotificationsDaily");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SendEmailNotificationsDaily", "Send email notifications as a daily digest instead of immediately.");
						}
					}
				}
				
				public LocalizedTranslation SendEmailNotificationsDaily_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SendEmailNotificationsDaily");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SendEmailNotificationsDaily", "Send email notifications as a daily digest instead of immediately.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendEmailNotificationsDaily
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SendEmailNotificationsDaily");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendEmailNotificationsDaily_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SendEmailNotificationsDaily");
				}
				
				public LocalizedTranslation ShowAds
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowAds");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowAds", "Always Show Ads");
						}
					}
				}
				
				public LocalizedTranslation ShowAds_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowAds");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowAds", "Always Show Ads");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAds
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowAds");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAds_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowAds");
				}
				
				public LocalizedTranslation ShowAdsToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowAdsToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowAdsToolTip", "When enabled, you will always see advertisements, even if you have a subscription.");
						}
					}
				}
				
				public LocalizedTranslation ShowAdsToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowAdsToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowAdsToolTip", "When enabled, you will always see advertisements, even if you have a subscription.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAdsToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowAdsToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAdsToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowAdsToolTip");
				}
				
				public LocalizedTranslation ShowAvatars
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowAvatars");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowAvatars", "Show Avatars");
						}
					}
				}
				
				public LocalizedTranslation ShowAvatars_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowAvatars");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowAvatars", "Show Avatars");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAvatars
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowAvatars");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAvatars_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowAvatars");
				}
				
				public LocalizedTranslation ShowAvatarsToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowAvatarsToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowAvatarsToolTip", "When enabled, users' avatars will appear for the site.");
						}
					}
				}
				
				public LocalizedTranslation ShowAvatarsToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowAvatarsToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowAvatarsToolTip", "When enabled, users' avatars will appear for the site.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAvatarsToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowAvatarsToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowAvatarsToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowAvatarsToolTip");
				}
				
				public LocalizedTranslation ShowCensored
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowCensored");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowCensored", "Show Censored Content");
						}
					}
				}
				
				public LocalizedTranslation ShowCensored_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowCensored");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowCensored", "Show Censored Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowCensored
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowCensored");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowCensored_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowCensored");
				}
				
				public LocalizedTranslation ShowCensoredToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowCensoredToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowCensoredToolTip", "When enabled, censored content (such as profanity) will not be hidden.");
						}
					}
				}
				
				public LocalizedTranslation ShowCensoredToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowCensoredToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowCensoredToolTip", "When enabled, censored content (such as profanity) will not be hidden.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowCensoredToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowCensoredToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowCensoredToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowCensoredToolTip");
				}
				
				public LocalizedTranslation ShowContentMarkedAsSpam
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowContentMarkedAsSpam");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowContentMarkedAsSpam", "Show Content Marked As Spam");
						}
					}
				}
				
				public LocalizedTranslation ShowContentMarkedAsSpam_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowContentMarkedAsSpam");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowContentMarkedAsSpam", "Show Content Marked As Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowContentMarkedAsSpam
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowContentMarkedAsSpam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowContentMarkedAsSpam_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowContentMarkedAsSpam");
				}
				
				public LocalizedTranslation ShowDeletedContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowDeletedContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowDeletedContent", "Show Deleted Content");
						}
					}
				}
				
				public LocalizedTranslation ShowDeletedContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowDeletedContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowDeletedContent", "Show Deleted Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowDeletedContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowDeletedContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowDeletedContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowDeletedContent");
				}
				
				public LocalizedTranslation ShowDeletedToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowDeletedToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowDeletedToolTip", "When enabled, you will see content which has been deleted.");
						}
					}
				}
				
				public LocalizedTranslation ShowDeletedToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowDeletedToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowDeletedToolTip", "When enabled, you will see content which has been deleted.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowDeletedToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowDeletedToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowDeletedToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowDeletedToolTip");
				}
				
				public LocalizedTranslation ShowHellbanContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowHellbanContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowHellbanContent", "Show Hellban Content");
						}
					}
				}
				
				public LocalizedTranslation ShowHellbanContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowHellbanContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowHellbanContent", "Show Hellban Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowHellbanContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowHellbanContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowHellbanContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowHellbanContent");
				}
				
				public LocalizedTranslation ShowHellbanContentTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowHellbanContentTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowHellbanContentTooltip", "When enabled, you will see content from hellbanned members.");
						}
					}
				}
				
				public LocalizedTranslation ShowHellbanContentTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowHellbanContentTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowHellbanContentTooltip", "When enabled, you will see content from hellbanned members.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowHellbanContentTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowHellbanContentTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowHellbanContentTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowHellbanContentTooltip");
				}
				
				public LocalizedTranslation ShowSignatures
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSignatures");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSignatures", "Show Signatures");
						}
					}
				}
				
				public LocalizedTranslation ShowSignatures_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSignatures");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSignatures", "Show Signatures");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSignatures
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSignatures");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSignatures_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSignatures");
				}
				
				public LocalizedTranslation ShowSignaturesToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSignaturesToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSignaturesToolTip", "When enabled, users' signatures will appear for the site.");
						}
					}
				}
				
				public LocalizedTranslation ShowSignaturesToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSignaturesToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSignaturesToolTip", "When enabled, users' signatures will appear for the site.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSignaturesToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSignaturesToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSignaturesToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSignaturesToolTip");
				}
				
				public LocalizedTranslation ShowSmileToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSmileToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSmileToolTip", "When enabled, you will see graphical smilies, instead of their textual representation.");
						}
					}
				}
				
				public LocalizedTranslation ShowSmileToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSmileToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSmileToolTip", "When enabled, you will see graphical smilies, instead of their textual representation.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSmileToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSmileToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSmileToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSmileToolTip");
				}
				
				public LocalizedTranslation ShowSmilies
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSmilies");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSmilies", "Show Smilies");
						}
					}
				}
				
				public LocalizedTranslation ShowSmilies_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSmilies");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSmilies", "Show Smilies");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSmilies
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSmilies");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSmilies_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSmilies");
				}
				
				public LocalizedTranslation ShowSpamContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSpamContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSpamContent", "Show Content Marked as Spam");
						}
					}
				}
				
				public LocalizedTranslation ShowSpamContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSpamContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSpamContent", "Show Content Marked as Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSpamContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSpamContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSpamContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSpamContent");
				}
				
				public LocalizedTranslation ShowSpamToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShowSpamToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShowSpamToolTip", "When enabled, you will see content which has been flagged as spam.");
						}
					}
				}
				
				public LocalizedTranslation ShowSpamToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowSpamToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowSpamToolTip", "When enabled, you will see content which has been flagged as spam.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSpamToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowSpamToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowSpamToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShowSpamToolTip");
				}
				
				public LocalizedTranslation SiteSkin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SiteSkin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SiteSkin", "Site Skin");
						}
					}
				}
				
				public LocalizedTranslation SiteSkin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SiteSkin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SiteSkin", "Site Skin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSkin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SiteSkin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSkin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SiteSkin");
				}
				
				public LocalizedTranslation SiteSkinToolTip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SiteSkinToolTip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SiteSkinToolTip", "Enjoy a custom skin!");
						}
					}
				}
				
				public LocalizedTranslation SiteSkinToolTip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SiteSkinToolTip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SiteSkinToolTip", "Enjoy a custom skin!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSkinToolTip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SiteSkinToolTip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSkinToolTip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SiteSkinToolTip");
				}
				
				public LocalizedTranslation TheFollowingHaveCommentedOnYourProfile(object _0)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TheFollowingHaveCommentedOnYourProfile", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TheFollowingHaveCommentedOnYourProfile", "<p>{0},</p><p>The following have recently commented on your profile.", _0);
					}
				}
				
				public LocalizedTranslation TheFollowingHaveCommentedOnYourProfile_ForLanguageID(int languageID, object _0)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TheFollowingHaveCommentedOnYourProfile", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TheFollowingHaveCommentedOnYourProfile", "<p>{0},</p><p>The following have recently commented on your profile.", _0);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TheFollowingHaveCommentedOnYourProfile(object _0)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TheFollowingHaveCommentedOnYourProfile", _0);
				}
				
				public LazyLocalizedTranslation Lazy_TheFollowingHaveCommentedOnYourProfile_ForLanguageID(int languageID, object _0)
				{
					return this.CalculateLazyTranslation(languageID, "TheFollowingHaveCommentedOnYourProfile", _0);
				}
				
				public LocalizedTranslation TitleEnteredNotAllowed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TitleEnteredNotAllowed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TitleEnteredNotAllowed", "The title you have entered is not allowed.");
						}
					}
				}
				
				public LocalizedTranslation TitleEnteredNotAllowed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TitleEnteredNotAllowed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TitleEnteredNotAllowed", "The title you have entered is not allowed.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TitleEnteredNotAllowed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TitleEnteredNotAllowed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TitleEnteredNotAllowed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TitleEnteredNotAllowed");
				}
				
				public LocalizedTranslation TitlesUnlocked
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TitlesUnlocked");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TitlesUnlocked", "Titles unlocked!");
						}
					}
				}
				
				public LocalizedTranslation TitlesUnlocked_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TitlesUnlocked");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TitlesUnlocked", "Titles unlocked!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TitlesUnlocked
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TitlesUnlocked");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TitlesUnlocked_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TitlesUnlocked");
				}
				
				public LocalizedTranslation UntrustedIPMsg(object link)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UntrustedIPMsg", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UntrustedIPMsg", "<b>Note:</b> Some of your account options, including your password and email address, cannot be changed because you are accessing this web site from an untrusted IP Address. You can verify your account ownership <a href=\"{link}\">here</a>.", link);
					}
				}
				
				public LocalizedTranslation UntrustedIPMsg_ForLanguageID(int languageID, object link)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UntrustedIPMsg", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UntrustedIPMsg", "<b>Note:</b> Some of your account options, including your password and email address, cannot be changed because you are accessing this web site from an untrusted IP Address. You can verify your account ownership <a href=\"{link}\">here</a>.", link);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UntrustedIPMsg(object link)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UntrustedIPMsg", link);
				}
				
				public LazyLocalizedTranslation Lazy_UntrustedIPMsg_ForLanguageID(int languageID, object link)
				{
					return this.CalculateLazyTranslation(languageID, "UntrustedIPMsg", link);
				}
				
				public LocalizedTranslation UseMyDefaultTitle
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UseMyDefaultTitle");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UseMyDefaultTitle", "Use my default title");
						}
					}
				}
				
				public LocalizedTranslation UseMyDefaultTitle_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UseMyDefaultTitle");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UseMyDefaultTitle", "Use my default title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UseMyDefaultTitle
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UseMyDefaultTitle");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UseMyDefaultTitle_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UseMyDefaultTitle");
				}
				
				public LocalizedTranslation UserHasCommentedOnYourProfile(object userName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UserHasCommentedOnYourProfile", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserHasCommentedOnYourProfile", "<p><strong>{userName}</strong> has commented on your profile.</p>", userName);
					}
				}
				
				public LocalizedTranslation UserHasCommentedOnYourProfile_ForLanguageID(int languageID, object userName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserHasCommentedOnYourProfile", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserHasCommentedOnYourProfile", "<p><strong>{userName}</strong> has commented on your profile.</p>", userName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserHasCommentedOnYourProfile(object userName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UserHasCommentedOnYourProfile", userName);
				}
				
				public LazyLocalizedTranslation Lazy_UserHasCommentedOnYourProfile_ForLanguageID(int languageID, object userName)
				{
					return this.CalculateLazyTranslation(languageID, "UserHasCommentedOnYourProfile", userName);
				}
				
				public LocalizedTranslation ViewUnpublishedContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewUnpublishedContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewUnpublishedContent", "View Unpublished Content");
						}
					}
				}
				
				public LocalizedTranslation ViewUnpublishedContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewUnpublishedContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewUnpublishedContent", "View Unpublished Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewUnpublishedContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewUnpublishedContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewUnpublishedContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewUnpublishedContent");
				}
				
				public LocalizedTranslation ViewUnpublishedContentTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewUnpublishedContentTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewUnpublishedContentTooltip", "When enabled, you will see content set to Draft status.");
						}
					}
				}
				
				public LocalizedTranslation ViewUnpublishedContentTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewUnpublishedContentTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewUnpublishedContentTooltip", "When enabled, you will see content set to Draft status.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewUnpublishedContentTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewUnpublishedContentTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewUnpublishedContentTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewUnpublishedContentTooltip");
				}
				
				public LocalizedTranslation WarningsAndBans
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WarningsAndBans");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WarningsAndBans", "Warnings & Bans");
						}
					}
				}
				
				public LocalizedTranslation WarningsAndBans_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WarningsAndBans");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WarningsAndBans", "Warnings & Bans");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WarningsAndBans
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WarningsAndBans");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WarningsAndBans_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WarningsAndBans");
				}
				
				public LocalizedTranslation WarningStats
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WarningStats");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WarningStats", "Warnings (Active / Total)");
						}
					}
				}
				
				public LocalizedTranslation WarningStats_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WarningStats");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WarningStats", "Warnings (Active / Total)");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WarningStats
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WarningStats");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WarningStats_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WarningStats");
				}
				
				public LocalizedTranslation WelcomeMsg(object sitename, object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "WelcomeMsg", sitename, username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeMsg", "{username}, you have successfully been registered for {sitename}! You will be redirected back to the previous page momentarily.", sitename, username);
					}
				}
				
				public LocalizedTranslation WelcomeMsg_ForLanguageID(int languageID, object sitename, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeMsg", sitename, username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeMsg", "{username}, you have successfully been registered for {sitename}! You will be redirected back to the previous page momentarily.", sitename, username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeMsg(object sitename, object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeMsg", sitename, username);
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeMsg_ForLanguageID(int languageID, object sitename, object username)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeMsg", sitename, username);
				}
				
				public LocalizedTranslation YourVanityTitle(object title)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "YourVanityTitle", title);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YourVanityTitle", "Your vanity title ({title}) will always be shown regardless of which forum title is chosen.", title);
					}
				}
				
				public LocalizedTranslation YourVanityTitle_ForLanguageID(int languageID, object title)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YourVanityTitle", title);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YourVanityTitle", "Your vanity title ({title}) will always be shown regardless of which forum title is chosen.", title);
					}
				}
				
				public LazyLocalizedTranslation Lazy_YourVanityTitle(object title)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "YourVanityTitle", title);
				}
				
				public LazyLocalizedTranslation Lazy_YourVanityTitle_ForLanguageID(int languageID, object title)
				{
					return this.CalculateLazyTranslation(languageID, "YourVanityTitle", title);
				}
				

				#endregion
			}
			
			private AccountSubNamespace _cacheAccount;
			public AccountSubNamespace Account
			{
				get
				{
					if (_cacheAccount == null)
					{
						_cacheAccount = new AccountSubNamespace();
					}
					return _cacheAccount;
				}
			}
			public sealed class ActivityLogSubNamespace : SubNamespaceBase
			{
				public ActivityLogSubNamespace() : base("Global", "ActivityLog") { }
				
				#region Phrase methods
				
				public LocalizedTranslation ActivityLog
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ActivityLog");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ActivityLog", "Activity Log");
						}
					}
				}
				
				public LocalizedTranslation ActivityLog_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ActivityLog");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ActivityLog", "Activity Log");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ActivityLog
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ActivityLog");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ActivityLog_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ActivityLog");
				}
				
				public LocalizedTranslation EntityID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EntityID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EntityID", "Entity ID");
						}
					}
				}
				
				public LocalizedTranslation EntityID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EntityID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EntityID", "Entity ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EntityID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EntityID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EntityID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EntityID");
				}
				
				public LocalizedTranslation EntityType
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EntityType");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EntityType", "Entity Type");
						}
					}
				}
				
				public LocalizedTranslation EntityType_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EntityType");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EntityType", "Entity Type");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EntityType
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EntityType");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EntityType_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EntityType");
				}
				
				public LocalizedTranslation Notes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Notes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Notes", "Notes");
						}
					}
				}
				
				public LocalizedTranslation Notes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Notes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Notes", "Notes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Notes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Notes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Notes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Notes");
				}
				

				#endregion
			}
			
			private ActivityLogSubNamespace _cacheActivityLog;
			public ActivityLogSubNamespace ActivityLog
			{
				get
				{
					if (_cacheActivityLog == null)
					{
						_cacheActivityLog = new ActivityLogSubNamespace();
					}
					return _cacheActivityLog;
				}
			}
			public sealed class AnnouncementsSubNamespace : SubNamespaceBase
			{
				public AnnouncementsSubNamespace() : base("Global", "Announcements") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AnnouncementEndDateDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AnnouncementEndDateDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AnnouncementEndDateDesc", "A date and time when the announcement will no longer show, this is required.");
						}
					}
				}
				
				public LocalizedTranslation AnnouncementEndDateDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AnnouncementEndDateDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AnnouncementEndDateDesc", "A date and time when the announcement will no longer show, this is required.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementEndDateDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AnnouncementEndDateDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementEndDateDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AnnouncementEndDateDesc");
				}
				
				public LocalizedTranslation AnnouncementLinkDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AnnouncementLinkDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AnnouncementLinkDesc", "An optional link to include along with the message.");
						}
					}
				}
				
				public LocalizedTranslation AnnouncementLinkDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AnnouncementLinkDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AnnouncementLinkDesc", "An optional link to include along with the message.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementLinkDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AnnouncementLinkDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementLinkDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AnnouncementLinkDesc");
				}
				
				public LocalizedTranslation AnnouncementRolesDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AnnouncementRolesDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AnnouncementRolesDesc", "Limit which roles can see the announcement.  Leaving this blank will mean everyone can view it.");
						}
					}
				}
				
				public LocalizedTranslation AnnouncementRolesDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AnnouncementRolesDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AnnouncementRolesDesc", "Limit which roles can see the announcement.  Leaving this blank will mean everyone can view it.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementRolesDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AnnouncementRolesDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementRolesDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AnnouncementRolesDesc");
				}
				
				public LocalizedTranslation AnnouncementStartDateDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AnnouncementStartDateDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AnnouncementStartDateDesc", "An optional date and time to start showing the announcement. If left blank, it will always be shown up until the end date and time.");
						}
					}
				}
				
				public LocalizedTranslation AnnouncementStartDateDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AnnouncementStartDateDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AnnouncementStartDateDesc", "An optional date and time to start showing the announcement. If left blank, it will always be shown up until the end date and time.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementStartDateDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AnnouncementStartDateDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementStartDateDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AnnouncementStartDateDesc");
				}
				
				public LocalizedTranslation AnnouncementTextDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AnnouncementTextDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AnnouncementTextDesc", "A short message that is the content of the announcement.");
						}
					}
				}
				
				public LocalizedTranslation AnnouncementTextDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AnnouncementTextDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AnnouncementTextDesc", "A short message that is the content of the announcement.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementTextDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AnnouncementTextDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AnnouncementTextDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AnnouncementTextDesc");
				}
				

				#endregion
			}
			
			private AnnouncementsSubNamespace _cacheAnnouncements;
			public AnnouncementsSubNamespace Announcements
			{
				get
				{
					if (_cacheAnnouncements == null)
					{
						_cacheAnnouncements = new AnnouncementsSubNamespace();
					}
					return _cacheAnnouncements;
				}
			}
			public sealed class AuthenticationSubNamespace : SubNamespaceBase
			{
				public AuthenticationSubNamespace() : base("Global", "Authentication") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AccountMergeSessionExpired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AccountMergeSessionExpired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AccountMergeSessionExpired", "Your account merge session has expired.");
						}
					}
				}
				
				public LocalizedTranslation AccountMergeSessionExpired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AccountMergeSessionExpired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountMergeSessionExpired", "Your account merge session has expired.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountMergeSessionExpired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AccountMergeSessionExpired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountMergeSessionExpired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AccountMergeSessionExpired");
				}
				
				public LocalizedTranslation AlreadyPending
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AlreadyPending");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AlreadyPending", "Your account already has a pending verification. Please check your e-mail or text messages, including Spam / Junkmail folders.");
						}
					}
				}
				
				public LocalizedTranslation AlreadyPending_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AlreadyPending");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AlreadyPending", "Your account already has a pending verification. Please check your e-mail or text messages, including Spam / Junkmail folders.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AlreadyPending
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AlreadyPending");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AlreadyPending_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AlreadyPending");
				}
				
				public LocalizedTranslation CreateOne
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateOne");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateOne", "Register");
						}
					}
				}
				
				public LocalizedTranslation CreateOne_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateOne");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateOne", "Register");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateOne
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateOne");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateOne_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateOne");
				}
				
				public LocalizedTranslation DifferentIP(object code, object ipAddressCurrent, object ipAddressOrg)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "DifferentIP", code, ipAddressCurrent, ipAddressOrg);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DifferentIP", "The account verification request for the code provided ({code}) came from a different IP Address ({ipAddressOrg}) than the one you are currently browsing the site from ({ipAddressCurrent}).", code, ipAddressCurrent, ipAddressOrg);
					}
				}
				
				public LocalizedTranslation DifferentIP_ForLanguageID(int languageID, object code, object ipAddressCurrent, object ipAddressOrg)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DifferentIP", code, ipAddressCurrent, ipAddressOrg);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DifferentIP", "The account verification request for the code provided ({code}) came from a different IP Address ({ipAddressOrg}) than the one you are currently browsing the site from ({ipAddressCurrent}).", code, ipAddressCurrent, ipAddressOrg);
					}
				}
				
				public LazyLocalizedTranslation Lazy_DifferentIP(object code, object ipAddressCurrent, object ipAddressOrg)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "DifferentIP", code, ipAddressCurrent, ipAddressOrg);
				}
				
				public LazyLocalizedTranslation Lazy_DifferentIP_ForLanguageID(int languageID, object code, object ipAddressCurrent, object ipAddressOrg)
				{
					return this.CalculateLazyTranslation(languageID, "DifferentIP", code, ipAddressCurrent, ipAddressOrg);
				}
				
				public LocalizedTranslation DontHaveAnAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DontHaveAnAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DontHaveAnAccount", "Don't have an account?");
						}
					}
				}
				
				public LocalizedTranslation DontHaveAnAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DontHaveAnAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DontHaveAnAccount", "Don't have an account?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAnAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DontHaveAnAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAnAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DontHaveAnAccount");
				}
				
				public LocalizedTranslation EmailChoice
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EmailChoice");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EmailChoice", "<b>E-mail Verification</b><br />You can verify your account by confirming ownership of the e-mail address associated with it. Click the button below and you will receive an e-mail with a link to confirm ownership.");
						}
					}
				}
				
				public LocalizedTranslation EmailChoice_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailChoice");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailChoice", "<b>E-mail Verification</b><br />You can verify your account by confirming ownership of the e-mail address associated with it. Click the button below and you will receive an e-mail with a link to confirm ownership.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailChoice
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailChoice");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailChoice_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EmailChoice");
				}
				
				public LocalizedTranslation EmailSent(object email)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "EmailSent", email);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailSent", "An e-mail has been sent with a link to grant access from this IP Address to: {email}. You should receive this e-mail momentarily. Note: Be sure to check your Spam / Junkmail folders.", email);
					}
				}
				
				public LocalizedTranslation EmailSent_ForLanguageID(int languageID, object email)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailSent", email);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailSent", "An e-mail has been sent with a link to grant access from this IP Address to: {email}. You should receive this e-mail momentarily. Note: Be sure to check your Spam / Junkmail folders.", email);
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailSent(object email)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailSent", email);
				}
				
				public LazyLocalizedTranslation Lazy_EmailSent_ForLanguageID(int languageID, object email)
				{
					return this.CalculateLazyTranslation(languageID, "EmailSent", email);
				}
				
				public LocalizedTranslation ExpiredCode(object code)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ExpiredCode", code);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ExpiredCode", "The account verification request for the code provided ({code}) could not be found, is expired or has already been processed.", code);
					}
				}
				
				public LocalizedTranslation ExpiredCode_ForLanguageID(int languageID, object code)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ExpiredCode", code);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ExpiredCode", "The account verification request for the code provided ({code}) could not be found, is expired or has already been processed.", code);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ExpiredCode(object code)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ExpiredCode", code);
				}
				
				public LazyLocalizedTranslation Lazy_ExpiredCode_ForLanguageID(int languageID, object code)
				{
					return this.CalculateLazyTranslation(languageID, "ExpiredCode", code);
				}
				
				public LocalizedTranslation Forgot
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Forgot");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Forgot", "Forgot?");
						}
					}
				}
				
				public LocalizedTranslation Forgot_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Forgot");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Forgot", "Forgot?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forgot
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Forgot");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forgot_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Forgot");
				}
				
				public LocalizedTranslation IncorrectPassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IncorrectPassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IncorrectPassword", "The password you entered does not match an existing Curse account.");
						}
					}
				}
				
				public LocalizedTranslation IncorrectPassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IncorrectPassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IncorrectPassword", "The password you entered does not match an existing Curse account.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IncorrectPassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IncorrectPassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IncorrectPassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IncorrectPassword");
				}
				
				public LocalizedTranslation InvalidCode(object code)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidCode", code);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidCode", "The code provided ({code}) is invalid.", code);
					}
				}
				
				public LocalizedTranslation InvalidCode_ForLanguageID(int languageID, object code)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidCode", code);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidCode", "The code provided ({code}) is invalid.", code);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidCode(object code)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidCode", code);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidCode_ForLanguageID(int languageID, object code)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidCode", code);
				}
				
				public LocalizedTranslation LoginTo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LoginTo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LoginTo", "Login to");
						}
					}
				}
				
				public LocalizedTranslation LoginTo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LoginTo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LoginTo", "Login to");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LoginTo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LoginTo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LoginTo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LoginTo");
				}
				
				public LocalizedTranslation ModeratorChoice(object pmLink)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ModeratorChoice", pmLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ModeratorChoice", "<b>Contact a Moderator</b><br />You can verify your account by contacting a moderator. Simply e-mail them, or send a <a href=\"{pmLink}\">Private Message</a>.", pmLink);
					}
				}
				
				public LocalizedTranslation ModeratorChoice_ForLanguageID(int languageID, object pmLink)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ModeratorChoice", pmLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ModeratorChoice", "<b>Contact a Moderator</b><br />You can verify your account by contacting a moderator. Simply e-mail them, or send a <a href=\"{pmLink}\">Private Message</a>.", pmLink);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ModeratorChoice(object pmLink)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ModeratorChoice", pmLink);
				}
				
				public LazyLocalizedTranslation Lazy_ModeratorChoice_ForLanguageID(int languageID, object pmLink)
				{
					return this.CalculateLazyTranslation(languageID, "ModeratorChoice", pmLink);
				}
				
				public LocalizedTranslation OAuth
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OAuth");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OAuth", "OAuth");
						}
					}
				}
				
				public LocalizedTranslation OAuth_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OAuth");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OAuth", "OAuth");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OAuth
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OAuth");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OAuth_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OAuth");
				}
				
				public LocalizedTranslation OAuthInvalid(object platform)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "OAuthInvalid", platform);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OAuthInvalid", "There was an error while trying to validate your attempt to login with {platform}.  This can happen if your session times out with {platform} or you click the allow option.  Please click the link below to try again.", platform);
					}
				}
				
				public LocalizedTranslation OAuthInvalid_ForLanguageID(int languageID, object platform)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OAuthInvalid", platform);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OAuthInvalid", "There was an error while trying to validate your attempt to login with {platform}.  This can happen if your session times out with {platform} or you click the allow option.  Please click the link below to try again.", platform);
					}
				}
				
				public LazyLocalizedTranslation Lazy_OAuthInvalid(object platform)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "OAuthInvalid", platform);
				}
				
				public LazyLocalizedTranslation Lazy_OAuthInvalid_ForLanguageID(int languageID, object platform)
				{
					return this.CalculateLazyTranslation(languageID, "OAuthInvalid", platform);
				}
				
				public LocalizedTranslation PremiumExperience
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PremiumExperience");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PremiumExperience", "Get an Epic Experience with Premium");
						}
					}
				}
				
				public LocalizedTranslation PremiumExperience_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PremiumExperience");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PremiumExperience", "Get an Epic Experience with Premium");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumExperience
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PremiumExperience");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumExperience_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PremiumExperience");
				}
				
				public LocalizedTranslation ResetPassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ResetPassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ResetPassword", "Reset Password");
						}
					}
				}
				
				public LocalizedTranslation ResetPassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ResetPassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ResetPassword", "Reset Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ResetPassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ResetPassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ResetPassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ResetPassword");
				}
				
				public LocalizedTranslation SendEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SendEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SendEmail", "Send Verification E-mail");
						}
					}
				}
				
				public LocalizedTranslation SendEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SendEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SendEmail", "Send Verification E-mail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SendEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SendEmail");
				}
				
				public LocalizedTranslation SendTextMsg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SendTextMsg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SendTextMsg", "Send Verification Text Message");
						}
					}
				}
				
				public LocalizedTranslation SendTextMsg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SendTextMsg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SendTextMsg", "Send Verification Text Message");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendTextMsg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SendTextMsg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SendTextMsg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SendTextMsg");
				}
				
				public LocalizedTranslation TextMsgChoice(object mobileNumber)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TextMsgChoice", mobileNumber);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TextMsgChoice", "<b>Text Message Verification</b><br />You can verify your account by confirming ownership of the mobile phone number associated with it ({mobileNumber}). Click the button below and you will receive a text message with a link to confirm ownership.", mobileNumber);
					}
				}
				
				public LocalizedTranslation TextMsgChoice_ForLanguageID(int languageID, object mobileNumber)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TextMsgChoice", mobileNumber);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TextMsgChoice", "<b>Text Message Verification</b><br />You can verify your account by confirming ownership of the mobile phone number associated with it ({mobileNumber}). Click the button below and you will receive a text message with a link to confirm ownership.", mobileNumber);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TextMsgChoice(object mobileNumber)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TextMsgChoice", mobileNumber);
				}
				
				public LazyLocalizedTranslation Lazy_TextMsgChoice_ForLanguageID(int languageID, object mobileNumber)
				{
					return this.CalculateLazyTranslation(languageID, "TextMsgChoice", mobileNumber);
				}
				
				public LocalizedTranslation TextMsgSent(object mobileNum)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TextMsgSent", mobileNum);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TextMsgSent", "A text message has been sent with a link to grant access from this IP Address to: {mobileNum}. You should receive this text message momentarily.", mobileNum);
					}
				}
				
				public LocalizedTranslation TextMsgSent_ForLanguageID(int languageID, object mobileNum)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TextMsgSent", mobileNum);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TextMsgSent", "A text message has been sent with a link to grant access from this IP Address to: {mobileNum}. You should receive this text message momentarily.", mobileNum);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TextMsgSent(object mobileNum)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TextMsgSent", mobileNum);
				}
				
				public LazyLocalizedTranslation Lazy_TextMsgSent_ForLanguageID(int languageID, object mobileNum)
				{
					return this.CalculateLazyTranslation(languageID, "TextMsgSent", mobileNum);
				}
				
				public LocalizedTranslation TroubleLoggingIn
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TroubleLoggingIn");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TroubleLoggingIn", "Trouble logging in?");
						}
					}
				}
				
				public LocalizedTranslation TroubleLoggingIn_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TroubleLoggingIn");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TroubleLoggingIn", "Trouble logging in?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TroubleLoggingIn
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TroubleLoggingIn");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TroubleLoggingIn_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TroubleLoggingIn");
				}
				
				public LocalizedTranslation UntrustedIP(object ipAddress)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UntrustedIP", ipAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UntrustedIP", "The IP address you are accessing the site from (<b>{ipAddress}</b>) is not a trusted IP address for this user account.", ipAddress);
					}
				}
				
				public LocalizedTranslation UntrustedIP_ForLanguageID(int languageID, object ipAddress)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UntrustedIP", ipAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UntrustedIP", "The IP address you are accessing the site from (<b>{ipAddress}</b>) is not a trusted IP address for this user account.", ipAddress);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UntrustedIP(object ipAddress)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UntrustedIP", ipAddress);
				}
				
				public LazyLocalizedTranslation Lazy_UntrustedIP_ForLanguageID(int languageID, object ipAddress)
				{
					return this.CalculateLazyTranslation(languageID, "UntrustedIP", ipAddress);
				}
				
				public LocalizedTranslation UsernameEmailAddress
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UsernameEmailAddress");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UsernameEmailAddress", "Email Address");
						}
					}
				}
				
				public LocalizedTranslation UsernameEmailAddress_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UsernameEmailAddress");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UsernameEmailAddress", "Email Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UsernameEmailAddress
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UsernameEmailAddress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UsernameEmailAddress_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UsernameEmailAddress");
				}
				
				public LocalizedTranslation Validate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Validate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Validate", "Validate");
						}
					}
				}
				
				public LocalizedTranslation Validate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Validate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Validate", "Validate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Validate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Validate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Validate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Validate");
				}
				
				public LocalizedTranslation VerificationCode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VerificationCode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VerificationCode", "Verification Code:");
						}
					}
				}
				
				public LocalizedTranslation VerificationCode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VerificationCode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VerificationCode", "Verification Code:");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerificationCode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VerificationCode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerificationCode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VerificationCode");
				}
				
				public LocalizedTranslation VerifiedIP(object ipAddress)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "VerifiedIP", ipAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VerifiedIP", "Your account can now be accessed from the requested IP Address ({ipAddress}).", ipAddress);
					}
				}
				
				public LocalizedTranslation VerifiedIP_ForLanguageID(int languageID, object ipAddress)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VerifiedIP", ipAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VerifiedIP", "Your account can now be accessed from the requested IP Address ({ipAddress}).", ipAddress);
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerifiedIP(object ipAddress)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "VerifiedIP", ipAddress);
				}
				
				public LazyLocalizedTranslation Lazy_VerifiedIP_ForLanguageID(int languageID, object ipAddress)
				{
					return this.CalculateLazyTranslation(languageID, "VerifiedIP", ipAddress);
				}
				
				public LocalizedTranslation VerifyAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VerifyAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VerifyAccount", "Verify Account Ownership");
						}
					}
				}
				
				public LocalizedTranslation VerifyAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VerifyAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VerifyAccount", "Verify Account Ownership");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerifyAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VerifyAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerifyAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VerifyAccount");
				}
				
				public LocalizedTranslation VerifyChoices
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VerifyChoices");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VerifyChoices", "You can verify your account with one of the following options:");
						}
					}
				}
				
				public LocalizedTranslation VerifyChoices_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VerifyChoices");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VerifyChoices", "You can verify your account with one of the following options:");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerifyChoices
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VerifyChoices");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VerifyChoices_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VerifyChoices");
				}
				

				#endregion
			}
			
			private AuthenticationSubNamespace _cacheAuthentication;
			public AuthenticationSubNamespace Authentication
			{
				get
				{
					if (_cacheAuthentication == null)
					{
						_cacheAuthentication = new AuthenticationSubNamespace();
					}
					return _cacheAuthentication;
				}
			}
			public sealed class BillingSubNamespace : SubNamespaceBase
			{
				public BillingSubNamespace() : base("Global", "Billing") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AcceptPremiumToS
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AcceptPremiumToS");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AcceptPremiumToS", "I have read and agree to the <a href='http://www.curse.com/terms' target='_blank'>Premium Terms of Service</a>");
						}
					}
				}
				
				public LocalizedTranslation AcceptPremiumToS_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AcceptPremiumToS");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AcceptPremiumToS", "I have read and agree to the <a href='http://www.curse.com/terms' target='_blank'>Premium Terms of Service</a>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptPremiumToS
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AcceptPremiumToS");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptPremiumToS_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AcceptPremiumToS");
				}
				
				public LocalizedTranslation AcceptTerms
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AcceptTerms");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AcceptTerms", "Accept Terms");
						}
					}
				}
				
				public LocalizedTranslation AcceptTerms_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AcceptTerms");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AcceptTerms", "Accept Terms");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptTerms
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AcceptTerms");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptTerms_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AcceptTerms");
				}
				
				public LocalizedTranslation AcceptToS
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AcceptToS");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AcceptToS", "I have read and agree to the <a href='http://www.curse.com/terms' target='_blank'>Terms of Service</a>");
						}
					}
				}
				
				public LocalizedTranslation AcceptToS_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AcceptToS");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AcceptToS", "I have read and agree to the <a href='http://www.curse.com/terms' target='_blank'>Terms of Service</a>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptToS
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AcceptToS");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptToS_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AcceptToS");
				}
				
				public LocalizedTranslation AccountID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AccountID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AccountID", "Account ID");
						}
					}
				}
				
				public LocalizedTranslation AccountID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AccountID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountID", "Account ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AccountID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AccountID");
				}
				
				public LocalizedTranslation AccountNumberInvalid
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AccountNumberInvalid");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AccountNumberInvalid", "Account number is invalid.");
						}
					}
				}
				
				public LocalizedTranslation AccountNumberInvalid_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AccountNumberInvalid");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountNumberInvalid", "Account number is invalid.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountNumberInvalid
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AccountNumberInvalid");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountNumberInvalid_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AccountNumberInvalid");
				}
				
				public LocalizedTranslation AddPaymentMethod
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddPaymentMethod");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddPaymentMethod", "Add Payment Method");
						}
					}
				}
				
				public LocalizedTranslation AddPaymentMethod_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddPaymentMethod");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddPaymentMethod", "Add Payment Method");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPaymentMethod
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddPaymentMethod");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPaymentMethod_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddPaymentMethod");
				}
				
				public LocalizedTranslation Address1
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Address1");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Address1", "Address 1");
						}
					}
				}
				
				public LocalizedTranslation Address1_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Address1");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Address1", "Address 1");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address1
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Address1");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address1_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Address1");
				}
				
				public LocalizedTranslation Address2
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Address2");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Address2", "Address 2");
						}
					}
				}
				
				public LocalizedTranslation Address2_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Address2");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Address2", "Address 2");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address2
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Address2");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address2_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Address2");
				}
				
				public LocalizedTranslation AfterCompletingThisForm
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AfterCompletingThisForm");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AfterCompletingThisForm", "After completing this form, you will be forwarded to PayPal to complete the transaction.");
						}
					}
				}
				
				public LocalizedTranslation AfterCompletingThisForm_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AfterCompletingThisForm");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AfterCompletingThisForm", "After completing this form, you will be forwarded to PayPal to complete the transaction.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AfterCompletingThisForm
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AfterCompletingThisForm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AfterCompletingThisForm_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AfterCompletingThisForm");
				}
				
				public LocalizedTranslation AutoRenew
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AutoRenew");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AutoRenew", "Auto Renew");
						}
					}
				}
				
				public LocalizedTranslation AutoRenew_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AutoRenew");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AutoRenew", "Auto Renew");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoRenew
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AutoRenew");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoRenew_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AutoRenew");
				}
				
				public LocalizedTranslation BillingAccountID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BillingAccountID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BillingAccountID", "Billing Account ID");
						}
					}
				}
				
				public LocalizedTranslation BillingAccountID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BillingAccountID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BillingAccountID", "Billing Account ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingAccountID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BillingAccountID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingAccountID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BillingAccountID");
				}
				
				public LocalizedTranslation BillingPlanID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BillingPlanID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BillingPlanID", "Billing Plan ID");
						}
					}
				}
				
				public LocalizedTranslation BillingPlanID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BillingPlanID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BillingPlanID", "Billing Plan ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingPlanID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BillingPlanID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingPlanID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BillingPlanID");
				}
				
				public LocalizedTranslation BillingTransactions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BillingTransactions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BillingTransactions", "Billing Transactions");
						}
					}
				}
				
				public LocalizedTranslation BillingTransactions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BillingTransactions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BillingTransactions", "Billing Transactions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingTransactions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BillingTransactions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BillingTransactions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BillingTransactions");
				}
				
				public LocalizedTranslation BundledSubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BundledSubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BundledSubscriptions", "Bundled Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation BundledSubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BundledSubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BundledSubscriptions", "Bundled Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BundledSubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BundledSubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BundledSubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BundledSubscriptions");
				}
				
				public LocalizedTranslation Buy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Buy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Buy", "Buy");
						}
					}
				}
				
				public LocalizedTranslation Buy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Buy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Buy", "Buy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Buy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Buy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Buy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Buy");
				}
				
				public LocalizedTranslation CardHasExpired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CardHasExpired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CardHasExpired", "Card has expired.");
						}
					}
				}
				
				public LocalizedTranslation CardHasExpired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CardHasExpired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CardHasExpired", "Card has expired.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CardHasExpired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CardHasExpired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CardHasExpired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CardHasExpired");
				}
				
				public LocalizedTranslation CardNumber
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CardNumber");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CardNumber", "Card Number");
						}
					}
				}
				
				public LocalizedTranslation CardNumber_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CardNumber");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CardNumber", "Card Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CardNumber
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CardNumber");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CardNumber_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CardNumber");
				}
				
				public LocalizedTranslation Checkout
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Checkout");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Checkout", "Checkout");
						}
					}
				}
				
				public LocalizedTranslation Checkout_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Checkout");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Checkout", "Checkout");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Checkout
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Checkout");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Checkout_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Checkout");
				}
				
				public LocalizedTranslation CodeApplied
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CodeApplied");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CodeApplied", "Code Applied");
						}
					}
				}
				
				public LocalizedTranslation CodeApplied_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CodeApplied");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CodeApplied", "Code Applied");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CodeApplied
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CodeApplied");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CodeApplied_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CodeApplied");
				}
				
				public LocalizedTranslation CodeCouldNotBeClaimed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CodeCouldNotBeClaimed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CodeCouldNotBeClaimed", "Code Could Not Be Claimed");
						}
					}
				}
				
				public LocalizedTranslation CodeCouldNotBeClaimed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CodeCouldNotBeClaimed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CodeCouldNotBeClaimed", "Code Could Not Be Claimed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CodeCouldNotBeClaimed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CodeCouldNotBeClaimed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CodeCouldNotBeClaimed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CodeCouldNotBeClaimed");
				}
				
				public LocalizedTranslation CompletePurchase
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CompletePurchase");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CompletePurchase", "Complete Purchase");
						}
					}
				}
				
				public LocalizedTranslation CompletePurchase_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CompletePurchase");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CompletePurchase", "Complete Purchase");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompletePurchase
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CompletePurchase");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CompletePurchase_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CompletePurchase");
				}
				
				public LocalizedTranslation CouponCodeAlreadyClaimed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CouponCodeAlreadyClaimed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CouponCodeAlreadyClaimed", "This code has already been claimed.");
						}
					}
				}
				
				public LocalizedTranslation CouponCodeAlreadyClaimed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponCodeAlreadyClaimed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponCodeAlreadyClaimed", "This code has already been claimed.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeAlreadyClaimed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponCodeAlreadyClaimed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeAlreadyClaimed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CouponCodeAlreadyClaimed");
				}
				
				public LocalizedTranslation CouponCodeDesc
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CouponCodeDesc");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CouponCodeDesc", "Enter your code to claim your gift certificate. If you have an active subscription or tokens, your next bill or charge date will be pushed back by the length of the coupon.");
						}
					}
				}
				
				public LocalizedTranslation CouponCodeDesc_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponCodeDesc");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponCodeDesc", "Enter your code to claim your gift certificate. If you have an active subscription or tokens, your next bill or charge date will be pushed back by the length of the coupon.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeDesc
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponCodeDesc");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeDesc_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CouponCodeDesc");
				}
				
				public LocalizedTranslation CouponCodeExpired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CouponCodeExpired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CouponCodeExpired", "This code has expired.");
						}
					}
				}
				
				public LocalizedTranslation CouponCodeExpired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponCodeExpired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponCodeExpired", "This code has expired.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeExpired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponCodeExpired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeExpired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CouponCodeExpired");
				}
				
				public LocalizedTranslation CouponCodeWatermark
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CouponCodeWatermark");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CouponCodeWatermark", "XXXX-XXXX-XXXX-XXXX");
						}
					}
				}
				
				public LocalizedTranslation CouponCodeWatermark_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponCodeWatermark");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponCodeWatermark", "XXXX-XXXX-XXXX-XXXX");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeWatermark
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponCodeWatermark");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponCodeWatermark_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CouponCodeWatermark");
				}
				
				public LocalizedTranslation CouponRedemptionHtmlBody(object couponCode, object entitleEntity)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CouponRedemptionHtmlBody", couponCode, entitleEntity);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponRedemptionHtmlBody", "Your coupon {couponCode} has been successfully applied to {entitleEntity}.", couponCode, entitleEntity);
					}
				}
				
				public LocalizedTranslation CouponRedemptionHtmlBody_ForLanguageID(int languageID, object couponCode, object entitleEntity)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponRedemptionHtmlBody", couponCode, entitleEntity);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponRedemptionHtmlBody", "Your coupon {couponCode} has been successfully applied to {entitleEntity}.", couponCode, entitleEntity);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionHtmlBody(object couponCode, object entitleEntity)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponRedemptionHtmlBody", couponCode, entitleEntity);
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionHtmlBody_ForLanguageID(int languageID, object couponCode, object entitleEntity)
				{
					return this.CalculateLazyTranslation(languageID, "CouponRedemptionHtmlBody", couponCode, entitleEntity);
				}
				
				public LocalizedTranslation CouponRedemptionSubject
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CouponRedemptionSubject");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CouponRedemptionSubject", "Your coupon redemption");
						}
					}
				}
				
				public LocalizedTranslation CouponRedemptionSubject_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponRedemptionSubject");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponRedemptionSubject", "Your coupon redemption");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionSubject
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponRedemptionSubject");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionSubject_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CouponRedemptionSubject");
				}
				
				public LocalizedTranslation CouponRedemptionTextBody(object couponCode, object entitleEntity)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CouponRedemptionTextBody", couponCode, entitleEntity);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponRedemptionTextBody", "Your coupon {couponCode} has been successfully applied to {entitleEntity}.", couponCode, entitleEntity);
					}
				}
				
				public LocalizedTranslation CouponRedemptionTextBody_ForLanguageID(int languageID, object couponCode, object entitleEntity)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CouponRedemptionTextBody", couponCode, entitleEntity);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CouponRedemptionTextBody", "Your coupon {couponCode} has been successfully applied to {entitleEntity}.", couponCode, entitleEntity);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionTextBody(object couponCode, object entitleEntity)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CouponRedemptionTextBody", couponCode, entitleEntity);
				}
				
				public LazyLocalizedTranslation Lazy_CouponRedemptionTextBody_ForLanguageID(int languageID, object couponCode, object entitleEntity)
				{
					return this.CalculateLazyTranslation(languageID, "CouponRedemptionTextBody", couponCode, entitleEntity);
				}
				
				public LocalizedTranslation Credit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Credit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Credit", "Credit");
						}
					}
				}
				
				public LocalizedTranslation Credit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Credit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Credit", "Credit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Credit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Credit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Credit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Credit");
				}
				
				public LocalizedTranslation CreditTokens
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreditTokens");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreditTokens", "Credit Tokens");
						}
					}
				}
				
				public LocalizedTranslation CreditTokens_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreditTokens");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreditTokens", "Credit Tokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreditTokens
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreditTokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreditTokens_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreditTokens");
				}
				
				public LocalizedTranslation CurrentSubscription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CurrentSubscription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CurrentSubscription", "Current Subscription");
						}
					}
				}
				
				public LocalizedTranslation CurrentSubscription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CurrentSubscription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CurrentSubscription", "Current Subscription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurrentSubscription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CurrentSubscription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurrentSubscription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CurrentSubscription");
				}
				
				public LocalizedTranslation CVV2Number
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CVV2Number");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CVV2Number", "CVV2 Number");
						}
					}
				}
				
				public LocalizedTranslation CVV2Number_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CVV2Number");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CVV2Number", "CVV2 Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CVV2Number
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CVV2Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CVV2Number_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CVV2Number");
				}
				
				public LocalizedTranslation CVVError
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CVVError");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CVVError", "CVV code must be a number.");
						}
					}
				}
				
				public LocalizedTranslation CVVError_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CVVError");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CVVError", "CVV code must be a number.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CVVError
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CVVError");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CVVError_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CVVError");
				}
				
				public LocalizedTranslation DebitTokens
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DebitTokens");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DebitTokens", "Debit Tokens");
						}
					}
				}
				
				public LocalizedTranslation DebitTokens_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DebitTokens");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DebitTokens", "Debit Tokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DebitTokens
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DebitTokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DebitTokens_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DebitTokens");
				}
				
				public LocalizedTranslation EmailAddress
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EmailAddress");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EmailAddress", "Email Address");
						}
					}
				}
				
				public LocalizedTranslation EmailAddress_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailAddress");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailAddress", "Email Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailAddress
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailAddress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailAddress_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EmailAddress");
				}
				
				public LocalizedTranslation EmailConfirmationWillBeSent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EmailConfirmationWillBeSent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EmailConfirmationWillBeSent", "An e-mail confirmation will be sent to you.");
						}
					}
				}
				
				public LocalizedTranslation EmailConfirmationWillBeSent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailConfirmationWillBeSent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailConfirmationWillBeSent", "An e-mail confirmation will be sent to you.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailConfirmationWillBeSent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailConfirmationWillBeSent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailConfirmationWillBeSent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EmailConfirmationWillBeSent");
				}
				
				public LocalizedTranslation EndingIn(object creditCardType, object number)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "EndingIn", creditCardType, number);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EndingIn", "{creditCardType} ending in {number}", creditCardType, number);
					}
				}
				
				public LocalizedTranslation EndingIn_ForLanguageID(int languageID, object creditCardType, object number)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EndingIn", creditCardType, number);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EndingIn", "{creditCardType} ending in {number}", creditCardType, number);
					}
				}
				
				public LazyLocalizedTranslation Lazy_EndingIn(object creditCardType, object number)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "EndingIn", creditCardType, number);
				}
				
				public LazyLocalizedTranslation Lazy_EndingIn_ForLanguageID(int languageID, object creditCardType, object number)
				{
					return this.CalculateLazyTranslation(languageID, "EndingIn", creditCardType, number);
				}
				
				public LocalizedTranslation Entitlement
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Entitlement");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Entitlement", "Entitlement");
						}
					}
				}
				
				public LocalizedTranslation Entitlement_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Entitlement");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Entitlement", "Entitlement");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entitlement
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Entitlement");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entitlement_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Entitlement");
				}
				
				public LocalizedTranslation EntitlementsChanging(object numDays)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "EntitlementsChanging", numDays);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EntitlementsChanging", "<p>The new subscription you have chosen contains different entitlements than your current subscription.\r\nAs a result, your current subscription will be cancelled, and your new subscription will be credited <strong>{numDays} days.</strong></p>\r\n", numDays);
					}
				}
				
				public LocalizedTranslation EntitlementsChanging_ForLanguageID(int languageID, object numDays)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EntitlementsChanging", numDays);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EntitlementsChanging", "<p>The new subscription you have chosen contains different entitlements than your current subscription.\r\nAs a result, your current subscription will be cancelled, and your new subscription will be credited <strong>{numDays} days.</strong></p>\r\n", numDays);
					}
				}
				
				public LazyLocalizedTranslation Lazy_EntitlementsChanging(object numDays)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "EntitlementsChanging", numDays);
				}
				
				public LazyLocalizedTranslation Lazy_EntitlementsChanging_ForLanguageID(int languageID, object numDays)
				{
					return this.CalculateLazyTranslation(languageID, "EntitlementsChanging", numDays);
				}
				
				public LocalizedTranslation Entitles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Entitles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Entitles", "Entitles");
						}
					}
				}
				
				public LocalizedTranslation Entitles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Entitles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Entitles", "Entitles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entitles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Entitles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entitles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Entitles");
				}
				
				public LocalizedTranslation Expiration
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Expiration");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Expiration", "Expiration");
						}
					}
				}
				
				public LocalizedTranslation Expiration_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Expiration");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Expiration", "Expiration");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Expiration
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Expiration");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Expiration_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Expiration");
				}
				
				public LocalizedTranslation GiftCertificates
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GiftCertificates");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GiftCertificates", "Gift Certificates");
						}
					}
				}
				
				public LocalizedTranslation GiftCertificates_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GiftCertificates");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GiftCertificates", "Gift Certificates");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GiftCertificates
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GiftCertificates");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GiftCertificates_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GiftCertificates");
				}
				
				public LocalizedTranslation GroupPayments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GroupPayments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GroupPayments", "Group Payments");
						}
					}
				}
				
				public LocalizedTranslation GroupPayments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GroupPayments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GroupPayments", "Group Payments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GroupPayments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GroupPayments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GroupPayments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GroupPayments");
				}
				
				public LocalizedTranslation GroupPlansUpdated(object link)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "GroupPlansUpdated", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GroupPlansUpdated", "Your group plans were successfully saved. Click <a href=\"{link}\">here</a> to contribute.", link);
					}
				}
				
				public LocalizedTranslation GroupPlansUpdated_ForLanguageID(int languageID, object link)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GroupPlansUpdated", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GroupPlansUpdated", "Your group plans were successfully saved. Click <a href=\"{link}\">here</a> to contribute.", link);
					}
				}
				
				public LazyLocalizedTranslation Lazy_GroupPlansUpdated(object link)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "GroupPlansUpdated", link);
				}
				
				public LazyLocalizedTranslation Lazy_GroupPlansUpdated_ForLanguageID(int languageID, object link)
				{
					return this.CalculateLazyTranslation(languageID, "GroupPlansUpdated", link);
				}
				
				public LocalizedTranslation GuildHostingPremiumFeatures
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingPremiumFeatures");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingPremiumFeatures", "Guild Hosting Premium Features");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingPremiumFeatures_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingPremiumFeatures");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingPremiumFeatures", "Guild Hosting Premium Features");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingPremiumFeatures
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingPremiumFeatures");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingPremiumFeatures_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingPremiumFeatures");
				}
				
				public LocalizedTranslation GuildHostingSubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingSubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingSubscriptions", "Guild Hosting Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingSubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingSubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingSubscriptions", "Guild Hosting Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingSubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingSubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingSubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingSubscriptions");
				}
				
				public LocalizedTranslation HideAutomaticTransactions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HideAutomaticTransactions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HideAutomaticTransactions", "Hide Automatic Transactions");
						}
					}
				}
				
				public LocalizedTranslation HideAutomaticTransactions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HideAutomaticTransactions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HideAutomaticTransactions", "Hide Automatic Transactions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HideAutomaticTransactions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HideAutomaticTransactions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HideAutomaticTransactions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HideAutomaticTransactions");
				}
				
				public LocalizedTranslation InvalidCode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InvalidCode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InvalidCode", "Invalid code");
						}
					}
				}
				
				public LocalizedTranslation InvalidCode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidCode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidCode", "Invalid code");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidCode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidCode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidCode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidCode");
				}
				
				public LocalizedTranslation IssueRefund
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IssueRefund");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IssueRefund", "Issue Refund");
						}
					}
				}
				
				public LocalizedTranslation IssueRefund_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IssueRefund");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IssueRefund", "Issue Refund");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IssueRefund
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IssueRefund");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IssueRefund_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IssueRefund");
				}
				
				public LocalizedTranslation ItemDetails
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ItemDetails");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ItemDetails", "Item Details");
						}
					}
				}
				
				public LocalizedTranslation ItemDetails_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ItemDetails");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ItemDetails", "Item Details");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ItemDetails
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ItemDetails");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ItemDetails_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ItemDetails");
				}
				
				public LocalizedTranslation LegacySubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LegacySubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LegacySubscriptions", "Legacy Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation LegacySubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LegacySubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LegacySubscriptions", "Legacy Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LegacySubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LegacySubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LegacySubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LegacySubscriptions");
				}
				
				public LocalizedTranslation NameOnCard
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NameOnCard");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NameOnCard", "Name on Card");
						}
					}
				}
				
				public LocalizedTranslation NameOnCard_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NameOnCard");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NameOnCard", "Name on Card");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NameOnCard
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NameOnCard");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NameOnCard_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NameOnCard");
				}
				
				public LocalizedTranslation NameOnPaypalAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NameOnPaypalAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NameOnPaypalAccount", "Name on Paypal Account");
						}
					}
				}
				
				public LocalizedTranslation NameOnPaypalAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NameOnPaypalAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NameOnPaypalAccount", "Name on Paypal Account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NameOnPaypalAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NameOnPaypalAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NameOnPaypalAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NameOnPaypalAccount");
				}
				
				public LocalizedTranslation NewSubscription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NewSubscription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NewSubscription", "New Subscription");
						}
					}
				}
				
				public LocalizedTranslation NewSubscription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NewSubscription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NewSubscription", "New Subscription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NewSubscription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NewSubscription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NewSubscription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NewSubscription");
				}
				
				public LocalizedTranslation OrderNumber
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OrderNumber");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OrderNumber", "Order Number");
						}
					}
				}
				
				public LocalizedTranslation OrderNumber_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OrderNumber");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OrderNumber", "Order Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OrderNumber
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OrderNumber");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OrderNumber_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OrderNumber");
				}
				
				public LocalizedTranslation Payment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Payment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Payment", "Payment");
						}
					}
				}
				
				public LocalizedTranslation Payment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Payment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Payment", "Payment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Payment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Payment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Payment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Payment");
				}
				
				public LocalizedTranslation PaymentMethod
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PaymentMethod");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PaymentMethod", "Payment Method");
						}
					}
				}
				
				public LocalizedTranslation PaymentMethod_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PaymentMethod");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PaymentMethod", "Payment Method");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethod
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PaymentMethod");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethod_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PaymentMethod");
				}
				
				public LocalizedTranslation PaymentMethodCardDesc(object digits, object type)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PaymentMethodCardDesc", digits, type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PaymentMethodCardDesc", "{type} ending in {digits}", digits, type);
					}
				}
				
				public LocalizedTranslation PaymentMethodCardDesc_ForLanguageID(int languageID, object digits, object type)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PaymentMethodCardDesc", digits, type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PaymentMethodCardDesc", "{type} ending in {digits}", digits, type);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethodCardDesc(object digits, object type)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PaymentMethodCardDesc", digits, type);
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethodCardDesc_ForLanguageID(int languageID, object digits, object type)
				{
					return this.CalculateLazyTranslation(languageID, "PaymentMethodCardDesc", digits, type);
				}
				
				public LocalizedTranslation PaymentMethodPaypalDesc(object email)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PaymentMethodPaypalDesc", email);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PaymentMethodPaypalDesc", "PayPal: {email}", email);
					}
				}
				
				public LocalizedTranslation PaymentMethodPaypalDesc_ForLanguageID(int languageID, object email)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PaymentMethodPaypalDesc", email);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PaymentMethodPaypalDesc", "PayPal: {email}", email);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethodPaypalDesc(object email)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PaymentMethodPaypalDesc", email);
				}
				
				public LazyLocalizedTranslation Lazy_PaymentMethodPaypalDesc_ForLanguageID(int languageID, object email)
				{
					return this.CalculateLazyTranslation(languageID, "PaymentMethodPaypalDesc", email);
				}
				
				public LocalizedTranslation PayPalEmail(object emailAddress)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PayPalEmail", emailAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PayPalEmail", "PayPal: {emailAddress}", emailAddress);
					}
				}
				
				public LocalizedTranslation PayPalEmail_ForLanguageID(int languageID, object emailAddress)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PayPalEmail", emailAddress);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PayPalEmail", "PayPal: {emailAddress}", emailAddress);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayPalEmail(object emailAddress)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PayPalEmail", emailAddress);
				}
				
				public LazyLocalizedTranslation Lazy_PayPalEmail_ForLanguageID(int languageID, object emailAddress)
				{
					return this.CalculateLazyTranslation(languageID, "PayPalEmail", emailAddress);
				}
				
				public LocalizedTranslation PayPalForward
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PayPalForward");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PayPalForward", "After completing this form, you will be forwarded to PayPal to complete the transaction.");
						}
					}
				}
				
				public LocalizedTranslation PayPalForward_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PayPalForward");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PayPalForward", "After completing this form, you will be forwarded to PayPal to complete the transaction.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayPalForward
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PayPalForward");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayPalForward_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PayPalForward");
				}
				
				public LocalizedTranslation PayPalInformation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PayPalInformation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PayPalInformation", "PayPal Information");
						}
					}
				}
				
				public LocalizedTranslation PayPalInformation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PayPalInformation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PayPalInformation", "PayPal Information");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayPalInformation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PayPalInformation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayPalInformation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PayPalInformation");
				}
				
				public LocalizedTranslation PayWith
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PayWith");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PayWith", "Pay with");
						}
					}
				}
				
				public LocalizedTranslation PayWith_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PayWith");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PayWith", "Pay with");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayWith
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PayWith");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PayWith_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PayWith");
				}
				
				public LocalizedTranslation Plan
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Plan");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Plan", "Plan");
						}
					}
				}
				
				public LocalizedTranslation Plan_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Plan");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Plan", "Plan");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Plan
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Plan");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Plan_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Plan");
				}
				
				public LocalizedTranslation PlanToApplyTokensTo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PlanToApplyTokensTo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PlanToApplyTokensTo", "Plan to apply tokens to");
						}
					}
				}
				
				public LocalizedTranslation PlanToApplyTokensTo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PlanToApplyTokensTo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PlanToApplyTokensTo", "Plan to apply tokens to");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlanToApplyTokensTo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PlanToApplyTokensTo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlanToApplyTokensTo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PlanToApplyTokensTo");
				}
				
				public LocalizedTranslation PostalCode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostalCode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostalCode", "Postal Code");
						}
					}
				}
				
				public LocalizedTranslation PostalCode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostalCode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostalCode", "Postal Code");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostalCode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostalCode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostalCode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostalCode");
				}
				
				public LocalizedTranslation PoweredByVentrilo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PoweredByVentrilo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PoweredByVentrilo", "Powered by Ventrilo");
						}
					}
				}
				
				public LocalizedTranslation PoweredByVentrilo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PoweredByVentrilo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PoweredByVentrilo", "Powered by Ventrilo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PoweredByVentrilo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PoweredByVentrilo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PoweredByVentrilo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PoweredByVentrilo");
				}
				
				public LocalizedTranslation ProductID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ProductID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ProductID", "Product ID");
						}
					}
				}
				
				public LocalizedTranslation ProductID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ProductID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ProductID", "Product ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ProductID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ProductID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ProductID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ProductID");
				}
				
				public LocalizedTranslation PurchasedTokens
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PurchasedTokens");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PurchasedTokens", "Purchased Tokens");
						}
					}
				}
				
				public LocalizedTranslation PurchasedTokens_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PurchasedTokens");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PurchasedTokens", "Purchased Tokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PurchasedTokens
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PurchasedTokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PurchasedTokens_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PurchasedTokens");
				}
				
				public LocalizedTranslation RedeemGiftCertifcate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RedeemGiftCertifcate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RedeemGiftCertifcate", "Redeem Gift Certificate");
						}
					}
				}
				
				public LocalizedTranslation RedeemGiftCertifcate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RedeemGiftCertifcate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RedeemGiftCertifcate", "Redeem Gift Certificate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RedeemGiftCertifcate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RedeemGiftCertifcate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RedeemGiftCertifcate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RedeemGiftCertifcate");
				}
				
				public LocalizedTranslation SelectPaymentMethod
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectPaymentMethod");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectPaymentMethod", "Select Payment Method");
						}
					}
				}
				
				public LocalizedTranslation SelectPaymentMethod_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectPaymentMethod");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectPaymentMethod", "Select Payment Method");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectPaymentMethod
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectPaymentMethod");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectPaymentMethod_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectPaymentMethod");
				}
				
				public LocalizedTranslation SubscriptionID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SubscriptionID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SubscriptionID", "Subscription ID");
						}
					}
				}
				
				public LocalizedTranslation SubscriptionID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubscriptionID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubscriptionID", "Subscription ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SubscriptionID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SubscriptionID");
				}
				
				public LocalizedTranslation SubscriptionIDValue(object subscriptionID)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "SubscriptionIDValue", subscriptionID);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubscriptionIDValue", "Subscription ID: {subscriptionID}", subscriptionID);
					}
				}
				
				public LocalizedTranslation SubscriptionIDValue_ForLanguageID(int languageID, object subscriptionID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubscriptionIDValue", subscriptionID);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubscriptionIDValue", "Subscription ID: {subscriptionID}", subscriptionID);
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionIDValue(object subscriptionID)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "SubscriptionIDValue", subscriptionID);
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionIDValue_ForLanguageID(int languageID, object subscriptionID)
				{
					return this.CalculateLazyTranslation(languageID, "SubscriptionIDValue", subscriptionID);
				}
				
				public LocalizedTranslation SubscriptionOptionsComingSoon
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SubscriptionOptionsComingSoon");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SubscriptionOptionsComingSoon", "Subscription Options Coming Soon");
						}
					}
				}
				
				public LocalizedTranslation SubscriptionOptionsComingSoon_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubscriptionOptionsComingSoon");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubscriptionOptionsComingSoon", "Subscription Options Coming Soon");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionOptionsComingSoon
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SubscriptionOptionsComingSoon");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubscriptionOptionsComingSoon_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SubscriptionOptionsComingSoon");
				}
				
				public LocalizedTranslation SubTotal
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SubTotal");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SubTotal", "Sub Total");
						}
					}
				}
				
				public LocalizedTranslation SubTotal_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubTotal");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubTotal", "Sub Total");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubTotal
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SubTotal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubTotal_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SubTotal");
				}
				
				public LocalizedTranslation Tax
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tax");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tax", "Tax");
						}
					}
				}
				
				public LocalizedTranslation Tax_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tax");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tax", "Tax");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tax
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tax");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tax_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tax");
				}
				
				public LocalizedTranslation TokenAmount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TokenAmount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TokenAmount", "Token Amount");
						}
					}
				}
				
				public LocalizedTranslation TokenAmount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokenAmount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenAmount", "Token Amount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenAmount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TokenAmount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenAmount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TokenAmount");
				}
				
				public LocalizedTranslation TokenExpiration(object description, object effectiveDays)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TokenExpiration", description, effectiveDays);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenExpiration", "{effectiveDays:0.##} days of {description}", description, effectiveDays);
					}
				}
				
				public LocalizedTranslation TokenExpiration_ForLanguageID(int languageID, object description, object effectiveDays)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokenExpiration", description, effectiveDays);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenExpiration", "{effectiveDays:0.##} days of {description}", description, effectiveDays);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenExpiration(object description, object effectiveDays)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TokenExpiration", description, effectiveDays);
				}
				
				public LazyLocalizedTranslation Lazy_TokenExpiration_ForLanguageID(int languageID, object description, object effectiveDays)
				{
					return this.CalculateLazyTranslation(languageID, "TokenExpiration", description, effectiveDays);
				}
				
				public LocalizedTranslation TokenRate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TokenRate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TokenRate", "Token Rate");
						}
					}
				}
				
				public LocalizedTranslation TokenRate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokenRate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenRate", "Token Rate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenRate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TokenRate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenRate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TokenRate");
				}
				
				public LocalizedTranslation TokenRatePerDay(object numTokens)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TokenRatePerDay", numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenRatePerDay", "{numTokens} PLURAL[{numTokens};token;tokens] / day", numTokens);
					}
				}
				
				public LocalizedTranslation TokenRatePerDay_ForLanguageID(int languageID, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokenRatePerDay", numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenRatePerDay", "{numTokens} PLURAL[{numTokens};token;tokens] / day", numTokens);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenRatePerDay(object numTokens)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TokenRatePerDay", numTokens);
				}
				
				public LazyLocalizedTranslation Lazy_TokenRatePerDay_ForLanguageID(int languageID, object numTokens)
				{
					return this.CalculateLazyTranslation(languageID, "TokenRatePerDay", numTokens);
				}
				
				public LocalizedTranslation TokenRatePerDays(object numDays, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TokenRatePerDays", numDays, numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenRatePerDays", "{numTokens} PLURAL[{numTokens};token;tokens] / {numDays} PLURAL[{numDays};day;days]", numDays, numTokens);
					}
				}
				
				public LocalizedTranslation TokenRatePerDays_ForLanguageID(int languageID, object numDays, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokenRatePerDays", numDays, numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokenRatePerDays", "{numTokens} PLURAL[{numTokens};token;tokens] / {numDays} PLURAL[{numDays};day;days]", numDays, numTokens);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokenRatePerDays(object numDays, object numTokens)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TokenRatePerDays", numDays, numTokens);
				}
				
				public LazyLocalizedTranslation Lazy_TokenRatePerDays_ForLanguageID(int languageID, object numDays, object numTokens)
				{
					return this.CalculateLazyTranslation(languageID, "TokenRatePerDays", numDays, numTokens);
				}
				
				public LocalizedTranslation Tokens
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tokens");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tokens", "Tokens");
						}
					}
				}
				
				public LocalizedTranslation Tokens_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tokens");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tokens", "Tokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tokens
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tokens");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tokens_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tokens");
				}
				
				public LocalizedTranslation TokensPerDay(object numTokens)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TokensPerDay", numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokensPerDay", "{numTokens} PLURAL[{numTokens};token;tokens] / day", numTokens);
					}
				}
				
				public LocalizedTranslation TokensPerDay_ForLanguageID(int languageID, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokensPerDay", numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokensPerDay", "{numTokens} PLURAL[{numTokens};token;tokens] / day", numTokens);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokensPerDay(object numTokens)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TokensPerDay", numTokens);
				}
				
				public LazyLocalizedTranslation Lazy_TokensPerDay_ForLanguageID(int languageID, object numTokens)
				{
					return this.CalculateLazyTranslation(languageID, "TokensPerDay", numTokens);
				}
				
				public LocalizedTranslation TokensPerMultipleDays(object numDays, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TokensPerMultipleDays", numDays, numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokensPerMultipleDays", "{numTokens} PLURAL[{numTokens};token;tokens] / {numDays} PLURAL[{numDays};day;days]", numDays, numTokens);
					}
				}
				
				public LocalizedTranslation TokensPerMultipleDays_ForLanguageID(int languageID, object numDays, object numTokens)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TokensPerMultipleDays", numDays, numTokens);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TokensPerMultipleDays", "{numTokens} PLURAL[{numTokens};token;tokens] / {numDays} PLURAL[{numDays};day;days]", numDays, numTokens);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TokensPerMultipleDays(object numDays, object numTokens)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TokensPerMultipleDays", numDays, numTokens);
				}
				
				public LazyLocalizedTranslation Lazy_TokensPerMultipleDays_ForLanguageID(int languageID, object numDays, object numTokens)
				{
					return this.CalculateLazyTranslation(languageID, "TokensPerMultipleDays", numDays, numTokens);
				}
				
				public LocalizedTranslation Total
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Total");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Total", "Total");
						}
					}
				}
				
				public LocalizedTranslation Total_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Total");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Total", "Total");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Total
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Total");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Total_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Total");
				}
				
				public LocalizedTranslation TransactionID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TransactionID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TransactionID", "Transaction ID");
						}
					}
				}
				
				public LocalizedTranslation TransactionID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TransactionID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TransactionID", "Transaction ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TransactionID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TransactionID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TransactionID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TransactionID");
				}
				
				public LocalizedTranslation TypeNotAcceptable(object type)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TypeNotAcceptable", type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TypeNotAcceptable", "{type} is not an acceptable card type.", type);
					}
				}
				
				public LocalizedTranslation TypeNotAcceptable_ForLanguageID(int languageID, object type)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TypeNotAcceptable", type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TypeNotAcceptable", "{type} is not an acceptable card type.", type);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TypeNotAcceptable(object type)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TypeNotAcceptable", type);
				}
				
				public LazyLocalizedTranslation Lazy_TypeNotAcceptable_ForLanguageID(int languageID, object type)
				{
					return this.CalculateLazyTranslation(languageID, "TypeNotAcceptable", type);
				}
				
				public LocalizedTranslation VentriloSubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VentriloSubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VentriloSubscriptions", "Ventrilo Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation VentriloSubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VentriloSubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VentriloSubscriptions", "Ventrilo Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VentriloSubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VentriloSubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VentriloSubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VentriloSubscriptions");
				}
				
				public LocalizedTranslation YouAreRedeemingACouponForColon
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "YouAreRedeemingACouponForColon");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("YouAreRedeemingACouponForColon", "You are redeeming a coupon for:");
						}
					}
				}
				
				public LocalizedTranslation YouAreRedeemingACouponForColon_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YouAreRedeemingACouponForColon");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YouAreRedeemingACouponForColon", "You are redeeming a coupon for:");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouAreRedeemingACouponForColon
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "YouAreRedeemingACouponForColon");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouAreRedeemingACouponForColon_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "YouAreRedeemingACouponForColon");
				}
				

				#endregion
			}
			
			private BillingSubNamespace _cacheBilling;
			public BillingSubNamespace Billing
			{
				get
				{
					if (_cacheBilling == null)
					{
						_cacheBilling = new BillingSubNamespace();
					}
					return _cacheBilling;
				}
			}
			public sealed class ButtonsSubNamespace : SubNamespaceBase
			{
				public ButtonsSubNamespace() : base("Global", "Buttons") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Activate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Activate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Activate", "Activate");
						}
					}
				}
				
				public LocalizedTranslation Activate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Activate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Activate", "Activate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Activate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Activate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Activate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Activate");
				}
				
				public LocalizedTranslation Add
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Add");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Add", "Add");
						}
					}
				}
				
				public LocalizedTranslation Add_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Add");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Add", "Add");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Add
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Add");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Add_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Add");
				}
				
				public LocalizedTranslation Agree
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Agree");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Agree", "Got It!");
						}
					}
				}
				
				public LocalizedTranslation Agree_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Agree");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Agree", "Got It!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Agree
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Agree");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Agree_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Agree");
				}
				
				public LocalizedTranslation ApproveAll
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ApproveAll");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ApproveAll", "Approve All");
						}
					}
				}
				
				public LocalizedTranslation ApproveAll_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ApproveAll");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ApproveAll", "Approve All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ApproveAll
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ApproveAll");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ApproveAll_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ApproveAll");
				}
				
				public LocalizedTranslation AttachFile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AttachFile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AttachFile", "Upload");
						}
					}
				}
				
				public LocalizedTranslation AttachFile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AttachFile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AttachFile", "Upload");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AttachFile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AttachFile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AttachFile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AttachFile");
				}
				
				public LocalizedTranslation Cancel
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Cancel");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Cancel", "Cancel");
						}
					}
				}
				
				public LocalizedTranslation Cancel_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Cancel");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Cancel", "Cancel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Cancel
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Cancel");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Cancel_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Cancel");
				}
				
				public LocalizedTranslation Complete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Complete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Complete", "Complete");
						}
					}
				}
				
				public LocalizedTranslation Complete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Complete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Complete", "Complete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Complete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Complete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Complete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Complete");
				}
				
				public LocalizedTranslation Create
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Create");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Create", "Create");
						}
					}
				}
				
				public LocalizedTranslation Create_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Create");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Create", "Create");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Create
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Create");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Create_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Create");
				}
				
				public LocalizedTranslation CreateNew(object EntityType)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CreateNew", EntityType);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateNew", "Create new {EntityType}", EntityType);
					}
				}
				
				public LocalizedTranslation CreateNew_ForLanguageID(int languageID, object EntityType)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateNew", EntityType);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateNew", "Create new {EntityType}", EntityType);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateNew(object EntityType)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateNew", EntityType);
				}
				
				public LazyLocalizedTranslation Lazy_CreateNew_ForLanguageID(int languageID, object EntityType)
				{
					return this.CalculateLazyTranslation(languageID, "CreateNew", EntityType);
				}
				
				public LocalizedTranslation Deactivate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Deactivate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Deactivate", "Deactivate");
						}
					}
				}
				
				public LocalizedTranslation Deactivate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Deactivate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Deactivate", "Deactivate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deactivate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Deactivate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deactivate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Deactivate");
				}
				
				public LocalizedTranslation Delete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Delete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Delete", "Delete");
						}
					}
				}
				
				public LocalizedTranslation Delete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Delete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Delete", "Delete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Delete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Delete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Delete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Delete");
				}
				
				public LocalizedTranslation DenyAll
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DenyAll");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DenyAll", "Deny All");
						}
					}
				}
				
				public LocalizedTranslation DenyAll_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DenyAll");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DenyAll", "Deny All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DenyAll
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DenyAll");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DenyAll_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DenyAll");
				}
				
				public LocalizedTranslation Disable
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Disable");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Disable", "Disable");
						}
					}
				}
				
				public LocalizedTranslation Disable_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Disable");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Disable", "Disable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disable
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Disable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disable_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Disable");
				}
				
				public LocalizedTranslation Edit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Edit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Edit", "Edit");
						}
					}
				}
				
				public LocalizedTranslation Edit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Edit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Edit", "Edit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Edit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Edit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Edit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Edit");
				}
				
				public LocalizedTranslation Enable
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Enable");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Enable", "Enable");
						}
					}
				}
				
				public LocalizedTranslation Enable_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Enable");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Enable", "Enable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enable
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Enable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enable_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Enable");
				}
				
				public LocalizedTranslation Follow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Follow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Follow", "Follow");
						}
					}
				}
				
				public LocalizedTranslation Follow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Follow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Follow", "Follow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Follow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Follow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Follow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Follow");
				}
				
				public LocalizedTranslation Login
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Login");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Login", "Login");
						}
					}
				}
				
				public LocalizedTranslation Login_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Login");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Login", "Login");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Login
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Login");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Login_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Login");
				}
				
				public LocalizedTranslation Male
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Male");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Male", "Male");
						}
					}
				}
				
				public LocalizedTranslation Male_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Male");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Male", "Male");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Male
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Male");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Male_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Male");
				}
				
				public LocalizedTranslation Push
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Push");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Push", "Push");
						}
					}
				}
				
				public LocalizedTranslation Push_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Push");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Push", "Push");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Push
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Push");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Push_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Push");
				}
				
				public LocalizedTranslation Register
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Register");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Register", "Register");
						}
					}
				}
				
				public LocalizedTranslation Register_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Register");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Register", "Register");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Register
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Register");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Register_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Register");
				}
				
				public LocalizedTranslation Save
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Save");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Save", "Save");
						}
					}
				}
				
				public LocalizedTranslation Save_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Save");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Save", "Save");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Save
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Save");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Save_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Save");
				}
				
				public LocalizedTranslation SaveChanges
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SaveChanges");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SaveChanges", "Save Changes");
						}
					}
				}
				
				public LocalizedTranslation SaveChanges_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SaveChanges");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SaveChanges", "Save Changes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SaveChanges
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SaveChanges");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SaveChanges_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SaveChanges");
				}
				
				public LocalizedTranslation Select
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Select");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Select", "Select");
						}
					}
				}
				
				public LocalizedTranslation Select_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Select");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Select", "Select");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Select
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Select");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Select_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Select");
				}
				
				public LocalizedTranslation SelectAPage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectAPage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectAPage", "Select a page");
						}
					}
				}
				
				public LocalizedTranslation SelectAPage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectAPage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectAPage", "Select a page");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectAPage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectAPage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectAPage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectAPage");
				}
				
				public LocalizedTranslation Start
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Start");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Start", "Start");
						}
					}
				}
				
				public LocalizedTranslation Start_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Start");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Start", "Start");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Start
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Start");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Start_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Start");
				}
				
				public LocalizedTranslation Submit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Submit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Submit", "Submit");
						}
					}
				}
				
				public LocalizedTranslation Submit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Submit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Submit", "Submit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Submit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Submit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Submit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Submit");
				}
				
				public LocalizedTranslation Undelete
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Undelete");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Undelete", "Undelete");
						}
					}
				}
				
				public LocalizedTranslation Undelete_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Undelete");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Undelete", "Undelete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undelete
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Undelete");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undelete_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Undelete");
				}
				
				public LocalizedTranslation Undo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Undo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Undo", "Undo");
						}
					}
				}
				
				public LocalizedTranslation Undo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Undo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Undo", "Undo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Undo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Undo");
				}
				
				public LocalizedTranslation Unfollow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unfollow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unfollow", "Stop Following");
						}
					}
				}
				
				public LocalizedTranslation Unfollow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unfollow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unfollow", "Stop Following");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unfollow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unfollow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unfollow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unfollow");
				}
				
				public LocalizedTranslation Update
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Update");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Update", "Update");
						}
					}
				}
				
				public LocalizedTranslation Update_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Update");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Update", "Update");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Update
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Update");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Update_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Update");
				}
				
				public LocalizedTranslation Upload
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Upload");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Upload", "Upload");
						}
					}
				}
				
				public LocalizedTranslation Upload_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Upload");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Upload", "Upload");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Upload
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Upload");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Upload_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Upload");
				}
				

				#endregion
			}
			
			private ButtonsSubNamespace _cacheButtons;
			public ButtonsSubNamespace Buttons
			{
				get
				{
					if (_cacheButtons == null)
					{
						_cacheButtons = new ButtonsSubNamespace();
					}
					return _cacheButtons;
				}
			}
			public sealed class CareerSubNamespace : SubNamespaceBase
			{
				public CareerSubNamespace() : base("Global", "Career") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AltApplyJobMsg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AltApplyJobMsg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AltApplyJobMsg", "<p> Interested in applying? Please send along your resume and cover letter to <a href=\"mailto:jobs@curse.com\">jobs@curse.com</a> with the position title as the subject line. </p>");
						}
					}
				}
				
				public LocalizedTranslation AltApplyJobMsg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AltApplyJobMsg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AltApplyJobMsg", "<p> Interested in applying? Please send along your resume and cover letter to <a href=\"mailto:jobs@curse.com\">jobs@curse.com</a> with the position title as the subject line. </p>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AltApplyJobMsg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AltApplyJobMsg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AltApplyJobMsg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AltApplyJobMsg");
				}
				
				public LocalizedTranslation ApplyForJob
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ApplyForJob");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ApplyForJob", "APPLY FOR THIS JOB");
						}
					}
				}
				
				public LocalizedTranslation ApplyForJob_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ApplyForJob");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ApplyForJob", "APPLY FOR THIS JOB");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ApplyForJob
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ApplyForJob");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ApplyForJob_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ApplyForJob");
				}
				
				public LocalizedTranslation CareerHeroImg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CareerHeroImg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CareerHeroImg", "http://media-corp.cursecdn.local/attachments/0/59/people.jpg");
						}
					}
				}
				
				public LocalizedTranslation CareerHeroImg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CareerHeroImg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CareerHeroImg", "http://media-corp.cursecdn.local/attachments/0/59/people.jpg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CareerHeroImg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CareerHeroImg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CareerHeroImg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CareerHeroImg");
				}
				
				public LocalizedTranslation CareerPostSlug
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CareerPostSlug");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CareerPostSlug", "career-page");
						}
					}
				}
				
				public LocalizedTranslation CareerPostSlug_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CareerPostSlug");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CareerPostSlug", "career-page");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CareerPostSlug
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CareerPostSlug");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CareerPostSlug_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CareerPostSlug");
				}
				
				public LocalizedTranslation NoJobsMsg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoJobsMsg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoJobsMsg", "There are currently no open positions");
						}
					}
				}
				
				public LocalizedTranslation NoJobsMsg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoJobsMsg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoJobsMsg", "There are currently no open positions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoJobsMsg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoJobsMsg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoJobsMsg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoJobsMsg");
				}
				
				public LocalizedTranslation OpenPosition
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OpenPosition");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OpenPosition", "Open Positions");
						}
					}
				}
				
				public LocalizedTranslation OpenPosition_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OpenPosition");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OpenPosition", "Open Positions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OpenPosition
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OpenPosition");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OpenPosition_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OpenPosition");
				}
				

				#endregion
			}
			
			private CareerSubNamespace _cacheCareer;
			public CareerSubNamespace Career
			{
				get
				{
					if (_cacheCareer == null)
					{
						_cacheCareer = new CareerSubNamespace();
					}
					return _cacheCareer;
				}
			}
			public sealed class CMSSubNamespace : SubNamespaceBase
			{
				public CMSSubNamespace() : base("Global", "CMS") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AutoPostToSocial
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AutoPostToSocial");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AutoPostToSocial", "Auto post to Social Networks");
						}
					}
				}
				
				public LocalizedTranslation AutoPostToSocial_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AutoPostToSocial");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AutoPostToSocial", "Auto post to Social Networks");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoPostToSocial
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AutoPostToSocial");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoPostToSocial_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AutoPostToSocial");
				}
				
				public LocalizedTranslation AutoPostToSocialDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AutoPostToSocialDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AutoPostToSocialDescription", "This will automatically post newly created posts to any social networks that have been linked to this site.");
						}
					}
				}
				
				public LocalizedTranslation AutoPostToSocialDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AutoPostToSocialDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AutoPostToSocialDescription", "This will automatically post newly created posts to any social networks that have been linked to this site.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoPostToSocialDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AutoPostToSocialDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AutoPostToSocialDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AutoPostToSocialDescription");
				}
				
				public LocalizedTranslation MediaGallery
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MediaGallery");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MediaGallery", "Media Gallery");
						}
					}
				}
				
				public LocalizedTranslation MediaGallery_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MediaGallery");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MediaGallery", "Media Gallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MediaGallery
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MediaGallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MediaGallery_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MediaGallery");
				}
				
				public LocalizedTranslation UfgEmbed(object channel, object video)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UfgEmbed", channel, video);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UfgEmbed", "<a href=\"http://unionforgamers.com/\">\r\n<div style=\"margin: 0 auto; width: 853px;\">\r\n  <iframe style=\"display: block;\" height=\"480\" width=\"853\" src=\"http://www.youtube.com/embed/{video}?wmode=transparent\" allowfullscreen=\"1\"></iframe>\r\n  <div style=\"height: 70px; background: #161616; color: #ffffff; font-size: 13px; font-family: Open Sans,sans-serif; border-bottom-left-radius: 3px; border-bottom-right-radius: 3px; border-top: 1px solid #272727; font-weight: normal;\">\r\n    <span style=\"width: 170px; display: block; float: left; height:70px;\">\r\n      <span style=\"display: inline-block; height: 100%; vertical-align: middle;\"></span>\r\n      <img style=\"margin-left: 10px; vertical-align:middle;\" alt=\"\" src=\"http://media-hearth.cursecdn.com/attachments/3/202/ufg-logo.png\" />\r\n    </span>\r\n    <span style=\"text-align: center; width: 483px; display: block; float: left; height:70px;\">\r\n      <span style=\"display: inline-block; height: 100%; vertical-align: middle;\"></span>\r\n      <p style=\"vertical-align:middle; display: inline-block;\">This channel is a part of the <span style=\"color: #fc5f15;\">Union For Gamers Network</span>.<br /><span style=\"color: #7e7e7e;\">Click for more info on Curse's Youtube partnership.</span></p>\r\n    </span>\r\n    <span style=\"width: 200px; display: block; float: left; padding-top: 9px;\">\r\n      <script src=\"https://apis.google.com/js/platform.js\"></script>\r\n      <div class=\"g-ytsubscribe\" data-channel=\"{channel}\" data-layout=\"full\" data-theme=\"dark\" data-count=\"default\"></div>\r\n    </span>\r\n    <span style=\"clear: both;\"></span>\r\n  </div>\r\n</div>\r\n</a>", channel, video);
					}
				}
				
				public LocalizedTranslation UfgEmbed_ForLanguageID(int languageID, object channel, object video)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UfgEmbed", channel, video);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UfgEmbed", "<a href=\"http://unionforgamers.com/\">\r\n<div style=\"margin: 0 auto; width: 853px;\">\r\n  <iframe style=\"display: block;\" height=\"480\" width=\"853\" src=\"http://www.youtube.com/embed/{video}?wmode=transparent\" allowfullscreen=\"1\"></iframe>\r\n  <div style=\"height: 70px; background: #161616; color: #ffffff; font-size: 13px; font-family: Open Sans,sans-serif; border-bottom-left-radius: 3px; border-bottom-right-radius: 3px; border-top: 1px solid #272727; font-weight: normal;\">\r\n    <span style=\"width: 170px; display: block; float: left; height:70px;\">\r\n      <span style=\"display: inline-block; height: 100%; vertical-align: middle;\"></span>\r\n      <img style=\"margin-left: 10px; vertical-align:middle;\" alt=\"\" src=\"http://media-hearth.cursecdn.com/attachments/3/202/ufg-logo.png\" />\r\n    </span>\r\n    <span style=\"text-align: center; width: 483px; display: block; float: left; height:70px;\">\r\n      <span style=\"display: inline-block; height: 100%; vertical-align: middle;\"></span>\r\n      <p style=\"vertical-align:middle; display: inline-block;\">This channel is a part of the <span style=\"color: #fc5f15;\">Union For Gamers Network</span>.<br /><span style=\"color: #7e7e7e;\">Click for more info on Curse's Youtube partnership.</span></p>\r\n    </span>\r\n    <span style=\"width: 200px; display: block; float: left; padding-top: 9px;\">\r\n      <script src=\"https://apis.google.com/js/platform.js\"></script>\r\n      <div class=\"g-ytsubscribe\" data-channel=\"{channel}\" data-layout=\"full\" data-theme=\"dark\" data-count=\"default\"></div>\r\n    </span>\r\n    <span style=\"clear: both;\"></span>\r\n  </div>\r\n</div>\r\n</a>", channel, video);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UfgEmbed(object channel, object video)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UfgEmbed", channel, video);
				}
				
				public LazyLocalizedTranslation Lazy_UfgEmbed_ForLanguageID(int languageID, object channel, object video)
				{
					return this.CalculateLazyTranslation(languageID, "UfgEmbed", channel, video);
				}
				

				#endregion
			}
			
			private CMSSubNamespace _cacheCMS;
			public CMSSubNamespace CMS
			{
				get
				{
					if (_cacheCMS == null)
					{
						_cacheCMS = new CMSSubNamespace();
					}
					return _cacheCMS;
				}
			}
			public sealed class CommentsSubNamespace : SubNamespaceBase
			{
				public CommentsSubNamespace() : base("Global", "Comments") { }
				
				#region Phrase methods
				
				public LocalizedTranslation BannedFromPostingInForum(object forumName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "BannedFromPostingInForum", forumName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BannedFromPostingInForum", "You are banned from posting in {forumName}.", forumName);
					}
				}
				
				public LocalizedTranslation BannedFromPostingInForum_ForLanguageID(int languageID, object forumName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BannedFromPostingInForum", forumName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BannedFromPostingInForum", "You are banned from posting in {forumName}.", forumName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_BannedFromPostingInForum(object forumName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "BannedFromPostingInForum", forumName);
				}
				
				public LazyLocalizedTranslation Lazy_BannedFromPostingInForum_ForLanguageID(int languageID, object forumName)
				{
					return this.CalculateLazyTranslation(languageID, "BannedFromPostingInForum", forumName);
				}
				
				public LocalizedTranslation CommentedOnYourProfile(object userName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CommentedOnYourProfile", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentedOnYourProfile", "{userName} commented on your user profile", userName);
					}
				}
				
				public LocalizedTranslation CommentedOnYourProfile_ForLanguageID(int languageID, object userName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentedOnYourProfile", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentedOnYourProfile", "{userName} commented on your user profile", userName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentedOnYourProfile(object userName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentedOnYourProfile", userName);
				}
				
				public LazyLocalizedTranslation Lazy_CommentedOnYourProfile_ForLanguageID(int languageID, object userName)
				{
					return this.CalculateLazyTranslation(languageID, "CommentedOnYourProfile", userName);
				}
				
				public LocalizedTranslation FirstDevComment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FirstDevComment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FirstDevComment", "First Dev Comment");
						}
					}
				}
				
				public LocalizedTranslation FirstDevComment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FirstDevComment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FirstDevComment", "First Dev Comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FirstDevComment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FirstDevComment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FirstDevComment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FirstDevComment");
				}
				
				public LocalizedTranslation NewPostsBy(object _0, object authorDisplayName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NewPostsBy", _0, authorDisplayName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NewPostsBy", "New PLURAL[{0};Post;Posts] By {authorDisplayName}", _0, authorDisplayName);
					}
				}
				
				public LocalizedTranslation NewPostsBy_ForLanguageID(int languageID, object _0, object authorDisplayName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NewPostsBy", _0, authorDisplayName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NewPostsBy", "New PLURAL[{0};Post;Posts] By {authorDisplayName}", _0, authorDisplayName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NewPostsBy(object _0, object authorDisplayName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NewPostsBy", _0, authorDisplayName);
				}
				
				public LazyLocalizedTranslation Lazy_NewPostsBy_ForLanguageID(int languageID, object _0, object authorDisplayName)
				{
					return this.CalculateLazyTranslation(languageID, "NewPostsBy", _0, authorDisplayName);
				}
				
				public LocalizedTranslation NextDevComment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NextDevComment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NextDevComment", "Next Dev Comment");
						}
					}
				}
				
				public LocalizedTranslation NextDevComment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NextDevComment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NextDevComment", "Next Dev Comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NextDevComment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NextDevComment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NextDevComment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NextDevComment");
				}
				
				public LocalizedTranslation NoComments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoComments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoComments", "There haven't been any comments posted yet.");
						}
					}
				}
				
				public LocalizedTranslation NoComments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoComments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoComments", "There haven't been any comments posted yet.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoComments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoComments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoComments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoComments");
				}
				
				public LocalizedTranslation NumComments(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NumComments", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumComments", "{num} PLURAL[{num};Comment;Comments]", num);
					}
				}
				
				public LocalizedTranslation NumComments_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NumComments", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumComments", "{num} PLURAL[{num};Comment;Comments]", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NumComments(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NumComments", num);
				}
				
				public LazyLocalizedTranslation Lazy_NumComments_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "NumComments", num);
				}
				
				public LocalizedTranslation PostedAMessageOn(object comment, object user)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PostedAMessageOn", comment, user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedAMessageOn", "<span class=\"post-author\">{user}</span> posted a message on {comment}", comment, user);
					}
				}
				
				public LocalizedTranslation PostedAMessageOn_ForLanguageID(int languageID, object comment, object user)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostedAMessageOn", comment, user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedAMessageOn", "<span class=\"post-author\">{user}</span> posted a message on {comment}", comment, user);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostedAMessageOn(object comment, object user)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PostedAMessageOn", comment, user);
				}
				
				public LazyLocalizedTranslation Lazy_PostedAMessageOn_ForLanguageID(int languageID, object comment, object user)
				{
					return this.CalculateLazyTranslation(languageID, "PostedAMessageOn", comment, user);
				}
				
				public LocalizedTranslation PostingDisabled
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostingDisabled");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostingDisabled", "Posting Disabled");
						}
					}
				}
				
				public LocalizedTranslation PostingDisabled_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostingDisabled");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostingDisabled", "Posting Disabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostingDisabled
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostingDisabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostingDisabled_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostingDisabled");
				}
				
				public LocalizedTranslation Recaptcha
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Recaptcha");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Recaptcha", "Recaptcha");
						}
					}
				}
				
				public LocalizedTranslation Recaptcha_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Recaptcha");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Recaptcha", "Recaptcha");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recaptcha
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Recaptcha");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recaptcha_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Recaptcha");
				}
				
				public LocalizedTranslation Recover_Password
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Recover Password");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Recover Password", "Recover Password");
						}
					}
				}
				
				public LocalizedTranslation Recover_Password_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Recover Password");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Recover Password", "Recover Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recover_Password
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Recover Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recover_Password_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Recover Password");
				}
				
				public LocalizedTranslation ShowNewReplies(object _0)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ShowNewReplies", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowNewReplies", "Show New PLURAL[{0};Reply;Replies] ({0})", _0);
					}
				}
				
				public LocalizedTranslation ShowNewReplies_ForLanguageID(int languageID, object _0)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShowNewReplies", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShowNewReplies", "Show New PLURAL[{0};Reply;Replies] ({0})", _0);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShowNewReplies(object _0)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ShowNewReplies", _0);
				}
				
				public LazyLocalizedTranslation Lazy_ShowNewReplies_ForLanguageID(int languageID, object _0)
				{
					return this.CalculateLazyTranslation(languageID, "ShowNewReplies", _0);
				}
				

				#endregion
			}
			
			private CommentsSubNamespace _cacheComments;
			public CommentsSubNamespace Comments
			{
				get
				{
					if (_cacheComments == null)
					{
						_cacheComments = new CommentsSubNamespace();
					}
					return _cacheComments;
				}
			}
			public sealed class CommonSubNamespace : SubNamespaceDictionaryBase
			{
				public CommonSubNamespace() : base("Global", "Common") { }
				
				#region Phrase methods
				
				public LocalizedTranslation Version
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Version");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Version", "Version");
						}
					}
				}
				
				public LocalizedTranslation Version_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Version");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Version", "Version");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Version
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Version");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Version_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Version");
				}
				
				public LocalizedTranslation AboutToLeave(object siteName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "AboutToLeave", siteName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AboutToLeave", "You are about to leave {siteName}", siteName);
					}
				}
				
				public LocalizedTranslation AboutToLeave_ForLanguageID(int languageID, object siteName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AboutToLeave", siteName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AboutToLeave", "You are about to leave {siteName}", siteName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_AboutToLeave(object siteName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "AboutToLeave", siteName);
				}
				
				public LazyLocalizedTranslation Lazy_AboutToLeave_ForLanguageID(int languageID, object siteName)
				{
					return this.CalculateLazyTranslation(languageID, "AboutToLeave", siteName);
				}
				
				public LocalizedTranslation Accept
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Accept");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Accept", "Accept");
						}
					}
				}
				
				public LocalizedTranslation Accept_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Accept");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Accept", "Accept");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Accept
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Accept");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Accept_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Accept");
				}
				
				public LocalizedTranslation AcceptTOS
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AcceptTOS");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AcceptTOS", "Accept Terms of Service");
						}
					}
				}
				
				public LocalizedTranslation AcceptTOS_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AcceptTOS");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AcceptTOS", "Accept Terms of Service");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptTOS
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AcceptTOS");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AcceptTOS_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AcceptTOS");
				}
				
				public LocalizedTranslation Account
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Account");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Account", "Account");
						}
					}
				}
				
				public LocalizedTranslation Account_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Account");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Account", "Account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Account
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Account_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Account");
				}
				
				public LocalizedTranslation AccountPreferences
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AccountPreferences");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AccountPreferences", "Account Preferences");
						}
					}
				}
				
				public LocalizedTranslation AccountPreferences_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AccountPreferences");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AccountPreferences", "Account Preferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountPreferences
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AccountPreferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AccountPreferences_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AccountPreferences");
				}
				
				public LocalizedTranslation Action
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Action");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Action", "Action");
						}
					}
				}
				
				public LocalizedTranslation Action_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Action");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Action", "Action");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Action
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Action");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Action_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Action");
				}
				
				public LocalizedTranslation Active
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Active");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Active", "Active");
						}
					}
				}
				
				public LocalizedTranslation Active_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Active");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Active", "Active");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Active
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Active");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Active_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Active");
				}
				
				public LocalizedTranslation Activity
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Activity");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Activity", "Activity");
						}
					}
				}
				
				public LocalizedTranslation Activity_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Activity");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Activity", "Activity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Activity
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Activity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Activity_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Activity");
				}
				
				public LocalizedTranslation Add
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Add");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Add", "Add");
						}
					}
				}
				
				public LocalizedTranslation Add_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Add");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Add", "Add");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Add
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Add");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Add_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Add");
				}
				
				public LocalizedTranslation AddCharacter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddCharacter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddCharacter", "Add a character");
						}
					}
				}
				
				public LocalizedTranslation AddCharacter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddCharacter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddCharacter", "Add a character");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddCharacter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddCharacter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddCharacter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddCharacter");
				}
				
				public LocalizedTranslation AddPost
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddPost");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddPost", "Add a Post");
						}
					}
				}
				
				public LocalizedTranslation AddPost_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddPost");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddPost", "Add a Post");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPost
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddPost");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPost_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddPost");
				}
				
				public LocalizedTranslation Address
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Address");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Address", "Address");
						}
					}
				}
				
				public LocalizedTranslation Address_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Address");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Address", "Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Address_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Address");
				}
				
				public LocalizedTranslation AddsDamage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddsDamage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddsDamage", "Test");
						}
					}
				}
				
				public LocalizedTranslation AddsDamage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddsDamage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddsDamage", "Test");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddsDamage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddsDamage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddsDamage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddsDamage");
				}
				
				public LocalizedTranslation AddTag
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddTag");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddTag", "Add Tag");
						}
					}
				}
				
				public LocalizedTranslation AddTag_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddTag");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddTag", "Add Tag");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddTag
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddTag");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddTag_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddTag");
				}
				
				public LocalizedTranslation AddWidget
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddWidget");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddWidget", "Add Widget");
						}
					}
				}
				
				public LocalizedTranslation AddWidget_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddWidget");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddWidget", "Add Widget");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddWidget
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddWidget");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddWidget_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddWidget");
				}
				
				public LocalizedTranslation Admin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Admin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Admin", "Admin");
						}
					}
				}
				
				public LocalizedTranslation Admin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Admin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Admin", "Admin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Admin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Admin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Admin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Admin");
				}
				
				public LocalizedTranslation AdvancedSearch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AdvancedSearch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AdvancedSearch", "Advanced Search");
						}
					}
				}
				
				public LocalizedTranslation AdvancedSearch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AdvancedSearch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AdvancedSearch", "Advanced Search");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdvancedSearch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AdvancedSearch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdvancedSearch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AdvancedSearch");
				}
				
				public LocalizedTranslation Advertising
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Advertising");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Advertising", "Advertising");
						}
					}
				}
				
				public LocalizedTranslation Advertising_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Advertising");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Advertising", "Advertising");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Advertising
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Advertising");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Advertising_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Advertising");
				}
				
				public LocalizedTranslation Age
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Age");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Age", "Age");
						}
					}
				}
				
				public LocalizedTranslation Age_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Age");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Age", "Age");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Age
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Age");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Age_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Age");
				}
				
				public LocalizedTranslation ALegendaryGuildExperience
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ALegendaryGuildExperience");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ALegendaryGuildExperience", "A Legendary Guild Experience");
						}
					}
				}
				
				public LocalizedTranslation ALegendaryGuildExperience_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ALegendaryGuildExperience");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ALegendaryGuildExperience", "A Legendary Guild Experience");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ALegendaryGuildExperience
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ALegendaryGuildExperience");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ALegendaryGuildExperience_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ALegendaryGuildExperience");
				}
				
				public LocalizedTranslation All_Rights_Reserved
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "All Rights Reserved");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("All Rights Reserved", "All Rights Reserved");
						}
					}
				}
				
				public LocalizedTranslation All_Rights_Reserved_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "All Rights Reserved");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("All Rights Reserved", "All Rights Reserved");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All_Rights_Reserved
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "All Rights Reserved");
					}
				}
				
				public LazyLocalizedTranslation Lazy_All_Rights_Reserved_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "All Rights Reserved");
				}
				
				public LocalizedTranslation AllowTagging
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AllowTagging");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AllowTagging", "Allow Tagging?");
						}
					}
				}
				
				public LocalizedTranslation AllowTagging_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AllowTagging");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AllowTagging", "Allow Tagging?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllowTagging
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AllowTagging");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllowTagging_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AllowTagging");
				}
				
				public LocalizedTranslation AllPhrase
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AllPhrase");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AllPhrase", "All");
						}
					}
				}
				
				public LocalizedTranslation AllPhrase_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AllPhrase");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AllPhrase", "All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllPhrase
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AllPhrase");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllPhrase_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AllPhrase");
				}
				
				public LocalizedTranslation AllTime
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AllTime");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AllTime", "All Time");
						}
					}
				}
				
				public LocalizedTranslation AllTime_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AllTime");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AllTime", "All Time");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllTime
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AllTime");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AllTime_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AllTime");
				}
				
				public LocalizedTranslation Amount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Amount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Amount", "Amount");
						}
					}
				}
				
				public LocalizedTranslation Amount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Amount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Amount", "Amount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Amount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Amount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Amount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Amount");
				}
				
				public LocalizedTranslation And
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "And");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("And", "and");
						}
					}
				}
				
				public LocalizedTranslation And_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "And");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("And", "and");
					}
				}
				
				public LazyLocalizedTranslation Lazy_And
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "And");
					}
				}
				
				public LazyLocalizedTranslation Lazy_And_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "And");
				}
				
				public LocalizedTranslation AndXOthers(object recipientCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "AndXOthers", recipientCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AndXOthers", "and {recipientCount} others", recipientCount);
					}
				}
				
				public LocalizedTranslation AndXOthers_ForLanguageID(int languageID, object recipientCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AndXOthers", recipientCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AndXOthers", "and {recipientCount} others", recipientCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_AndXOthers(object recipientCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "AndXOthers", recipientCount);
				}
				
				public LazyLocalizedTranslation Lazy_AndXOthers_ForLanguageID(int languageID, object recipientCount)
				{
					return this.CalculateLazyTranslation(languageID, "AndXOthers", recipientCount);
				}
				
				public LocalizedTranslation Apply
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Apply");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Apply", "Apply");
						}
					}
				}
				
				public LocalizedTranslation Apply_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Apply");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Apply", "Apply");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Apply
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Apply");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Apply_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Apply");
				}
				
				public LocalizedTranslation AreYouALegacyWowsteadUser
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AreYouALegacyWowsteadUser");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AreYouALegacyWowsteadUser", "Are you a legacy Wowstead user?");
						}
					}
				}
				
				public LocalizedTranslation AreYouALegacyWowsteadUser_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AreYouALegacyWowsteadUser");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AreYouALegacyWowsteadUser", "Are you a legacy Wowstead user?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AreYouALegacyWowsteadUser
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AreYouALegacyWowsteadUser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AreYouALegacyWowsteadUser_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AreYouALegacyWowsteadUser");
				}
				
				public LocalizedTranslation Articles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Articles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Articles", "Articles");
						}
					}
				}
				
				public LocalizedTranslation Articles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Articles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Articles", "Articles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Articles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Articles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Articles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Articles");
				}
				
				public LocalizedTranslation Ascending
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Ascending");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Ascending", "Ascending");
						}
					}
				}
				
				public LocalizedTranslation Ascending_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Ascending");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Ascending", "Ascending");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Ascending
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Ascending");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Ascending_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Ascending");
				}
				
				public LocalizedTranslation asdfasdf
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "asdfasdf");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("asdfasdf", "asdfasdf");
						}
					}
				}
				
				public LocalizedTranslation asdfasdf_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "asdfasdf");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("asdfasdf", "asdfasdf");
					}
				}
				
				public LazyLocalizedTranslation Lazy_asdfasdf
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "asdfasdf");
					}
				}
				
				public LazyLocalizedTranslation Lazy_asdfasdf_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "asdfasdf");
				}
				
				public LocalizedTranslation AssignRoles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AssignRoles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AssignRoles", "Roles & Permissions");
						}
					}
				}
				
				public LocalizedTranslation AssignRoles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AssignRoles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AssignRoles", "Roles & Permissions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AssignRoles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AssignRoles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AssignRoles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AssignRoles");
				}
				
				public LocalizedTranslation AsSurrogate(object surrogate)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "AsSurrogate", surrogate);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AsSurrogate", "as {surrogate}", surrogate);
					}
				}
				
				public LocalizedTranslation AsSurrogate_ForLanguageID(int languageID, object surrogate)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AsSurrogate", surrogate);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AsSurrogate", "as {surrogate}", surrogate);
					}
				}
				
				public LazyLocalizedTranslation Lazy_AsSurrogate(object surrogate)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "AsSurrogate", surrogate);
				}
				
				public LazyLocalizedTranslation Lazy_AsSurrogate_ForLanguageID(int languageID, object surrogate)
				{
					return this.CalculateLazyTranslation(languageID, "AsSurrogate", surrogate);
				}
				
				public LocalizedTranslation Attachments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Attachments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Attachments", "Attachments");
						}
					}
				}
				
				public LocalizedTranslation Attachments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Attachments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Attachments", "Attachments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Attachments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Attachments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Attachments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Attachments");
				}
				
				public LocalizedTranslation Author
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Author");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Author", "Author");
						}
					}
				}
				
				public LocalizedTranslation Author_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Author");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Author", "Author");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Author
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Author");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Author_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Author");
				}
				
				public LocalizedTranslation Avatars
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Avatars");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Avatars", "Avatars");
						}
					}
				}
				
				public LocalizedTranslation Avatars_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Avatars");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Avatars", "Avatars");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Avatars
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Avatars");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Avatars_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Avatars");
				}
				
				public LocalizedTranslation AvatarUploadDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AvatarUploadDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AvatarUploadDescription", "Avatars ideally have an equal height and width.");
						}
					}
				}
				
				public LocalizedTranslation AvatarUploadDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AvatarUploadDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AvatarUploadDescription", "Avatars ideally have an equal height and width.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AvatarUploadDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AvatarUploadDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AvatarUploadDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AvatarUploadDescription");
				}
				
				public LocalizedTranslation AverageRating
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AverageRating");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AverageRating", "Average Rating");
						}
					}
				}
				
				public LocalizedTranslation AverageRating_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AverageRating");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AverageRating", "Average Rating");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AverageRating
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AverageRating");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AverageRating_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AverageRating");
				}
				
				public LocalizedTranslation Back
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Back");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Back", "Back");
						}
					}
				}
				
				public LocalizedTranslation Back_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Back");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Back", "Back");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Back
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Back");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Back_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Back");
				}
				
				public LocalizedTranslation BackToPreviousStep(object label)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "BackToPreviousStep", label);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BackToPreviousStep", "Back to {label}", label);
					}
				}
				
				public LocalizedTranslation BackToPreviousStep_ForLanguageID(int languageID, object label)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BackToPreviousStep", label);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BackToPreviousStep", "Back to {label}", label);
					}
				}
				
				public LazyLocalizedTranslation Lazy_BackToPreviousStep(object label)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "BackToPreviousStep", label);
				}
				
				public LazyLocalizedTranslation Lazy_BackToPreviousStep_ForLanguageID(int languageID, object label)
				{
					return this.CalculateLazyTranslation(languageID, "BackToPreviousStep", label);
				}
				
				public LocalizedTranslation BanConfirm
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BanConfirm");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BanConfirm", "Are you sure you want to ban this user?");
						}
					}
				}
				
				public LocalizedTranslation BanConfirm_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BanConfirm");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BanConfirm", "Are you sure you want to ban this user?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanConfirm
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BanConfirm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanConfirm_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BanConfirm");
				}
				
				public LocalizedTranslation BanIP
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BanIP");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BanIP", "Ban IP");
						}
					}
				}
				
				public LocalizedTranslation BanIP_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BanIP");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BanIP", "Ban IP");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanIP
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BanIP");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BanIP_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BanIP");
				}
				
				public LocalizedTranslation BaseModules
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BaseModules");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BaseModules", "Base Modules");
						}
					}
				}
				
				public LocalizedTranslation BaseModules_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BaseModules");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BaseModules", "Base Modules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BaseModules
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BaseModules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BaseModules_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BaseModules");
				}
				
				public LocalizedTranslation BetaCompleteMsg(object useremail)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "BetaCompleteMsg", useremail);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BetaCompleteMsg", "You will be notified at your email address ({useremail}) once you are accepted to be a beta tester.", useremail);
					}
				}
				
				public LocalizedTranslation BetaCompleteMsg_ForLanguageID(int languageID, object useremail)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BetaCompleteMsg", useremail);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BetaCompleteMsg", "You will be notified at your email address ({useremail}) once you are accepted to be a beta tester.", useremail);
					}
				}
				
				public LazyLocalizedTranslation Lazy_BetaCompleteMsg(object useremail)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "BetaCompleteMsg", useremail);
				}
				
				public LazyLocalizedTranslation Lazy_BetaCompleteMsg_ForLanguageID(int languageID, object useremail)
				{
					return this.CalculateLazyTranslation(languageID, "BetaCompleteMsg", useremail);
				}
				
				public LocalizedTranslation BirthDate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BirthDate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BirthDate", "Birth Date");
						}
					}
				}
				
				public LocalizedTranslation BirthDate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BirthDate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BirthDate", "Birth Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BirthDate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BirthDate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BirthDate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BirthDate");
				}
				
				public LocalizedTranslation BlockedCookies
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BlockedCookies");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BlockedCookies", "Blocked Cookies");
						}
					}
				}
				
				public LocalizedTranslation BlockedCookies_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BlockedCookies");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BlockedCookies", "Blocked Cookies");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BlockedCookies
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BlockedCookies");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BlockedCookies_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BlockedCookies");
				}
				
				public LocalizedTranslation Body
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Body");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Body", "Body");
						}
					}
				}
				
				public LocalizedTranslation Body_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Body");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Body", "Body");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Body
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Body");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Body_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Body");
				}
				
				public LocalizedTranslation Browse
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Browse");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Browse", "Browse");
						}
					}
				}
				
				public LocalizedTranslation Browse_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Browse");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Browse", "Browse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Browse
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Browse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Browse_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Browse");
				}
				
				public LocalizedTranslation Browser
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Browser");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Browser", "Browser");
						}
					}
				}
				
				public LocalizedTranslation Browser_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Browser");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Browser", "Browser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Browser
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Browser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Browser_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Browser");
				}
				
				public LocalizedTranslation BuildType
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "BuildType");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("BuildType", "Build Type");
						}
					}
				}
				
				public LocalizedTranslation BuildType_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "BuildType");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("BuildType", "Build Type");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BuildType
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "BuildType");
					}
				}
				
				public LazyLocalizedTranslation Lazy_BuildType_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "BuildType");
				}
				
				public LocalizedTranslation By
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "By");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("By", "By");
						}
					}
				}
				
				public LocalizedTranslation By_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "By");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("By", "By");
					}
				}
				
				public LazyLocalizedTranslation Lazy_By
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "By");
					}
				}
				
				public LazyLocalizedTranslation Lazy_By_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "By");
				}
				
				public LocalizedTranslation CacheManager
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CacheManager");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CacheManager", "Cache Manager");
						}
					}
				}
				
				public LocalizedTranslation CacheManager_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CacheManager");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CacheManager", "Cache Manager");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CacheManager
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CacheManager");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CacheManager_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CacheManager");
				}
				
				public LocalizedTranslation CannotHaveALetterImmediatelyFollowedBySlashes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CannotHaveALetterImmediatelyFollowedBySlashes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CannotHaveALetterImmediatelyFollowedBySlashes", "Cannot have a letter immediately followed by \\\"//\\\". Put a space in-between.");
						}
					}
				}
				
				public LocalizedTranslation CannotHaveALetterImmediatelyFollowedBySlashes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CannotHaveALetterImmediatelyFollowedBySlashes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CannotHaveALetterImmediatelyFollowedBySlashes", "Cannot have a letter immediately followed by \\\"//\\\". Put a space in-between.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveALetterImmediatelyFollowedBySlashes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CannotHaveALetterImmediatelyFollowedBySlashes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveALetterImmediatelyFollowedBySlashes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CannotHaveALetterImmediatelyFollowedBySlashes");
				}
				
				public LocalizedTranslation CannotHaveALetterImmediatelyFollowedBySlashStar
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CannotHaveALetterImmediatelyFollowedBySlashStar");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CannotHaveALetterImmediatelyFollowedBySlashStar", "Cannot have a letter immediately followed by \\\"/*\\\". Put a space in-between.");
						}
					}
				}
				
				public LocalizedTranslation CannotHaveALetterImmediatelyFollowedBySlashStar_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CannotHaveALetterImmediatelyFollowedBySlashStar");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CannotHaveALetterImmediatelyFollowedBySlashStar", "Cannot have a letter immediately followed by \\\"/*\\\". Put a space in-between.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveALetterImmediatelyFollowedBySlashStar
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CannotHaveALetterImmediatelyFollowedBySlashStar");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveALetterImmediatelyFollowedBySlashStar_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CannotHaveALetterImmediatelyFollowedBySlashStar");
				}
				
				public LocalizedTranslation CannotHaveTheSequenceSlashStarSlash
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CannotHaveTheSequenceSlashStarSlash");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CannotHaveTheSequenceSlashStarSlash", "Cannot have the sequence \\\"/*/\\\".");
						}
					}
				}
				
				public LocalizedTranslation CannotHaveTheSequenceSlashStarSlash_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CannotHaveTheSequenceSlashStarSlash");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CannotHaveTheSequenceSlashStarSlash", "Cannot have the sequence \\\"/*/\\\".");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveTheSequenceSlashStarSlash
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CannotHaveTheSequenceSlashStarSlash");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CannotHaveTheSequenceSlashStarSlash_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CannotHaveTheSequenceSlashStarSlash");
				}
				
				public LocalizedTranslation Category
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Category");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Category", "Category");
						}
					}
				}
				
				public LocalizedTranslation Category_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Category");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Category", "Category");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Category
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Category");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Category_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Category");
				}
				
				public LocalizedTranslation CauseError
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CauseError");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CauseError", "Cause Error");
						}
					}
				}
				
				public LocalizedTranslation CauseError_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CauseError");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CauseError", "Cause Error");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CauseError
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CauseError");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CauseError_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CauseError");
				}
				
				public LocalizedTranslation Change
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Change");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Change", "Change");
						}
					}
				}
				
				public LocalizedTranslation Change_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Change");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Change", "Change");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Change
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Change");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Change_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Change");
				}
				
				public LocalizedTranslation ChangeAvatar
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ChangeAvatar");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ChangeAvatar", "Change Avatar");
						}
					}
				}
				
				public LocalizedTranslation ChangeAvatar_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ChangeAvatar");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ChangeAvatar", "Change Avatar");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeAvatar
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ChangeAvatar");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangeAvatar_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ChangeAvatar");
				}
				
				public LocalizedTranslation ChangePassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ChangePassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ChangePassword", "Change Password");
						}
					}
				}
				
				public LocalizedTranslation ChangePassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ChangePassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ChangePassword", "Change Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangePassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ChangePassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ChangePassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ChangePassword");
				}
				
				public LocalizedTranslation Characters
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Characters");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Characters", "Characters");
						}
					}
				}
				
				public LocalizedTranslation Characters_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Characters");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Characters", "Characters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Characters
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Characters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Characters_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Characters");
				}
				
				public LocalizedTranslation Checksum
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Checksum");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Checksum", "Checksum");
						}
					}
				}
				
				public LocalizedTranslation Checksum_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Checksum");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Checksum", "Checksum");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Checksum
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Checksum");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Checksum_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Checksum");
				}
				
				public LocalizedTranslation City
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "City");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("City", "City");
						}
					}
				}
				
				public LocalizedTranslation City_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "City");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("City", "City");
					}
				}
				
				public LazyLocalizedTranslation Lazy_City
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "City");
					}
				}
				
				public LazyLocalizedTranslation Lazy_City_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "City");
				}
				
				public LocalizedTranslation ClickHere
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ClickHere");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ClickHere", "click here");
						}
					}
				}
				
				public LocalizedTranslation ClickHere_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ClickHere");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ClickHere", "click here");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickHere
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ClickHere");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickHere_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ClickHere");
				}
				
				public LocalizedTranslation ClickSave
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ClickSave");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ClickSave", "Click save.");
						}
					}
				}
				
				public LocalizedTranslation ClickSave_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ClickSave");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ClickSave", "Click save.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickSave
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ClickSave");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickSave_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ClickSave");
				}
				
				public LocalizedTranslation ClickToReturn
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ClickToReturn");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ClickToReturn", "Click here to return now.");
						}
					}
				}
				
				public LocalizedTranslation ClickToReturn_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ClickToReturn");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ClickToReturn", "Click here to return now.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickToReturn
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ClickToReturn");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ClickToReturn_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ClickToReturn");
				}
				
				public LocalizedTranslation Client
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Client");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Client", "Client");
						}
					}
				}
				
				public LocalizedTranslation Client_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Client");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Client", "Client");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Client
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Client");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Client_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Client");
				}
				
				public LocalizedTranslation Close
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Close");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Close", "Close");
						}
					}
				}
				
				public LocalizedTranslation Close_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Close");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Close", "Close");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Close
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Close");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Close_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Close");
				}
				
				public LocalizedTranslation Code
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Code");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Code", "Code");
						}
					}
				}
				
				public LocalizedTranslation Code_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Code");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Code", "Code");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Code
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Code");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Code_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Code");
				}
				
				public LocalizedTranslation ColonConnector
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ColonConnector");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ColonConnector", ": ");
						}
					}
				}
				
				public LocalizedTranslation ColonConnector_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ColonConnector");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ColonConnector", ": ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ColonConnector
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ColonConnector");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ColonConnector_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ColonConnector");
				}
				
				public LocalizedTranslation Color
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Color");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Color", "Color");
						}
					}
				}
				
				public LocalizedTranslation Color_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Color");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Color", "Color");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Color
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Color");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Color_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Color");
				}
				
				public LocalizedTranslation ColorInvalid(object value)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ColorInvalid", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ColorInvalid", "{value} is not a valid color.", value);
					}
				}
				
				public LocalizedTranslation ColorInvalid_ForLanguageID(int languageID, object value)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ColorInvalid", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ColorInvalid", "{value} is not a valid color.", value);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ColorInvalid(object value)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ColorInvalid", value);
				}
				
				public LazyLocalizedTranslation Lazy_ColorInvalid_ForLanguageID(int languageID, object value)
				{
					return this.CalculateLazyTranslation(languageID, "ColorInvalid", value);
				}
				
				public LocalizedTranslation Comment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Comment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Comment", "Comment");
						}
					}
				}
				
				public LocalizedTranslation Comment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Comment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Comment", "Comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Comment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Comment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Comment");
				}
				
				public LocalizedTranslation CommentBodyRequired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CommentBodyRequired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CommentBodyRequired", "Please write something in the comment box.");
						}
					}
				}
				
				public LocalizedTranslation CommentBodyRequired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentBodyRequired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentBodyRequired", "Please write something in the comment box.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentBodyRequired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentBodyRequired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentBodyRequired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CommentBodyRequired");
				}
				
				public LocalizedTranslation CommentCount(object count)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CommentCount", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentCount", "{count} PLURAL[{count};Comment;Comments]", count);
					}
				}
				
				public LocalizedTranslation CommentCount_ForLanguageID(int languageID, object count)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentCount", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentCount", "{count} PLURAL[{count};Comment;Comments]", count);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentCount(object count)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentCount", count);
				}
				
				public LazyLocalizedTranslation Lazy_CommentCount_ForLanguageID(int languageID, object count)
				{
					return this.CalculateLazyTranslation(languageID, "CommentCount", count);
				}
				
				public LocalizedTranslation Comments
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Comments");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Comments", "Comments");
						}
					}
				}
				
				public LocalizedTranslation Comments_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Comments");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Comments", "Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Comments
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Comments");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Comments_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Comments");
				}
				
				public LocalizedTranslation CommentsCanBeViewed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CommentsCanBeViewed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CommentsCanBeViewed", "Comments can currently be viewed and posted by the applicant.");
						}
					}
				}
				
				public LocalizedTranslation CommentsCanBeViewed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentsCanBeViewed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentsCanBeViewed", "Comments can currently be viewed and posted by the applicant.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsCanBeViewed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentsCanBeViewed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsCanBeViewed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CommentsCanBeViewed");
				}
				
				public LocalizedTranslation CommentsCantBeViewed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CommentsCantBeViewed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CommentsCantBeViewed", "Comments can no longer be viewed or posted by the applicant.");
						}
					}
				}
				
				public LocalizedTranslation CommentsCantBeViewed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentsCantBeViewed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentsCantBeViewed", "Comments can no longer be viewed or posted by the applicant.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsCantBeViewed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentsCantBeViewed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentsCantBeViewed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CommentsCantBeViewed");
				}
				
				public LocalizedTranslation CommentStatus
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CommentStatus");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CommentStatus", "Comment status");
						}
					}
				}
				
				public LocalizedTranslation CommentStatus_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CommentStatus");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CommentStatus", "Comment status");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentStatus
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CommentStatus");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CommentStatus_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CommentStatus");
				}
				
				public LocalizedTranslation Community
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Community");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Community", "Community");
						}
					}
				}
				
				public LocalizedTranslation Community_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Community");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Community", "Community");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Community
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Community");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Community_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Community");
				}
				
				public LocalizedTranslation Confirm
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Confirm");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Confirm", "Confirm");
						}
					}
				}
				
				public LocalizedTranslation Confirm_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Confirm");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Confirm", "Confirm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Confirm
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Confirm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Confirm_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Confirm");
				}
				
				public LocalizedTranslation ConfirmDelete(object prompt)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ConfirmDelete", prompt);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ConfirmDelete", "Are you sure you want to delete {prompt}?", prompt);
					}
				}
				
				public LocalizedTranslation ConfirmDelete_ForLanguageID(int languageID, object prompt)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ConfirmDelete", prompt);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ConfirmDelete", "Are you sure you want to delete {prompt}?", prompt);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ConfirmDelete(object prompt)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ConfirmDelete", prompt);
				}
				
				public LazyLocalizedTranslation Lazy_ConfirmDelete_ForLanguageID(int languageID, object prompt)
				{
					return this.CalculateLazyTranslation(languageID, "ConfirmDelete", prompt);
				}
				
				public LocalizedTranslation CongratulationsTemplate(object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CongratulationsTemplate", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CongratulationsTemplate", "Congratulations, {username}!", username);
					}
				}
				
				public LocalizedTranslation CongratulationsTemplate_ForLanguageID(int languageID, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CongratulationsTemplate", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CongratulationsTemplate", "Congratulations, {username}!", username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CongratulationsTemplate(object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CongratulationsTemplate", username);
				}
				
				public LazyLocalizedTranslation Lazy_CongratulationsTemplate_ForLanguageID(int languageID, object username)
				{
					return this.CalculateLazyTranslation(languageID, "CongratulationsTemplate", username);
				}
				
				public LocalizedTranslation Connected
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Connected");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Connected", "Connected");
						}
					}
				}
				
				public LocalizedTranslation Connected_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Connected");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Connected", "Connected");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Connected
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Connected");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Connected_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Connected");
				}
				
				public LocalizedTranslation ContactUsAction(object action)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContactUsAction", action);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContactUsAction", "If you feel you have reached this message in error please {action}.", action);
					}
				}
				
				public LocalizedTranslation ContactUsAction_ForLanguageID(int languageID, object action)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContactUsAction", action);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContactUsAction", "If you feel you have reached this message in error please {action}.", action);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContactUsAction(object action)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContactUsAction", action);
				}
				
				public LazyLocalizedTranslation Lazy_ContactUsAction_ForLanguageID(int languageID, object action)
				{
					return this.CalculateLazyTranslation(languageID, "ContactUsAction", action);
				}
				
				public LocalizedTranslation Content
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Content");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Content", "Content");
						}
					}
				}
				
				public LocalizedTranslation Content_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Content");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Content", "Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Content
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Content_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Content");
				}
				
				public LocalizedTranslation ContentIsPasswordGated
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ContentIsPasswordGated");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ContentIsPasswordGated", "The content you have requested requires a password to view. Please enter the password below to continue.");
						}
					}
				}
				
				public LocalizedTranslation ContentIsPasswordGated_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContentIsPasswordGated");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentIsPasswordGated", "The content you have requested requires a password to view. Please enter the password below to continue.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContentIsPasswordGated
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ContentIsPasswordGated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContentIsPasswordGated_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ContentIsPasswordGated");
				}
				
				public LocalizedTranslation ContentLengthErrorMessage(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContentLengthErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessage", "Must be within {alpha} and {bravo} bytes.", alpha, bravo);
					}
				}
				
				public LocalizedTranslation ContentLengthErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContentLengthErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessage", "Must be within {alpha} and {bravo} bytes.", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessage(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContentLengthErrorMessage", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "ContentLengthErrorMessage", alpha, bravo);
				}
				
				public LocalizedTranslation ContentLengthErrorMessageMaximum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContentLengthErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessageMaximum", "Must be at most {num} PLURAL[{num};byte;bytes].", num);
					}
				}
				
				public LocalizedTranslation ContentLengthErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContentLengthErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessageMaximum", "Must be at most {num} PLURAL[{num};byte;bytes].", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessageMaximum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContentLengthErrorMessageMaximum", num);
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "ContentLengthErrorMessageMaximum", num);
				}
				
				public LocalizedTranslation ContentLengthErrorMessageMinimum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContentLengthErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessageMinimum", "Must be at least {num} PLURAL[{num};byte;bytes].", num);
					}
				}
				
				public LocalizedTranslation ContentLengthErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContentLengthErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContentLengthErrorMessageMinimum", "Must be at least {num} PLURAL[{num};byte;bytes].", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessageMinimum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContentLengthErrorMessageMinimum", num);
				}
				
				public LazyLocalizedTranslation Lazy_ContentLengthErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "ContentLengthErrorMessageMinimum", num);
				}
				
				public LocalizedTranslation Continue
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Continue");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Continue", "Continue");
						}
					}
				}
				
				public LocalizedTranslation Continue_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Continue");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Continue", "Continue");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Continue
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Continue");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Continue_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Continue");
				}
				
				public LocalizedTranslation ContinueToNextStep(object label)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContinueToNextStep", label);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContinueToNextStep", "Continue to {label}", label);
					}
				}
				
				public LocalizedTranslation ContinueToNextStep_ForLanguageID(int languageID, object label)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContinueToNextStep", label);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContinueToNextStep", "Continue to {label}", label);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToNextStep(object label)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContinueToNextStep", label);
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToNextStep_ForLanguageID(int languageID, object label)
				{
					return this.CalculateLazyTranslation(languageID, "ContinueToNextStep", label);
				}
				
				public LocalizedTranslation ContinueToSite
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ContinueToSite");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ContinueToSite", "Continue to Site");
						}
					}
				}
				
				public LocalizedTranslation ContinueToSite_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContinueToSite");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContinueToSite", "Continue to Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToSite
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ContinueToSite");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToSite_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ContinueToSite");
				}
				
				public LocalizedTranslation ContinueToStepTemplate(object stepNumber)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ContinueToStepTemplate", stepNumber);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContinueToStepTemplate", "Continue to step {stepNumber}", stepNumber);
					}
				}
				
				public LocalizedTranslation ContinueToStepTemplate_ForLanguageID(int languageID, object stepNumber)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ContinueToStepTemplate", stepNumber);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ContinueToStepTemplate", "Continue to step {stepNumber}", stepNumber);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToStepTemplate(object stepNumber)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ContinueToStepTemplate", stepNumber);
				}
				
				public LazyLocalizedTranslation Lazy_ContinueToStepTemplate_ForLanguageID(int languageID, object stepNumber)
				{
					return this.CalculateLazyTranslation(languageID, "ContinueToStepTemplate", stepNumber);
				}
				
				public LocalizedTranslation Copyright
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Copyright");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Copyright", "\u00a9 2010 Curse Inc.");
						}
					}
				}
				
				public LocalizedTranslation Copyright_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Copyright");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Copyright", "\u00a9 2010 Curse Inc.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Copyright
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Copyright");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Copyright_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Copyright");
				}
				
				public LocalizedTranslation CopyrightWithYear(object year)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CopyrightWithYear", year);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CopyrightWithYear", "&copy;{year} Curse, Inc. All Rights Reserved.", year);
					}
				}
				
				public LocalizedTranslation CopyrightWithYear_ForLanguageID(int languageID, object year)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CopyrightWithYear", year);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CopyrightWithYear", "&copy;{year} Curse, Inc. All Rights Reserved.", year);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CopyrightWithYear(object year)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CopyrightWithYear", year);
				}
				
				public LazyLocalizedTranslation Lazy_CopyrightWithYear_ForLanguageID(int languageID, object year)
				{
					return this.CalculateLazyTranslation(languageID, "CopyrightWithYear", year);
				}
				
				public LocalizedTranslation CountErrorMessage(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CountErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessage", "Must specify within {alpha} and {bravo} items.", alpha, bravo);
					}
				}
				
				public LocalizedTranslation CountErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CountErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessage", "Must specify within {alpha} and {bravo} items.", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessage(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CountErrorMessage", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "CountErrorMessage", alpha, bravo);
				}
				
				public LocalizedTranslation CountErrorMessageMaximum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CountErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessageMaximum", "Must specify at most {num} PLURAL[{num};item;items].", num);
					}
				}
				
				public LocalizedTranslation CountErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CountErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessageMaximum", "Must specify at most {num} PLURAL[{num};item;items].", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessageMaximum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CountErrorMessageMaximum", num);
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "CountErrorMessageMaximum", num);
				}
				
				public LocalizedTranslation CountErrorMessageMinimum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CountErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessageMinimum", "Must specify at least {num} PLURAL[{num};item;items].", num);
					}
				}
				
				public LocalizedTranslation CountErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CountErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CountErrorMessageMinimum", "Must specify at least {num} PLURAL[{num};item;items].", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessageMinimum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CountErrorMessageMinimum", num);
				}
				
				public LazyLocalizedTranslation Lazy_CountErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "CountErrorMessageMinimum", num);
				}
				
				public LocalizedTranslation Country
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Country");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Country", "Country");
						}
					}
				}
				
				public LocalizedTranslation Country_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Country");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Country", "Country");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Country
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Country");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Country_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Country");
				}
				
				public LocalizedTranslation Create
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Create");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Create", "Create");
						}
					}
				}
				
				public LocalizedTranslation Create_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Create");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Create", "Create");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Create
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Create");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Create_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Create");
				}
				
				public LocalizedTranslation CreateAnAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateAnAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateAnAccount", "Create an account");
						}
					}
				}
				
				public LocalizedTranslation CreateAnAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateAnAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateAnAccount", "Create an account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateAnAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateAnAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateAnAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateAnAccount");
				}
				
				public LocalizedTranslation CreateAnAccountForFree
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateAnAccountForFree");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateAnAccountForFree", "Create an account for free!");
						}
					}
				}
				
				public LocalizedTranslation CreateAnAccountForFree_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateAnAccountForFree");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateAnAccountForFree", "Create an account for free!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateAnAccountForFree
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateAnAccountForFree");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateAnAccountForFree_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateAnAccountForFree");
				}
				
				public LocalizedTranslation CreateCharacter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreateCharacter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreateCharacter", "Create Character");
						}
					}
				}
				
				public LocalizedTranslation CreateCharacter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreateCharacter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreateCharacter", "Create Character");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateCharacter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreateCharacter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreateCharacter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreateCharacter");
				}
				
				public LocalizedTranslation CreatedBy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreatedBy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreatedBy", "Created By");
						}
					}
				}
				
				public LocalizedTranslation CreatedBy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreatedBy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreatedBy", "Created By");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatedBy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreatedBy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatedBy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreatedBy");
				}
				
				public LocalizedTranslation CreatedByTemplate(object userName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "CreatedByTemplate", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreatedByTemplate", "Created By {userName}", userName);
					}
				}
				
				public LocalizedTranslation CreatedByTemplate_ForLanguageID(int languageID, object userName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreatedByTemplate", userName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreatedByTemplate", "Created By {userName}", userName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatedByTemplate(object userName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "CreatedByTemplate", userName);
				}
				
				public LazyLocalizedTranslation Lazy_CreatedByTemplate_ForLanguageID(int languageID, object userName)
				{
					return this.CalculateLazyTranslation(languageID, "CreatedByTemplate", userName);
				}
				
				public LocalizedTranslation CreatePost
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreatePost");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreatePost", "Create post");
						}
					}
				}
				
				public LocalizedTranslation CreatePost_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreatePost");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreatePost", "Create post");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatePost
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreatePost");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatePost_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreatePost");
				}
				
				public LocalizedTranslation CreatingAnAccountIsEasy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CreatingAnAccountIsEasy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CreatingAnAccountIsEasy", "Creating a Curse ID is fast and easy");
						}
					}
				}
				
				public LocalizedTranslation CreatingAnAccountIsEasy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CreatingAnAccountIsEasy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CreatingAnAccountIsEasy", "Creating a Curse ID is fast and easy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatingAnAccountIsEasy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CreatingAnAccountIsEasy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CreatingAnAccountIsEasy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CreatingAnAccountIsEasy");
				}
				
				public LocalizedTranslation Curse
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Curse");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Curse", "Curse");
						}
					}
				}
				
				public LocalizedTranslation Curse_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Curse");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Curse", "Curse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Curse
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Curse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Curse_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Curse");
				}
				
				public LocalizedTranslation CurseID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CurseID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CurseID", "Curse ID");
						}
					}
				}
				
				public LocalizedTranslation CurseID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CurseID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CurseID", "Curse ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurseID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CurseID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurseID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CurseID");
				}
				
				public LocalizedTranslation CurseIDOrEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CurseIDOrEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CurseIDOrEmail", "Curse ID or E-mail Address");
						}
					}
				}
				
				public LocalizedTranslation CurseIDOrEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CurseIDOrEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CurseIDOrEmail", "Curse ID or E-mail Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurseIDOrEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CurseIDOrEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CurseIDOrEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CurseIDOrEmail");
				}
				
				public LocalizedTranslation Custom
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Custom");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Custom", "Custom");
						}
					}
				}
				
				public LocalizedTranslation Custom_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Custom");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Custom", "Custom");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Custom
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Custom");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Custom_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Custom");
				}
				
				public LocalizedTranslation CustomDomainSupported
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CustomDomainSupported");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CustomDomainSupported", "Custom Domain Supported");
						}
					}
				}
				
				public LocalizedTranslation CustomDomainSupported_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CustomDomainSupported");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CustomDomainSupported", "Custom Domain Supported");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomDomainSupported
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CustomDomainSupported");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomDomainSupported_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CustomDomainSupported");
				}
				
				public LocalizedTranslation CustomDomainWatermark
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "CustomDomainWatermark");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("CustomDomainWatermark", "Enter Custom Domain");
						}
					}
				}
				
				public LocalizedTranslation CustomDomainWatermark_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "CustomDomainWatermark");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("CustomDomainWatermark", "Enter Custom Domain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomDomainWatermark
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "CustomDomainWatermark");
					}
				}
				
				public LazyLocalizedTranslation Lazy_CustomDomainWatermark_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "CustomDomainWatermark");
				}
				
				public LocalizedTranslation Date
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Date");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Date", "Date");
						}
					}
				}
				
				public LocalizedTranslation Date_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Date");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Date", "Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Date
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Date_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Date");
				}
				
				public LocalizedTranslation DateCreated
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateCreated");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateCreated", "Date Created");
						}
					}
				}
				
				public LocalizedTranslation DateCreated_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateCreated");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateCreated", "Date Created");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateCreated
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateCreated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateCreated_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateCreated");
				}
				
				public LocalizedTranslation DateEnded
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateEnded");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateEnded", "Date Ended");
						}
					}
				}
				
				public LocalizedTranslation DateEnded_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateEnded");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateEnded", "Date Ended");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateEnded
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateEnded");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateEnded_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateEnded");
				}
				
				public LocalizedTranslation DateExpires
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateExpires");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateExpires", "Date Expires");
						}
					}
				}
				
				public LocalizedTranslation DateExpires_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateExpires");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateExpires", "Date Expires");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateExpires
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateExpires");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateExpires_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateExpires");
				}
				
				public LocalizedTranslation DateFieldDateRange(object maxValue, object minValue)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "DateFieldDateRange", maxValue, minValue);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateFieldDateRange", "Date must be between {minValue} and {maxValue}", maxValue, minValue);
					}
				}
				
				public LocalizedTranslation DateFieldDateRange_ForLanguageID(int languageID, object maxValue, object minValue)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateFieldDateRange", maxValue, minValue);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateFieldDateRange", "Date must be between {minValue} and {maxValue}", maxValue, minValue);
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateFieldDateRange(object maxValue, object minValue)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "DateFieldDateRange", maxValue, minValue);
				}
				
				public LazyLocalizedTranslation Lazy_DateFieldDateRange_ForLanguageID(int languageID, object maxValue, object minValue)
				{
					return this.CalculateLazyTranslation(languageID, "DateFieldDateRange", maxValue, minValue);
				}
				
				public LocalizedTranslation DateModified
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateModified");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateModified", "Last Updated");
						}
					}
				}
				
				public LocalizedTranslation DateModified_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateModified");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateModified", "Last Updated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateModified
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateModified");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateModified_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateModified");
				}
				
				public LocalizedTranslation DateStarted
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateStarted");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateStarted", "Date Started");
						}
					}
				}
				
				public LocalizedTranslation DateStarted_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateStarted");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateStarted", "Date Started");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateStarted
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateStarted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateStarted_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateStarted");
				}
				
				public LocalizedTranslation DateUpdated
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DateUpdated");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DateUpdated", "Date Updated");
						}
					}
				}
				
				public LocalizedTranslation DateUpdated_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DateUpdated");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DateUpdated", "Date Updated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateUpdated
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DateUpdated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DateUpdated_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DateUpdated");
				}
				
				public LocalizedTranslation DecimalValueErrorMessagePrecision(object decimalPoints)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "DecimalValueErrorMessagePrecision", decimalPoints);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DecimalValueErrorMessagePrecision", "Must have a maximum precision of {decimalPoints}.", decimalPoints);
					}
				}
				
				public LocalizedTranslation DecimalValueErrorMessagePrecision_ForLanguageID(int languageID, object decimalPoints)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DecimalValueErrorMessagePrecision", decimalPoints);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DecimalValueErrorMessagePrecision", "Must have a maximum precision of {decimalPoints}.", decimalPoints);
					}
				}
				
				public LazyLocalizedTranslation Lazy_DecimalValueErrorMessagePrecision(object decimalPoints)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "DecimalValueErrorMessagePrecision", decimalPoints);
				}
				
				public LazyLocalizedTranslation Lazy_DecimalValueErrorMessagePrecision_ForLanguageID(int languageID, object decimalPoints)
				{
					return this.CalculateLazyTranslation(languageID, "DecimalValueErrorMessagePrecision", decimalPoints);
				}
				
				public LocalizedTranslation Decline
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Decline");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Decline", "Decline");
						}
					}
				}
				
				public LocalizedTranslation Decline_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Decline");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Decline", "Decline");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Decline
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Decline");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Decline_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Decline");
				}
				
				public LocalizedTranslation Default
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Default");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Default", "Default");
						}
					}
				}
				
				public LocalizedTranslation Default_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Default");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Default", "Default");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Default
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Default");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Default_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Default");
				}
				
				public LocalizedTranslation Deleted
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Deleted");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Deleted", "Deleted");
						}
					}
				}
				
				public LocalizedTranslation Deleted_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Deleted");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Deleted", "Deleted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deleted
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Deleted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deleted_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Deleted");
				}
				
				public LocalizedTranslation Deny
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Deny");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Deny", "Deny");
						}
					}
				}
				
				public LocalizedTranslation Deny_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Deny");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Deny", "Deny");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deny
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Deny");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Deny_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Deny");
				}
				
				public LocalizedTranslation Descending
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Descending");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Descending", "Descending");
						}
					}
				}
				
				public LocalizedTranslation Descending_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Descending");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Descending", "Descending");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Descending
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Descending");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Descending_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Descending");
				}
				
				public LocalizedTranslation Description
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Description");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Description", "Description");
						}
					}
				}
				
				public LocalizedTranslation Description_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Description");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Description", "Description");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Description
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Description");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Description_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Description");
				}
				
				public LocalizedTranslation Details
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Details");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Details", "Details");
						}
					}
				}
				
				public LocalizedTranslation Details_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Details");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Details", "Details");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Details
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Details");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Details_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Details");
				}
				
				public LocalizedTranslation Dimensions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Dimensions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Dimensions", "Dimensions");
						}
					}
				}
				
				public LocalizedTranslation Dimensions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Dimensions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Dimensions", "Dimensions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Dimensions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Dimensions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Dimensions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Dimensions");
				}
				
				public LocalizedTranslation Disable
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Disable");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Disable", "Disable");
						}
					}
				}
				
				public LocalizedTranslation Disable_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Disable");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Disable", "Disable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disable
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Disable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disable_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Disable");
				}
				
				public LocalizedTranslation Disabled
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Disabled");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Disabled", "Disabled");
						}
					}
				}
				
				public LocalizedTranslation Disabled_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Disabled");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Disabled", "Disabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disabled
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Disabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Disabled_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Disabled");
				}
				
				public LocalizedTranslation DisplayOrder
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DisplayOrder");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DisplayOrder", "Display Order");
						}
					}
				}
				
				public LocalizedTranslation DisplayOrder_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DisplayOrder");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DisplayOrder", "Display Order");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DisplayOrder
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DisplayOrder");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DisplayOrder_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DisplayOrder");
				}
				
				public LocalizedTranslation Domain
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Domain");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Domain", "Domain");
						}
					}
				}
				
				public LocalizedTranslation Domain_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Domain");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Domain", "Domain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Domain
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Domain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Domain_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Domain");
				}
				
				public LocalizedTranslation DomainErrorMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DomainErrorMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DomainErrorMessage", "Must be a valid domain.");
						}
					}
				}
				
				public LocalizedTranslation DomainErrorMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DomainErrorMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DomainErrorMessage", "Must be a valid domain.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DomainErrorMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DomainErrorMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DomainErrorMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DomainErrorMessage");
				}
				
				public LocalizedTranslation DontHaveAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DontHaveAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DontHaveAccount", "Don't have an account yet?");
						}
					}
				}
				
				public LocalizedTranslation DontHaveAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DontHaveAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DontHaveAccount", "Don't have an account yet?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DontHaveAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DontHaveAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DontHaveAccount");
				}
				
				public LocalizedTranslation Download
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Download");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Download", "Download");
						}
					}
				}
				
				public LocalizedTranslation Download_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Download");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Download", "Download");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Download
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Download");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Download_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Download");
				}
				
				public LocalizedTranslation DownloadCount(object Count)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "DownloadCount", Count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DownloadCount", "{Count} downloads", Count);
					}
				}
				
				public LocalizedTranslation DownloadCount_ForLanguageID(int languageID, object Count)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DownloadCount", Count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DownloadCount", "{Count} downloads", Count);
					}
				}
				
				public LazyLocalizedTranslation Lazy_DownloadCount(object Count)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "DownloadCount", Count);
				}
				
				public LazyLocalizedTranslation Lazy_DownloadCount_ForLanguageID(int languageID, object Count)
				{
					return this.CalculateLazyTranslation(languageID, "DownloadCount", Count);
				}
				
				public LocalizedTranslation DownloadNow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "DownloadNow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("DownloadNow", "Download Now!");
						}
					}
				}
				
				public LocalizedTranslation DownloadNow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DownloadNow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DownloadNow", "Download Now!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DownloadNow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "DownloadNow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_DownloadNow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "DownloadNow");
				}
				
				public LocalizedTranslation Drafts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Drafts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Drafts", "Drafts");
						}
					}
				}
				
				public LocalizedTranslation Drafts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Drafts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Drafts", "Drafts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Drafts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Drafts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Drafts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Drafts");
				}
				
				public LocalizedTranslation DuplicateErrorMessage(object item)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "DuplicateErrorMessage", item);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DuplicateErrorMessage", "You cannot specify {item} more than once.", item);
					}
				}
				
				public LocalizedTranslation DuplicateErrorMessage_ForLanguageID(int languageID, object item)
				{
					try
					{
						return this.CalculateTranslation(languageID, "DuplicateErrorMessage", item);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("DuplicateErrorMessage", "You cannot specify {item} more than once.", item);
					}
				}
				
				public LazyLocalizedTranslation Lazy_DuplicateErrorMessage(object item)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "DuplicateErrorMessage", item);
				}
				
				public LazyLocalizedTranslation Lazy_DuplicateErrorMessage_ForLanguageID(int languageID, object item)
				{
					return this.CalculateLazyTranslation(languageID, "DuplicateErrorMessage", item);
				}
				
				public LocalizedTranslation Duration(object time)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "Duration", time);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Duration", "{time} long", time);
					}
				}
				
				public LocalizedTranslation Duration_ForLanguageID(int languageID, object time)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Duration", time);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Duration", "{time} long", time);
					}
				}
				
				public LazyLocalizedTranslation Lazy_Duration(object time)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "Duration", time);
				}
				
				public LazyLocalizedTranslation Lazy_Duration_ForLanguageID(int languageID, object time)
				{
					return this.CalculateLazyTranslation(languageID, "Duration", time);
				}
				
				public LocalizedTranslation Edit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Edit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Edit", "Edit");
						}
					}
				}
				
				public LocalizedTranslation Edit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Edit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Edit", "Edit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Edit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Edit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Edit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Edit");
				}
				
				public LocalizedTranslation EditAttachment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EditAttachment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EditAttachment", "Edit Attachment");
						}
					}
				}
				
				public LocalizedTranslation EditAttachment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EditAttachment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EditAttachment", "Edit Attachment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditAttachment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EditAttachment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditAttachment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EditAttachment");
				}
				
				public LocalizedTranslation EditComment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EditComment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EditComment", "Edit Comment");
						}
					}
				}
				
				public LocalizedTranslation EditComment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EditComment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EditComment", "Edit Comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditComment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EditComment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditComment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EditComment");
				}
				
				public LocalizedTranslation EditMyAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EditMyAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EditMyAccount", "Edit My Account");
						}
					}
				}
				
				public LocalizedTranslation EditMyAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EditMyAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EditMyAccount", "Edit My Account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditMyAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EditMyAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EditMyAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EditMyAccount");
				}
				
				public LocalizedTranslation Email
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Email");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Email", "Email");
						}
					}
				}
				
				public LocalizedTranslation Email_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Email");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Email", "Email");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Email
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Email");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Email_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Email");
				}
				
				public LocalizedTranslation EmailAddress
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EmailAddress");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EmailAddress", "Email Address");
						}
					}
				}
				
				public LocalizedTranslation EmailAddress_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailAddress");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailAddress", "Email Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailAddress
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailAddress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailAddress_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EmailAddress");
				}
				
				public LocalizedTranslation EmailErrorMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EmailErrorMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EmailErrorMessage", "Must be an e-mail address.");
						}
					}
				}
				
				public LocalizedTranslation EmailErrorMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EmailErrorMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EmailErrorMessage", "Must be an e-mail address.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailErrorMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EmailErrorMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EmailErrorMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EmailErrorMessage");
				}
				
				public LocalizedTranslation Enable
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Enable");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Enable", "Enable");
						}
					}
				}
				
				public LocalizedTranslation Enable_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Enable");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Enable", "Enable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enable
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Enable");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enable_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Enable");
				}
				
				public LocalizedTranslation Enabled
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Enabled");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Enabled", "Enabled");
						}
					}
				}
				
				public LocalizedTranslation Enabled_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Enabled");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Enabled", "Enabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enabled
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Enabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Enabled_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Enabled");
				}
				
				public LocalizedTranslation EndDate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EndDate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EndDate", "End Date");
						}
					}
				}
				
				public LocalizedTranslation EndDate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EndDate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EndDate", "End Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EndDate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EndDate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EndDate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EndDate");
				}
				
				public LocalizedTranslation EndDateWithTimezone(object timezone)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "EndDateWithTimezone", timezone);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EndDateWithTimezone", "End Date ({timezone})", timezone);
					}
				}
				
				public LocalizedTranslation EndDateWithTimezone_ForLanguageID(int languageID, object timezone)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EndDateWithTimezone", timezone);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EndDateWithTimezone", "End Date ({timezone})", timezone);
					}
				}
				
				public LazyLocalizedTranslation Lazy_EndDateWithTimezone(object timezone)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "EndDateWithTimezone", timezone);
				}
				
				public LazyLocalizedTranslation Lazy_EndDateWithTimezone_ForLanguageID(int languageID, object timezone)
				{
					return this.CalculateLazyTranslation(languageID, "EndDateWithTimezone", timezone);
				}
				
				public LocalizedTranslation Entity
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Entity");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Entity", "Entity");
						}
					}
				}
				
				public LocalizedTranslation Entity_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Entity");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Entity", "Entity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entity
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Entity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Entity_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Entity");
				}
				
				public LocalizedTranslation EqualErrorMessage(object actual, object expected)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "EqualErrorMessage", actual, expected);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EqualErrorMessage", "{actual} must be equal to {expected}", actual, expected);
					}
				}
				
				public LocalizedTranslation EqualErrorMessage_ForLanguageID(int languageID, object actual, object expected)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EqualErrorMessage", actual, expected);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EqualErrorMessage", "{actual} must be equal to {expected}", actual, expected);
					}
				}
				
				public LazyLocalizedTranslation Lazy_EqualErrorMessage(object actual, object expected)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "EqualErrorMessage", actual, expected);
				}
				
				public LazyLocalizedTranslation Lazy_EqualErrorMessage_ForLanguageID(int languageID, object actual, object expected)
				{
					return this.CalculateLazyTranslation(languageID, "EqualErrorMessage", actual, expected);
				}
				
				public LocalizedTranslation Error
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Error");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Error", "Error");
						}
					}
				}
				
				public LocalizedTranslation Error_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Error");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Error", "Error");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Error
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Error");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Error_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Error");
				}
				
				public LocalizedTranslation ErrorContactUs
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ErrorContactUs");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ErrorContactUs", "If you feel you have reached this message in error please contact us.");
						}
					}
				}
				
				public LocalizedTranslation ErrorContactUs_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ErrorContactUs");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ErrorContactUs", "If you feel you have reached this message in error please contact us.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ErrorContactUs
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ErrorContactUs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ErrorContactUs_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ErrorContactUs");
				}
				
				public LocalizedTranslation ErrorOccured
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ErrorOccured");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ErrorOccured", "Sorry, an error occurred while processing your request.");
						}
					}
				}
				
				public LocalizedTranslation ErrorOccured_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ErrorOccured");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ErrorOccured", "Sorry, an error occurred while processing your request.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ErrorOccured
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ErrorOccured");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ErrorOccured_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ErrorOccured");
				}
				
				public LocalizedTranslation EventManagement
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "EventManagement");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("EventManagement", "Event management");
						}
					}
				}
				
				public LocalizedTranslation EventManagement_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "EventManagement");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("EventManagement", "Event management");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EventManagement
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "EventManagement");
					}
				}
				
				public LazyLocalizedTranslation Lazy_EventManagement_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "EventManagement");
				}
				
				public LocalizedTranslation Expired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Expired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Expired", "Expired");
						}
					}
				}
				
				public LocalizedTranslation Expired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Expired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Expired", "Expired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Expired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Expired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Expired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Expired");
				}
				
				public LocalizedTranslation Failed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Failed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Failed", "Failed");
						}
					}
				}
				
				public LocalizedTranslation Failed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Failed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Failed", "Failed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Failed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Failed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Failed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Failed");
				}
				
				public LocalizedTranslation False
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "False");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("False", "False");
						}
					}
				}
				
				public LocalizedTranslation False_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "False");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("False", "False");
					}
				}
				
				public LazyLocalizedTranslation Lazy_False
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "False");
					}
				}
				
				public LazyLocalizedTranslation Lazy_False_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "False");
				}
				
				public LocalizedTranslation Featured
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Featured");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Featured", "Featured");
						}
					}
				}
				
				public LocalizedTranslation Featured_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Featured");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Featured", "Featured");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Featured
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Featured");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Featured_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Featured");
				}
				
				public LocalizedTranslation Features
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Features");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Features", "Features");
						}
					}
				}
				
				public LocalizedTranslation Features_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Features");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Features", "Features");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Features
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Features");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Features_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Features");
				}
				
				public LocalizedTranslation FeedUrl
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FeedUrl");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FeedUrl", "Feed URL");
						}
					}
				}
				
				public LocalizedTranslation FeedUrl_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FeedUrl");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FeedUrl", "Feed URL");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FeedUrl
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FeedUrl");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FeedUrl_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FeedUrl");
				}
				
				public LocalizedTranslation Female
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Female");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Female", "Female");
						}
					}
				}
				
				public LocalizedTranslation Female_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Female");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Female", "Female");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Female
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Female");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Female_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Female");
				}
				
				public LocalizedTranslation FieldNumberTemplate(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "FieldNumberTemplate", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FieldNumberTemplate", "Field #{num}", num);
					}
				}
				
				public LocalizedTranslation FieldNumberTemplate_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FieldNumberTemplate", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FieldNumberTemplate", "Field #{num}", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_FieldNumberTemplate(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "FieldNumberTemplate", num);
				}
				
				public LazyLocalizedTranslation Lazy_FieldNumberTemplate_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "FieldNumberTemplate", num);
				}
				
				public LocalizedTranslation FileExtensionErrorMessageMultiple(object extensions)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "FileExtensionErrorMessageMultiple", extensions);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileExtensionErrorMessageMultiple", "File must end in one of: {extensions}.", extensions);
					}
				}
				
				public LocalizedTranslation FileExtensionErrorMessageMultiple_ForLanguageID(int languageID, object extensions)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FileExtensionErrorMessageMultiple", extensions);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileExtensionErrorMessageMultiple", "File must end in one of: {extensions}.", extensions);
					}
				}
				
				public LazyLocalizedTranslation Lazy_FileExtensionErrorMessageMultiple(object extensions)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "FileExtensionErrorMessageMultiple", extensions);
				}
				
				public LazyLocalizedTranslation Lazy_FileExtensionErrorMessageMultiple_ForLanguageID(int languageID, object extensions)
				{
					return this.CalculateLazyTranslation(languageID, "FileExtensionErrorMessageMultiple", extensions);
				}
				
				public LocalizedTranslation FileExtensionErrorMessageSingle(object extension)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "FileExtensionErrorMessageSingle", extension);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileExtensionErrorMessageSingle", "File must end in {extension}.", extension);
					}
				}
				
				public LocalizedTranslation FileExtensionErrorMessageSingle_ForLanguageID(int languageID, object extension)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FileExtensionErrorMessageSingle", extension);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileExtensionErrorMessageSingle", "File must end in {extension}.", extension);
					}
				}
				
				public LazyLocalizedTranslation Lazy_FileExtensionErrorMessageSingle(object extension)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "FileExtensionErrorMessageSingle", extension);
				}
				
				public LazyLocalizedTranslation Lazy_FileExtensionErrorMessageSingle_ForLanguageID(int languageID, object extension)
				{
					return this.CalculateLazyTranslation(languageID, "FileExtensionErrorMessageSingle", extension);
				}
				
				public LocalizedTranslation FileNameErrorMessage(object fileName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "FileNameErrorMessage", fileName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileNameErrorMessage", "File name must be {fileName}.", fileName);
					}
				}
				
				public LocalizedTranslation FileNameErrorMessage_ForLanguageID(int languageID, object fileName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FileNameErrorMessage", fileName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FileNameErrorMessage", "File name must be {fileName}.", fileName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_FileNameErrorMessage(object fileName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "FileNameErrorMessage", fileName);
				}
				
				public LazyLocalizedTranslation Lazy_FileNameErrorMessage_ForLanguageID(int languageID, object fileName)
				{
					return this.CalculateLazyTranslation(languageID, "FileNameErrorMessage", fileName);
				}
				
				public LocalizedTranslation FilterBy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FilterBy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FilterBy", "Filter By");
						}
					}
				}
				
				public LocalizedTranslation FilterBy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FilterBy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FilterBy", "Filter By");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FilterBy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FilterBy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FilterBy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FilterBy");
				}
				
				public LocalizedTranslation FilterBySite
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FilterBySite");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FilterBySite", "Filter By Site");
						}
					}
				}
				
				public LocalizedTranslation FilterBySite_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FilterBySite");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FilterBySite", "Filter By Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FilterBySite
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FilterBySite");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FilterBySite_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FilterBySite");
				}
				
				public LocalizedTranslation Finish
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Finish");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Finish", "Finish");
						}
					}
				}
				
				public LocalizedTranslation Finish_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Finish");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Finish", "Finish");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Finish
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Finish");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Finish_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Finish");
				}
				
				public LocalizedTranslation First
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "First");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("First", "First");
						}
					}
				}
				
				public LocalizedTranslation First_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "First");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("First", "First");
					}
				}
				
				public LazyLocalizedTranslation Lazy_First
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "First");
					}
				}
				
				public LazyLocalizedTranslation Lazy_First_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "First");
				}
				
				public LocalizedTranslation FirstName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FirstName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FirstName", "First name");
						}
					}
				}
				
				public LocalizedTranslation FirstName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FirstName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FirstName", "First name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FirstName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FirstName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FirstName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FirstName");
				}
				
				public LocalizedTranslation Follow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Follow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Follow", "Follow");
						}
					}
				}
				
				public LocalizedTranslation Follow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Follow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Follow", "Follow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Follow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Follow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Follow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Follow");
				}
				
				public LocalizedTranslation FollowersTemplate(object followersCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "FollowersTemplate", followersCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FollowersTemplate", "{followersCount} PLURAL[{followersCount};Follower;Followers;]", followersCount);
					}
				}
				
				public LocalizedTranslation FollowersTemplate_ForLanguageID(int languageID, object followersCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FollowersTemplate", followersCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FollowersTemplate", "{followersCount} PLURAL[{followersCount};Follower;Followers;]", followersCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_FollowersTemplate(object followersCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "FollowersTemplate", followersCount);
				}
				
				public LazyLocalizedTranslation Lazy_FollowersTemplate_ForLanguageID(int languageID, object followersCount)
				{
					return this.CalculateLazyTranslation(languageID, "FollowersTemplate", followersCount);
				}
				
				public LocalizedTranslation FooterLinks
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FooterLinks");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FooterLinks", "<!-- Footer -->\r\n<footer class=\"main t-footer u-icon u-icon-a group\" id=\"footer\" role=\"complimentary\">\r\n\t<div class=\"t-footer-wrapper\">\t\r\n\t\t<div class=\"t-footer-curseInfo\">\r\n\t\t\t<hgroup>\r\n\t\t\t\t<h1>Curse</h1>\r\n\t\t\t\t<h2><strong>Enjoy the game</strong></h2>\r\n\t\t\t</hgroup>\r\n\t\t\t<div class=\"t-footer-signUp\">\r\n\t\t\t\t<h4>Not a Member?</h4>\r\n\t\t\t\t<h5>Get your Free Account!</h5>\r\n\t\t\t\t<a href=\"http://www.curse.com\" class=\"u-button u-button-a\">Sign up for Free!</a>\r\n\t\t\t</div>\r\n\t\t\t<ul class=\"t-footer-socialLinks\">\r\n\t\t\t\t<li><a href=\"http://www.youtube.com/curseentertainment\"><i class=\"u-icon-youtube\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.twitter.com/#!/cursenetwork\"><i class=\"u-icon-twitter\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.facebook.com/CurseNetwork\"><i class=\"u-icon-facebook\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/news.rss\"><i class=\"u-icon-rss\"></i></a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-curseNetwork\">\r\n\t\t\t<header><h4>Featured Sites</h4><a href=\"http://www.curse.com\" class=\"t-footer-jumpLink\">More</a></header>\r\n\t\t\t<ul class=\"t-footer-featured group\">\r\n\t\t\t\t<li class=\"t-footer-featureItem site-gw2g\">\r\n\t\t\t\t\t<a href=\"http://www.guildwars2guru.com\">\r\n\t\t\t\t\t\t<h4>Guild Wars 2 Guru</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-gw2g\"></i>Guild Wars 2 Guru</dt>\r\n\t\t\t\t\t\t\t<dd>The latest and greatest on Tyria.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-lolpro\">\r\n\t\t\t\t\t<a href=\"http://www.lolpro.com\">\r\n\t\t\t\t\t\t<h4>LoL Pro</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-lolpro\"></i>LoL Pro</dt>\r\n\t\t\t\t\t\t\t<dd>Dominate with Pro LoL guides.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-mmoc\">\r\n\t\t\t\t\t<a href=\"http://www.mmo-champion.com\">\r\n\t\t\t\t\t\t<h4>MMO-Champion</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-mmoc\"></i>MMO-Champion</dt>\r\n\t\t\t\t\t\t\t<dd>Keep ahead with the champions of WoW coverage.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-gw2db\">\r\n\t\t\t\t\t<a href=\"http://www.gw2db.com\">\r\n\t\t\t\t\t\t<h4>GW2DB</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-gw2db\"></i>GW2DB</dt>\r\n\t\t\t\t\t\t\t<dd>Explore Tyria with Curse and GW2DB.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t</ul>\r\n\t\t\t<header><h4>Browse</h4><!--<a href=\"http://www.curse.com\" class=\"t-footer-jumpLink\">More</a>--></header>\r\n\t\t\t<ul class=\"t-footer-browse\">\r\n\t\t\t\t<li class=\"j-footer-item t-footer-coreLinks\">\r\n\t\t\t\t\t<a href=\"\" class=\"j-selected\">Core</a>\r\n\t\t\t\t\t<ul class=\"j-list-selected\">\r\n\t\t\t\t\t\t<li><a href=\"http://www.curse.com/\">Curse</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.mmo-champion.com/\">MMO-Champion</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.curseforge.com/\">CurseForge</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowace.com/\">WowAce</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.skyrimforge.com/\">SkyrimForge</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.sc2mapster.com/\">SC2Mapster</a></li>\r\n                                                <li><a href=\"http://www.lolpro.com/\">LoLPro</a></li>\r\n                                                <li><a href=\"http://www.exilepro.com\">ExilePro</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-communityLinks\">\r\n\t\t\t\t\t<a href=\"\">Community</a>\r\n\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t<li><a href=\"http://www.minecraftforum.net/\">Minecraft Forum</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.terrariaonline.com/\">Terraria Online</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.arenajunkies.com/\">Arena Junkies</a></li>\r\n                                                <li><a href=\"http://www.eqnextfans.com/\">EQNext Fans</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://guildwars2guru.com/\">Guild Wars 2 Guru</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.diablofans.com/\">DiabloFans</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.fpsgeneral.com/\">FPS General</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.darthhater.com/\">DarthHater</a></li>\r\n                                                <li><a href=\"http://www.wildstarforums.com/\">Wildstar Forums</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-databaseLinks\">\r\n\t\t\t\t\t<a href=\"\">Database</a>\r\n\t\t\t\t\t<ul>\r\n                                                <li><a href=\"http://www.gw2db.com/\">Guild Wars 2 DB</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.zybez.net/\">Zybez</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.muthead.com/\">Muthead</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.aionarmory.com/\">Aion Armory</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowdb.com/\">WoW Database</a></li>\r\n                                                <li><a href=\"http://www.marriland.com\">Marriland</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-wikiLinks\">\r\n\t\t\t\t\t<a href=\"\">Wiki</a>\r\n\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t<li><a href=\"http://www.gamepedia.com/\">Gamepedia</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.minecraftwiki.net/\">Minecraft Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://www.dota2wiki.com/\">Dota 2 Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowpedia.org/\">Wowpedia</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://wiki.terrariaonline.com/\">Terraria Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://neverwinter.gamepedia.com/\">Neverwinter Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://dayz.gamepedia.com/\">DayZ Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://hearthstone.gamepedia.com/\">Hearthstone Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://wildstar.gamepedia.com/\">Wildstar Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://madden25.gamepedia.com/\">Madden 25 Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<span class=\"return-to-top\"><a href=\"#top\">Back to Top</a></span>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-curseLinks\">\r\n\t\t\t<ul>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/about\">About Us</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/advertising/overview\">Advertising</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/privacy\">Privacy Policy</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/terms\">Terms of Service</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/premiumterms\">Premium Terms of Service</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/newsletter\">Curse Newsletter</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/jobs\">Jobs at Curse</a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-createdBy\">\r\n\t\t\t<div class=\"curse-logo\">Curse Logo</div>\r\n\t\t\t<p class=\"happy-pants\">Handcrafted in San Francisco <span>&</span> Huntsville</p>\r\n\t\t</div>\r\n</footer>\r\n<!-- Update -->");
						}
					}
				}
				
				public LocalizedTranslation FooterLinks_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FooterLinks");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FooterLinks", "<!-- Footer -->\r\n<footer class=\"main t-footer u-icon u-icon-a group\" id=\"footer\" role=\"complimentary\">\r\n\t<div class=\"t-footer-wrapper\">\t\r\n\t\t<div class=\"t-footer-curseInfo\">\r\n\t\t\t<hgroup>\r\n\t\t\t\t<h1>Curse</h1>\r\n\t\t\t\t<h2><strong>Enjoy the game</strong></h2>\r\n\t\t\t</hgroup>\r\n\t\t\t<div class=\"t-footer-signUp\">\r\n\t\t\t\t<h4>Not a Member?</h4>\r\n\t\t\t\t<h5>Get your Free Account!</h5>\r\n\t\t\t\t<a href=\"http://www.curse.com\" class=\"u-button u-button-a\">Sign up for Free!</a>\r\n\t\t\t</div>\r\n\t\t\t<ul class=\"t-footer-socialLinks\">\r\n\t\t\t\t<li><a href=\"http://www.youtube.com/curseentertainment\"><i class=\"u-icon-youtube\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.twitter.com/#!/cursenetwork\"><i class=\"u-icon-twitter\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.facebook.com/CurseNetwork\"><i class=\"u-icon-facebook\"></i></a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/news.rss\"><i class=\"u-icon-rss\"></i></a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-curseNetwork\">\r\n\t\t\t<header><h4>Featured Sites</h4><a href=\"http://www.curse.com\" class=\"t-footer-jumpLink\">More</a></header>\r\n\t\t\t<ul class=\"t-footer-featured group\">\r\n\t\t\t\t<li class=\"t-footer-featureItem site-gw2g\">\r\n\t\t\t\t\t<a href=\"http://www.guildwars2guru.com\">\r\n\t\t\t\t\t\t<h4>Guild Wars 2 Guru</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-gw2g\"></i>Guild Wars 2 Guru</dt>\r\n\t\t\t\t\t\t\t<dd>The latest and greatest on Tyria.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-lolpro\">\r\n\t\t\t\t\t<a href=\"http://www.lolpro.com\">\r\n\t\t\t\t\t\t<h4>LoL Pro</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-lolpro\"></i>LoL Pro</dt>\r\n\t\t\t\t\t\t\t<dd>Dominate with Pro LoL guides.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-mmoc\">\r\n\t\t\t\t\t<a href=\"http://www.mmo-champion.com\">\r\n\t\t\t\t\t\t<h4>MMO-Champion</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-mmoc\"></i>MMO-Champion</dt>\r\n\t\t\t\t\t\t\t<dd>Keep ahead with the champions of WoW coverage.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"t-footer-featureItem site-gw2db\">\r\n\t\t\t\t\t<a href=\"http://www.gw2db.com\">\r\n\t\t\t\t\t\t<h4>GW2DB</h4>\r\n\t\t\t\t\t\t<dl>\r\n\t\t\t\t\t\t\t<dt><i class=\"u-icon-gw2db\"></i>GW2DB</dt>\r\n\t\t\t\t\t\t\t<dd>Explore Tyria with Curse and GW2DB.</dd>\r\n\t\t\t\t\t\t</dl>\r\n\t\t\t\t\t</a>\r\n\t\t\t\t</li>\r\n\t\t\t</ul>\r\n\t\t\t<header><h4>Browse</h4><!--<a href=\"http://www.curse.com\" class=\"t-footer-jumpLink\">More</a>--></header>\r\n\t\t\t<ul class=\"t-footer-browse\">\r\n\t\t\t\t<li class=\"j-footer-item t-footer-coreLinks\">\r\n\t\t\t\t\t<a href=\"\" class=\"j-selected\">Core</a>\r\n\t\t\t\t\t<ul class=\"j-list-selected\">\r\n\t\t\t\t\t\t<li><a href=\"http://www.curse.com/\">Curse</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.mmo-champion.com/\">MMO-Champion</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.curseforge.com/\">CurseForge</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowace.com/\">WowAce</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.skyrimforge.com/\">SkyrimForge</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.sc2mapster.com/\">SC2Mapster</a></li>\r\n                                                <li><a href=\"http://www.lolpro.com/\">LoLPro</a></li>\r\n                                                <li><a href=\"http://www.exilepro.com\">ExilePro</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-communityLinks\">\r\n\t\t\t\t\t<a href=\"\">Community</a>\r\n\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t<li><a href=\"http://www.minecraftforum.net/\">Minecraft Forum</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.terrariaonline.com/\">Terraria Online</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.arenajunkies.com/\">Arena Junkies</a></li>\r\n                                                <li><a href=\"http://www.eqnextfans.com/\">EQNext Fans</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://guildwars2guru.com/\">Guild Wars 2 Guru</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.diablofans.com/\">DiabloFans</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.fpsgeneral.com/\">FPS General</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.darthhater.com/\">DarthHater</a></li>\r\n                                                <li><a href=\"http://www.wildstarforums.com/\">Wildstar Forums</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-databaseLinks\">\r\n\t\t\t\t\t<a href=\"\">Database</a>\r\n\t\t\t\t\t<ul>\r\n                                                <li><a href=\"http://www.gw2db.com/\">Guild Wars 2 DB</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.zybez.net/\">Zybez</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.muthead.com/\">Muthead</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.aionarmory.com/\">Aion Armory</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowdb.com/\">WoW Database</a></li>\r\n                                                <li><a href=\"http://www.marriland.com\">Marriland</a></li>\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t\t<li class=\"j-footer-item t-footer-wikiLinks\">\r\n\t\t\t\t\t<a href=\"\">Wiki</a>\r\n\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t<li><a href=\"http://www.gamepedia.com/\">Gamepedia</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.minecraftwiki.net/\">Minecraft Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://www.dota2wiki.com/\">Dota 2 Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://www.wowpedia.org/\">Wowpedia</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://wiki.terrariaonline.com/\">Terraria Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://neverwinter.gamepedia.com/\">Neverwinter Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://dayz.gamepedia.com/\">DayZ Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://hearthstone.gamepedia.com/\">Hearthstone Wiki</a></li>\r\n\t\t\t\t\t\t<li><a href=\"http://wildstar.gamepedia.com/\">Wildstar Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t\t<li><a href=\"http://madden25.gamepedia.com/\">Madden 25 Wiki</a></li>\t\t\t\t\t\t\r\n\t\t\t\t\t</ul>\r\n\t\t\t\t</li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<span class=\"return-to-top\"><a href=\"#top\">Back to Top</a></span>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-curseLinks\">\r\n\t\t\t<ul>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/about\">About Us</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/advertising/overview\">Advertising</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/privacy\">Privacy Policy</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/terms\">Terms of Service</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/premiumterms\">Premium Terms of Service</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/newsletter\">Curse Newsletter</a></li>\r\n\t\t\t\t<li><a href=\"http://www.curse.com/jobs\">Jobs at Curse</a></li>\r\n\t\t\t</ul>\r\n\t\t</div>\r\n\t\t<div class=\"t-footer-createdBy\">\r\n\t\t\t<div class=\"curse-logo\">Curse Logo</div>\r\n\t\t\t<p class=\"happy-pants\">Handcrafted in San Francisco <span>&</span> Huntsville</p>\r\n\t\t</div>\r\n</footer>\r\n<!-- Update -->");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FooterLinks
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FooterLinks");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FooterLinks_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FooterLinks");
				}
				
				public LocalizedTranslation Forbidden
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Forbidden");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Forbidden", "Forbidden");
						}
					}
				}
				
				public LocalizedTranslation Forbidden_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Forbidden");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Forbidden", "Forbidden");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forbidden
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Forbidden");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forbidden_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Forbidden");
				}
				
				public LocalizedTranslation ForbiddenNoAccess
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ForbiddenNoAccess");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ForbiddenNoAccess", "You do not have access to perform that action.");
						}
					}
				}
				
				public LocalizedTranslation ForbiddenNoAccess_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ForbiddenNoAccess");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ForbiddenNoAccess", "You do not have access to perform that action.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ForbiddenNoAccess
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ForbiddenNoAccess");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ForbiddenNoAccess_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ForbiddenNoAccess");
				}
				
				public LocalizedTranslation ForgotYourPassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ForgotYourPassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ForgotYourPassword", "Forgot your password?");
						}
					}
				}
				
				public LocalizedTranslation ForgotYourPassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ForgotYourPassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ForgotYourPassword", "Forgot your password?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ForgotYourPassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ForgotYourPassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ForgotYourPassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ForgotYourPassword");
				}
				
				public LocalizedTranslation ForgotYourPasswordTemplate(object passwordLink)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ForgotYourPasswordTemplate", passwordLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ForgotYourPasswordTemplate", "Forgot your {passwordLink}?", passwordLink);
					}
				}
				
				public LocalizedTranslation ForgotYourPasswordTemplate_ForLanguageID(int languageID, object passwordLink)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ForgotYourPasswordTemplate", passwordLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ForgotYourPasswordTemplate", "Forgot your {passwordLink}?", passwordLink);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ForgotYourPasswordTemplate(object passwordLink)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ForgotYourPasswordTemplate", passwordLink);
				}
				
				public LazyLocalizedTranslation Lazy_ForgotYourPasswordTemplate_ForLanguageID(int languageID, object passwordLink)
				{
					return this.CalculateLazyTranslation(languageID, "ForgotYourPasswordTemplate", passwordLink);
				}
				
				public LocalizedTranslation Forums
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Forums");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Forums", "Forums");
						}
					}
				}
				
				public LocalizedTranslation Forums_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Forums");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Forums", "Forums");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forums
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Forums");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Forums_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Forums");
				}
				
				public LocalizedTranslation FreeSite
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FreeSite");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FreeSite", "Free Site");
						}
					}
				}
				
				public LocalizedTranslation FreeSite_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FreeSite");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FreeSite", "Free Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FreeSite
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FreeSite");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FreeSite_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FreeSite");
				}
				
				public LocalizedTranslation From
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "From");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("From", "From");
						}
					}
				}
				
				public LocalizedTranslation From_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "From");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("From", "From");
					}
				}
				
				public LazyLocalizedTranslation Lazy_From
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "From");
					}
				}
				
				public LazyLocalizedTranslation Lazy_From_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "From");
				}
				
				public LocalizedTranslation FullCssCustomization
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "FullCssCustomization");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("FullCssCustomization", "Full CSS Customization");
						}
					}
				}
				
				public LocalizedTranslation FullCssCustomization_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "FullCssCustomization");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("FullCssCustomization", "Full CSS Customization");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FullCssCustomization
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "FullCssCustomization");
					}
				}
				
				public LazyLocalizedTranslation Lazy_FullCssCustomization_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "FullCssCustomization");
				}
				
				public LocalizedTranslation Galleries
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Galleries");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Galleries", "Galleries");
						}
					}
				}
				
				public LocalizedTranslation Galleries_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Galleries");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Galleries", "Galleries");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Galleries
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Galleries");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Galleries_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Galleries");
				}
				
				public LocalizedTranslation Game
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Game");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Game", "Game");
						}
					}
				}
				
				public LocalizedTranslation Game_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Game");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Game", "Game");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Game
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Game");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Game_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Game");
				}
				
				public LocalizedTranslation GameInfo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GameInfo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GameInfo", "Game Info");
						}
					}
				}
				
				public LocalizedTranslation GameInfo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GameInfo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GameInfo", "Game Info");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GameInfo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GameInfo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GameInfo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GameInfo");
				}
				
				public LocalizedTranslation GamerNetwork
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetwork");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetwork", "Gamer Network");
						}
					}
				}
				
				public LocalizedTranslation GamerNetwork_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetwork");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetwork", "Gamer Network");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetwork
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetwork");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetwork_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetwork");
				}
				
				public LocalizedTranslation GamerNetworkItem1
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem1");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem1", "Connect to your friends through IM, VOIP and Guildspace Messages, all for free!");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem1_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem1");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem1", "Connect to your friends through IM, VOIP and Guildspace Messages, all for free!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem1
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem1");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem1_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem1");
				}
				
				public LocalizedTranslation GamerNetworkItem2
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem2");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem2", "Broadcast your in-game achievements to everyone in your network through the Shoutbox.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem2_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem2");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem2", "Broadcast your in-game achievements to everyone in your network through the Shoutbox.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem2
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem2");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem2_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem2");
				}
				
				public LocalizedTranslation GamerNetworkItem3
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem3");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem3", "Upload screenshots and publish albums.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem3_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem3");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem3", "Upload screenshots and publish albums.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem3
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem3");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem3_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem3");
				}
				
				public LocalizedTranslation GamerNetworkItem4
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem4");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem4", "Find and apply to guilds.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem4_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem4");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem4", "Find and apply to guilds.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem4
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem4");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem4_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem4");
				}
				
				public LocalizedTranslation GamerNetworkItem5
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem5");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem5", "Create and join groups - persistent group chat.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem5_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem5");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem5", "Create and join groups - persistent group chat.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem5
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem5");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem5_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem5");
				}
				
				public LocalizedTranslation GamerNetworkItem6
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem6");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem6", "Receive updates on what your friends and foes are doing.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem6_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem6");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem6", "Receive updates on what your friends and foes are doing.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem6
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem6");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem6_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem6");
				}
				
				public LocalizedTranslation GamerNetworkItem7
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GamerNetworkItem7");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GamerNetworkItem7", "Receive Twitter updates from Guildspace Twitter users.");
						}
					}
				}
				
				public LocalizedTranslation GamerNetworkItem7_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GamerNetworkItem7");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GamerNetworkItem7", "Receive Twitter updates from Guildspace Twitter users.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem7
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GamerNetworkItem7");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GamerNetworkItem7_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GamerNetworkItem7");
				}
				
				public LocalizedTranslation Games
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Games");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Games", "Games");
						}
					}
				}
				
				public LocalizedTranslation Games_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Games");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Games", "Games");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Games
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Games");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Games_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Games");
				}
				
				public LocalizedTranslation Gender
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Gender");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Gender", "Gender");
						}
					}
				}
				
				public LocalizedTranslation Gender_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Gender");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Gender", "Gender");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Gender
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Gender");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Gender_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Gender");
				}
				
				public LocalizedTranslation General
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "General");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("General", "General");
						}
					}
				}
				
				public LocalizedTranslation General_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "General");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("General", "General");
					}
				}
				
				public LazyLocalizedTranslation Lazy_General
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "General");
					}
				}
				
				public LazyLocalizedTranslation Lazy_General_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "General");
				}
				
				public LocalizedTranslation GeneralSettings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GeneralSettings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GeneralSettings", "General Settings");
						}
					}
				}
				
				public LocalizedTranslation GeneralSettings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GeneralSettings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GeneralSettings", "General Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GeneralSettings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GeneralSettings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GeneralSettings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GeneralSettings");
				}
				
				public LocalizedTranslation GenerateGuid
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GenerateGuid");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GenerateGuid", "Generate a new GUID");
						}
					}
				}
				
				public LocalizedTranslation GenerateGuid_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GenerateGuid");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GenerateGuid", "Generate a new GUID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GenerateGuid
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GenerateGuid");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GenerateGuid_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GenerateGuid");
				}
				
				public LocalizedTranslation GetStarted
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GetStarted");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GetStarted", "Get Started");
						}
					}
				}
				
				public LocalizedTranslation GetStarted_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GetStarted");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GetStarted", "Get Started");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GetStarted
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GetStarted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GetStarted_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GetStarted");
				}
				
				public LocalizedTranslation GetVentrilo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GetVentrilo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GetVentrilo", "Get your guild connected with a Ventrilo server from Curse!");
						}
					}
				}
				
				public LocalizedTranslation GetVentrilo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GetVentrilo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GetVentrilo", "Get your guild connected with a Ventrilo server from Curse!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GetVentrilo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GetVentrilo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GetVentrilo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GetVentrilo");
				}
				
				public LocalizedTranslation GlobalSettings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GlobalSettings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GlobalSettings", "Global Settings");
						}
					}
				}
				
				public LocalizedTranslation GlobalSettings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GlobalSettings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GlobalSettings", "Global Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GlobalSettings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GlobalSettings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GlobalSettings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GlobalSettings");
				}
				
				public LocalizedTranslation Go
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Go");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Go", "Go");
						}
					}
				}
				
				public LocalizedTranslation Go_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Go");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Go", "Go");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Go
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Go");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Go_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Go");
				}
				
				public LocalizedTranslation Grats_
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Grats!");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Grats!", "Grats!");
						}
					}
				}
				
				public LocalizedTranslation Grats__ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Grats!");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Grats!", "Grats!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Grats_
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Grats!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Grats__ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Grats!");
				}
				
				public LocalizedTranslation Grid
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Grid");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Grid", "Grid");
						}
					}
				}
				
				public LocalizedTranslation Grid_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Grid");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Grid", "Grid");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Grid
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Grid");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Grid_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Grid");
				}
				
				public LocalizedTranslation Group
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Group");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Group", "Group");
						}
					}
				}
				
				public LocalizedTranslation Group_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Group");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Group", "Group");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Group
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Group");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Group_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Group");
				}
				
				public LocalizedTranslation Guests
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Guests");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Guests", "Guests");
						}
					}
				}
				
				public LocalizedTranslation Guests_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Guests");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Guests", "Guests");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Guests
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Guests");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Guests_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Guests");
				}
				
				public LocalizedTranslation GuidTooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuidTooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuidTooltip", "What's a GUID?");
						}
					}
				}
				
				public LocalizedTranslation GuidTooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuidTooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuidTooltip", "What's a GUID?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuidTooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuidTooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuidTooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuidTooltip");
				}
				
				public LocalizedTranslation GuidTooltipWriteup
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuidTooltipWriteup");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuidTooltipWriteup", "A GUID (Guaranteed Unique Identifier) is something used to identify you when you're using site features, but are not actually browsing the site. It gets used automatically, so you don't need to worry about it. However, if you want to generate a new GUID for whatever reason, just click this button.");
						}
					}
				}
				
				public LocalizedTranslation GuidTooltipWriteup_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuidTooltipWriteup");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuidTooltipWriteup", "A GUID (Guaranteed Unique Identifier) is something used to identify you when you're using site features, but are not actually browsing the site. It gets used automatically, so you don't need to worry about it. However, if you want to generate a new GUID for whatever reason, just click this button.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuidTooltipWriteup
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuidTooltipWriteup");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuidTooltipWriteup_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuidTooltipWriteup");
				}
				
				public LocalizedTranslation GuidYourGuidTemplate(object guid)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "GuidYourGuidTemplate", guid);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuidYourGuidTemplate", "Your GUID is: {guid}", guid);
					}
				}
				
				public LocalizedTranslation GuidYourGuidTemplate_ForLanguageID(int languageID, object guid)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuidYourGuidTemplate", guid);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuidYourGuidTemplate", "Your GUID is: {guid}", guid);
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuidYourGuidTemplate(object guid)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "GuidYourGuidTemplate", guid);
				}
				
				public LazyLocalizedTranslation Lazy_GuidYourGuidTemplate_ForLanguageID(int languageID, object guid)
				{
					return this.CalculateLazyTranslation(languageID, "GuidYourGuidTemplate", guid);
				}
				
				public LocalizedTranslation GuildHosting
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHosting");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHosting", "Guild Hosting");
						}
					}
				}
				
				public LocalizedTranslation GuildHosting_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHosting");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHosting", "Guild Hosting");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHosting
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHosting");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHosting_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHosting");
				}
				
				public LocalizedTranslation GuildHostingItem1
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingItem1");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingItem1", "Automated roster tracking - set up your guild roster permissions quickly and easily.");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingItem1_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingItem1");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingItem1", "Automated roster tracking - set up your guild roster permissions quickly and easily.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem1
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingItem1");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem1_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingItem1");
				}
				
				public LocalizedTranslation GuildHostingItem2
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingItem2");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingItem2", "Integrated, flexible DKP system allows you to manage DKP and track it in-game.");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingItem2_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingItem2");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingItem2", "Integrated, flexible DKP system allows you to manage DKP and track it in-game.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem2
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingItem2");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem2_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingItem2");
				}
				
				public LocalizedTranslation GuildHostingItem3
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingItem3");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingItem3", "The Guild Recruitment System helps players find and apply to your guild.");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingItem3_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingItem3");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingItem3", "The Guild Recruitment System helps players find and apply to your guild.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem3
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingItem3");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem3_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingItem3");
				}
				
				public LocalizedTranslation GuildHostingItem4
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildHostingItem4");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildHostingItem4", "Interactive Guild Calendar.");
						}
					}
				}
				
				public LocalizedTranslation GuildHostingItem4_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildHostingItem4");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildHostingItem4", "Interactive Guild Calendar.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem4
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildHostingItem4");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildHostingItem4_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildHostingItem4");
				}
				
				public LocalizedTranslation GuildName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "GuildName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("GuildName", "Guild Name");
						}
					}
				}
				
				public LocalizedTranslation GuildName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "GuildName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("GuildName", "Guild Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "GuildName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_GuildName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "GuildName");
				}
				
				public LocalizedTranslation Guilds
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Guilds");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Guilds", "Guilds");
						}
					}
				}
				
				public LocalizedTranslation Guilds_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Guilds");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Guilds", "Guilds");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Guilds
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Guilds");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Guilds_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Guilds");
				}
				
				public LocalizedTranslation HeaderLinks
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HeaderLinks");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HeaderLinks", "<ul class=\"t-netbar-discover t-netbar-section u-dropdown\" role=\"directory\">\r\n  <li>\r\n    <a href=\"http://www.curse.com\" class=\"t-netbar-label\">Curse Sites <i class=\"u-icon-dropDown\"></i></a>\r\n  </li>\r\n</ul>");
						}
					}
				}
				
				public LocalizedTranslation HeaderLinks_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HeaderLinks");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HeaderLinks", "<ul class=\"t-netbar-discover t-netbar-section u-dropdown\" role=\"directory\">\r\n  <li>\r\n    <a href=\"http://www.curse.com\" class=\"t-netbar-label\">Curse Sites <i class=\"u-icon-dropDown\"></i></a>\r\n  </li>\r\n</ul>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HeaderLinks
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HeaderLinks");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HeaderLinks_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HeaderLinks");
				}
				
				public LocalizedTranslation HeaderLinksLegacy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HeaderLinksLegacy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HeaderLinksLegacy", "<ul>\r\n    <li class=\"suckerfish\">\r\n        <span class=\"curse-sites\">Curse Sites</span>\r\n        <ul class=\"section-drop\">\r\n            <li class=\"cursesite-curse\"><a href=\"http://www.curse.com/\">Curse.com</a></li>\r\n            <li class=\"cursesite-mmoc\"><a href=\"http://www.mmo-champion.com/\">MMO-Champion</a></li>\r\n            <li class=\"cursesite-wowstead\"><a href=\"http://www.wowstead.com/\">Wowstead</a></li>\r\n            <li class=\"cursesite-arenajunkies\"><a href=\"http://www.arenajunkies.com/\">Arena Junkies</a></li>\r\n            <li class=\"cursesite-minecraftforums\"><a href=\"http://www.minecraftforums.net/\">Minecraft Forums</a></li>\r\n            <li class=\"cursesite-darthhater\"><a href=\"http://www.darthhater.com/\">Darth Hater</a></li>\r\n            <li class=\"cursesite-diablofans\"><a href=\"http://www.diablofans.com/\">DiabloFans</a></li>\r\n            <li class=\"cursesite-terraria\"><a href=\"http://www.terrariaonline.com/\">Terarria Online</a></li>\r\n        </ul>\r\n    </li>\r\n</ul>");
						}
					}
				}
				
				public LocalizedTranslation HeaderLinksLegacy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HeaderLinksLegacy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HeaderLinksLegacy", "<ul>\r\n    <li class=\"suckerfish\">\r\n        <span class=\"curse-sites\">Curse Sites</span>\r\n        <ul class=\"section-drop\">\r\n            <li class=\"cursesite-curse\"><a href=\"http://www.curse.com/\">Curse.com</a></li>\r\n            <li class=\"cursesite-mmoc\"><a href=\"http://www.mmo-champion.com/\">MMO-Champion</a></li>\r\n            <li class=\"cursesite-wowstead\"><a href=\"http://www.wowstead.com/\">Wowstead</a></li>\r\n            <li class=\"cursesite-arenajunkies\"><a href=\"http://www.arenajunkies.com/\">Arena Junkies</a></li>\r\n            <li class=\"cursesite-minecraftforums\"><a href=\"http://www.minecraftforums.net/\">Minecraft Forums</a></li>\r\n            <li class=\"cursesite-darthhater\"><a href=\"http://www.darthhater.com/\">Darth Hater</a></li>\r\n            <li class=\"cursesite-diablofans\"><a href=\"http://www.diablofans.com/\">DiabloFans</a></li>\r\n            <li class=\"cursesite-terraria\"><a href=\"http://www.terrariaonline.com/\">Terarria Online</a></li>\r\n        </ul>\r\n    </li>\r\n</ul>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HeaderLinksLegacy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HeaderLinksLegacy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HeaderLinksLegacy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HeaderLinksLegacy");
				}
				
				public LocalizedTranslation Height
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Height");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Height", "Height");
						}
					}
				}
				
				public LocalizedTranslation Height_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Height");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Height", "Height");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Height
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Height");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Height_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Height");
				}
				
				public LocalizedTranslation Help
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Help");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Help", "Help");
						}
					}
				}
				
				public LocalizedTranslation Help_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Help");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Help", "Help");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Help
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Help");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Help_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Help");
				}
				
				public LocalizedTranslation Here
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Here");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Here", "here");
						}
					}
				}
				
				public LocalizedTranslation Here_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Here");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Here", "here");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Here
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Here");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Here_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Here");
				}
				
				public LocalizedTranslation HideSettings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HideSettings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HideSettings", "Hide Settings");
						}
					}
				}
				
				public LocalizedTranslation HideSettings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HideSettings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HideSettings", "Hide Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HideSettings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HideSettings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HideSettings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HideSettings");
				}
				
				public LocalizedTranslation History
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "History");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("History", "History");
						}
					}
				}
				
				public LocalizedTranslation History_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "History");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("History", "History");
					}
				}
				
				public LazyLocalizedTranslation Lazy_History
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "History");
					}
				}
				
				public LazyLocalizedTranslation Lazy_History_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "History");
				}
				
				public LocalizedTranslation Home
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Home");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Home", "Home");
						}
					}
				}
				
				public LocalizedTranslation Home_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Home");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Home", "Home");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Home
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Home");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Home_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Home");
				}
				
				public LocalizedTranslation Homepage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Homepage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Homepage", "Homepage");
						}
					}
				}
				
				public LocalizedTranslation Homepage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Homepage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Homepage", "Homepage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Homepage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Homepage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Homepage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Homepage");
				}
				
				public LocalizedTranslation HostName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HostName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HostName", "Host Name");
						}
					}
				}
				
				public LocalizedTranslation HostName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HostName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HostName", "Host Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HostName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HostName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HostName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HostName");
				}
				
				public LocalizedTranslation HtmlSanitizer
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "HtmlSanitizer");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("HtmlSanitizer", "HTML Sanitizer");
						}
					}
				}
				
				public LocalizedTranslation HtmlSanitizer_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "HtmlSanitizer");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("HtmlSanitizer", "HTML Sanitizer");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HtmlSanitizer
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "HtmlSanitizer");
					}
				}
				
				public LazyLocalizedTranslation Lazy_HtmlSanitizer_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "HtmlSanitizer");
				}
				
				public LocalizedTranslation IAmATeapot
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IAmATeapot");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IAmATeapot", "I am a teapot");
						}
					}
				}
				
				public LocalizedTranslation IAmATeapot_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IAmATeapot");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IAmATeapot", "I am a teapot");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IAmATeapot
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IAmATeapot");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IAmATeapot_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IAmATeapot");
				}
				
				public LocalizedTranslation IAmATeapotOutOfCoffee
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IAmATeapotOutOfCoffee");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IAmATeapotOutOfCoffee", "Unfortunately this coffee machine is out of coffee.");
						}
					}
				}
				
				public LocalizedTranslation IAmATeapotOutOfCoffee_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IAmATeapotOutOfCoffee");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IAmATeapotOutOfCoffee", "Unfortunately this coffee machine is out of coffee.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IAmATeapotOutOfCoffee
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IAmATeapotOutOfCoffee");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IAmATeapotOutOfCoffee_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IAmATeapotOutOfCoffee");
				}
				
				public LocalizedTranslation iCalEventExport
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "iCalEventExport");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("iCalEventExport", "iCal Calendar Event Export");
						}
					}
				}
				
				public LocalizedTranslation iCalEventExport_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "iCalEventExport");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("iCalEventExport", "iCal Calendar Event Export");
					}
				}
				
				public LazyLocalizedTranslation Lazy_iCalEventExport
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "iCalEventExport");
					}
				}
				
				public LazyLocalizedTranslation Lazy_iCalEventExport_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "iCalEventExport");
				}
				
				public LocalizedTranslation Icon
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Icon");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Icon", "Icon");
						}
					}
				}
				
				public LocalizedTranslation Icon_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Icon");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Icon", "Icon");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Icon
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Icon");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Icon_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Icon");
				}
				
				public LocalizedTranslation ID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ID", "ID");
						}
					}
				}
				
				public LocalizedTranslation ID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ID", "ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ID");
				}
				
				public LocalizedTranslation IfHaveAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IfHaveAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IfHaveAccount", "If you have an account");
						}
					}
				}
				
				public LocalizedTranslation IfHaveAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IfHaveAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IfHaveAccount", "If you have an account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IfHaveAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IfHaveAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IfHaveAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IfHaveAccount");
				}
				
				public LocalizedTranslation Image
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Image");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Image", "Require the applicant upload an image.");
						}
					}
				}
				
				public LocalizedTranslation Image_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Image");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Image", "Require the applicant upload an image.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Image
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Image");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Image_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Image");
				}
				
				public LocalizedTranslation Images
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Images");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Images", "Images");
						}
					}
				}
				
				public LocalizedTranslation Images_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Images");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Images", "Images");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Images
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Images");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Images_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Images");
				}
				
				public LocalizedTranslation Immedietly
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Immedietly");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Immedietly", "immedietly");
						}
					}
				}
				
				public LocalizedTranslation Immedietly_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Immedietly");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Immedietly", "immedietly");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Immedietly
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Immedietly");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Immedietly_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Immedietly");
				}
				
				public LocalizedTranslation In
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "In");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("In", "In");
						}
					}
				}
				
				public LocalizedTranslation In_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "In");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("In", "In");
					}
				}
				
				public LazyLocalizedTranslation Lazy_In
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "In");
					}
				}
				
				public LazyLocalizedTranslation Lazy_In_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "In");
				}
				
				public LocalizedTranslation IncreasedDataStorage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IncreasedDataStorage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IncreasedDataStorage", "Increased Data Storage");
						}
					}
				}
				
				public LocalizedTranslation IncreasedDataStorage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IncreasedDataStorage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IncreasedDataStorage", "Increased Data Storage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IncreasedDataStorage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IncreasedDataStorage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IncreasedDataStorage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IncreasedDataStorage");
				}
				
				public LocalizedTranslation Information
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Information");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Information", "Information");
						}
					}
				}
				
				public LocalizedTranslation Information_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Information");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Information", "Information");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Information
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Information");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Information_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Information");
				}
				
				public LocalizedTranslation InnovativeDesignPitch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InnovativeDesignPitch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InnovativeDesignPitch", "Innovative design makes managing cutting-edge features easy.");
						}
					}
				}
				
				public LocalizedTranslation InnovativeDesignPitch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InnovativeDesignPitch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InnovativeDesignPitch", "Innovative design makes managing cutting-edge features easy.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InnovativeDesignPitch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InnovativeDesignPitch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InnovativeDesignPitch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InnovativeDesignPitch");
				}
				
				public LocalizedTranslation IntegerFieldRange(object maxValue, object minValue, object name)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "IntegerFieldRange", maxValue, minValue, name);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerFieldRange", "{name} must be between {minValue} and {maxValue}", maxValue, minValue, name);
					}
				}
				
				public LocalizedTranslation IntegerFieldRange_ForLanguageID(int languageID, object maxValue, object minValue, object name)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IntegerFieldRange", maxValue, minValue, name);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerFieldRange", "{name} must be between {minValue} and {maxValue}", maxValue, minValue, name);
					}
				}
				
				public LazyLocalizedTranslation Lazy_IntegerFieldRange(object maxValue, object minValue, object name)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "IntegerFieldRange", maxValue, minValue, name);
				}
				
				public LazyLocalizedTranslation Lazy_IntegerFieldRange_ForLanguageID(int languageID, object maxValue, object minValue, object name)
				{
					return this.CalculateLazyTranslation(languageID, "IntegerFieldRange", maxValue, minValue, name);
				}
				
				public LocalizedTranslation IntegerValueErrorMessageMaximum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "IntegerValueErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageMaximum", "Must be at most {num}.", num);
					}
				}
				
				public LocalizedTranslation IntegerValueErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IntegerValueErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageMaximum", "Must be at most {num}.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageMaximum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "IntegerValueErrorMessageMaximum", num);
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "IntegerValueErrorMessageMaximum", num);
				}
				
				public LocalizedTranslation IntegerValueErrorMessageMinimum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "IntegerValueErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageMinimum", "Must be at least {num}.", num);
					}
				}
				
				public LocalizedTranslation IntegerValueErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IntegerValueErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageMinimum", "Must be at least {num}.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageMinimum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "IntegerValueErrorMessageMinimum", num);
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "IntegerValueErrorMessageMinimum", num);
				}
				
				public LocalizedTranslation IntegerValueErrorMessageRange(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "IntegerValueErrorMessageRange", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageRange", "Must be at least {alpha} and at most {bravo}.", alpha, bravo);
					}
				}
				
				public LocalizedTranslation IntegerValueErrorMessageRange_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IntegerValueErrorMessageRange", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IntegerValueErrorMessageRange", "Must be at least {alpha} and at most {bravo}.", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageRange(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "IntegerValueErrorMessageRange", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_IntegerValueErrorMessageRange_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "IntegerValueErrorMessageRange", alpha, bravo);
				}
				
				public LocalizedTranslation Integration
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Integration");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Integration", "Integration");
						}
					}
				}
				
				public LocalizedTranslation Integration_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Integration");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Integration", "Integration");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Integration
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Integration");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Integration_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Integration");
				}
				
				public LocalizedTranslation InternationalPresence
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InternationalPresence");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InternationalPresence", "International Presence");
						}
					}
				}
				
				public LocalizedTranslation InternationalPresence_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InternationalPresence");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InternationalPresence", "International Presence");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InternationalPresence
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InternationalPresence");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InternationalPresence_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InternationalPresence");
				}
				
				public LocalizedTranslation Invalidation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Invalidation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Invalidation", "Invalidation");
						}
					}
				}
				
				public LocalizedTranslation Invalidation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Invalidation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Invalidation", "Invalidation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Invalidation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Invalidation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Invalidation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Invalidation");
				}
				
				public LocalizedTranslation InvalidChoice(object choice)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidChoice", choice);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidChoice", "Not a valid choice: {choice}", choice);
					}
				}
				
				public LocalizedTranslation InvalidChoice_ForLanguageID(int languageID, object choice)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidChoice", choice);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidChoice", "Not a valid choice: {choice}", choice);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidChoice(object choice)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidChoice", choice);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidChoice_ForLanguageID(int languageID, object choice)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidChoice", choice);
				}
				
				public LocalizedTranslation InvalidDate(object date)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidDate", date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidDate", "{date} is not a valid date.", date);
					}
				}
				
				public LocalizedTranslation InvalidDate_ForLanguageID(int languageID, object date)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidDate", date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidDate", "{date} is not a valid date.", date);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidDate(object date)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidDate", date);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidDate_ForLanguageID(int languageID, object date)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidDate", date);
				}
				
				public LocalizedTranslation InvalidDecimal(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidDecimal", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidDecimal", "{num} is not a valid number.", num);
					}
				}
				
				public LocalizedTranslation InvalidDecimal_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidDecimal", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidDecimal", "{num} is not a valid number.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidDecimal(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidDecimal", num);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidDecimal_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidDecimal", num);
				}
				
				public LocalizedTranslation InvalidGenericModelFormat
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "InvalidGenericModelFormat");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("InvalidGenericModelFormat", "Invalid generic model, should be the type ID, colon (:), then the entity ID.");
						}
					}
				}
				
				public LocalizedTranslation InvalidGenericModelFormat_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidGenericModelFormat");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidGenericModelFormat", "Invalid generic model, should be the type ID, colon (:), then the entity ID.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidGenericModelFormat
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidGenericModelFormat");
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidGenericModelFormat_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidGenericModelFormat");
				}
				
				public LocalizedTranslation InvalidGuid(object guid)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidGuid", guid);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidGuid", "{guid} is not a valid value.", guid);
					}
				}
				
				public LocalizedTranslation InvalidGuid_ForLanguageID(int languageID, object guid)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidGuid", guid);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidGuid", "{guid} is not a valid value.", guid);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidGuid(object guid)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidGuid", guid);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidGuid_ForLanguageID(int languageID, object guid)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidGuid", guid);
				}
				
				public LocalizedTranslation InvalidInteger(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidInteger", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidInteger", "{num} is not a valid number.", num);
					}
				}
				
				public LocalizedTranslation InvalidInteger_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidInteger", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidInteger", "{num} is not a valid number.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidInteger(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidInteger", num);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidInteger_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidInteger", num);
				}
				
				public LocalizedTranslation InvalidIPAddress(object value)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidIPAddress", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidIPAddress", "Invalid IP Address: {value}", value);
					}
				}
				
				public LocalizedTranslation InvalidIPAddress_ForLanguageID(int languageID, object value)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidIPAddress", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidIPAddress", "Invalid IP Address: {value}", value);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidIPAddress(object value)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidIPAddress", value);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidIPAddress_ForLanguageID(int languageID, object value)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidIPAddress", value);
				}
				
				public LocalizedTranslation InvalidTimeSpan(object timeSpan)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "InvalidTimeSpan", timeSpan);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidTimeSpan", "{timeSpan} is not a valid time span.", timeSpan);
					}
				}
				
				public LocalizedTranslation InvalidTimeSpan_ForLanguageID(int languageID, object timeSpan)
				{
					try
					{
						return this.CalculateTranslation(languageID, "InvalidTimeSpan", timeSpan);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("InvalidTimeSpan", "{timeSpan} is not a valid time span.", timeSpan);
					}
				}
				
				public LazyLocalizedTranslation Lazy_InvalidTimeSpan(object timeSpan)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "InvalidTimeSpan", timeSpan);
				}
				
				public LazyLocalizedTranslation Lazy_InvalidTimeSpan_ForLanguageID(int languageID, object timeSpan)
				{
					return this.CalculateLazyTranslation(languageID, "InvalidTimeSpan", timeSpan);
				}
				
				public LocalizedTranslation IPAddress
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IPAddress");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IPAddress", "IP Address");
						}
					}
				}
				
				public LocalizedTranslation IPAddress_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IPAddress");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IPAddress", "IP Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPAddress
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IPAddress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPAddress_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IPAddress");
				}
				
				public LocalizedTranslation IPAddressNotValid
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IPAddressNotValid");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IPAddressNotValid", "Not a valid IP Address");
						}
					}
				}
				
				public LocalizedTranslation IPAddressNotValid_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IPAddressNotValid");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IPAddressNotValid", "Not a valid IP Address");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPAddressNotValid
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IPAddressNotValid");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPAddressNotValid_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IPAddressNotValid");
				}
				
				public LocalizedTranslation IPAddressPluralForm(object count)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "IPAddressPluralForm", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IPAddressPluralForm", "PLURAL[{count};IP Address;IP Addresses]", count);
					}
				}
				
				public LocalizedTranslation IPAddressPluralForm_ForLanguageID(int languageID, object count)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IPAddressPluralForm", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IPAddressPluralForm", "PLURAL[{count};IP Address;IP Addresses]", count);
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPAddressPluralForm(object count)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "IPAddressPluralForm", count);
				}
				
				public LazyLocalizedTranslation Lazy_IPAddressPluralForm_ForLanguageID(int languageID, object count)
				{
					return this.CalculateLazyTranslation(languageID, "IPAddressPluralForm", count);
				}
				
				public LocalizedTranslation IPBans
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IPBans");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IPBans", "IP Bans");
						}
					}
				}
				
				public LocalizedTranslation IPBans_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IPBans");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IPBans", "IP Bans");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPBans
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IPBans");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IPBans_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IPBans");
				}
				
				public LocalizedTranslation IsEnabled
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IsEnabled");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IsEnabled", "Is Enabled");
						}
					}
				}
				
				public LocalizedTranslation IsEnabled_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IsEnabled");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IsEnabled", "Is Enabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IsEnabled
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IsEnabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IsEnabled_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IsEnabled");
				}
				
				public LocalizedTranslation IsFeatured
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "IsFeatured");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("IsFeatured", "Is Featured");
						}
					}
				}
				
				public LocalizedTranslation IsFeatured_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "IsFeatured");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("IsFeatured", "Is Featured");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IsFeatured
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "IsFeatured");
					}
				}
				
				public LazyLocalizedTranslation Lazy_IsFeatured_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "IsFeatured");
				}
				
				public LocalizedTranslation Jobs
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Jobs");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Jobs", "Jobs");
						}
					}
				}
				
				public LocalizedTranslation Jobs_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Jobs");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Jobs", "Jobs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Jobs
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Jobs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Jobs_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Jobs");
				}
				
				public LocalizedTranslation JSONdata
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "JSONdata");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("JSONdata", "JSON data");
						}
					}
				}
				
				public LocalizedTranslation JSONdata_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "JSONdata");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("JSONdata", "JSON data");
					}
				}
				
				public LazyLocalizedTranslation Lazy_JSONdata
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "JSONdata");
					}
				}
				
				public LazyLocalizedTranslation Lazy_JSONdata_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "JSONdata");
				}
				
				public LocalizedTranslation Key
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Key");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Key", "Key");
						}
					}
				}
				
				public LocalizedTranslation Key_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Key");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Key", "Key");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Key
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Key");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Key_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Key");
				}
				
				public LocalizedTranslation KnownIPs
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "KnownIPs");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("KnownIPs", "Known IP Addresses");
						}
					}
				}
				
				public LocalizedTranslation KnownIPs_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "KnownIPs");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("KnownIPs", "Known IP Addresses");
					}
				}
				
				public LazyLocalizedTranslation Lazy_KnownIPs
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "KnownIPs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_KnownIPs_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "KnownIPs");
				}
				
				public LocalizedTranslation Label
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Label");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Label", "Label");
						}
					}
				}
				
				public LocalizedTranslation Label_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Label");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Label", "Label");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Label
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Label");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Label_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Label");
				}
				
				public LocalizedTranslation Language
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Language");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Language", "Language");
						}
					}
				}
				
				public LocalizedTranslation Language_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Language");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Language", "Language");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Language
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Language");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Language_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Language");
				}
				
				public LocalizedTranslation Languages
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Languages");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Languages", "Languages");
						}
					}
				}
				
				public LocalizedTranslation Languages_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Languages");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Languages", "Languages");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Languages
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Languages");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Languages_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Languages");
				}
				
				public LocalizedTranslation Last
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Last");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Last", "Last");
						}
					}
				}
				
				public LocalizedTranslation Last_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Last");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Last", "Last");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Last
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Last");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Last_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Last");
				}
				
				public LocalizedTranslation LastActivityOnTemplate(object date)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LastActivityOnTemplate", date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastActivityOnTemplate", "Last active {date}", date);
					}
				}
				
				public LocalizedTranslation LastActivityOnTemplate_ForLanguageID(int languageID, object date)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastActivityOnTemplate", date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastActivityOnTemplate", "Last active {date}", date);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastActivityOnTemplate(object date)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LastActivityOnTemplate", date);
				}
				
				public LazyLocalizedTranslation Lazy_LastActivityOnTemplate_ForLanguageID(int languageID, object date)
				{
					return this.CalculateLazyTranslation(languageID, "LastActivityOnTemplate", date);
				}
				
				public LocalizedTranslation LastAndJoiner
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastAndJoiner");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastAndJoiner", ", and ");
						}
					}
				}
				
				public LocalizedTranslation LastAndJoiner_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastAndJoiner");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastAndJoiner", ", and ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastAndJoiner
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastAndJoiner");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastAndJoiner_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastAndJoiner");
				}
				
				public LocalizedTranslation LastCommentBy(object author, object colonConnector)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LastCommentBy", author, colonConnector);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastCommentBy", "Last Comment By{colonConnector}{author}", author, colonConnector);
					}
				}
				
				public LocalizedTranslation LastCommentBy_ForLanguageID(int languageID, object author, object colonConnector)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastCommentBy", author, colonConnector);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastCommentBy", "Last Comment By{colonConnector}{author}", author, colonConnector);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastCommentBy(object author, object colonConnector)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LastCommentBy", author, colonConnector);
				}
				
				public LazyLocalizedTranslation Lazy_LastCommentBy_ForLanguageID(int languageID, object author, object colonConnector)
				{
					return this.CalculateLazyTranslation(languageID, "LastCommentBy", author, colonConnector);
				}
				
				public LocalizedTranslation LastName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastName", "Last name");
						}
					}
				}
				
				public LocalizedTranslation LastName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastName", "Last name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastName");
				}
				
				public LocalizedTranslation LastOrJoiner
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastOrJoiner");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastOrJoiner", ", or ");
						}
					}
				}
				
				public LocalizedTranslation LastOrJoiner_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastOrJoiner");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastOrJoiner", ", or ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastOrJoiner
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastOrJoiner");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastOrJoiner_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastOrJoiner");
				}
				
				public LocalizedTranslation LastPost(object colonConnector, object date)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LastPost", colonConnector, date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastPost", "Last Post{colonConnector}{date}", colonConnector, date);
					}
				}
				
				public LocalizedTranslation LastPost_ForLanguageID(int languageID, object colonConnector, object date)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastPost", colonConnector, date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastPost", "Last Post{colonConnector}{date}", colonConnector, date);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastPost(object colonConnector, object date)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LastPost", colonConnector, date);
				}
				
				public LazyLocalizedTranslation Lazy_LastPost_ForLanguageID(int languageID, object colonConnector, object date)
				{
					return this.CalculateLazyTranslation(languageID, "LastPost", colonConnector, date);
				}
				
				public LocalizedTranslation LastSeen
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LastSeen");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LastSeen", "Last Seen");
						}
					}
				}
				
				public LocalizedTranslation LastSeen_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastSeen");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastSeen", "Last Seen");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastSeen
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LastSeen");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastSeen_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LastSeen");
				}
				
				public LocalizedTranslation LastUpdated(object on)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LastUpdated", on);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastUpdated", "Last updated {on}", on);
					}
				}
				
				public LocalizedTranslation LastUpdated_ForLanguageID(int languageID, object on)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LastUpdated", on);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LastUpdated", "Last updated {on}", on);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LastUpdated(object on)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LastUpdated", on);
				}
				
				public LazyLocalizedTranslation Lazy_LastUpdated_ForLanguageID(int languageID, object on)
				{
					return this.CalculateLazyTranslation(languageID, "LastUpdated", on);
				}
				
				public LocalizedTranslation LatestCommentBy(object user)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LatestCommentBy", user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LatestCommentBy", "latest comment by {user}", user);
					}
				}
				
				public LocalizedTranslation LatestCommentBy_ForLanguageID(int languageID, object user)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LatestCommentBy", user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LatestCommentBy", "latest comment by {user}", user);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LatestCommentBy(object user)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LatestCommentBy", user);
				}
				
				public LazyLocalizedTranslation Lazy_LatestCommentBy_ForLanguageID(int languageID, object user)
				{
					return this.CalculateLazyTranslation(languageID, "LatestCommentBy", user);
				}
				
				public LocalizedTranslation LearnMore
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LearnMore");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LearnMore", "Learn More");
						}
					}
				}
				
				public LocalizedTranslation LearnMore_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LearnMore");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LearnMore", "Learn More");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LearnMore
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LearnMore");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LearnMore_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LearnMore");
				}
				
				public LocalizedTranslation LengthErrorMessage(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LengthErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessage", "Must be within {alpha} and {bravo} characters long.", alpha, bravo);
					}
				}
				
				public LocalizedTranslation LengthErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LengthErrorMessage", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessage", "Must be within {alpha} and {bravo} characters long.", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessage(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LengthErrorMessage", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessage_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "LengthErrorMessage", alpha, bravo);
				}
				
				public LocalizedTranslation LengthErrorMessageMaximum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LengthErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessageMaximum", "Must be at most {num} PLURAL[{num};character;characters] long.", num);
					}
				}
				
				public LocalizedTranslation LengthErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LengthErrorMessageMaximum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessageMaximum", "Must be at most {num} PLURAL[{num};character;characters] long.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessageMaximum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LengthErrorMessageMaximum", num);
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessageMaximum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "LengthErrorMessageMaximum", num);
				}
				
				public LocalizedTranslation LengthErrorMessageMinimum(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LengthErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessageMinimum", "Must be at least {num} PLURAL[{num};character;characters] long.", num);
					}
				}
				
				public LocalizedTranslation LengthErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LengthErrorMessageMinimum", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LengthErrorMessageMinimum", "Must be at least {num} PLURAL[{num};character;characters] long.", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessageMinimum(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LengthErrorMessageMinimum", num);
				}
				
				public LazyLocalizedTranslation Lazy_LengthErrorMessageMinimum_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "LengthErrorMessageMinimum", num);
				}
				
				public LocalizedTranslation LettersAndNumbersOnly
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LettersAndNumbersOnly");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LettersAndNumbersOnly", "Must be letters and numbers only, starting with a letter.");
						}
					}
				}
				
				public LocalizedTranslation LettersAndNumbersOnly_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LettersAndNumbersOnly");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LettersAndNumbersOnly", "Must be letters and numbers only, starting with a letter.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LettersAndNumbersOnly
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LettersAndNumbersOnly");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LettersAndNumbersOnly_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LettersAndNumbersOnly");
				}
				
				public LocalizedTranslation Like
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Like");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Like", "Like");
						}
					}
				}
				
				public LocalizedTranslation Like_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Like");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Like", "Like");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Like
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Like");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Like_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Like");
				}
				
				public LocalizedTranslation Likes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Likes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Likes", "Likes");
						}
					}
				}
				
				public LocalizedTranslation Likes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Likes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Likes", "Likes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Likes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Likes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Likes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Likes");
				}
				
				public LocalizedTranslation Link
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Link");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Link", "Link");
						}
					}
				}
				
				public LocalizedTranslation Link_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Link");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Link", "Link");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Link
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Link");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Link_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Link");
				}
				
				public LocalizedTranslation LinkOutMessage(object Model)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LinkOutMessage", Model);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LinkOutMessage", "    <p>\r\n    You have clicked on a link to 3rd party content, and will be redirected in a few seconds.\r\n    </p>\r\n    <p>\r\n    If you do not want to leave the site, please use your browser's back button.\r\n    </p>\r\n    <p>\r\n    Click <a href=\"{Model}\">here</a> to continue to the link now.\r\n    </p>", Model);
					}
				}
				
				public LocalizedTranslation LinkOutMessage_ForLanguageID(int languageID, object Model)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LinkOutMessage", Model);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LinkOutMessage", "    <p>\r\n    You have clicked on a link to 3rd party content, and will be redirected in a few seconds.\r\n    </p>\r\n    <p>\r\n    If you do not want to leave the site, please use your browser's back button.\r\n    </p>\r\n    <p>\r\n    Click <a href=\"{Model}\">here</a> to continue to the link now.\r\n    </p>", Model);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LinkOutMessage(object Model)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LinkOutMessage", Model);
				}
				
				public LazyLocalizedTranslation Lazy_LinkOutMessage_ForLanguageID(int languageID, object Model)
				{
					return this.CalculateLazyTranslation(languageID, "LinkOutMessage", Model);
				}
				
				public LocalizedTranslation Links
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Links");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Links", "Links");
						}
					}
				}
				
				public LocalizedTranslation Links_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Links");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Links", "Links");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Links
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Links");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Links_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Links");
				}
				
				public LocalizedTranslation LinkWarning
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LinkWarning");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LinkWarning", "Link Warning");
						}
					}
				}
				
				public LocalizedTranslation LinkWarning_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LinkWarning");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LinkWarning", "Link Warning");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LinkWarning
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LinkWarning");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LinkWarning_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LinkWarning");
				}
				
				public LocalizedTranslation Location
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Location");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Location", "Location");
						}
					}
				}
				
				public LocalizedTranslation Location_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Location");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Location", "Location");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Location
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Location");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Location_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Location");
				}
				
				public LocalizedTranslation Locked
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Locked");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Locked", "Locked");
						}
					}
				}
				
				public LocalizedTranslation Locked_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Locked");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Locked", "Locked");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Locked
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Locked");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Locked_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Locked");
				}
				
				public LocalizedTranslation LoginToLikeTemplate(object loginLink)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "LoginToLikeTemplate", loginLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LoginToLikeTemplate", "{loginLink} to like this.", loginLink);
					}
				}
				
				public LocalizedTranslation LoginToLikeTemplate_ForLanguageID(int languageID, object loginLink)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LoginToLikeTemplate", loginLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LoginToLikeTemplate", "{loginLink} to like this.", loginLink);
					}
				}
				
				public LazyLocalizedTranslation Lazy_LoginToLikeTemplate(object loginLink)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "LoginToLikeTemplate", loginLink);
				}
				
				public LazyLocalizedTranslation Lazy_LoginToLikeTemplate_ForLanguageID(int languageID, object loginLink)
				{
					return this.CalculateLazyTranslation(languageID, "LoginToLikeTemplate", loginLink);
				}
				
				public LocalizedTranslation LoginWithCurse
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LoginWithCurse");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LoginWithCurse", "Log in with your Curse username");
						}
					}
				}
				
				public LocalizedTranslation LoginWithCurse_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LoginWithCurse");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LoginWithCurse", "Log in with your Curse username");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LoginWithCurse
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LoginWithCurse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LoginWithCurse_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LoginWithCurse");
				}
				
				public LocalizedTranslation Logout
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Logout");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Logout", "Sign Out");
						}
					}
				}
				
				public LocalizedTranslation Logout_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Logout");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Logout", "Sign Out");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Logout
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Logout");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Logout_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Logout");
				}
				
				public LocalizedTranslation LuaDBTypeErrorMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "LuaDBTypeErrorMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("LuaDBTypeErrorMessage", "Invalid File Format");
						}
					}
				}
				
				public LocalizedTranslation LuaDBTypeErrorMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "LuaDBTypeErrorMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("LuaDBTypeErrorMessage", "Invalid File Format");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LuaDBTypeErrorMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "LuaDBTypeErrorMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_LuaDBTypeErrorMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "LuaDBTypeErrorMessage");
				}
				
				public LocalizedTranslation MailStatistics
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MailStatistics");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MailStatistics", "Mail Statistics");
						}
					}
				}
				
				public LocalizedTranslation MailStatistics_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MailStatistics");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MailStatistics", "Mail Statistics");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MailStatistics
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MailStatistics");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MailStatistics_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MailStatistics");
				}
				
				public LocalizedTranslation Manage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Manage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Manage", "Manage");
						}
					}
				}
				
				public LocalizedTranslation Manage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Manage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Manage", "Manage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Manage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Manage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Manage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Manage");
				}
				
				public LocalizedTranslation ManageCharacters
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ManageCharacters");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ManageCharacters", "Manage Characters");
						}
					}
				}
				
				public LocalizedTranslation ManageCharacters_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ManageCharacters");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ManageCharacters", "Manage Characters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ManageCharacters
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ManageCharacters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ManageCharacters_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ManageCharacters");
				}
				
				public LocalizedTranslation MarkedAsSpam
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MarkedAsSpam");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MarkedAsSpam", "Marked as Spam");
						}
					}
				}
				
				public LocalizedTranslation MarkedAsSpam_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MarkedAsSpam");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MarkedAsSpam", "Marked as Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MarkedAsSpam
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MarkedAsSpam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MarkedAsSpam_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MarkedAsSpam");
				}
				
				public LocalizedTranslation Markup
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Markup");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Markup", "Markup");
						}
					}
				}
				
				public LocalizedTranslation Markup_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Markup");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Markup", "Markup");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Markup
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Markup");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Markup_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Markup");
				}
				
				public LocalizedTranslation Member
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Member");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Member", "Member");
						}
					}
				}
				
				public LocalizedTranslation Member_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Member");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Member", "Member");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Member
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Member");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Member_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Member");
				}
				
				public LocalizedTranslation MemberForTemplate(object date, object time)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "MemberForTemplate", date, time);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MemberForTemplate", "Member for <span class=\"tip\" title=\"{date}\">{time}</span>", date, time);
					}
				}
				
				public LocalizedTranslation MemberForTemplate_ForLanguageID(int languageID, object date, object time)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MemberForTemplate", date, time);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MemberForTemplate", "Member for <span class=\"tip\" title=\"{date}\">{time}</span>", date, time);
					}
				}
				
				public LazyLocalizedTranslation Lazy_MemberForTemplate(object date, object time)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "MemberForTemplate", date, time);
				}
				
				public LazyLocalizedTranslation Lazy_MemberForTemplate_ForLanguageID(int languageID, object date, object time)
				{
					return this.CalculateLazyTranslation(languageID, "MemberForTemplate", date, time);
				}
				
				public LocalizedTranslation Members
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Members");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Members", "Members");
						}
					}
				}
				
				public LocalizedTranslation Members_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Members");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Members", "Members");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Members
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Members");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Members_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Members");
				}
				
				public LocalizedTranslation MemberSince
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MemberSince");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MemberSince", "Member Since");
						}
					}
				}
				
				public LocalizedTranslation MemberSince_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MemberSince");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MemberSince", "Member Since");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MemberSince
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MemberSince");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MemberSince_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MemberSince");
				}
				
				public LocalizedTranslation Message
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Message");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Message", "Message");
						}
					}
				}
				
				public LocalizedTranslation Message_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Message");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Message", "Message");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Message
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Message");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Message_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Message");
				}
				
				public LocalizedTranslation MethodNotAllowed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MethodNotAllowed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MethodNotAllowed", "Method Not Allowed");
						}
					}
				}
				
				public LocalizedTranslation MethodNotAllowed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MethodNotAllowed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MethodNotAllowed", "Method Not Allowed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MethodNotAllowed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MethodNotAllowed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MethodNotAllowed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MethodNotAllowed");
				}
				
				public LocalizedTranslation MethodNotAllowedDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MethodNotAllowedDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MethodNotAllowedDescription", "A request was made of a resource using a request method not supported by that resource.");
						}
					}
				}
				
				public LocalizedTranslation MethodNotAllowedDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MethodNotAllowedDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MethodNotAllowedDescription", "A request was made of a resource using a request method not supported by that resource.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MethodNotAllowedDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MethodNotAllowedDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MethodNotAllowedDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MethodNotAllowedDescription");
				}
				
				public LocalizedTranslation Milliseconds(object numMilliseconds)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "Milliseconds", numMilliseconds);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Milliseconds", "{numMilliseconds} PLURAL[{numMilliseconds};millisecond;milliseconds]", numMilliseconds);
					}
				}
				
				public LocalizedTranslation Milliseconds_ForLanguageID(int languageID, object numMilliseconds)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Milliseconds", numMilliseconds);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Milliseconds", "{numMilliseconds} PLURAL[{numMilliseconds};millisecond;milliseconds]", numMilliseconds);
					}
				}
				
				public LazyLocalizedTranslation Lazy_Milliseconds(object numMilliseconds)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "Milliseconds", numMilliseconds);
				}
				
				public LazyLocalizedTranslation Lazy_Milliseconds_ForLanguageID(int languageID, object numMilliseconds)
				{
					return this.CalculateLazyTranslation(languageID, "Milliseconds", numMilliseconds);
				}
				
				public LocalizedTranslation MimeTypeInvalidTemplate(object type)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "MimeTypeInvalidTemplate", type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MimeTypeInvalidTemplate", "{type} is not a supported file type.", type);
					}
				}
				
				public LocalizedTranslation MimeTypeInvalidTemplate_ForLanguageID(int languageID, object type)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MimeTypeInvalidTemplate", type);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MimeTypeInvalidTemplate", "{type} is not a supported file type.", type);
					}
				}
				
				public LazyLocalizedTranslation Lazy_MimeTypeInvalidTemplate(object type)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "MimeTypeInvalidTemplate", type);
				}
				
				public LazyLocalizedTranslation Lazy_MimeTypeInvalidTemplate_ForLanguageID(int languageID, object type)
				{
					return this.CalculateLazyTranslation(languageID, "MimeTypeInvalidTemplate", type);
				}
				
				public LocalizedTranslation Moderation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Moderation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Moderation", "Moderation");
						}
					}
				}
				
				public LocalizedTranslation Moderation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Moderation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Moderation", "Moderation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Moderation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Moderation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Moderation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Moderation");
				}
				
				public LocalizedTranslation ModuleNotFound
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ModuleNotFound");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ModuleNotFound", "Module Disabled");
						}
					}
				}
				
				public LocalizedTranslation ModuleNotFound_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ModuleNotFound");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ModuleNotFound", "Module Disabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ModuleNotFound
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ModuleNotFound");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ModuleNotFound_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ModuleNotFound");
				}
				
				public LocalizedTranslation ModuleNotFoundSubtext(object link)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "ModuleNotFoundSubtext", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ModuleNotFoundSubtext", "We're sorry, but this module is currently disabled. Please contact a site admin if this has been done in error. Site admins can enable modules under {link} in the Control Panel.", link);
					}
				}
				
				public LocalizedTranslation ModuleNotFoundSubtext_ForLanguageID(int languageID, object link)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ModuleNotFoundSubtext", link);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ModuleNotFoundSubtext", "We're sorry, but this module is currently disabled. Please contact a site admin if this has been done in error. Site admins can enable modules under {link} in the Control Panel.", link);
					}
				}
				
				public LazyLocalizedTranslation Lazy_ModuleNotFoundSubtext(object link)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "ModuleNotFoundSubtext", link);
				}
				
				public LazyLocalizedTranslation Lazy_ModuleNotFoundSubtext_ForLanguageID(int languageID, object link)
				{
					return this.CalculateLazyTranslation(languageID, "ModuleNotFoundSubtext", link);
				}
				
				public LocalizedTranslation MonthlyCount(object Count)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "MonthlyCount", Count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MonthlyCount", "{Count} Monthly", Count);
					}
				}
				
				public LocalizedTranslation MonthlyCount_ForLanguageID(int languageID, object Count)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MonthlyCount", Count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MonthlyCount", "{Count} Monthly", Count);
					}
				}
				
				public LazyLocalizedTranslation Lazy_MonthlyCount(object Count)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "MonthlyCount", Count);
				}
				
				public LazyLocalizedTranslation Lazy_MonthlyCount_ForLanguageID(int languageID, object Count)
				{
					return this.CalculateLazyTranslation(languageID, "MonthlyCount", Count);
				}
				
				public LocalizedTranslation More
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "More");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("More", "More");
						}
					}
				}
				
				public LocalizedTranslation More_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "More");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("More", "More");
					}
				}
				
				public LazyLocalizedTranslation Lazy_More
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "More");
					}
				}
				
				public LazyLocalizedTranslation Lazy_More_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "More");
				}
				
				public LocalizedTranslation Moved
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Moved");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Moved", "moved");
						}
					}
				}
				
				public LocalizedTranslation Moved_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Moved");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Moved", "moved");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Moved
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Moved");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Moved_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Moved");
				}
				
				public LocalizedTranslation MustBeValidJSON
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MustBeValidJSON");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MustBeValidJSON", "Must be valid JSON");
						}
					}
				}
				
				public LocalizedTranslation MustBeValidJSON_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MustBeValidJSON");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MustBeValidJSON", "Must be valid JSON");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustBeValidJSON
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MustBeValidJSON");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustBeValidJSON_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MustBeValidJSON");
				}
				
				public LocalizedTranslation MustLogin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MustLogin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MustLogin", "You must be logged in to apply for Curse Voice beta.");
						}
					}
				}
				
				public LocalizedTranslation MustLogin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MustLogin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MustLogin", "You must be logged in to apply for Curse Voice beta.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustLogin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MustLogin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MustLogin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MustLogin");
				}
				
				public LocalizedTranslation MyAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyAccount", "My Account");
						}
					}
				}
				
				public LocalizedTranslation MyAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyAccount", "My Account");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyAccount");
				}
				
				public LocalizedTranslation MyCharacters
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyCharacters");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyCharacters", "My Characters");
						}
					}
				}
				
				public LocalizedTranslation MyCharacters_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyCharacters");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyCharacters", "My Characters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyCharacters
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyCharacters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyCharacters_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyCharacters");
				}
				
				public LocalizedTranslation MyCurse
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyCurse");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyCurse", "My Curse");
						}
					}
				}
				
				public LocalizedTranslation MyCurse_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyCurse");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyCurse", "My Curse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyCurse
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyCurse");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyCurse_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyCurse");
				}
				
				public LocalizedTranslation MyProfile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MyProfile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MyProfile", "My Profile");
						}
					}
				}
				
				public LocalizedTranslation MyProfile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MyProfile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MyProfile", "My Profile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyProfile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MyProfile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MyProfile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MyProfile");
				}
				
				public LocalizedTranslation MySubscriptions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "MySubscriptions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("MySubscriptions", "My Subscriptions");
						}
					}
				}
				
				public LocalizedTranslation MySubscriptions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "MySubscriptions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("MySubscriptions", "My Subscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MySubscriptions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "MySubscriptions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_MySubscriptions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "MySubscriptions");
				}
				
				public LocalizedTranslation Name
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Name");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Name", "Name");
						}
					}
				}
				
				public LocalizedTranslation Name_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Name");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Name", "Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Name
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Name_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Name");
				}
				
				public LocalizedTranslation Navigation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Navigation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Navigation", "Navigation");
						}
					}
				}
				
				public LocalizedTranslation Navigation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Navigation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Navigation", "Navigation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Navigation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Navigation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Navigation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Navigation");
				}
				
				public LocalizedTranslation NeedACurseID
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NeedACurseID");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NeedACurseID", "Need a Curse ID?");
						}
					}
				}
				
				public LocalizedTranslation NeedACurseID_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NeedACurseID");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NeedACurseID", "Need a Curse ID?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedACurseID
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NeedACurseID");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedACurseID_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NeedACurseID");
				}
				
				public LocalizedTranslation NeedAnAccount
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NeedAnAccount");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NeedAnAccount", "Need an Account?");
						}
					}
				}
				
				public LocalizedTranslation NeedAnAccount_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NeedAnAccount");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NeedAnAccount", "Need an Account?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedAnAccount
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NeedAnAccount");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedAnAccount_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NeedAnAccount");
				}
				
				public LocalizedTranslation NeedHelp
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NeedHelp");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NeedHelp", "Need Help?");
						}
					}
				}
				
				public LocalizedTranslation NeedHelp_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NeedHelp");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NeedHelp", "Need Help?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedHelp
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NeedHelp");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedHelp_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NeedHelp");
				}
				
				public LocalizedTranslation NeedHelpTemplate(object helpLink)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NeedHelpTemplate", helpLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NeedHelpTemplate", "Need help? See our {helpLink}", helpLink);
					}
				}
				
				public LocalizedTranslation NeedHelpTemplate_ForLanguageID(int languageID, object helpLink)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NeedHelpTemplate", helpLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NeedHelpTemplate", "Need help? See our {helpLink}", helpLink);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NeedHelpTemplate(object helpLink)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NeedHelpTemplate", helpLink);
				}
				
				public LazyLocalizedTranslation Lazy_NeedHelpTemplate_ForLanguageID(int languageID, object helpLink)
				{
					return this.CalculateLazyTranslation(languageID, "NeedHelpTemplate", helpLink);
				}
				
				public LocalizedTranslation Never
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Never");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Never", "Never");
						}
					}
				}
				
				public LocalizedTranslation Never_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Never");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Never", "Never");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Never
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Never");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Never_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Never");
				}
				
				public LocalizedTranslation New
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "New");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("New", "New");
						}
					}
				}
				
				public LocalizedTranslation New_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "New");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("New", "New");
					}
				}
				
				public LazyLocalizedTranslation Lazy_New
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "New");
					}
				}
				
				public LazyLocalizedTranslation Lazy_New_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "New");
				}
				
				public LocalizedTranslation News
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "News");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("News", "News");
						}
					}
				}
				
				public LocalizedTranslation News_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "News");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("News", "News");
					}
				}
				
				public LazyLocalizedTranslation Lazy_News
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "News");
					}
				}
				
				public LazyLocalizedTranslation Lazy_News_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "News");
				}
				
				public LocalizedTranslation Next
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Next");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Next", "Next");
						}
					}
				}
				
				public LocalizedTranslation Next_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Next");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Next", "Next");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Next
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Next");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Next_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Next");
				}
				
				public LocalizedTranslation NicknameOrUsername
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NicknameOrUsername");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NicknameOrUsername", "Nickname or Username");
						}
					}
				}
				
				public LocalizedTranslation NicknameOrUsername_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NicknameOrUsername");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NicknameOrUsername", "Nickname or Username");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NicknameOrUsername
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NicknameOrUsername");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NicknameOrUsername_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NicknameOrUsername");
				}
				
				public LocalizedTranslation No
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "No");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("No", "No");
						}
					}
				}
				
				public LocalizedTranslation No_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "No");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("No", "No");
					}
				}
				
				public LazyLocalizedTranslation Lazy_No
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "No");
					}
				}
				
				public LazyLocalizedTranslation Lazy_No_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "No");
				}
				
				public LocalizedTranslation No_file_chosen
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "No file chosen");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("No file chosen", "No file chosen");
						}
					}
				}
				
				public LocalizedTranslation No_file_chosen_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "No file chosen");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("No file chosen", "No file chosen");
					}
				}
				
				public LazyLocalizedTranslation Lazy_No_file_chosen
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "No file chosen");
					}
				}
				
				public LazyLocalizedTranslation Lazy_No_file_chosen_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "No file chosen");
				}
				
				public LocalizedTranslation NoAssociatedCharacters(object addCharLink)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NoAssociatedCharacters", addCharLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoAssociatedCharacters", "You currently do not have any characters associated with your account. {addCharLink} to experience all of WowStead's features and interact with your guild.", addCharLink);
					}
				}
				
				public LocalizedTranslation NoAssociatedCharacters_ForLanguageID(int languageID, object addCharLink)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoAssociatedCharacters", addCharLink);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoAssociatedCharacters", "You currently do not have any characters associated with your account. {addCharLink} to experience all of WowStead's features and interact with your guild.", addCharLink);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoAssociatedCharacters(object addCharLink)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NoAssociatedCharacters", addCharLink);
				}
				
				public LazyLocalizedTranslation Lazy_NoAssociatedCharacters_ForLanguageID(int languageID, object addCharLink)
				{
					return this.CalculateLazyTranslation(languageID, "NoAssociatedCharacters", addCharLink);
				}
				
				public LocalizedTranslation NoCharacters
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoCharacters");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoCharacters", "No Characters");
						}
					}
				}
				
				public LocalizedTranslation NoCharacters_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoCharacters");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoCharacters", "No Characters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoCharacters
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoCharacters");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoCharacters_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoCharacters");
				}
				
				public LocalizedTranslation NoJobsMsg
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoJobsMsg");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoJobsMsg", "There are currently no open positions");
						}
					}
				}
				
				public LocalizedTranslation NoJobsMsg_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoJobsMsg");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoJobsMsg", "There are currently no open positions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoJobsMsg
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoJobsMsg");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoJobsMsg_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoJobsMsg");
				}
				
				public LocalizedTranslation None
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "None");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("None", "None");
						}
					}
				}
				
				public LocalizedTranslation None_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "None");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("None", "None");
					}
				}
				
				public LazyLocalizedTranslation Lazy_None
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "None");
					}
				}
				
				public LazyLocalizedTranslation Lazy_None_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "None");
				}
				
				public LocalizedTranslation NonexistentEntity(object id)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NonexistentEntity", id);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NonexistentEntity", "Nonexistent entity #{id}", id);
					}
				}
				
				public LocalizedTranslation NonexistentEntity_ForLanguageID(int languageID, object id)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NonexistentEntity", id);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NonexistentEntity", "Nonexistent entity #{id}", id);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NonexistentEntity(object id)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NonexistentEntity", id);
				}
				
				public LazyLocalizedTranslation Lazy_NonexistentEntity_ForLanguageID(int languageID, object id)
				{
					return this.CalculateLazyTranslation(languageID, "NonexistentEntity", id);
				}
				
				public LocalizedTranslation NoResultsFound
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NoResultsFound");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NoResultsFound", "No results were found.");
						}
					}
				}
				
				public LocalizedTranslation NoResultsFound_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoResultsFound");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoResultsFound", "No results were found.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoResultsFound
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NoResultsFound");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoResultsFound_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NoResultsFound");
				}
				
				public LocalizedTranslation NoResultsWereFound(object searchText)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NoResultsWereFound", searchText);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoResultsWereFound", "No results for \"{searchText}\" were found.", searchText);
					}
				}
				
				public LocalizedTranslation NoResultsWereFound_ForLanguageID(int languageID, object searchText)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NoResultsWereFound", searchText);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NoResultsWereFound", "No results for \"{searchText}\" were found.", searchText);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NoResultsWereFound(object searchText)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NoResultsWereFound", searchText);
				}
				
				public LazyLocalizedTranslation Lazy_NoResultsWereFound_ForLanguageID(int languageID, object searchText)
				{
					return this.CalculateLazyTranslation(languageID, "NoResultsWereFound", searchText);
				}
				
				public LocalizedTranslation Normal
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Normal");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Normal", "Normal");
						}
					}
				}
				
				public LocalizedTranslation Normal_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Normal");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Normal", "Normal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Normal
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Normal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Normal_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Normal");
				}
				
				public LocalizedTranslation NotEqualErrorMessage(object actual, object expected)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NotEqualErrorMessage", actual, expected);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotEqualErrorMessage", "{actual} must not be equal to {expected}", actual, expected);
					}
				}
				
				public LocalizedTranslation NotEqualErrorMessage_ForLanguageID(int languageID, object actual, object expected)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotEqualErrorMessage", actual, expected);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotEqualErrorMessage", "{actual} must not be equal to {expected}", actual, expected);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotEqualErrorMessage(object actual, object expected)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NotEqualErrorMessage", actual, expected);
				}
				
				public LazyLocalizedTranslation Lazy_NotEqualErrorMessage_ForLanguageID(int languageID, object actual, object expected)
				{
					return this.CalculateLazyTranslation(languageID, "NotEqualErrorMessage", actual, expected);
				}
				
				public LocalizedTranslation NotFound
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotFound");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotFound", "Not found");
						}
					}
				}
				
				public LocalizedTranslation NotFound_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotFound");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotFound", "Not found");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotFound
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotFound");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotFound_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotFound");
				}
				
				public LocalizedTranslation NotFoundUnableToFind
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotFoundUnableToFind");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotFoundUnableToFind", "We were unable to find the page or file you were looking for.");
						}
					}
				}
				
				public LocalizedTranslation NotFoundUnableToFind_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotFoundUnableToFind");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotFoundUnableToFind", "We were unable to find the page or file you were looking for.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotFoundUnableToFind
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotFoundUnableToFind");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotFoundUnableToFind_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotFoundUnableToFind");
				}
				
				public LocalizedTranslation NotImplemented
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotImplemented");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotImplemented", "Not Implemented");
						}
					}
				}
				
				public LocalizedTranslation NotImplemented_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotImplemented");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotImplemented", "Not Implemented");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotImplemented
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotImplemented");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotImplemented_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotImplemented");
				}
				
				public LocalizedTranslation NotImplementedMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "NotImplementedMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("NotImplementedMessage", "The server either does not recognise the request method, or it lacks the ability to fulfil the request.");
						}
					}
				}
				
				public LocalizedTranslation NotImplementedMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NotImplementedMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NotImplementedMessage", "The server either does not recognise the request method, or it lacks the ability to fulfil the request.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotImplementedMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "NotImplementedMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_NotImplementedMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "NotImplementedMessage");
				}
				
				public LocalizedTranslation Null
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Null");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Null", "Null");
						}
					}
				}
				
				public LocalizedTranslation Null_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Null");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Null", "Null");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Null
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Null");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Null_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Null");
				}
				
				public LocalizedTranslation NumberOfMembers(object memberCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NumberOfMembers", memberCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumberOfMembers", "{memberCount} Members", memberCount);
					}
				}
				
				public LocalizedTranslation NumberOfMembers_ForLanguageID(int languageID, object memberCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NumberOfMembers", memberCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumberOfMembers", "{memberCount} Members", memberCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NumberOfMembers(object memberCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NumberOfMembers", memberCount);
				}
				
				public LazyLocalizedTranslation Lazy_NumberOfMembers_ForLanguageID(int languageID, object memberCount)
				{
					return this.CalculateLazyTranslation(languageID, "NumberOfMembers", memberCount);
				}
				
				public LocalizedTranslation NumberOfPrivateMessagesAbbr(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NumberOfPrivateMessagesAbbr", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumberOfPrivateMessagesAbbr", "{num} PLURAL[{num};PM;PMs]", num);
					}
				}
				
				public LocalizedTranslation NumberOfPrivateMessagesAbbr_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NumberOfPrivateMessagesAbbr", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumberOfPrivateMessagesAbbr", "{num} PLURAL[{num};PM;PMs]", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NumberOfPrivateMessagesAbbr(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NumberOfPrivateMessagesAbbr", num);
				}
				
				public LazyLocalizedTranslation Lazy_NumberOfPrivateMessagesAbbr_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "NumberOfPrivateMessagesAbbr", num);
				}
				
				public LocalizedTranslation NumViews(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "NumViews", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumViews", "{num} PLURAL[{num};View;Views]", num);
					}
				}
				
				public LocalizedTranslation NumViews_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "NumViews", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("NumViews", "{num} PLURAL[{num};View;Views]", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_NumViews(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "NumViews", num);
				}
				
				public LazyLocalizedTranslation Lazy_NumViews_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "NumViews", num);
				}
				
				public LocalizedTranslation Of
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Of");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Of", "Of");
						}
					}
				}
				
				public LocalizedTranslation Of_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Of");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Of", "Of");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Of
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Of");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Of_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Of");
				}
				
				public LocalizedTranslation OfText(object text)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "OfText", text);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OfText", "of {text}", text);
					}
				}
				
				public LocalizedTranslation OfText_ForLanguageID(int languageID, object text)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OfText", text);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OfText", "of {text}", text);
					}
				}
				
				public LazyLocalizedTranslation Lazy_OfText(object text)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "OfText", text);
				}
				
				public LazyLocalizedTranslation Lazy_OfText_ForLanguageID(int languageID, object text)
				{
					return this.CalculateLazyTranslation(languageID, "OfText", text);
				}
				
				public LocalizedTranslation OK
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OK");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OK", "OK");
						}
					}
				}
				
				public LocalizedTranslation OK_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OK");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OK", "OK");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OK
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OK");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OK_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OK");
				}
				
				public LocalizedTranslation OnlyThoseWhoHaveCanManageGulidApplicationPermission
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OnlyThoseWhoHaveCanManageGulidApplicationPermission");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OnlyThoseWhoHaveCanManageGulidApplicationPermission", "Only those who have the Can Manage Guild Application permission can view applications that have been decided upon.");
						}
					}
				}
				
				public LocalizedTranslation OnlyThoseWhoHaveCanManageGulidApplicationPermission_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OnlyThoseWhoHaveCanManageGulidApplicationPermission");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OnlyThoseWhoHaveCanManageGulidApplicationPermission", "Only those who have the Can Manage Guild Application permission can view applications that have been decided upon.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OnlyThoseWhoHaveCanManageGulidApplicationPermission
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OnlyThoseWhoHaveCanManageGulidApplicationPermission");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OnlyThoseWhoHaveCanManageGulidApplicationPermission_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OnlyThoseWhoHaveCanManageGulidApplicationPermission");
				}
				
				public LocalizedTranslation OperatorBeginsWith
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorBeginsWith");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorBeginsWith", "Begins With");
						}
					}
				}
				
				public LocalizedTranslation OperatorBeginsWith_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorBeginsWith");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorBeginsWith", "Begins With");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorBeginsWith
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorBeginsWith");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorBeginsWith_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorBeginsWith");
				}
				
				public LocalizedTranslation OperatorContains
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorContains");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorContains", "Contains");
						}
					}
				}
				
				public LocalizedTranslation OperatorContains_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorContains");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorContains", "Contains");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorContains
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorContains");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorContains_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorContains");
				}
				
				public LocalizedTranslation OperatorEndsWith
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorEndsWith");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorEndsWith", "Ends With");
						}
					}
				}
				
				public LocalizedTranslation OperatorEndsWith_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorEndsWith");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorEndsWith", "Ends With");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorEndsWith
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorEndsWith");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorEndsWith_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorEndsWith");
				}
				
				public LocalizedTranslation OperatorEquals
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorEquals");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorEquals", "Equals");
						}
					}
				}
				
				public LocalizedTranslation OperatorEquals_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorEquals");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorEquals", "Equals");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorEquals
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorEquals");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorEquals_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorEquals");
				}
				
				public LocalizedTranslation OperatorGreaterThan
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorGreaterThan");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorGreaterThan", "Greater Than");
						}
					}
				}
				
				public LocalizedTranslation OperatorGreaterThan_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorGreaterThan");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorGreaterThan", "Greater Than");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorGreaterThan
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorGreaterThan");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorGreaterThan_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorGreaterThan");
				}
				
				public LocalizedTranslation OperatorLessThan
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OperatorLessThan");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OperatorLessThan", "Less Than");
						}
					}
				}
				
				public LocalizedTranslation OperatorLessThan_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OperatorLessThan");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OperatorLessThan", "Less Than");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorLessThan
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OperatorLessThan");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OperatorLessThan_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OperatorLessThan");
				}
				
				public LocalizedTranslation Optional
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Optional");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Optional", "optional");
						}
					}
				}
				
				public LocalizedTranslation Optional_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Optional");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Optional", "optional");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Optional
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Optional");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Optional_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Optional");
				}
				
				public LocalizedTranslation OptionalModules
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "OptionalModules");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("OptionalModules", "Optional Modules");
						}
					}
				}
				
				public LocalizedTranslation OptionalModules_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "OptionalModules");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("OptionalModules", "Optional Modules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OptionalModules
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "OptionalModules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_OptionalModules_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "OptionalModules");
				}
				
				public LocalizedTranslation Or
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Or");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Or", "Or");
						}
					}
				}
				
				public LocalizedTranslation Or_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Or");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Or", "Or");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Or
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Or");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Or_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Or");
				}
				
				public LocalizedTranslation Order
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Order");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Order", "Order");
						}
					}
				}
				
				public LocalizedTranslation Order_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Order");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Order", "Order");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Order
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Order");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Order_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Order");
				}
				
				public LocalizedTranslation Other
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Other");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Other", "Other");
						}
					}
				}
				
				public LocalizedTranslation Other_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Other");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Other", "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Other");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Other_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Other");
				}
				
				public LocalizedTranslation Overall
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Overall");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Overall", "Overall");
						}
					}
				}
				
				public LocalizedTranslation Overall_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Overall");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Overall", "Overall");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Overall
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Overall");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Overall_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Overall");
				}
				
				public LocalizedTranslation Overview
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Overview");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Overview", "Overview");
						}
					}
				}
				
				public LocalizedTranslation Overview_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Overview");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Overview", "Overview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Overview
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Overview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Overview_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Overview");
				}
				
				public LocalizedTranslation Page
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Page");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Page", "Page");
						}
					}
				}
				
				public LocalizedTranslation Page_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Page");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Page", "Page");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Page
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Page");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Page_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Page");
				}
				
				public LocalizedTranslation PageContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PageContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PageContent", "Page Content");
						}
					}
				}
				
				public LocalizedTranslation PageContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PageContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PageContent", "Page Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PageContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PageContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PageContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PageContent");
				}
				
				public LocalizedTranslation PageOf(object currentPage, object pageCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PageOf", currentPage, pageCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PageOf", "Page {currentPage} of {pageCount}", currentPage, pageCount);
					}
				}
				
				public LocalizedTranslation PageOf_ForLanguageID(int languageID, object currentPage, object pageCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PageOf", currentPage, pageCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PageOf", "Page {currentPage} of {pageCount}", currentPage, pageCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PageOf(object currentPage, object pageCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PageOf", currentPage, pageCount);
				}
				
				public LazyLocalizedTranslation Lazy_PageOf_ForLanguageID(int languageID, object currentPage, object pageCount)
				{
					return this.CalculateLazyTranslation(languageID, "PageOf", currentPage, pageCount);
				}
				
				public LocalizedTranslation PageXOfY(object current, object total)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PageXOfY", current, total);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PageXOfY", "Page {current} of {total}", current, total);
					}
				}
				
				public LocalizedTranslation PageXOfY_ForLanguageID(int languageID, object current, object total)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PageXOfY", current, total);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PageXOfY", "Page {current} of {total}", current, total);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PageXOfY(object current, object total)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PageXOfY", current, total);
				}
				
				public LazyLocalizedTranslation Lazy_PageXOfY_ForLanguageID(int languageID, object current, object total)
				{
					return this.CalculateLazyTranslation(languageID, "PageXOfY", current, total);
				}
				
				public LocalizedTranslation Password
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Password");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Password", "Password");
						}
					}
				}
				
				public LocalizedTranslation Password_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Password");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Password", "Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Password
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Password_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Password");
				}
				
				public LocalizedTranslation PasswordIncorrect
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PasswordIncorrect");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PasswordIncorrect", "The password provided was incorrect.");
						}
					}
				}
				
				public LocalizedTranslation PasswordIncorrect_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PasswordIncorrect");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PasswordIncorrect", "The password provided was incorrect.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PasswordIncorrect
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PasswordIncorrect");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PasswordIncorrect_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PasswordIncorrect");
				}
				
				public LocalizedTranslation PasswordsDoNotMatch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PasswordsDoNotMatch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PasswordsDoNotMatch", "The passwords do not match.");
						}
					}
				}
				
				public LocalizedTranslation PasswordsDoNotMatch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PasswordsDoNotMatch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PasswordsDoNotMatch", "The passwords do not match.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PasswordsDoNotMatch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PasswordsDoNotMatch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PasswordsDoNotMatch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PasswordsDoNotMatch");
				}
				
				public LocalizedTranslation Past30Days
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Past30Days");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Past30Days", "Past 30 Days");
						}
					}
				}
				
				public LocalizedTranslation Past30Days_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Past30Days");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Past30Days", "Past 30 Days");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Past30Days
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Past30Days");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Past30Days_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Past30Days");
				}
				
				public LocalizedTranslation PastWeek
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PastWeek");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PastWeek", "Past Week");
						}
					}
				}
				
				public LocalizedTranslation PastWeek_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PastWeek");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PastWeek", "Past Week");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PastWeek
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PastWeek");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PastWeek_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PastWeek");
				}
				
				public LocalizedTranslation Permalink
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Permalink");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Permalink", "Permalink");
						}
					}
				}
				
				public LocalizedTranslation Permalink_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Permalink");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Permalink", "Permalink");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permalink
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Permalink");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permalink_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Permalink");
				}
				
				public LocalizedTranslation Permission
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Permission");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Permission", "Permission");
						}
					}
				}
				
				public LocalizedTranslation Permission_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Permission");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Permission", "Permission");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permission
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Permission");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permission_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Permission");
				}
				
				public LocalizedTranslation Permissions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Permissions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Permissions", "Permissions");
						}
					}
				}
				
				public LocalizedTranslation Permissions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Permissions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Permissions", "Permissions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permissions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Permissions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Permissions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Permissions");
				}
				
				public LocalizedTranslation Personal
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Personal");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Personal", "Personal");
						}
					}
				}
				
				public LocalizedTranslation Personal_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Personal");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Personal", "Personal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Personal
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Personal");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Personal_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Personal");
				}
				
				public LocalizedTranslation Phrase
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Phrase");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Phrase", "Phrase");
						}
					}
				}
				
				public LocalizedTranslation Phrase_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Phrase");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Phrase", "Phrase");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Phrase
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Phrase");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Phrase_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Phrase");
				}
				
				public LocalizedTranslation Ping
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Ping");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Ping", "Ping");
						}
					}
				}
				
				public LocalizedTranslation Ping_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Ping");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Ping", "Ping");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Ping
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Ping");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Ping_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Ping");
				}
				
				public LocalizedTranslation PlainTextOnly
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PlainTextOnly");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PlainTextOnly", "Please use plain text only.");
						}
					}
				}
				
				public LocalizedTranslation PlainTextOnly_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PlainTextOnly");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PlainTextOnly", "Please use plain text only.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlainTextOnly
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PlainTextOnly");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlainTextOnly_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PlainTextOnly");
				}
				
				public LocalizedTranslation PlayNow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PlayNow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PlayNow", "Play Now");
						}
					}
				}
				
				public LocalizedTranslation PlayNow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PlayNow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PlayNow", "Play Now");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlayNow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PlayNow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PlayNow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PlayNow");
				}
				
				public LocalizedTranslation PleaseFillOutFormToAddCharacter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PleaseFillOutFormToAddCharacter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PleaseFillOutFormToAddCharacter", "Please fill out the form below to add a character to your account. You can add as many alternative characters to your account as you like. If you already have characters linked to your account, you can find them under 'My Characters'.");
						}
					}
				}
				
				public LocalizedTranslation PleaseFillOutFormToAddCharacter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PleaseFillOutFormToAddCharacter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PleaseFillOutFormToAddCharacter", "Please fill out the form below to add a character to your account. You can add as many alternative characters to your account as you like. If you already have characters linked to your account, you can find them under 'My Characters'.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseFillOutFormToAddCharacter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PleaseFillOutFormToAddCharacter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseFillOutFormToAddCharacter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PleaseFillOutFormToAddCharacter");
				}
				
				public LocalizedTranslation PleaseLogIn
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PleaseLogIn");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PleaseLogIn", "Please log in.");
						}
					}
				}
				
				public LocalizedTranslation PleaseLogIn_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PleaseLogIn");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PleaseLogIn", "Please log in.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseLogIn
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PleaseLogIn");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseLogIn_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PleaseLogIn");
				}
				
				public LocalizedTranslation PleaseTryAgain
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PleaseTryAgain");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PleaseTryAgain", "Please try again.");
						}
					}
				}
				
				public LocalizedTranslation PleaseTryAgain_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PleaseTryAgain");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PleaseTryAgain", "Please try again.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseTryAgain
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PleaseTryAgain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseTryAgain_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PleaseTryAgain");
				}
				
				public LocalizedTranslation PleaseWaitProcessing
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PleaseWaitProcessing");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PleaseWaitProcessing", "Please wait, processing ...");
						}
					}
				}
				
				public LocalizedTranslation PleaseWaitProcessing_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PleaseWaitProcessing");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PleaseWaitProcessing", "Please wait, processing ...");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseWaitProcessing
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PleaseWaitProcessing");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PleaseWaitProcessing_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PleaseWaitProcessing");
				}
				
				public LocalizedTranslation PmDirections
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PmDirections");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PmDirections", "To send a PM to a character, use the format wow/Charactername@Realm@Region - ex. wow/Tempestra@Lightbringer@us");
						}
					}
				}
				
				public LocalizedTranslation PmDirections_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PmDirections");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PmDirections", "To send a PM to a character, use the format wow/Charactername@Realm@Region - ex. wow/Tempestra@Lightbringer@us");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PmDirections
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PmDirections");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PmDirections_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PmDirections");
				}
				
				public LocalizedTranslation Points
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Points");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Points", "Points");
						}
					}
				}
				
				public LocalizedTranslation Points_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Points");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Points", "Points");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Points
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Points");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Points_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Points");
				}
				
				public LocalizedTranslation PortNumber
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PortNumber");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PortNumber", "Port Number");
						}
					}
				}
				
				public LocalizedTranslation PortNumber_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PortNumber");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PortNumber", "Port Number");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PortNumber
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PortNumber");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PortNumber_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PortNumber");
				}
				
				public LocalizedTranslation Post
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Post");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Post", "Posts");
						}
					}
				}
				
				public LocalizedTranslation Post_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Post");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Post", "Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Post
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Post");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Post_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Post");
				}
				
				public LocalizedTranslation PostAComment
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostAComment");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostAComment", "Post a comment");
						}
					}
				}
				
				public LocalizedTranslation PostAComment_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostAComment");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostAComment", "Post a comment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostAComment
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostAComment");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostAComment_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostAComment");
				}
				
				public LocalizedTranslation PostAsUser
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostAsUser");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostAsUser", "Post as User");
						}
					}
				}
				
				public LocalizedTranslation PostAsUser_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostAsUser");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostAsUser", "Post as User");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostAsUser
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostAsUser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostAsUser_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostAsUser");
				}
				
				public LocalizedTranslation PostedIn(object colonConnector, object location)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PostedIn", colonConnector, location);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedIn", "Posted in{colonConnector}{location}", colonConnector, location);
					}
				}
				
				public LocalizedTranslation PostedIn_ForLanguageID(int languageID, object colonConnector, object location)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostedIn", colonConnector, location);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedIn", "Posted in{colonConnector}{location}", colonConnector, location);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostedIn(object colonConnector, object location)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PostedIn", colonConnector, location);
				}
				
				public LazyLocalizedTranslation Lazy_PostedIn_ForLanguageID(int languageID, object colonConnector, object location)
				{
					return this.CalculateLazyTranslation(languageID, "PostedIn", colonConnector, location);
				}
				
				public LocalizedTranslation PostedOn(object colonConnector, object date)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PostedOn", colonConnector, date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedOn", "Posted{colonConnector}{date}", colonConnector, date);
					}
				}
				
				public LocalizedTranslation PostedOn_ForLanguageID(int languageID, object colonConnector, object date)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostedOn", colonConnector, date);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostedOn", "Posted{colonConnector}{date}", colonConnector, date);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostedOn(object colonConnector, object date)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PostedOn", colonConnector, date);
				}
				
				public LazyLocalizedTranslation Lazy_PostedOn_ForLanguageID(int languageID, object colonConnector, object date)
				{
					return this.CalculateLazyTranslation(languageID, "PostedOn", colonConnector, date);
				}
				
				public LocalizedTranslation PostingAsUser(object user)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "PostingAsUser", user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostingAsUser", "Posting as {user}", user);
					}
				}
				
				public LocalizedTranslation PostingAsUser_ForLanguageID(int languageID, object user)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostingAsUser", user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostingAsUser", "Posting as {user}", user);
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostingAsUser(object user)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "PostingAsUser", user);
				}
				
				public LazyLocalizedTranslation Lazy_PostingAsUser_ForLanguageID(int languageID, object user)
				{
					return this.CalculateLazyTranslation(languageID, "PostingAsUser", user);
				}
				
				public LocalizedTranslation PostingInstructions
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostingInstructions");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostingInstructions", "When posting, please be sure that the content of your post does not violate our <a href=\"https://www.amazon.com/gp/help/customer/display.html?nodeId=201929730\">Terms of Service</a>.");
						}
					}
				}
				
				public LocalizedTranslation PostingInstructions_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostingInstructions");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostingInstructions", "When posting, please be sure that the content of your post does not violate our <a href=\"https://www.amazon.com/gp/help/customer/display.html?nodeId=201929730\">Terms of Service</a>.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostingInstructions
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostingInstructions");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostingInstructions_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostingInstructions");
				}
				
				public LocalizedTranslation PostPreview
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PostPreview");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PostPreview", "Post Preview");
						}
					}
				}
				
				public LocalizedTranslation PostPreview_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PostPreview");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PostPreview", "Post Preview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostPreview
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PostPreview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PostPreview_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PostPreview");
				}
				
				public LocalizedTranslation Preferences
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Preferences");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Preferences", "Preferences");
						}
					}
				}
				
				public LocalizedTranslation Preferences_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Preferences");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Preferences", "Preferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preferences
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Preferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preferences_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Preferences");
				}
				
				public LocalizedTranslation PreferencesSet
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PreferencesSet");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PreferencesSet", "Preferences Set");
						}
					}
				}
				
				public LocalizedTranslation PreferencesSet_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PreferencesSet");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PreferencesSet", "Preferences Set");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PreferencesSet
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PreferencesSet");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PreferencesSet_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PreferencesSet");
				}
				
				public LocalizedTranslation Preload
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Preload");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Preload", "Preload");
						}
					}
				}
				
				public LocalizedTranslation Preload_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Preload");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Preload", "Preload");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preload
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Preload");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preload_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Preload");
				}
				
				public LocalizedTranslation PremiumNavBarUpsell
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PremiumNavBarUpsell");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PremiumNavBarUpsell", "Get an Epic Experience with Premium");
						}
					}
				}
				
				public LocalizedTranslation PremiumNavBarUpsell_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PremiumNavBarUpsell");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PremiumNavBarUpsell", "Get an Epic Experience with Premium");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumNavBarUpsell
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PremiumNavBarUpsell");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumNavBarUpsell_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PremiumNavBarUpsell");
				}
				
				public LocalizedTranslation PremiumSite
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PremiumSite");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PremiumSite", "Premium Site");
						}
					}
				}
				
				public LocalizedTranslation PremiumSite_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PremiumSite");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PremiumSite", "Premium Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumSite
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PremiumSite");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumSite_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PremiumSite");
				}
				
				public LocalizedTranslation PremiumThemes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PremiumThemes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PremiumThemes", "Premium Themes");
						}
					}
				}
				
				public LocalizedTranslation PremiumThemes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PremiumThemes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PremiumThemes", "Premium Themes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumThemes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PremiumThemes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PremiumThemes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PremiumThemes");
				}
				
				public LocalizedTranslation Preview
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Preview");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Preview", "Preview");
						}
					}
				}
				
				public LocalizedTranslation Preview_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Preview");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Preview", "Preview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preview
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Preview");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Preview_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Preview");
				}
				
				public LocalizedTranslation Previous
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Previous");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Previous", "Previous");
						}
					}
				}
				
				public LocalizedTranslation Previous_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Previous");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Previous", "Previous");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Previous
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Previous");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Previous_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Previous");
				}
				
				public LocalizedTranslation PrintOrderSummary
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PrintOrderSummary");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PrintOrderSummary", "Print Order Summary");
						}
					}
				}
				
				public LocalizedTranslation PrintOrderSummary_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PrintOrderSummary");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PrintOrderSummary", "Print Order Summary");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrintOrderSummary
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PrintOrderSummary");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrintOrderSummary_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PrintOrderSummary");
				}
				
				public LocalizedTranslation Priority
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Priority");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Priority", "Priority");
						}
					}
				}
				
				public LocalizedTranslation Priority_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Priority");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Priority", "Priority");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Priority
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Priority");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Priority_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Priority");
				}
				
				public LocalizedTranslation PriorityCustomerSupport
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PriorityCustomerSupport");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PriorityCustomerSupport", "Priority Customer Support");
						}
					}
				}
				
				public LocalizedTranslation PriorityCustomerSupport_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PriorityCustomerSupport");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PriorityCustomerSupport", "Priority Customer Support");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PriorityCustomerSupport
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PriorityCustomerSupport");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PriorityCustomerSupport_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PriorityCustomerSupport");
				}
				
				public LocalizedTranslation PriorityListingPitch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PriorityListingPitch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PriorityListingPitch", "Priority Listing on WowStead Guild Recruitment Tool");
						}
					}
				}
				
				public LocalizedTranslation PriorityListingPitch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PriorityListingPitch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PriorityListingPitch", "Priority Listing on WowStead Guild Recruitment Tool");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PriorityListingPitch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PriorityListingPitch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PriorityListingPitch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PriorityListingPitch");
				}
				
				public LocalizedTranslation Privacy_Policy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Privacy Policy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Privacy Policy", "Privacy Policy");
						}
					}
				}
				
				public LocalizedTranslation Privacy_Policy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Privacy Policy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Privacy Policy", "Privacy Policy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Privacy_Policy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Privacy Policy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Privacy_Policy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Privacy Policy");
				}
				
				public LocalizedTranslation PrivateMessagesAbbr
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PrivateMessagesAbbr");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PrivateMessagesAbbr", "PMs");
						}
					}
				}
				
				public LocalizedTranslation PrivateMessagesAbbr_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PrivateMessagesAbbr");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PrivateMessagesAbbr", "PMs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivateMessagesAbbr
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PrivateMessagesAbbr");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PrivateMessagesAbbr_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PrivateMessagesAbbr");
				}
				
				public LocalizedTranslation Progress
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Progress");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Progress", "Progress");
						}
					}
				}
				
				public LocalizedTranslation Progress_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Progress");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Progress", "Progress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Progress
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Progress");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Progress_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Progress");
				}
				
				public LocalizedTranslation Promotion
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Promotion");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Promotion", "Promotion");
						}
					}
				}
				
				public LocalizedTranslation Promotion_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Promotion");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Promotion", "Promotion");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Promotion
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Promotion");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Promotion_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Promotion");
				}
				
				public LocalizedTranslation PublicApplicationsCanBeViewed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PublicApplicationsCanBeViewed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PublicApplicationsCanBeViewed", "Public applications can be viewed by everyone but only commented on by those with permission.");
						}
					}
				}
				
				public LocalizedTranslation PublicApplicationsCanBeViewed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PublicApplicationsCanBeViewed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PublicApplicationsCanBeViewed", "Public applications can be viewed by everyone but only commented on by those with permission.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PublicApplicationsCanBeViewed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PublicApplicationsCanBeViewed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PublicApplicationsCanBeViewed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PublicApplicationsCanBeViewed");
				}
				
				public LocalizedTranslation Publish
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Publish");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Publish", "Publish");
						}
					}
				}
				
				public LocalizedTranslation Publish_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Publish");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Publish", "Publish");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Publish
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Publish");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Publish_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Publish");
				}
				
				public LocalizedTranslation Published
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Published");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Published", "Published");
						}
					}
				}
				
				public LocalizedTranslation Published_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Published");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Published", "Published");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Published
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Published");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Published_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Published");
				}
				
				public LocalizedTranslation PublishedBy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "PublishedBy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("PublishedBy", "Published By");
						}
					}
				}
				
				public LocalizedTranslation PublishedBy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "PublishedBy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("PublishedBy", "Published By");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PublishedBy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "PublishedBy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_PublishedBy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "PublishedBy");
				}
				
				public LocalizedTranslation QACreateDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "QACreateDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("QACreateDescription", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer rutrum volutpat massa, sit amet tempus nisl consequat eget. Morbi eu diam metus, id consequat purus. Curabitur eget urna ac nunc condimentum sagittis eu sit amet turpis. Donec ullamcorper lacinia imperdiet. Nulla sed risus a quam vehicula aliquet eget condimentum turpis. Phasellus ut enim in turpis pellentesque sodales. Maecenas non nisl at nulla fringilla interdum. Nam ultricies accumsan pretium. Nunc in viverra justo. Maecenas eu mauris ac mauris pharetra vulputate nec et velit. Nullam et mi nunc, at placerat nibh. Proin semper, erat a lacinia ullamcorper, lacus orci dapibus tellus, eu pharetra enim leo a odio. Nam euismod fermentum nisl nec sodales. Nam et tempus libero.\r\n\r\nInteger suscipit lacus sed metus sollicitudin sed pharetra elit rutrum. Aliquam tristique dapibus nulla et dapibus. Cras neque eros, aliquam quis varius nec, mollis id tortor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec sed risus lacus. Duis ullamcorper, justo a posuere mollis, urna tellus adipiscing mauris, ac porttitor metus urna ut eros. Quisque feugiat, diam at aliquam pulvinar, est metus vehicula quam, varius gravida lorem nunc eget mauris. Sed eget odio lorem. Fusce in nibh turpis. Sed nec urna nunc.");
						}
					}
				}
				
				public LocalizedTranslation QACreateDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "QACreateDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("QACreateDescription", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer rutrum volutpat massa, sit amet tempus nisl consequat eget. Morbi eu diam metus, id consequat purus. Curabitur eget urna ac nunc condimentum sagittis eu sit amet turpis. Donec ullamcorper lacinia imperdiet. Nulla sed risus a quam vehicula aliquet eget condimentum turpis. Phasellus ut enim in turpis pellentesque sodales. Maecenas non nisl at nulla fringilla interdum. Nam ultricies accumsan pretium. Nunc in viverra justo. Maecenas eu mauris ac mauris pharetra vulputate nec et velit. Nullam et mi nunc, at placerat nibh. Proin semper, erat a lacinia ullamcorper, lacus orci dapibus tellus, eu pharetra enim leo a odio. Nam euismod fermentum nisl nec sodales. Nam et tempus libero.\r\n\r\nInteger suscipit lacus sed metus sollicitudin sed pharetra elit rutrum. Aliquam tristique dapibus nulla et dapibus. Cras neque eros, aliquam quis varius nec, mollis id tortor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec sed risus lacus. Duis ullamcorper, justo a posuere mollis, urna tellus adipiscing mauris, ac porttitor metus urna ut eros. Quisque feugiat, diam at aliquam pulvinar, est metus vehicula quam, varius gravida lorem nunc eget mauris. Sed eget odio lorem. Fusce in nibh turpis. Sed nec urna nunc.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_QACreateDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "QACreateDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_QACreateDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "QACreateDescription");
				}
				
				public LocalizedTranslation Quantity
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Quantity");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Quantity", "Quantity");
						}
					}
				}
				
				public LocalizedTranslation Quantity_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Quantity");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Quantity", "Quantity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Quantity
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Quantity");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Quantity_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Quantity");
				}
				
				public LocalizedTranslation QuoteFrom(object quotee)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "QuoteFrom", quotee);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("QuoteFrom", "Quote from {quotee}", quotee);
					}
				}
				
				public LocalizedTranslation QuoteFrom_ForLanguageID(int languageID, object quotee)
				{
					try
					{
						return this.CalculateTranslation(languageID, "QuoteFrom", quotee);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("QuoteFrom", "Quote from {quotee}", quotee);
					}
				}
				
				public LazyLocalizedTranslation Lazy_QuoteFrom(object quotee)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "QuoteFrom", quotee);
				}
				
				public LazyLocalizedTranslation Lazy_QuoteFrom_ForLanguageID(int languageID, object quotee)
				{
					return this.CalculateLazyTranslation(languageID, "QuoteFrom", quotee);
				}
				
				public LocalizedTranslation RealmName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RealmName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RealmName", "Realm Name");
						}
					}
				}
				
				public LocalizedTranslation RealmName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RealmName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RealmName", "Realm Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RealmName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RealmName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RealmName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RealmName");
				}
				
				public LocalizedTranslation Reason
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Reason");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Reason", "Reason");
						}
					}
				}
				
				public LocalizedTranslation Reason_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Reason");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Reason", "Reason");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Reason
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Reason");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Reason_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Reason");
				}
				
				public LocalizedTranslation Recaptcha
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Recaptcha");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Recaptcha", "Recaptcha");
						}
					}
				}
				
				public LocalizedTranslation Recaptcha_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Recaptcha");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Recaptcha", "Recaptcha");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recaptcha
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Recaptcha");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recaptcha_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Recaptcha");
				}
				
				public LocalizedTranslation RecentPosts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RecentPosts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RecentPosts", "Recent Posts");
						}
					}
				}
				
				public LocalizedTranslation RecentPosts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RecentPosts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RecentPosts", "Recent Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RecentPosts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RecentPosts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RecentPosts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RecentPosts");
				}
				
				public LocalizedTranslation ReclaimPosts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ReclaimPosts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ReclaimPosts", "Reclaim Posts");
						}
					}
				}
				
				public LocalizedTranslation ReclaimPosts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ReclaimPosts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ReclaimPosts", "Reclaim Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReclaimPosts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ReclaimPosts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReclaimPosts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ReclaimPosts");
				}
				
				public LocalizedTranslation Recover_Password
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Recover Password");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Recover Password", "Recover Password");
						}
					}
				}
				
				public LocalizedTranslation Recover_Password_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Recover Password");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Recover Password", "Recover Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recover_Password
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Recover Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Recover_Password_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Recover Password");
				}
				
				public LocalizedTranslation RecoverPassword
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RecoverPassword");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RecoverPassword", "Recover Password");
						}
					}
				}
				
				public LocalizedTranslation RecoverPassword_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RecoverPassword");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RecoverPassword", "Recover Password");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RecoverPassword
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RecoverPassword");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RecoverPassword_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RecoverPassword");
				}
				
				public LocalizedTranslation RegardingSubject(object _0)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "RegardingSubject", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RegardingSubject", "Re: {0}", _0);
					}
				}
				
				public LocalizedTranslation RegardingSubject_ForLanguageID(int languageID, object _0)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RegardingSubject", _0);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RegardingSubject", "Re: {0}", _0);
					}
				}
				
				public LazyLocalizedTranslation Lazy_RegardingSubject(object _0)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "RegardingSubject", _0);
				}
				
				public LazyLocalizedTranslation Lazy_RegardingSubject_ForLanguageID(int languageID, object _0)
				{
					return this.CalculateLazyTranslation(languageID, "RegardingSubject", _0);
				}
				
				public LocalizedTranslation Register
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Register");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Register", "Register");
						}
					}
				}
				
				public LocalizedTranslation Register_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Register");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Register", "Register");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Register
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Register");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Register_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Register");
				}
				
				public LocalizedTranslation RegisteredOn(object dateRegistered)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "RegisteredOn", dateRegistered);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RegisteredOn", "registered {dateRegistered}", dateRegistered);
					}
				}
				
				public LocalizedTranslation RegisteredOn_ForLanguageID(int languageID, object dateRegistered)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RegisteredOn", dateRegistered);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RegisteredOn", "registered {dateRegistered}", dateRegistered);
					}
				}
				
				public LazyLocalizedTranslation Lazy_RegisteredOn(object dateRegistered)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "RegisteredOn", dateRegistered);
				}
				
				public LazyLocalizedTranslation Lazy_RegisteredOn_ForLanguageID(int languageID, object dateRegistered)
				{
					return this.CalculateLazyTranslation(languageID, "RegisteredOn", dateRegistered);
				}
				
				public LocalizedTranslation ReleaseDate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ReleaseDate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ReleaseDate", "Release Date");
						}
					}
				}
				
				public LocalizedTranslation ReleaseDate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ReleaseDate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ReleaseDate", "Release Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReleaseDate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ReleaseDate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ReleaseDate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ReleaseDate");
				}
				
				public LocalizedTranslation Remove
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Remove");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Remove", "Remove");
						}
					}
				}
				
				public LocalizedTranslation Remove_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Remove");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Remove", "Remove");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Remove
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Remove");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Remove_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Remove");
				}
				
				public LocalizedTranslation RemoveIPBan
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RemoveIPBan");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RemoveIPBan", "Remove IP Ban");
						}
					}
				}
				
				public LocalizedTranslation RemoveIPBan_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RemoveIPBan");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RemoveIPBan", "Remove IP Ban");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RemoveIPBan
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RemoveIPBan");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RemoveIPBan_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RemoveIPBan");
				}
				
				public LocalizedTranslation Reported
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Reported");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Reported", "Reported");
						}
					}
				}
				
				public LocalizedTranslation Reported_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Reported");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Reported", "Reported");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Reported
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Reported");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Reported_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Reported");
				}
				
				public LocalizedTranslation RequestTooLarge
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RequestTooLarge");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RequestTooLarge", "Request Too Large");
						}
					}
				}
				
				public LocalizedTranslation RequestTooLarge_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RequestTooLarge");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RequestTooLarge", "Request Too Large");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequestTooLarge
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RequestTooLarge");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequestTooLarge_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RequestTooLarge");
				}
				
				public LocalizedTranslation RequestTooLargeMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RequestTooLargeMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RequestTooLargeMessage", "Your request is too large, likely due to your upload. Please upload a smaller file, at most less than 5 Mb.");
						}
					}
				}
				
				public LocalizedTranslation RequestTooLargeMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RequestTooLargeMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RequestTooLargeMessage", "Your request is too large, likely due to your upload. Please upload a smaller file, at most less than 5 Mb.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequestTooLargeMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RequestTooLargeMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequestTooLargeMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RequestTooLargeMessage");
				}
				
				public LocalizedTranslation RequiredErrorMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RequiredErrorMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RequiredErrorMessage", "This field is required.");
						}
					}
				}
				
				public LocalizedTranslation RequiredErrorMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RequiredErrorMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RequiredErrorMessage", "This field is required.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequiredErrorMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RequiredErrorMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RequiredErrorMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RequiredErrorMessage");
				}
				
				public LocalizedTranslation RestoreContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RestoreContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RestoreContent", "Restore Content");
						}
					}
				}
				
				public LocalizedTranslation RestoreContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RestoreContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RestoreContent", "Restore Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RestoreContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RestoreContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RestoreContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RestoreContent");
				}
				
				public LocalizedTranslation Role
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Role");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Role", "Role");
						}
					}
				}
				
				public LocalizedTranslation Role_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Role");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Role", "Role");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Role
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Role");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Role_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Role");
				}
				
				public LocalizedTranslation RoleBasedSignup
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RoleBasedSignup");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RoleBasedSignup", "Role-based signup");
						}
					}
				}
				
				public LocalizedTranslation RoleBasedSignup_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RoleBasedSignup");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RoleBasedSignup", "Role-based signup");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RoleBasedSignup
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RoleBasedSignup");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RoleBasedSignup_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RoleBasedSignup");
				}
				
				public LocalizedTranslation RoleRequired
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "RoleRequired");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("RoleRequired", "Role(s) Required");
						}
					}
				}
				
				public LocalizedTranslation RoleRequired_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "RoleRequired");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("RoleRequired", "Role(s) Required");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RoleRequired
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "RoleRequired");
					}
				}
				
				public LazyLocalizedTranslation Lazy_RoleRequired_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "RoleRequired");
				}
				
				public LocalizedTranslation Rows
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Rows");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Rows", "Rows");
						}
					}
				}
				
				public LocalizedTranslation Rows_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Rows");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Rows", "Rows");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Rows
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Rows");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Rows_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Rows");
				}
				
				public LocalizedTranslation SavePreferences
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SavePreferences");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SavePreferences", "Save Preferences");
						}
					}
				}
				
				public LocalizedTranslation SavePreferences_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SavePreferences");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SavePreferences", "Save Preferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SavePreferences
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SavePreferences");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SavePreferences_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SavePreferences");
				}
				
				public LocalizedTranslation Seamless
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Seamless");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Seamless", "Seamless");
						}
					}
				}
				
				public LocalizedTranslation Seamless_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Seamless");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Seamless", "Seamless");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Seamless
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Seamless");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Seamless_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Seamless");
				}
				
				public LocalizedTranslation Search
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Search");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Search", "Search");
						}
					}
				}
				
				public LocalizedTranslation Search_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Search");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Search", "Search");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Search
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Search");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Search_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Search");
				}
				
				public LocalizedTranslation SearchBySiteDomain
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SearchBySiteDomain");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SearchBySiteDomain", "Search by Site Domain");
						}
					}
				}
				
				public LocalizedTranslation SearchBySiteDomain_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SearchBySiteDomain");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SearchBySiteDomain", "Search by Site Domain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SearchBySiteDomain
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SearchBySiteDomain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SearchBySiteDomain_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SearchBySiteDomain");
				}
				
				public LocalizedTranslation SearchByUserValue
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SearchByUserValue");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SearchByUserValue", "Search where user's");
						}
					}
				}
				
				public LocalizedTranslation SearchByUserValue_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SearchByUserValue");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SearchByUserValue", "Search where user's");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SearchByUserValue
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SearchByUserValue");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SearchByUserValue_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SearchByUserValue");
				}
				
				public LocalizedTranslation Search_test
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Search-test");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Search-test", "Search");
						}
					}
				}
				
				public LocalizedTranslation Search_test_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Search-test");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Search-test", "Search");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Search_test
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Search-test");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Search_test_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Search-test");
				}
				
				public LocalizedTranslation Security
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Security");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Security", "Security");
						}
					}
				}
				
				public LocalizedTranslation Security_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Security");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Security", "Security");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Security
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Security");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Security_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Security");
				}
				
				public LocalizedTranslation SeeMoreArticles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SeeMoreArticles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SeeMoreArticles", "See More Articles");
						}
					}
				}
				
				public LocalizedTranslation SeeMoreArticles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SeeMoreArticles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SeeMoreArticles", "See More Articles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeMoreArticles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SeeMoreArticles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeMoreArticles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SeeMoreArticles");
				}
				
				public LocalizedTranslation SeeMoreNews
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SeeMoreNews");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SeeMoreNews", "See More News");
						}
					}
				}
				
				public LocalizedTranslation SeeMoreNews_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SeeMoreNews");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SeeMoreNews", "See More News");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeMoreNews
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SeeMoreNews");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeMoreNews_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SeeMoreNews");
				}
				
				public LocalizedTranslation SeeUpcomingEvents
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SeeUpcomingEvents");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SeeUpcomingEvents", "See Upcoming Events");
						}
					}
				}
				
				public LocalizedTranslation SeeUpcomingEvents_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SeeUpcomingEvents");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SeeUpcomingEvents", "See Upcoming Events");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeUpcomingEvents
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SeeUpcomingEvents");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SeeUpcomingEvents_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SeeUpcomingEvents");
				}
				
				public LocalizedTranslation SelectADate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectADate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectADate", "Select a Date");
						}
					}
				}
				
				public LocalizedTranslation SelectADate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectADate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectADate", "Select a Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectADate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectADate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectADate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectADate");
				}
				
				public LocalizedTranslation SelectATime
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectATime");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectATime", "Select a Time");
						}
					}
				}
				
				public LocalizedTranslation SelectATime_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectATime");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectATime", "Select a Time");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectATime
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectATime");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectATime_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectATime");
				}
				
				public LocalizedTranslation SelectCharacter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectCharacter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectCharacter", "Select a Character");
						}
					}
				}
				
				public LocalizedTranslation SelectCharacter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectCharacter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectCharacter", "Select a Character");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectCharacter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectCharacter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectCharacter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectCharacter");
				}
				
				public LocalizedTranslation Selected
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Selected");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Selected", "Prizes are selected by hand, either by specifically picking them or randomly");
						}
					}
				}
				
				public LocalizedTranslation Selected_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Selected");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Selected", "Prizes are selected by hand, either by specifically picking them or randomly");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Selected
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Selected");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Selected_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Selected");
				}
				
				public LocalizedTranslation SelectModules
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SelectModules");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SelectModules", "Select Modules");
						}
					}
				}
				
				public LocalizedTranslation SelectModules_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SelectModules");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SelectModules", "Select Modules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectModules
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SelectModules");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SelectModules_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SelectModules");
				}
				
				public LocalizedTranslation Send
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Send");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Send", "Send Message");
						}
					}
				}
				
				public LocalizedTranslation Send_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Send");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Send", "Send Message");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Send
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Send");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Send_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Send");
				}
				
				public LocalizedTranslation SetRoles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SetRoles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SetRoles", "Set Roles");
						}
					}
				}
				
				public LocalizedTranslation SetRoles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SetRoles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SetRoles", "Set Roles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetRoles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SetRoles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetRoles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SetRoles");
				}
				
				public LocalizedTranslation Settings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Settings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Settings", "Settings");
						}
					}
				}
				
				public LocalizedTranslation Settings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Settings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Settings", "Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Settings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Settings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Settings");
				}
				
				public LocalizedTranslation SetupTakesMereMinutes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SetupTakesMereMinutes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SetupTakesMereMinutes", "Setup takes mere minutes!");
						}
					}
				}
				
				public LocalizedTranslation SetupTakesMereMinutes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SetupTakesMereMinutes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SetupTakesMereMinutes", "Setup takes mere minutes!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetupTakesMereMinutes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SetupTakesMereMinutes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetupTakesMereMinutes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SetupTakesMereMinutes");
				}
				
				public LocalizedTranslation SetVisibility
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SetVisibility");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SetVisibility", "Set Visibility");
						}
					}
				}
				
				public LocalizedTranslation SetVisibility_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SetVisibility");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SetVisibility", "Set Visibility");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetVisibility
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SetVisibility");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SetVisibility_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SetVisibility");
				}
				
				public LocalizedTranslation ShortDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ShortDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ShortDescription", "Short Description");
						}
					}
				}
				
				public LocalizedTranslation ShortDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ShortDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ShortDescription", "Short Description");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShortDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ShortDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ShortDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ShortDescription");
				}
				
				public LocalizedTranslation SignOut
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SignOut");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SignOut", "Sign Out");
						}
					}
				}
				
				public LocalizedTranslation SignOut_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SignOut");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SignOut", "Sign Out");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignOut
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SignOut");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignOut_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SignOut");
				}
				
				public LocalizedTranslation SignUpDetailed
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SignUpDetailed");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SignUpDetailed", "Sign up to create your free Guild Site!");
						}
					}
				}
				
				public LocalizedTranslation SignUpDetailed_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SignUpDetailed");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SignUpDetailed", "Sign up to create your free Guild Site!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignUpDetailed
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SignUpDetailed");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignUpDetailed_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SignUpDetailed");
				}
				
				public LocalizedTranslation SignupLink
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SignupLink");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SignupLink", "Signup Link");
						}
					}
				}
				
				public LocalizedTranslation SignupLink_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SignupLink");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SignupLink", "Signup Link");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignupLink
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SignupLink");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignupLink_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SignupLink");
				}
				
				public LocalizedTranslation SignUpNow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SignUpNow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SignUpNow", "Sign up now!");
						}
					}
				}
				
				public LocalizedTranslation SignUpNow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SignUpNow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SignUpNow", "Sign up now!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignUpNow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SignUpNow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SignUpNow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SignUpNow");
				}
				
				public LocalizedTranslation Simple
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Simple");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Simple", "Simple");
						}
					}
				}
				
				public LocalizedTranslation Simple_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Simple");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Simple", "Simple");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Simple
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Simple");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Simple_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Simple");
				}
				
				public LocalizedTranslation SimpleSearch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SimpleSearch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SimpleSearch", "Simple search");
						}
					}
				}
				
				public LocalizedTranslation SimpleSearch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SimpleSearch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SimpleSearch", "Simple search");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SimpleSearch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SimpleSearch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SimpleSearch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SimpleSearch");
				}
				
				public LocalizedTranslation Site
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Site");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Site", "Site");
						}
					}
				}
				
				public LocalizedTranslation Site_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Site");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Site", "Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Site
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Site");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Site_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Site");
				}
				
				public LocalizedTranslation SiteList
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SiteList");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SiteList", "Site List");
						}
					}
				}
				
				public LocalizedTranslation SiteList_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SiteList");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SiteList", "Site List");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteList
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SiteList");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteList_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SiteList");
				}
				
				public LocalizedTranslation SiteName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SiteName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SiteName", "Site Name");
						}
					}
				}
				
				public LocalizedTranslation SiteName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SiteName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SiteName", "Site Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SiteName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SiteName");
				}
				
				public LocalizedTranslation SiteSearch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SiteSearch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SiteSearch", "Search by Site Domain or Title");
						}
					}
				}
				
				public LocalizedTranslation SiteSearch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SiteSearch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SiteSearch", "Search by Site Domain or Title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSearch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SiteSearch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SiteSearch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SiteSearch");
				}
				
				public LocalizedTranslation Size
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Size");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Size", "Size");
						}
					}
				}
				
				public LocalizedTranslation Size_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Size");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Size", "Size");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Size
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Size");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Size_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Size");
				}
				
				public LocalizedTranslation Skin
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Skin");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Skin", "Skin");
						}
					}
				}
				
				public LocalizedTranslation Skin_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Skin");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Skin", "Skin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Skin
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Skin");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Skin_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Skin");
				}
				
				public LocalizedTranslation Slug
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Slug");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Slug", "Slug");
						}
					}
				}
				
				public LocalizedTranslation Slug_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Slug");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Slug", "Slug");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Slug
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Slug");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Slug_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Slug");
				}
				
				public LocalizedTranslation SmiteNoKey
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SmiteNoKey");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SmiteNoKey", "        <img class=\"background\" src=\"http://media-vox.cursecdn.com/attachments/0/589/dino_header.jpg\" />\r\n        <div class=\"keys\">\r\n            <div class=\"key-content\">\r\n                <h4>Play a Game with Curse Voice</h4>\r\n                <h3>And Get Rewards!</h3>\r\n                <h4 style=\"margin-bottom: 10px;\">You\u2019ve currently earned no rewards. :( </h4>\r\n                <p>Experience team communication like never before! Overlay, auto-matching, and easy session creation will take your game to the next level, making you unstoppable.</p>\r\n                <a href=\"https://account.hirezstudios.com/smitegame/?ok=1\" class=\"button\">Download SMITE</a>\r\n            </div>\r\n            <div class=\"wolf\"><img src=\"http://media-vox.cursecdn.com/attachments/0/439/wolfy.png\" /></div>\r\n        </div>");
						}
					}
				}
				
				public LocalizedTranslation SmiteNoKey_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SmiteNoKey");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SmiteNoKey", "        <img class=\"background\" src=\"http://media-vox.cursecdn.com/attachments/0/589/dino_header.jpg\" />\r\n        <div class=\"keys\">\r\n            <div class=\"key-content\">\r\n                <h4>Play a Game with Curse Voice</h4>\r\n                <h3>And Get Rewards!</h3>\r\n                <h4 style=\"margin-bottom: 10px;\">You\u2019ve currently earned no rewards. :( </h4>\r\n                <p>Experience team communication like never before! Overlay, auto-matching, and easy session creation will take your game to the next level, making you unstoppable.</p>\r\n                <a href=\"https://account.hirezstudios.com/smitegame/?ok=1\" class=\"button\">Download SMITE</a>\r\n            </div>\r\n            <div class=\"wolf\"><img src=\"http://media-vox.cursecdn.com/attachments/0/439/wolfy.png\" /></div>\r\n        </div>");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SmiteNoKey
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SmiteNoKey");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SmiteNoKey_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SmiteNoKey");
				}
				
				public LocalizedTranslation Social
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Social");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Social", "Social");
						}
					}
				}
				
				public LocalizedTranslation Social_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Social");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Social", "Social");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Social
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Social");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Social_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Social");
				}
				
				public LocalizedTranslation SocialPitch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SocialPitch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SocialPitch", "Stay connected with breakthrough communication and calendar tools.");
						}
					}
				}
				
				public LocalizedTranslation SocialPitch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SocialPitch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SocialPitch", "Stay connected with breakthrough communication and calendar tools.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SocialPitch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SocialPitch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SocialPitch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SocialPitch");
				}
				
				public LocalizedTranslation SortBy
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SortBy");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SortBy", "Sort by");
						}
					}
				}
				
				public LocalizedTranslation SortBy_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SortBy");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SortBy", "Sort by");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SortBy
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SortBy");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SortBy_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SortBy");
				}
				
				public LocalizedTranslation Source
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Source");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Source", "Source");
						}
					}
				}
				
				public LocalizedTranslation Source_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Source");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Source", "Source");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Source
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Source");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Source_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Source");
				}
				
				public LocalizedTranslation Space
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Space");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Space", "&nbsp;");
						}
					}
				}
				
				public LocalizedTranslation Space_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Space");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Space", "&nbsp;");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Space
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Space");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Space_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Space");
				}
				
				public LocalizedTranslation Spam
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Spam");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Spam", "Spam");
						}
					}
				}
				
				public LocalizedTranslation Spam_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Spam");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Spam", "Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Spam
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Spam");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Spam_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Spam");
				}
				
				public LocalizedTranslation SpamControl
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SpamControl");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SpamControl", "Spam Control");
						}
					}
				}
				
				public LocalizedTranslation SpamControl_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SpamControl");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SpamControl", "Spam Control");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SpamControl
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SpamControl");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SpamControl_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SpamControl");
				}
				
				public LocalizedTranslation SpecialAll
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SpecialAll");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SpecialAll", "\\u2014 All \\u2014");
						}
					}
				}
				
				public LocalizedTranslation SpecialAll_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SpecialAll");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SpecialAll", "\\u2014 All \\u2014");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SpecialAll
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SpecialAll");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SpecialAll_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SpecialAll");
				}
				
				public LocalizedTranslation StartDate
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "StartDate");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("StartDate", "Start Date");
						}
					}
				}
				
				public LocalizedTranslation StartDate_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "StartDate");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("StartDate", "Start Date");
					}
				}
				
				public LazyLocalizedTranslation Lazy_StartDate
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "StartDate");
					}
				}
				
				public LazyLocalizedTranslation Lazy_StartDate_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "StartDate");
				}
				
				public LocalizedTranslation StartDateWithTimezone(object timezoneName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "StartDateWithTimezone", timezoneName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("StartDateWithTimezone", "Start Date ({timezoneName})", timezoneName);
					}
				}
				
				public LocalizedTranslation StartDateWithTimezone_ForLanguageID(int languageID, object timezoneName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "StartDateWithTimezone", timezoneName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("StartDateWithTimezone", "Start Date ({timezoneName})", timezoneName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_StartDateWithTimezone(object timezoneName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "StartDateWithTimezone", timezoneName);
				}
				
				public LazyLocalizedTranslation Lazy_StartDateWithTimezone_ForLanguageID(int languageID, object timezoneName)
				{
					return this.CalculateLazyTranslation(languageID, "StartDateWithTimezone", timezoneName);
				}
				
				public LocalizedTranslation Started
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Started");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Started", "Started");
						}
					}
				}
				
				public LocalizedTranslation Started_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Started");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Started", "Started");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Started
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Started");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Started_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Started");
				}
				
				public LocalizedTranslation Starts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Starts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Starts", "Starts");
						}
					}
				}
				
				public LocalizedTranslation Starts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Starts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Starts", "Starts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Starts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Starts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Starts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Starts");
				}
				
				public LocalizedTranslation State
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "State");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("State", "State");
						}
					}
				}
				
				public LocalizedTranslation State_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "State");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("State", "State");
					}
				}
				
				public LazyLocalizedTranslation Lazy_State
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "State");
					}
				}
				
				public LazyLocalizedTranslation Lazy_State_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "State");
				}
				
				public LocalizedTranslation Statistics
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Statistics");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Statistics", "Statistics");
						}
					}
				}
				
				public LocalizedTranslation Statistics_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Statistics");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Statistics", "Statistics");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Statistics
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Statistics");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Statistics_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Statistics");
				}
				
				public LocalizedTranslation Status
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Status");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Status", "Status");
						}
					}
				}
				
				public LocalizedTranslation Status_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Status");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Status", "Status");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Status
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Status");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Status_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Status");
				}
				
				public LocalizedTranslation Step(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "Step", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Step", "Step {num}", num);
					}
				}
				
				public LocalizedTranslation Step_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Step", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Step", "Step {num}", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_Step(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "Step", num);
				}
				
				public LazyLocalizedTranslation Lazy_Step_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "Step", num);
				}
				
				public LocalizedTranslation StepOf(object current, object total)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "StepOf", current, total);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("StepOf", "Step {current} of {total}", current, total);
					}
				}
				
				public LocalizedTranslation StepOf_ForLanguageID(int languageID, object current, object total)
				{
					try
					{
						return this.CalculateTranslation(languageID, "StepOf", current, total);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("StepOf", "Step {current} of {total}", current, total);
					}
				}
				
				public LazyLocalizedTranslation Lazy_StepOf(object current, object total)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "StepOf", current, total);
				}
				
				public LazyLocalizedTranslation Lazy_StepOf_ForLanguageID(int languageID, object current, object total)
				{
					return this.CalculateLazyTranslation(languageID, "StepOf", current, total);
				}
				
				public LocalizedTranslation Subdomain
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Subdomain");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Subdomain", "Subdomain");
						}
					}
				}
				
				public LocalizedTranslation Subdomain_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Subdomain");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Subdomain", "Subdomain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Subdomain
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Subdomain");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Subdomain_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Subdomain");
				}
				
				public LocalizedTranslation Subject
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Subject");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Subject", "Subject");
						}
					}
				}
				
				public LocalizedTranslation Subject_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Subject");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Subject", "Subject");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Subject
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Subject");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Subject_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Subject");
				}
				
				public LocalizedTranslation Submit
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Submit");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Submit", "Submit");
						}
					}
				}
				
				public LocalizedTranslation Submit_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Submit");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Submit", "Submit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Submit
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Submit");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Submit_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Submit");
				}
				
				public LocalizedTranslation SubmitChanges
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SubmitChanges");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SubmitChanges", "Submit Changes");
						}
					}
				}
				
				public LocalizedTranslation SubmitChanges_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SubmitChanges");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SubmitChanges", "Submit Changes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubmitChanges
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SubmitChanges");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SubmitChanges_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SubmitChanges");
				}
				
				public LocalizedTranslation Summary
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Summary");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Summary", "Summary");
						}
					}
				}
				
				public LocalizedTranslation Summary_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Summary");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Summary", "Summary");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Summary
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Summary");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Summary_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Summary");
				}
				
				public LocalizedTranslation Support
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Support");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Support", "Support");
						}
					}
				}
				
				public LocalizedTranslation Support_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Support");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Support", "Support");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Support
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Support");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Support_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Support");
				}
				
				public LocalizedTranslation SyncPitch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SyncPitch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SyncPitch", "Unprecedented synchronization with in-game data and essential industry websites.");
						}
					}
				}
				
				public LocalizedTranslation SyncPitch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SyncPitch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SyncPitch", "Unprecedented synchronization with in-game data and essential industry websites.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SyncPitch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SyncPitch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SyncPitch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SyncPitch");
				}
				
				public LocalizedTranslation System
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "System");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("System", "System");
						}
					}
				}
				
				public LocalizedTranslation System_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "System");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("System", "System");
					}
				}
				
				public LazyLocalizedTranslation Lazy_System
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "System");
					}
				}
				
				public LazyLocalizedTranslation Lazy_System_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "System");
				}
				
				public LocalizedTranslation SystemSettings
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "SystemSettings");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("SystemSettings", "System Settings");
						}
					}
				}
				
				public LocalizedTranslation SystemSettings_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "SystemSettings");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("SystemSettings", "System Settings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SystemSettings
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "SystemSettings");
					}
				}
				
				public LazyLocalizedTranslation Lazy_SystemSettings_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "SystemSettings");
				}
				
				public LocalizedTranslation TagLine
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TagLine");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TagLine", "Tagline");
						}
					}
				}
				
				public LocalizedTranslation TagLine_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TagLine");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TagLine", "Tagline");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagLine
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TagLine");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagLine_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TagLine");
				}
				
				public LocalizedTranslation TagName
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TagName");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TagName", "Tag Name");
						}
					}
				}
				
				public LocalizedTranslation TagName_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TagName");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TagName", "Tag Name");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagName
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TagName");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagName_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TagName");
				}
				
				public LocalizedTranslation Tags
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tags");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tags", "Tags");
						}
					}
				}
				
				public LocalizedTranslation Tags_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tags");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tags", "Tags");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tags
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tags");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tags_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tags");
				}
				
				public LocalizedTranslation TagsDescription
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TagsDescription");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TagsDescription", "After typing a tag name, press enter to add it to the tag list.");
						}
					}
				}
				
				public LocalizedTranslation TagsDescription_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TagsDescription");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TagsDescription", "After typing a tag name, press enter to add it to the tag list.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagsDescription
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TagsDescription");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TagsDescription_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TagsDescription");
				}
				
				public LocalizedTranslation TakeASurvey
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TakeASurvey");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TakeASurvey", "Take a Survey");
						}
					}
				}
				
				public LocalizedTranslation TakeASurvey_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TakeASurvey");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TakeASurvey", "Take a Survey");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TakeASurvey
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TakeASurvey");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TakeASurvey_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TakeASurvey");
				}
				
				public LocalizedTranslation Template
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Template");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Template", "Template");
						}
					}
				}
				
				public LocalizedTranslation Template_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Template");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Template", "Template");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Template
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Template");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Template_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Template");
				}
				
				public LocalizedTranslation Terms_of_Use
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Terms of Use");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Terms of Use", "Terms of Use");
						}
					}
				}
				
				public LocalizedTranslation Terms_of_Use_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Terms of Use");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Terms of Use", "Terms of Use");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Terms_of_Use
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Terms of Use");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Terms_of_Use_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Terms of Use");
				}
				
				public LocalizedTranslation Test
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Test");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Test", "This is a new test!");
						}
					}
				}
				
				public LocalizedTranslation Test_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Test");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Test", "This is a new test!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Test
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Test");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Test_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Test");
				}
				
				public LocalizedTranslation TestStuff(object num)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TestStuff", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TestStuff", "This is just a test. {num} PLURAL[{num};bird;birds].", num);
					}
				}
				
				public LocalizedTranslation TestStuff_ForLanguageID(int languageID, object num)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TestStuff", num);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TestStuff", "This is just a test. {num} PLURAL[{num};bird;birds].", num);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TestStuff(object num)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TestStuff", num);
				}
				
				public LazyLocalizedTranslation Lazy_TestStuff_ForLanguageID(int languageID, object num)
				{
					return this.CalculateLazyTranslation(languageID, "TestStuff", num);
				}
				
				public LocalizedTranslation Text
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Text");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Text", "Text");
						}
					}
				}
				
				public LocalizedTranslation Text_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Text");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Text", "Text");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Text
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Text");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Text_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Text");
				}
				
				public LocalizedTranslation Thumbnail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Thumbnail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Thumbnail", "Thumbnail");
						}
					}
				}
				
				public LocalizedTranslation Thumbnail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Thumbnail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Thumbnail", "Thumbnail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Thumbnail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Thumbnail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Thumbnail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Thumbnail");
				}
				
				public LocalizedTranslation Time
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Time");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Time", "Time");
						}
					}
				}
				
				public LocalizedTranslation Time_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Time");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Time", "Time");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Time
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Time");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Time_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Time");
				}
				
				public LocalizedTranslation Timezone
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Timezone");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Timezone", "Timezone");
						}
					}
				}
				
				public LocalizedTranslation Timezone_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Timezone");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Timezone", "Timezone");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Timezone
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Timezone");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Timezone_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Timezone");
				}
				
				public LocalizedTranslation TimezoneError
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TimezoneError");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TimezoneError", "Timezone error");
						}
					}
				}
				
				public LocalizedTranslation TimezoneError_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TimezoneError");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TimezoneError", "Timezone error");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TimezoneError
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TimezoneError");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TimezoneError_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TimezoneError");
				}
				
				public LocalizedTranslation Title
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Title");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Title", "Title");
						}
					}
				}
				
				public LocalizedTranslation Title_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Title");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Title", "Title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Title
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Title");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Title_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Title");
				}
				
				public LocalizedTranslation To
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "To");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("To", "To");
						}
					}
				}
				
				public LocalizedTranslation To_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "To");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("To", "To");
					}
				}
				
				public LazyLocalizedTranslation Lazy_To
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "To");
					}
				}
				
				public LazyLocalizedTranslation Lazy_To_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "To");
				}
				
				public LocalizedTranslation ToChangeCharacter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ToChangeCharacter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ToChangeCharacter", "To change your active character, click on the star hovering above your alternate character.");
						}
					}
				}
				
				public LocalizedTranslation ToChangeCharacter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ToChangeCharacter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ToChangeCharacter", "To change your active character, click on the star hovering above your alternate character.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ToChangeCharacter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ToChangeCharacter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ToChangeCharacter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ToChangeCharacter");
				}
				
				public LocalizedTranslation Tools
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tools");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tools", "Tools");
						}
					}
				}
				
				public LocalizedTranslation Tools_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tools");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tools", "Tools");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tools
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tools");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tools_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tools");
				}
				
				public LocalizedTranslation Tooltip
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Tooltip");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Tooltip", "Tooltip");
						}
					}
				}
				
				public LocalizedTranslation Tooltip_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Tooltip");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Tooltip", "Tooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tooltip
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Tooltip");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Tooltip_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Tooltip");
				}
				
				public LocalizedTranslation TotalPosts
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "TotalPosts");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("TotalPosts", "Total Posts");
						}
					}
				}
				
				public LocalizedTranslation TotalPosts_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TotalPosts");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalPosts", "Total Posts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TotalPosts
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "TotalPosts");
					}
				}
				
				public LazyLocalizedTranslation Lazy_TotalPosts_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "TotalPosts");
				}
				
				public LocalizedTranslation TotalPostsBreakdownTemplate(object commentCount, object forumPostCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TotalPostsBreakdownTemplate", commentCount, forumPostCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalPostsBreakdownTemplate", "({commentCount} PLURAL[{commentCount};comment;comments], {forumPostCount} forum PLURAL[{forumPostCount};post;posts])", commentCount, forumPostCount);
					}
				}
				
				public LocalizedTranslation TotalPostsBreakdownTemplate_ForLanguageID(int languageID, object commentCount, object forumPostCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TotalPostsBreakdownTemplate", commentCount, forumPostCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalPostsBreakdownTemplate", "({commentCount} PLURAL[{commentCount};comment;comments], {forumPostCount} forum PLURAL[{forumPostCount};post;posts])", commentCount, forumPostCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TotalPostsBreakdownTemplate(object commentCount, object forumPostCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TotalPostsBreakdownTemplate", commentCount, forumPostCount);
				}
				
				public LazyLocalizedTranslation Lazy_TotalPostsBreakdownTemplate_ForLanguageID(int languageID, object commentCount, object forumPostCount)
				{
					return this.CalculateLazyTranslation(languageID, "TotalPostsBreakdownTemplate", commentCount, forumPostCount);
				}
				
				public LocalizedTranslation TotalPostsTemplate(object postCount)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TotalPostsTemplate", postCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalPostsTemplate", "{postCount} Total Posts", postCount);
					}
				}
				
				public LocalizedTranslation TotalPostsTemplate_ForLanguageID(int languageID, object postCount)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TotalPostsTemplate", postCount);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalPostsTemplate", "{postCount} Total Posts", postCount);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TotalPostsTemplate(object postCount)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TotalPostsTemplate", postCount);
				}
				
				public LazyLocalizedTranslation Lazy_TotalPostsTemplate_ForLanguageID(int languageID, object postCount)
				{
					return this.CalculateLazyTranslation(languageID, "TotalPostsTemplate", postCount);
				}
				
				public LocalizedTranslation TotalThanksTemplate(object count)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "TotalThanksTemplate", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalThanksTemplate", "{count} PLURAL[{count};Thank;Thanks]", count);
					}
				}
				
				public LocalizedTranslation TotalThanksTemplate_ForLanguageID(int languageID, object count)
				{
					try
					{
						return this.CalculateTranslation(languageID, "TotalThanksTemplate", count);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("TotalThanksTemplate", "{count} PLURAL[{count};Thank;Thanks]", count);
					}
				}
				
				public LazyLocalizedTranslation Lazy_TotalThanksTemplate(object count)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "TotalThanksTemplate", count);
				}
				
				public LazyLocalizedTranslation Lazy_TotalThanksTemplate_ForLanguageID(int languageID, object count)
				{
					return this.CalculateLazyTranslation(languageID, "TotalThanksTemplate", count);
				}
				
				public LocalizedTranslation True
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "True");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("True", "True");
						}
					}
				}
				
				public LocalizedTranslation True_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "True");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("True", "True");
					}
				}
				
				public LazyLocalizedTranslation Lazy_True
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "True");
					}
				}
				
				public LazyLocalizedTranslation Lazy_True_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "True");
				}
				
				public LocalizedTranslation Type
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Type");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Type", "Type");
						}
					}
				}
				
				public LocalizedTranslation Type_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Type");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Type", "Type");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Type
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Type");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Type_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Type");
				}
				
				public LocalizedTranslation Undeleted
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Undeleted");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Undeleted", "Undeleted");
						}
					}
				}
				
				public LocalizedTranslation Undeleted_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Undeleted");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Undeleted", "Undeleted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undeleted
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Undeleted");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Undeleted_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Undeleted");
				}
				
				public LocalizedTranslation UndeleteQuestion
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UndeleteQuestion");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UndeleteQuestion", "Are you sure you want to undelete?");
						}
					}
				}
				
				public LocalizedTranslation UndeleteQuestion_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UndeleteQuestion");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UndeleteQuestion", "Are you sure you want to undelete?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UndeleteQuestion
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UndeleteQuestion");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UndeleteQuestion_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UndeleteQuestion");
				}
				
				public LocalizedTranslation Unfollow
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unfollow");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unfollow", "Unfollow");
						}
					}
				}
				
				public LocalizedTranslation Unfollow_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unfollow");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unfollow", "Unfollow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unfollow
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unfollow");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unfollow_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unfollow");
				}
				
				public LocalizedTranslation Unknown
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unknown");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unknown", "Unknown");
						}
					}
				}
				
				public LocalizedTranslation Unknown_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unknown");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unknown", "Unknown");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unknown
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unknown");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unknown_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unknown");
				}
				
				public LocalizedTranslation UnknownAuthor
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UnknownAuthor");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UnknownAuthor", "Unknown Author");
						}
					}
				}
				
				public LocalizedTranslation UnknownAuthor_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownAuthor");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownAuthor", "Unknown Author");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownAuthor
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownAuthor");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownAuthor_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownAuthor");
				}
				
				public LocalizedTranslation UnknownEnum(object value)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UnknownEnum", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownEnum", "Unknown enum value: {value}", value);
					}
				}
				
				public LocalizedTranslation UnknownEnum_ForLanguageID(int languageID, object value)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownEnum", value);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownEnum", "Unknown enum value: {value}", value);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownEnum(object value)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownEnum", value);
				}
				
				public LazyLocalizedTranslation Lazy_UnknownEnum_ForLanguageID(int languageID, object value)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownEnum", value);
				}
				
				public LocalizedTranslation UnknownUser
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UnknownUser");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UnknownUser", "Unknown User");
						}
					}
				}
				
				public LocalizedTranslation UnknownUser_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownUser");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownUser", "Unknown User");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUser
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownUser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUser_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownUser");
				}
				
				public LocalizedTranslation UnknownUsers(object numUsers, object users)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UnknownUsers", numUsers, users);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownUsers", "Unknown PLURAL[{numUsers};User;Users]: {users}", numUsers, users);
					}
				}
				
				public LocalizedTranslation UnknownUsers_ForLanguageID(int languageID, object numUsers, object users)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UnknownUsers", numUsers, users);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UnknownUsers", "Unknown PLURAL[{numUsers};User;Users]: {users}", numUsers, users);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUsers(object numUsers, object users)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UnknownUsers", numUsers, users);
				}
				
				public LazyLocalizedTranslation Lazy_UnknownUsers_ForLanguageID(int languageID, object numUsers, object users)
				{
					return this.CalculateLazyTranslation(languageID, "UnknownUsers", numUsers, users);
				}
				
				public LocalizedTranslation Unsubscribe
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Unsubscribe");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Unsubscribe", "Unsubscribe");
						}
					}
				}
				
				public LocalizedTranslation Unsubscribe_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Unsubscribe");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Unsubscribe", "Unsubscribe");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unsubscribe
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Unsubscribe");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Unsubscribe_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Unsubscribe");
				}
				
				public LocalizedTranslation Update
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Update");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Update", "Update");
						}
					}
				}
				
				public LocalizedTranslation Update_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Update");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Update", "Update");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Update
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Update");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Update_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Update");
				}
				
				public LocalizedTranslation Updated
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Updated");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Updated", "Updated");
						}
					}
				}
				
				public LocalizedTranslation Updated_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Updated");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Updated", "Updated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Updated
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Updated");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Updated_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Updated");
				}
				
				public LocalizedTranslation UpdatingCharacterDash
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UpdatingCharacterDash");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UpdatingCharacterDash", "Updating Character - ");
						}
					}
				}
				
				public LocalizedTranslation UpdatingCharacterDash_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UpdatingCharacterDash");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UpdatingCharacterDash", "Updating Character - ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UpdatingCharacterDash
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UpdatingCharacterDash");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UpdatingCharacterDash_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UpdatingCharacterDash");
				}
				
				public LocalizedTranslation UploadAnyAmountOfImagesIntoTheAvatarPoolCollection
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UploadAnyAmountOfImagesIntoTheAvatarPoolCollection");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UploadAnyAmountOfImagesIntoTheAvatarPoolCollection", "Upload any amount of images into the avatar pool collection.\r\nNote: You are not allowed to use the Amazon Mark");
						}
					}
				}
				
				public LocalizedTranslation UploadAnyAmountOfImagesIntoTheAvatarPoolCollection_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UploadAnyAmountOfImagesIntoTheAvatarPoolCollection");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UploadAnyAmountOfImagesIntoTheAvatarPoolCollection", "Upload any amount of images into the avatar pool collection.\r\nNote: You are not allowed to use the Amazon Mark");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UploadAnyAmountOfImagesIntoTheAvatarPoolCollection
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UploadAnyAmountOfImagesIntoTheAvatarPoolCollection");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UploadAnyAmountOfImagesIntoTheAvatarPoolCollection_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UploadAnyAmountOfImagesIntoTheAvatarPoolCollection");
				}
				
				public LocalizedTranslation Uploaded
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Uploaded");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Uploaded", "Uploaded");
						}
					}
				}
				
				public LocalizedTranslation Uploaded_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Uploaded");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Uploaded", "Uploaded");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Uploaded
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Uploaded");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Uploaded_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Uploaded");
				}
				
				public LocalizedTranslation UploadOrSelectANewAvatar
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UploadOrSelectANewAvatar");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UploadOrSelectANewAvatar", "Upload or Select a New Avatar");
						}
					}
				}
				
				public LocalizedTranslation UploadOrSelectANewAvatar_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UploadOrSelectANewAvatar");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UploadOrSelectANewAvatar", "Upload or Select a New Avatar");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UploadOrSelectANewAvatar
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UploadOrSelectANewAvatar");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UploadOrSelectANewAvatar_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UploadOrSelectANewAvatar");
				}
				
				public LocalizedTranslation Url
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Url");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Url", "Url");
						}
					}
				}
				
				public LocalizedTranslation Url_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Url");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Url", "Url");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Url
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Url");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Url_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Url");
				}
				
				public LocalizedTranslation User
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "User");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("User", "User");
						}
					}
				}
				
				public LocalizedTranslation User_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "User");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("User", "User");
					}
				}
				
				public LazyLocalizedTranslation Lazy_User
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "User");
					}
				}
				
				public LazyLocalizedTranslation Lazy_User_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "User");
				}
				
				public LocalizedTranslation UserAlreadyMarked
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserAlreadyMarked");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserAlreadyMarked", "User is already marked under that role");
						}
					}
				}
				
				public LocalizedTranslation UserAlreadyMarked_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserAlreadyMarked");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAlreadyMarked", "User is already marked under that role");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserAlreadyMarked
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserAlreadyMarked");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserAlreadyMarked_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserAlreadyMarked");
				}
				
				public LocalizedTranslation UserAsCharacter(object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UserAsCharacter", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAsCharacter", "{username} as ", username);
					}
				}
				
				public LocalizedTranslation UserAsCharacter_ForLanguageID(int languageID, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserAsCharacter", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAsCharacter", "{username} as ", username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserAsCharacter(object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UserAsCharacter", username);
				}
				
				public LazyLocalizedTranslation Lazy_UserAsCharacter_ForLanguageID(int languageID, object username)
				{
					return this.CalculateLazyTranslation(languageID, "UserAsCharacter", username);
				}
				
				public LocalizedTranslation UserAsSurrogate(object surrogate, object user)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UserAsSurrogate", surrogate, user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAsSurrogate", "{user} as {surrogate}", surrogate, user);
					}
				}
				
				public LocalizedTranslation UserAsSurrogate_ForLanguageID(int languageID, object surrogate, object user)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserAsSurrogate", surrogate, user);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAsSurrogate", "{user} as {surrogate}", surrogate, user);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserAsSurrogate(object surrogate, object user)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UserAsSurrogate", surrogate, user);
				}
				
				public LazyLocalizedTranslation Lazy_UserAsSurrogate_ForLanguageID(int languageID, object surrogate, object user)
				{
					return this.CalculateLazyTranslation(languageID, "UserAsSurrogate", surrogate, user);
				}
				
				public LocalizedTranslation UserAvatar(object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UserAvatar", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAvatar", "{username}'s avatar", username);
					}
				}
				
				public LocalizedTranslation UserAvatar_ForLanguageID(int languageID, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserAvatar", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserAvatar", "{username}'s avatar", username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserAvatar(object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UserAvatar", username);
				}
				
				public LazyLocalizedTranslation Lazy_UserAvatar_ForLanguageID(int languageID, object username)
				{
					return this.CalculateLazyTranslation(languageID, "UserAvatar", username);
				}
				
				public LocalizedTranslation UserIPs
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserIPs");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserIPs", "IP Addresses");
						}
					}
				}
				
				public LocalizedTranslation UserIPs_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserIPs");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserIPs", "IP Addresses");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIPs
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserIPs");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIPs_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserIPs");
				}
				
				public LocalizedTranslation UserIsBanned
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserIsBanned");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserIsBanned", "You have been banned.");
						}
					}
				}
				
				public LocalizedTranslation UserIsBanned_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserIsBanned");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserIsBanned", "You have been banned.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIsBanned
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserIsBanned");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIsBanned_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserIsBanned");
				}
				
				public LocalizedTranslation UserIsBannedExplanation
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserIsBannedExplanation");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserIsBannedExplanation", "Either your account, or your IP Address has been banned from performing this action.");
						}
					}
				}
				
				public LocalizedTranslation UserIsBannedExplanation_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserIsBannedExplanation");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserIsBannedExplanation", "Either your account, or your IP Address has been banned from performing this action.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIsBannedExplanation
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserIsBannedExplanation");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserIsBannedExplanation_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserIsBannedExplanation");
				}
				
				public LocalizedTranslation Username
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Username");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Username", "Username");
						}
					}
				}
				
				public LocalizedTranslation Username_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Username");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Username", "Username");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Username
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Username");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Username_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Username");
				}
				
				public LocalizedTranslation UserProfile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserProfile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserProfile", "User Profile");
						}
					}
				}
				
				public LocalizedTranslation UserProfile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserProfile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserProfile", "User Profile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserProfile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserProfile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserProfile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserProfile");
				}
				
				public LocalizedTranslation Users
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Users");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Users", "Users");
						}
					}
				}
				
				public LocalizedTranslation Users_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Users");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Users", "Users");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Users
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Users");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Users_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Users");
				}
				
				public LocalizedTranslation UsersProfile(object userDisplayName)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UsersProfile", userDisplayName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UsersProfile", "{userDisplayName}'s Profile", userDisplayName);
					}
				}
				
				public LocalizedTranslation UsersProfile_ForLanguageID(int languageID, object userDisplayName)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UsersProfile", userDisplayName);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UsersProfile", "{userDisplayName}'s Profile", userDisplayName);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UsersProfile(object userDisplayName)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UsersProfile", userDisplayName);
				}
				
				public LazyLocalizedTranslation Lazy_UsersProfile_ForLanguageID(int languageID, object userDisplayName)
				{
					return this.CalculateLazyTranslation(languageID, "UsersProfile", userDisplayName);
				}
				
				public LocalizedTranslation UserThanksBreakdown(object likedComments, object othersLikedComments)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "UserThanksBreakdown", likedComments, othersLikedComments);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserThanksBreakdown", "({othersLikedComments} PLURAL[{othersLikedComments};thank;thanks] received, {likedComments} PLURAL[{likedComments};thank;thanks] given)", likedComments, othersLikedComments);
					}
				}
				
				public LocalizedTranslation UserThanksBreakdown_ForLanguageID(int languageID, object likedComments, object othersLikedComments)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserThanksBreakdown", likedComments, othersLikedComments);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserThanksBreakdown", "({othersLikedComments} PLURAL[{othersLikedComments};thank;thanks] received, {likedComments} PLURAL[{likedComments};thank;thanks] given)", likedComments, othersLikedComments);
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserThanksBreakdown(object likedComments, object othersLikedComments)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "UserThanksBreakdown", likedComments, othersLikedComments);
				}
				
				public LazyLocalizedTranslation Lazy_UserThanksBreakdown_ForLanguageID(int languageID, object likedComments, object othersLikedComments)
				{
					return this.CalculateLazyTranslation(languageID, "UserThanksBreakdown", likedComments, othersLikedComments);
				}
				
				public LocalizedTranslation UserTitles
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "UserTitles");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("UserTitles", "Forum Titles");
						}
					}
				}
				
				public LocalizedTranslation UserTitles_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "UserTitles");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("UserTitles", "Forum Titles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserTitles
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "UserTitles");
					}
				}
				
				public LazyLocalizedTranslation Lazy_UserTitles_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "UserTitles");
				}
				
				public LocalizedTranslation Value
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Value");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Value", "Value");
						}
					}
				}
				
				public LocalizedTranslation Value_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Value");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Value", "Value");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Value
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Value");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Value_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Value");
				}
				
				public LocalizedTranslation Video
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Video");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Video", "Video");
						}
					}
				}
				
				public LocalizedTranslation Video_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Video");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Video", "Video");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Video
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Video");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Video_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Video");
				}
				
				public LocalizedTranslation Videos
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Videos");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Videos", "Videos");
						}
					}
				}
				
				public LocalizedTranslation Videos_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Videos");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Videos", "Videos");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Videos
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Videos");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Videos_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Videos");
				}
				
				public LocalizedTranslation View
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "View");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("View", "View");
						}
					}
				}
				
				public LocalizedTranslation View_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "View");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("View", "View");
					}
				}
				
				public LazyLocalizedTranslation Lazy_View
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "View");
					}
				}
				
				public LazyLocalizedTranslation Lazy_View_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "View");
				}
				
				public LocalizedTranslation ViewAll
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewAll");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewAll", "View All");
						}
					}
				}
				
				public LocalizedTranslation ViewAll_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewAll");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewAll", "View All");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewAll
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewAll");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewAll_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewAll");
				}
				
				public LocalizedTranslation ViewDetails
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewDetails");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewDetails", "View Details");
						}
					}
				}
				
				public LocalizedTranslation ViewDetails_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewDetails");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewDetails", "View Details");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewDetails
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewDetails");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewDetails_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewDetails");
				}
				
				public LocalizedTranslation ViewGuildsGallery
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewGuildsGallery");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewGuildsGallery", "View Guild's Gallery");
						}
					}
				}
				
				public LocalizedTranslation ViewGuildsGallery_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewGuildsGallery");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewGuildsGallery", "View Guild's Gallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewGuildsGallery
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewGuildsGallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewGuildsGallery_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewGuildsGallery");
				}
				
				public LocalizedTranslation ViewMyProfile
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "ViewMyProfile");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("ViewMyProfile", "View My Profile");
						}
					}
				}
				
				public LocalizedTranslation ViewMyProfile_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "ViewMyProfile");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("ViewMyProfile", "View My Profile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewMyProfile
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "ViewMyProfile");
					}
				}
				
				public LazyLocalizedTranslation Lazy_ViewMyProfile_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "ViewMyProfile");
				}
				
				public LocalizedTranslation Views
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Views");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Views", "Views");
						}
					}
				}
				
				public LocalizedTranslation Views_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Views");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Views", "Views");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Views
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Views");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Views_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Views");
				}
				
				public LocalizedTranslation VisibleAsciiErrorMessage
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VisibleAsciiErrorMessage");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VisibleAsciiErrorMessage", "Must only contain Latin-based characters with no accents.");
						}
					}
				}
				
				public LocalizedTranslation VisibleAsciiErrorMessage_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VisibleAsciiErrorMessage");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VisibleAsciiErrorMessage", "Must only contain Latin-based characters with no accents.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VisibleAsciiErrorMessage
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VisibleAsciiErrorMessage");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VisibleAsciiErrorMessage_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VisibleAsciiErrorMessage");
				}
				
				public LocalizedTranslation VisitOurSupportCenter
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VisitOurSupportCenter");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VisitOurSupportCenter", "Visit our Support Center");
						}
					}
				}
				
				public LocalizedTranslation VisitOurSupportCenter_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VisitOurSupportCenter");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VisitOurSupportCenter", "Visit our Support Center");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VisitOurSupportCenter
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VisitOurSupportCenter");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VisitOurSupportCenter_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VisitOurSupportCenter");
				}
				
				public LocalizedTranslation VoiceAlreadyInstalledLink(object link, object urlCode)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "VoiceAlreadyInstalledLink", link, urlCode);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VoiceAlreadyInstalledLink", "Already have Curse Voice installed? <a class=\"alt-action-link j-launch-curse-voice\" data-url-code=\"{urlCode}\" href={link}\" target=\"_blank\">Click here to launch CurseVoice</a>", link, urlCode);
					}
				}
				
				public LocalizedTranslation VoiceAlreadyInstalledLink_ForLanguageID(int languageID, object link, object urlCode)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VoiceAlreadyInstalledLink", link, urlCode);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VoiceAlreadyInstalledLink", "Already have Curse Voice installed? <a class=\"alt-action-link j-launch-curse-voice\" data-url-code=\"{urlCode}\" href={link}\" target=\"_blank\">Click here to launch CurseVoice</a>", link, urlCode);
					}
				}
				
				public LazyLocalizedTranslation Lazy_VoiceAlreadyInstalledLink(object link, object urlCode)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "VoiceAlreadyInstalledLink", link, urlCode);
				}
				
				public LazyLocalizedTranslation Lazy_VoiceAlreadyInstalledLink_ForLanguageID(int languageID, object link, object urlCode)
				{
					return this.CalculateLazyTranslation(languageID, "VoiceAlreadyInstalledLink", link, urlCode);
				}
				
				public LocalizedTranslation VoiceServices
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "VoiceServices");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("VoiceServices", "Voice Services");
						}
					}
				}
				
				public LocalizedTranslation VoiceServices_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "VoiceServices");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("VoiceServices", "Voice Services");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VoiceServices
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "VoiceServices");
					}
				}
				
				public LazyLocalizedTranslation Lazy_VoiceServices_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "VoiceServices");
				}
				
				public LocalizedTranslation WebFarm
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WebFarm");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WebFarm", "Web Farm");
						}
					}
				}
				
				public LocalizedTranslation WebFarm_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WebFarm");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WebFarm", "Web Farm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WebFarm
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WebFarm");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WebFarm_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WebFarm");
				}
				
				public LocalizedTranslation WebNode
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WebNode");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WebNode", "Web Node");
						}
					}
				}
				
				public LocalizedTranslation WebNode_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WebNode");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WebNode", "Web Node");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WebNode
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WebNode");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WebNode_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WebNode");
				}
				
				public LocalizedTranslation WelcomeDeck
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WelcomeDeck");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WelcomeDeck", "Wowstead provides the premiere guild hosting experience on the web. Whether you're a new guild leader or an accomplished web master, easily create and manage your guild website - setup takes mere minutes!");
						}
					}
				}
				
				public LocalizedTranslation WelcomeDeck_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeDeck");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeDeck", "Wowstead provides the premiere guild hosting experience on the web. Whether you're a new guild leader or an accomplished web master, easily create and manage your guild website - setup takes mere minutes!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeDeck
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeDeck");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeDeck_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeDeck");
				}
				
				public LocalizedTranslation WelcomeGenericUser
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WelcomeGenericUser");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WelcomeGenericUser", "Welcome!");
						}
					}
				}
				
				public LocalizedTranslation WelcomeGenericUser_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeGenericUser");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeGenericUser", "Welcome!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeGenericUser
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeGenericUser");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeGenericUser_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeGenericUser");
				}
				
				public LocalizedTranslation WelcomeHeader
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WelcomeHeader");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WelcomeHeader", "All in one Guild Hosting");
						}
					}
				}
				
				public LocalizedTranslation WelcomeHeader_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeHeader");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeHeader", "All in one Guild Hosting");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeHeader
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeHeader");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeHeader_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeHeader");
				}
				
				public LocalizedTranslation WelcomeUser(object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "WelcomeUser", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeUser", "Welcome, {username}!", username);
					}
				}
				
				public LocalizedTranslation WelcomeUser_ForLanguageID(int languageID, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeUser", username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeUser", "Welcome, {username}!", username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeUser(object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeUser", username);
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeUser_ForLanguageID(int languageID, object username)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeUser", username);
				}
				
				public LocalizedTranslation WelcomeUserToSite(object site, object username)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "WelcomeUserToSite", site, username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeUserToSite", "\"Hi\", {username}! Welcome, {username} to {site}!", site, username);
					}
				}
				
				public LocalizedTranslation WelcomeUserToSite_ForLanguageID(int languageID, object site, object username)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WelcomeUserToSite", site, username);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WelcomeUserToSite", "\"Hi\", {username}! Welcome, {username} to {site}!", site, username);
					}
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeUserToSite(object site, object username)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "WelcomeUserToSite", site, username);
				}
				
				public LazyLocalizedTranslation Lazy_WelcomeUserToSite_ForLanguageID(int languageID, object site, object username)
				{
					return this.CalculateLazyTranslation(languageID, "WelcomeUserToSite", site, username);
				}
				
				public LocalizedTranslation WhatIsMogster
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WhatIsMogster");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WhatIsMogster", "Mogalog provides the premiere guild hosting experience on the web. Whether you're a new guild leader or an accomplished web master, easily create and manage your guild website - setup takes mere minutes! ");
						}
					}
				}
				
				public LocalizedTranslation WhatIsMogster_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WhatIsMogster");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WhatIsMogster", "Mogalog provides the premiere guild hosting experience on the web. Whether you're a new guild leader or an accomplished web master, easily create and manage your guild website - setup takes mere minutes! ");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogster
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WhatIsMogster");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogster_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WhatIsMogster");
				}
				
				public LocalizedTranslation WhatIsMogsterHeader
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WhatIsMogsterHeader");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WhatIsMogsterHeader", "What is Mogster?");
						}
					}
				}
				
				public LocalizedTranslation WhatIsMogsterHeader_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WhatIsMogsterHeader");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WhatIsMogsterHeader", "What is Mogster?");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogsterHeader
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WhatIsMogsterHeader");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogsterHeader_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WhatIsMogsterHeader");
				}
				
				public LocalizedTranslation WhatIsMogsterNetwork
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WhatIsMogsterNetwork");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WhatIsMogsterNetwork", "Mogster allows gamers to stay connected to their friends, follow famous players and guilds, create groups to discuss the latest hot game, and broadcast their in-game achievements.");
						}
					}
				}
				
				public LocalizedTranslation WhatIsMogsterNetwork_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WhatIsMogsterNetwork");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WhatIsMogsterNetwork", "Mogster allows gamers to stay connected to their friends, follow famous players and guilds, create groups to discuss the latest hot game, and broadcast their in-game achievements.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogsterNetwork
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WhatIsMogsterNetwork");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WhatIsMogsterNetwork_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WhatIsMogsterNetwork");
				}
				
				public LocalizedTranslation WidgetWorkspace
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WidgetWorkspace");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WidgetWorkspace", "Widget Workspace");
						}
					}
				}
				
				public LocalizedTranslation WidgetWorkspace_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WidgetWorkspace");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WidgetWorkspace", "Widget Workspace");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WidgetWorkspace
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WidgetWorkspace");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WidgetWorkspace_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WidgetWorkspace");
				}
				
				public LocalizedTranslation Width
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Width");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Width", "Width");
						}
					}
				}
				
				public LocalizedTranslation Width_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Width");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Width", "Width");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Width
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Width");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Width_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Width");
				}
				
				public LocalizedTranslation WowSteadAnnouncements
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WowSteadAnnouncements");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WowSteadAnnouncements", "WowStead Announcements");
						}
					}
				}
				
				public LocalizedTranslation WowSteadAnnouncements_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WowSteadAnnouncements");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WowSteadAnnouncements", "WowStead Announcements");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowSteadAnnouncements
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WowSteadAnnouncements");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowSteadAnnouncements_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WowSteadAnnouncements");
				}
				
				public LocalizedTranslation WowsteadEventPlanner
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WowsteadEventPlanner");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WowsteadEventPlanner", "Wowstead Event Planner (Calendar)");
						}
					}
				}
				
				public LocalizedTranslation WowsteadEventPlanner_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WowsteadEventPlanner");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WowsteadEventPlanner", "Wowstead Event Planner (Calendar)");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowsteadEventPlanner
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WowsteadEventPlanner");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowsteadEventPlanner_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WowsteadEventPlanner");
				}
				
				public LocalizedTranslation WowsteadPitch
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "WowsteadPitch");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("WowsteadPitch", "With the most advanced, relevant features, Wowstead is the ideal site for your guild to call home.  Whether you're a new guild leader or an accomplished web master, site creation is a breeze!");
						}
					}
				}
				
				public LocalizedTranslation WowsteadPitch_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "WowsteadPitch");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("WowsteadPitch", "With the most advanced, relevant features, Wowstead is the ideal site for your guild to call home.  Whether you're a new guild leader or an accomplished web master, site creation is a breeze!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowsteadPitch
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "WowsteadPitch");
					}
				}
				
				public LazyLocalizedTranslation Lazy_WowsteadPitch_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "WowsteadPitch");
				}
				
				public LocalizedTranslation XAndY(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "XAndY", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("XAndY", "{alpha} and {bravo}", alpha, bravo);
					}
				}
				
				public LocalizedTranslation XAndY_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "XAndY", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("XAndY", "{alpha} and {bravo}", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_XAndY(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "XAndY", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_XAndY_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "XAndY", alpha, bravo);
				}
				
				public LocalizedTranslation XOrY(object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(UninitializedLanguageID, "XOrY", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("XOrY", "{alpha} or {bravo}", alpha, bravo);
					}
				}
				
				public LocalizedTranslation XOrY_ForLanguageID(int languageID, object alpha, object bravo)
				{
					try
					{
						return this.CalculateTranslation(languageID, "XOrY", alpha, bravo);
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("XOrY", "{alpha} or {bravo}", alpha, bravo);
					}
				}
				
				public LazyLocalizedTranslation Lazy_XOrY(object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(UninitializedLanguageID, "XOrY", alpha, bravo);
				}
				
				public LazyLocalizedTranslation Lazy_XOrY_ForLanguageID(int languageID, object alpha, object bravo)
				{
					return this.CalculateLazyTranslation(languageID, "XOrY", alpha, bravo);
				}
				
				public LocalizedTranslation Yes
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "Yes");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("Yes", "Yes");
						}
					}
				}
				
				public LocalizedTranslation Yes_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "Yes");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("Yes", "Yes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Yes
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "Yes");
					}
				}
				
				public LazyLocalizedTranslation Lazy_Yes_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "Yes");
				}
				
				public LocalizedTranslation YouAreNowBeingRedirected
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "YouAreNowBeingRedirected");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("YouAreNowBeingRedirected", "You are now being redirected, or you can click the button below.");
						}
					}
				}
				
				public LocalizedTranslation YouAreNowBeingRedirected_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YouAreNowBeingRedirected");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YouAreNowBeingRedirected", "You are now being redirected, or you can click the button below.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouAreNowBeingRedirected
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "YouAreNowBeingRedirected");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouAreNowBeingRedirected_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "YouAreNowBeingRedirected");
				}
				
				public LocalizedTranslation YouCanSignInWithSameEmail
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "YouCanSignInWithSameEmail");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("YouCanSignInWithSameEmail", "You can now sign in with the same email address and password you used on legacy Wowstead!");
						}
					}
				}
				
				public LocalizedTranslation YouCanSignInWithSameEmail_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YouCanSignInWithSameEmail");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YouCanSignInWithSameEmail", "You can now sign in with the same email address and password you used on legacy Wowstead!");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouCanSignInWithSameEmail
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "YouCanSignInWithSameEmail");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YouCanSignInWithSameEmail_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "YouCanSignInWithSameEmail");
				}
				
				public LocalizedTranslation YourAppHasPassedThePoint
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "YourAppHasPassedThePoint");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("YourAppHasPassedThePoint", "Your application has passed the point where feedback is needed.");
						}
					}
				}
				
				public LocalizedTranslation YourAppHasPassedThePoint_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YourAppHasPassedThePoint");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YourAppHasPassedThePoint", "Your application has passed the point where feedback is needed.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YourAppHasPassedThePoint
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "YourAppHasPassedThePoint");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YourAppHasPassedThePoint_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "YourAppHasPassedThePoint");
				}
				
				public LocalizedTranslation YourGuildSiteHasPremiumInfo
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "YourGuildSiteHasPremiumInfo");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("YourGuildSiteHasPremiumInfo", "Your guild site is currently enjoying WowStead Premium as a part of the Premium Preview.");
						}
					}
				}
				
				public LocalizedTranslation YourGuildSiteHasPremiumInfo_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "YourGuildSiteHasPremiumInfo");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("YourGuildSiteHasPremiumInfo", "Your guild site is currently enjoying WowStead Premium as a part of the Premium Preview.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YourGuildSiteHasPremiumInfo
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "YourGuildSiteHasPremiumInfo");
					}
				}
				
				public LazyLocalizedTranslation Lazy_YourGuildSiteHasPremiumInfo_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "YourGuildSiteHasPremiumInfo");
				}
				

				#endregion
			}
			
			private CommonSubNamespace _cacheCommon;
			public CommonSubNamespace Common
			{
				get
				{
					if (_cacheCommon == null)
					{
						_cacheCommon = new CommonSubNamespace();
					}
					return _cacheCommon;
				}
			}
			public sealed class ContentManagementSubNamespace : SubNamespaceBase
			{
				public ContentManagementSubNamespace() : base("Global", "ContentManagement") { }
				
				#region Phrase methods
				
				public LocalizedTranslation AddContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddContent", "Add Content");
						}
					}
				}
				
				public LocalizedTranslation AddContent_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddContent");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddContent", "Add Content");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddContent
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddContent");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddContent_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddContent");
				}
				
				public LocalizedTranslation AddFolder
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddFolder");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddFolder", "Add Folder");
						}
					}
				}
				
				public LocalizedTranslation AddFolder_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddFolder");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddFolder", "Add Folder");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddFolder
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddFolder");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddFolder_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddFolder");
				}
				
				public LocalizedTranslation AddMediaGallery
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddMediaGallery");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddMediaGallery", "Add Media Gallery");
						}
					}
				}
				
				public LocalizedTranslation AddMediaGallery_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddMediaGallery");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddMediaGallery", "Add Media Gallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddMediaGallery
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddMediaGallery");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddMediaGallery_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddMediaGallery");
				}
				
				public LocalizedTranslation AddPost
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddPost");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddPost", "Add a Post");
						}
					}
				}
				
				public LocalizedTranslation AddPost_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddPost");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddPost", "Add a Post");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPost
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddPost");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddPost_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddPost");
				}
				
				public LocalizedTranslation AddQuestion
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddQuestion");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddQuestion", "Add Question");
						}
					}
				}
				
				public LocalizedTranslation AddQuestion_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddQuestion");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddQuestion", "Add Question");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddQuestion
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddQuestion");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddQuestion_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddQuestion");
				}
				
				public LocalizedTranslation AddToThisFolder
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AddToThisFolder");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AddToThisFolder", "Add to Folder");
						}
					}
				}
				
				public LocalizedTranslation AddToThisFolder_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AddToThisFolder");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AddToThisFolder", "Add to Folder");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddToThisFolder
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AddToThisFolder");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AddToThisFolder_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AddToThisFolder");
				}
				
				public LocalizedTranslation AdsWhichAreMarkedDisabled
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AdsWhichAreMarkedDisabled");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AdsWhichAreMarkedDisabled", "Ads which are marked disabled will not generate any markup except their container, if the template has one.");
						}
					}
				}
				
				public LocalizedTranslation AdsWhichAreMarkedDisabled_ForLanguageID(int languageID)
				{
					try
					{
						return this.CalculateTranslation(languageID, "AdsWhichAreMarkedDisabled");
					}
					catch (ArgumentException)
					{
						return this.CalculateFailedTranslation("AdsWhichAreMarkedDisabled", "Ads which are marked disabled will not generate any markup except their container, if the template has one.");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdsWhichAreMarkedDisabled
				{
					get
					{
						return this.CalculateLazyTranslation(UninitializedLanguageID, "AdsWhichAreMarkedDisabled");
					}
				}
				
				public LazyLocalizedTranslation Lazy_AdsWhichAreMarkedDisabled_ForLanguageID(int languageID)
				{
					return this.CalculateLazyTranslation(languageID, "AdsWhichAreMarkedDisabled");
				}
				
				public LocalizedTranslation AdvertisingContent
				{
					get
					{
						try
						{
							return this.CalculateTranslation(UninitializedLanguageID, "AdvertisingContent");
						}
						catch (ArgumentException)
						{
							return this.CalculateFailedTranslation("AdvertisingContent", "Advertising Content - ");
		