﻿using System.Collections.Generic;
using Curse.Cobalt.Localization;

namespace Curse.AGS.Localization
{
    public class AGSLocalizationFactory : LocalizationFactory
    {
        public override void UpdateLocalizationData(bool lazily)
        {
            L.UpdateLocalizationData(lazily);
        }

        public override void UpdateLocalizationLanguageData(int languageID, bool lazily)
        {
            L.UpdateLocalizationLanguageData(languageID, lazily);
        }

        public override ILocalizationNamespace GetNamespace(string name)
        {
            return L.GetNamespace(name);
        }

        public override bool TryGetNamespace(string name, out ILocalizationNamespace result)
        {
            return L.TryGetNamespace(name, out result);
        }

        public override ILocalizationNamespace SafeGetNamespace(string name)
        {
            return L.SafeGetNamespace(name);
        }

        public override LocalizedTranslation GetTranslationByPhraseID(int phraseID)
        {
            return L.GetTranslationByPhraseID(phraseID);
        }

        public override LocalizedTranslation GetTranslationByPhraseID(int phraseID, params object[] args)
        {
            return L.GetTranslationByPhraseID(phraseID, args);
        }

        public override LocalizedTranslation GetTranslationByPhraseID(int phraseID, IDictionary<string, object> dict)
        {
            return L.GetTranslationByPhraseID(phraseID, dict);
        }

        public override LocalizedTranslation GetTranslationForLanguageIDByPhraseID(int languageID, int phraseID)
        {
            return L.GetTranslationForLanguageIDByPhraseID(languageID, phraseID);
        }

        public override LocalizedTranslation GetTranslationForLanguageIDByPhraseID(int languageID, int phraseID, params object[] args)
        {
            return L.GetTranslationForLanguageIDByPhraseID(languageID, phraseID, args);
        }

        public override LocalizedTranslation GetTranslationForLanguageIDByPhraseID(int languageID, int phraseID, IDictionary<string, object> dict)
        {
            return L.GetTranslationForLanguageIDByPhraseID(languageID, phraseID, dict);
        }

        public override bool TryGetTranslationByPhraseID(int phraseID, out LocalizedTranslation result)
        {
            return L.TryGetTranslationByPhraseID(phraseID, out result);
        }

        public override bool TryGetTranslationByPhraseID(int phraseID, out LocalizedTranslation result, params object[] args)
        {
            return L.TryGetTranslationByPhraseID(phraseID, out result, args);
        }

        public override bool TryGetTranslationByPhraseID(int phraseID, out LocalizedTranslation result, IDictionary<string, object> dict)
        {
            return L.TryGetTranslationByPhraseID(phraseID, out result, dict);
        }

        public override bool TryGetTranslationForLanguageIDByPhraseID(int languageID, int phraseID, out LocalizedTranslation result)
        {
            return L.TryGetTranslationForLanguageIDByPhraseID(languageID, phraseID, out result);
        }

        public override bool TryGetTranslationForLanguageIDByPhraseID(int languageID, int phraseID, out LocalizedTranslation result, params object[] args)
        {
            return L.TryGetTranslationForLanguageIDByPhraseID(languageID, phraseID, out result, args);
        }

        public override bool TryGetTranslationForLanguageIDByPhraseID(int languageID, int phraseID, out LocalizedTranslation result, IDictionary<string, object> dict)
        {
            return L.TryGetTranslationForLanguageIDByPhraseID(languageID, phraseID, out result, dict);
        }

        public override void ClearCache(bool translationsOnly)
        {
            L.ClearCache(translationsOnly);
        }
    }
}
