﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Curse.Cobalt.Models;

namespace Curse.AGS.LwaDirectedIds
{
    public interface ILwaDirectedIdsExporter
    {
        DirectedIdsResult GetNewUsersInDateRange(DateTime startDate, DateTime endDate);
    }

    public class LwaDirectedIdsExporter : ILwaDirectedIdsExporter
    {
        public DirectedIdsResult GetNewUsersInDateRange(DateTime startDate, DateTime endDate)
        {
            var directedIds = (from u in User.Query
                join eum in ExternalUserMap.Query on u.ID equals eum.UserID
                where u.DateRegistered >= startDate
                      && u.DateRegistered <= endDate
                      && eum.ExternalAuthProviderID == 3 // 3 is the ID for LWA
                select eum.ExternalUserID).ToList();

            if (!directedIds.Any())
            {
                return new DirectedIdsResult
                {
                    Success = false,
                    Message = "No accounts created in this time period."
                };
            }

            return new DirectedIdsResult
            {
                Success = true,
                DirectedIdsCsvStream = this.GetDirectedIdsCsvStream(directedIds)
            };
        }

        private Stream GetDirectedIdsCsvStream(IEnumerable<string> directedIds)
        {
            var csvStreamWriter = new StreamWriter(new MemoryStream());
            csvStreamWriter.WriteLine("Directed ID");
            foreach (var directedId in directedIds)
            {
                csvStreamWriter.WriteLine($"{directedId}");
            }

            csvStreamWriter.Flush();
            var retVal = csvStreamWriter.BaseStream;
            retVal.Seek(0, SeekOrigin.Begin);
            return retVal;
        }
    }

    public class DirectedIdsResult
    {
        public bool Success { get; set; }

        public string Message { get; set; }

        public Stream DirectedIdsCsvStream { get; set; }
    }
}
