﻿using System;
using System.ComponentModel;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Linq;
using System.Linq.Expressions;
using System.Web.Mvc;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlTypes;
using System.Xml.Linq;

using Curse.Cobalt;
using Curse.Cobalt.Caching;
using Curse.Cobalt.Extensions;
using Curse.Cobalt.Attributes;
using Curse.Cobalt.Models;
using Curse.Cobalt.Application;
using Curse.Cobalt.Data;
using Curse.Cobalt.ModelExtensions;

namespace Curse.AGS.Models
{
	
	[Serializable]
    [Table(Name = "dbo.AGSForumEmailMap")]
    public sealed partial class AGSForumEmailMap : BaseModel<AGSForumEmailMap>, INotifyPropertyChanged, IModel
    {
        /// <summary>
        /// A unique ID for the current type. For AGSForumEmailMap, this is 1353100595.
        /// </summary>
		public new const int ModelTypeID = 1353100595;
		

		
        #region Columns
		
		public void UpdateDenormalizedData()
		{
		}

		// Expose the column names, in the correct order
		public static IEnumerable<string> ColumnNames
		{
			get
			{
				yield return "ID";
				yield return "Email";
				yield return "ForumID";
			}
		}    
		
        /// <summary>
		/// Represents this AGSForumEmailMap's ID database column.
		/// This is the AGSForumEmailMap's primary key.
		/// </summary>
		
		#region ExplicitIDSetting
		
		public void SetExplicitID(int id)
		{
			this._id = id;
			this._manuallySetID = true;
		}
		
		#endregion
        [Column(Storage = "_id", AutoSync = AutoSync.OnInsert, DbType = "INT NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        public int ID
        {
            get
            {
                return this._id;
            }
        }
		
        // Ignore the warning that _id is never assigned to, as it is assigned to via LINQ to Entities.
        #pragma warning disable 0649
        private int _id;
        #pragma warning restore 0649
        
		/// <summary>
		/// Represents the maximum length of the Email column, which is 255.
		/// </summary>
		public const int EmailMaxLength = 255;
        /// <summary>
		/// Represents this AGSForumEmailMap's Email database column.
		/// This string can not be null. It will always at least be an empty string.
		/// This string must be able to encode into ASCII, i.e. only represent codepoints 0-127.
		/// This has a maximum length of 255.
		/// </summary>
		[Column(Storage = "_email", DbType = "VARCHAR(255) NOT NULL", CanBeNull = false, UpdateCheck = UpdateCheck.Never)]
        public string Email
        {
            get
            {
                return this._email ?? string.Empty;
            }
            set
            {
				if (value == null)
				{
					value = string.Empty;
				}
				if (value.Length > EmailMaxLength)
				{
					throw new ArgumentException(string.Format("Must be at most length {0}. Provided value has a length of {1}.", EmailMaxLength, value.Length), "value");
				}
				if (System.Text.Encoding.ASCII.GetByteCount(value) != value.Length)
				{
					throw new ArgumentException("Must be an ASCII-encodable string", "value");
				}
                if (this._email != value)
                {
					IsDirty = true;
					string oldValue = this._email;					
                    this._email = value;
					this.OnEmailChanged(oldValue, value);
                    this.SendPropertyChanged("Email");
                }
            }
        }
		partial void OnEmailChanged(string oldValue, string newValue);
		
        private string _email;
        
        /// <summary>
		/// Represents this AGSForumEmailMap's ForumID database column.
		/// This represents a foreign key to Forum.
		/// </summary>
		[Column(Storage = "_forumID", DbType = "INT NOT NULL", UpdateCheck = UpdateCheck.Never)]
		[ForeignKey(ParentTableType = typeof(Forum), CausesInvalidation=false)]				
        public int ForumID
        {
            get
            {
                return this._forumID;
            }
            set
            {
                if (this._forumID != value)
                {
					IsDirty = true;
					int oldValue = this._forumID;					
                    this._forumID = value;
					this.OnForumIDChanged(oldValue, value);
                    this.SendPropertyChanged("ForumID");
                }
            }
        }
		partial void OnForumIDChanged(int oldValue, int newValue);
		
        private int _forumID;
        
		
		protected override void VerifyModelValidity()
		{
		}
		
        #endregion

		#region Clone
		
		public override AGSForumEmailMap Clone()
		{
			return new AGSForumEmailMap
			{
				Email = this.Email,
				ForumID = this.ForumID,
			};
		}
		
		IModel IModel.Clone()
		{
			return Clone();
		}
		
		#endregion

        #region Data Accessors
		// Generated from the Indexes on the table
		
		
		private static readonly Func<int, IQueryable<int>> CompiledQuery_ForumID = CreateCompiledQuery<int, IQueryable<int>>(
			(query, forumID) => query.Where(a => a.ForumID == forumID).Select(c => c.ID),
			(forumID) => string.Concat("AGSForumEmailMap.GetAllIDsByForumID(", forumID.ToNiceString(), ")"));
		private static readonly Func<int, bool> CompiledExistsQuery_ForumID = CreateCompiledQuery<int, bool>(
			(query, forumID) => query.Where(a => a.ForumID == forumID).Any(),
			(forumID) => string.Concat("AGSForumEmailMap.AnyByForumID(", forumID.ToNiceString(), ")"));
		private static readonly Func<int, int> CompiledCountQuery_ForumID = CreateCompiledQuery<int, int>(
			(query, forumID) => query.Where(a => a.ForumID == forumID).Count(),
			(forumID) => string.Concat("AGSForumEmailMap.CountByForumID(", forumID.ToNiceString(), ")"));
		
		/// <summary>
		/// Return a sequence of ints given the parameters provided.
		/// </summary>
		/// <param name="forumID">The ForumID to match.</param>
		/// <returns>A sequence of ints</returns>
        public static IEnumerable<int> GetAllIDsByForumID(int forumID)
        {
			return GetAllIDsByCompiledQuery(() => CompiledQuery_ForumID(forumID), string.Concat("ForumID=", forumID));
        }
		
		
		/// <summary>
		/// Return a sequence of AGSForumEmailMaps given the parameters provided.
		/// </summary>
		/// <param name="forumID">The ForumID to match.</param>
		/// <returns>A sequence of AGSForumEmailMaps</returns>
        public static IEnumerable<AGSForumEmailMap> GetAllByForumID(int forumID)
        {
			return GetAllByCompiledQuery(() => CompiledQuery_ForumID(forumID), string.Concat("ForumID=", forumID));
        }
		
		
		/// <summary>
		/// Return whether one or more AGSForumEmailMaps are found, given the parameters provided.
		/// </summary>
		/// <param name="forumID">The ForumID to match.</param>
		/// <returns>True if any amount of AGSForumEmailMaps are found, otherwise false</returns>
		public static bool AnyByForumID(int forumID)
		{
			return AnyByCompiledQuery(() => CompiledExistsQuery_ForumID(forumID), string.Concat("ForumID=", forumID));
		}
		
		/// <summary>
		/// Return the number of AGSForumEmailMaps found, given the parameters provided.
		/// </summary>
		/// <param name="forumID">The ForumID to match.</param>
		/// <returns>The amount of AGSForumEmailMaps that are found, 0 if none are found.</returns>
		public static int CountByForumID(int forumID)
		{
			return CountByCompiledQuery(() => CompiledCountQuery_ForumID(forumID), string.Concat("ForumID=", forumID));
		}
		
		/// <summary>
		/// Return an IQueryable of AGSForumEmailMap given the parameters provided.
		/// </summary>
		/// <param name="forumID">The ForumID to match.</param>
		/// <returns>An IQueryable of AGSForumEmailMap</returns>
		public static IQueryable<AGSForumEmailMap> GetQueryByForumID(int forumID)
		{
			return Query.Where(a => a.ForumID == forumID);
		}
		
		/// <summary>
		/// Return a sequence of ints given the parameters provided.
		/// </summary>
		/// <param name="forum">The Forum to match.</param>
		/// <returns>A sequence of ints</returns>
        public static IEnumerable<int> GetAllIDsByForum(Forum forum)
        {
			if (forum == null)
			{
				throw new ArgumentNullException("forum");
			}
			else if (!forum.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "forum");
			}
			return GetAllIDsByCompiledQuery(() => CompiledQuery_ForumID(forum.ID), string.Concat("ForumID=", forum.ID));
        }
		
		
		/// <summary>
		/// Return a sequence of AGSForumEmailMaps given the parameters provided.
		/// </summary>
		/// <param name="forum">The Forum to match.</param>
		/// <returns>A sequence of AGSForumEmailMaps</returns>
        public static IEnumerable<AGSForumEmailMap> GetAllByForum(Forum forum)
        {
			if (forum == null)
			{
				throw new ArgumentNullException("forum");
			}
			else if (!forum.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "forum");
			}
			return GetAllByCompiledQuery(() => CompiledQuery_ForumID(forum.ID), string.Concat("ForumID=", forum.ID));
        }
		
		
		/// <summary>
		/// Return whether one or more AGSForumEmailMaps are found, given the parameters provided.
		/// </summary>
		/// <param name="forum">The Forum to match.</param>
		/// <returns>True if any amount of AGSForumEmailMaps are found, otherwise false</returns>
		public static bool AnyByForum(Forum forum)
		{
			if (forum == null)
			{
				throw new ArgumentNullException("forum");
			}
			else if (!forum.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "forum");
			}
			return AnyByCompiledQuery(() => CompiledExistsQuery_ForumID(forum.ID), string.Concat("ForumID=", forum.ID));
		}
		
		/// <summary>
		/// Return the number of AGSForumEmailMaps found, given the parameters provided.
		/// </summary>
		/// <param name="forum">The Forum to match.</param>
		/// <returns>The amount of AGSForumEmailMaps that are found, 0 if none are found.</returns>
		public static int CountByForum(Forum forum)
		{
			if (forum == null)
			{
				throw new ArgumentNullException("forum");
			}
			else if (!forum.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "forum");
			}
			return CountByCompiledQuery(() => CompiledCountQuery_ForumID(forum.ID), string.Concat("ForumID=", forum.ID));
		}
		
		/// <summary>
		/// Return an IQueryable of AGSForumEmailMap given the parameters provided.
		/// </summary>
		/// <param name="forum">The Forum to match.</param>
		/// <returns>An IQueryable of AGSForumEmailMap</returns>
		public static IQueryable<AGSForumEmailMap> GetQueryByForum(Forum forum)
		{
			if (forum == null)
			{
				throw new ArgumentNullException("forum");
			}
			else if (!forum.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "forum");
			}
			return Query.Where(a => a.ForumID == forum.ID);
		}
		
		protected override IEnumerable<Tuple<bool, string>> DataAccessorCacheKeys
		{
			get
			{
				yield return Tuple.Create(true, string.Concat("ForumID=", ForumID));
			}
		}
		
        #endregion

		#region Relations
		/// <summary>
		/// The Forum of the current AGSForumEmailMap.
		/// This is just an accessor around ForumID.
		/// </summary>
		public Forum Forum
		{
			get
			{
                return this.GetRelatedEntity<Forum>(a => a.ForumID);
			}
            set
            {
				if (value == null)
				{
                    throw new ArgumentNullException("value");
				}
				else if (!value.IsSavedToDatabase)
				{
					Forum detached = value;
					AddTemporaryOnSaving(() => {
						if (!detached.IsSavedToDatabase)
						{
							throw new InvalidOperationException("Forum must be saved to the database before saving this AGSForumEmailMap.");
						}
						ForumID = detached.ID;
					});
				}
                else
                {
                    ForumID = value.ID;
                }
            }
		}
		
		#endregion
		
		#region Queries
		
		/// <summary>
		/// Get an IQueryable for all EntityRoleRequirements whose EntityTypeID and EntityID match the current AGSForumEmailMap.
		/// </summary>
		public IQueryable<EntityRoleRequirement> RoleRequirementQuery
		{
			get
			{
				return EntityRoleRequirement.GetQueryByEntityTypeIDAndEntityID(AGSForumEmailMap.ModelTypeID, this.ID);				
			}
		}
		
		/// <summary>
		/// Get an IQueryable for all UserAchievements whose EntityTypeID and EntityID match the current AGSForumEmailMap.
		/// </summary>
		public IQueryable<UserAchievement> AchievementsEearnedForEntity
		{
			get
			{
				return UserAchievement.GetQueryByEntityTypeIDAndEntityID(AGSForumEmailMap.ModelTypeID, this.ID);				
			}
		}
		
		/// <summary>
		/// Get an IQueryable for all VotingFraudNotifications whose EntityTypeID and EntityID match the current AGSForumEmailMap.
		/// </summary>
		public IQueryable<VotingFraudNotification> VotingFraudNotificationQuery
		{
			get
			{
				return VotingFraudNotification.GetQueryByEntityTypeIDAndEntityID(AGSForumEmailMap.ModelTypeID, this.ID);				
			}
		}
		
		protected override IEnumerable<string> GetRelationCacheKeys(AGSForumEmailMap original)
		{
			return Enumerable.Empty<string>();
		}
		
		#endregion
        


        #region Model Materialization
		
		protected override void Materialize(IDataReader reader)
		{
			this._id = (int)reader.GetValue(0);
			this._email = (string)reader.GetValue(1);
			this._forumID = (int)reader.GetValue(2);
		}
		#endregion
		

	}
}
