﻿using System;
using System.ComponentModel;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Linq;
using System.Linq.Expressions;
using System.Web.Mvc;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlTypes;
using System.Xml.Linq;

using Curse.Cobalt;
using Curse.Cobalt.Caching;
using Curse.Cobalt.Extensions;
using Curse.Cobalt.Attributes;
using Curse.Cobalt.Models;
using Curse.Cobalt.Application;
using Curse.Cobalt.Data;
using Curse.Cobalt.ModelExtensions;

namespace Curse.AGS.Models
{
	
	[Serializable]
    [Table(Name = "dbo.AGSRoleEmailTrigger")]
    public sealed partial class AGSRoleEmailTrigger : BaseModel<AGSRoleEmailTrigger>, INotifyPropertyChanged, IModel
    {
        /// <summary>
        /// A unique ID for the current type. For AGSRoleEmailTrigger, this is 257486511.
        /// </summary>
		public new const int ModelTypeID = 257486511;
		

		
        #region Columns
		
		public void UpdateDenormalizedData()
		{
		}

		// Expose the column names, in the correct order
		public static IEnumerable<string> ColumnNames
		{
			get
			{
				yield return "ID";
				yield return "RoleID";
			}
		}    
		
        /// <summary>
		/// Represents this AGSRoleEmailTrigger's ID database column.
		/// This is the AGSRoleEmailTrigger's primary key.
		/// </summary>
		
		#region ExplicitIDSetting
		
		public void SetExplicitID(int id)
		{
			this._id = id;
			this._manuallySetID = true;
		}
		
		#endregion
        [Column(Storage = "_id", AutoSync = AutoSync.OnInsert, DbType = "INT NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        public int ID
        {
            get
            {
                return this._id;
            }
        }
		
        // Ignore the warning that _id is never assigned to, as it is assigned to via LINQ to Entities.
        #pragma warning disable 0649
        private int _id;
        #pragma warning restore 0649
        
        /// <summary>
		/// Represents this AGSRoleEmailTrigger's RoleID database column.
		/// This represents a foreign key to Role.
		/// </summary>
		[Column(Storage = "_roleID", DbType = "INT NOT NULL", UpdateCheck = UpdateCheck.Never)]
		[ForeignKey(ParentTableType = typeof(Role))]				
        public int RoleID
        {
            get
            {
                return this._roleID;
            }
            set
            {
                if (this._roleID != value)
                {
					IsDirty = true;
					int oldValue = this._roleID;					
                    this._roleID = value;
					this.OnRoleIDChanged(oldValue, value);
                    this.SendPropertyChanged("RoleID");
                }
            }
        }
		partial void OnRoleIDChanged(int oldValue, int newValue);
		
        private int _roleID;
        
		
		protected override void VerifyModelValidity()
		{
		}
		
        #endregion

		#region Clone
		
		public override AGSRoleEmailTrigger Clone()
		{
			return new AGSRoleEmailTrigger
			{
				RoleID = this.RoleID,
			};
		}
		
		IModel IModel.Clone()
		{
			return Clone();
		}
		
		#endregion

        #region Data Accessors
		// Generated from the Indexes on the table
		
		
		private static readonly Func<int, IQueryable<int>> CompiledQuery_RoleID = CreateCompiledQuery<int, IQueryable<int>>(
			(query, roleID) => query.Where(a => a.RoleID == roleID).Select(c => c.ID),
			(roleID) => string.Concat("AGSRoleEmailTrigger.GetAllIDsByRoleID(", roleID.ToNiceString(), ")"));
		private static readonly Func<int, bool> CompiledExistsQuery_RoleID = CreateCompiledQuery<int, bool>(
			(query, roleID) => query.Where(a => a.RoleID == roleID).Any(),
			(roleID) => string.Concat("AGSRoleEmailTrigger.AnyByRoleID(", roleID.ToNiceString(), ")"));
		private static readonly Func<int, int> CompiledCountQuery_RoleID = CreateCompiledQuery<int, int>(
			(query, roleID) => query.Where(a => a.RoleID == roleID).Count(),
			(roleID) => string.Concat("AGSRoleEmailTrigger.CountByRoleID(", roleID.ToNiceString(), ")"));
		
		/// <summary>
		/// Return a sequence of ints given the parameters provided.
		/// </summary>
		/// <param name="roleID">The RoleID to match.</param>
		/// <returns>A sequence of ints</returns>
        public static IEnumerable<int> GetAllIDsByRoleID(int roleID)
        {
			return GetAllIDsByCompiledQuery(() => CompiledQuery_RoleID(roleID), string.Concat("RoleID=", roleID));
        }
		
		
		/// <summary>
		/// Return a sequence of AGSRoleEmailTriggers given the parameters provided.
		/// </summary>
		/// <param name="roleID">The RoleID to match.</param>
		/// <returns>A sequence of AGSRoleEmailTriggers</returns>
        public static IEnumerable<AGSRoleEmailTrigger> GetAllByRoleID(int roleID)
        {
			return GetAllByCompiledQuery(() => CompiledQuery_RoleID(roleID), string.Concat("RoleID=", roleID));
        }
		
		
		/// <summary>
		/// Return whether one or more AGSRoleEmailTriggers are found, given the parameters provided.
		/// </summary>
		/// <param name="roleID">The RoleID to match.</param>
		/// <returns>True if any amount of AGSRoleEmailTriggers are found, otherwise false</returns>
		public static bool AnyByRoleID(int roleID)
		{
			return AnyByCompiledQuery(() => CompiledExistsQuery_RoleID(roleID), string.Concat("RoleID=", roleID));
		}
		
		/// <summary>
		/// Return the number of AGSRoleEmailTriggers found, given the parameters provided.
		/// </summary>
		/// <param name="roleID">The RoleID to match.</param>
		/// <returns>The amount of AGSRoleEmailTriggers that are found, 0 if none are found.</returns>
		public static int CountByRoleID(int roleID)
		{
			return CountByCompiledQuery(() => CompiledCountQuery_RoleID(roleID), string.Concat("RoleID=", roleID));
		}
		
		/// <summary>
		/// Return an IQueryable of AGSRoleEmailTrigger given the parameters provided.
		/// </summary>
		/// <param name="roleID">The RoleID to match.</param>
		/// <returns>An IQueryable of AGSRoleEmailTrigger</returns>
		public static IQueryable<AGSRoleEmailTrigger> GetQueryByRoleID(int roleID)
		{
			return Query.Where(a => a.RoleID == roleID);
		}
		
		/// <summary>
		/// Return a sequence of ints given the parameters provided.
		/// </summary>
		/// <param name="role">The Role to match.</param>
		/// <returns>A sequence of ints</returns>
        public static IEnumerable<int> GetAllIDsByRole(Role role)
        {
			if (role == null)
			{
				throw new ArgumentNullException("role");
			}
			else if (!role.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "role");
			}
			return GetAllIDsByCompiledQuery(() => CompiledQuery_RoleID(role.ID), string.Concat("RoleID=", role.ID));
        }
		
		
		/// <summary>
		/// Return a sequence of AGSRoleEmailTriggers given the parameters provided.
		/// </summary>
		/// <param name="role">The Role to match.</param>
		/// <returns>A sequence of AGSRoleEmailTriggers</returns>
        public static IEnumerable<AGSRoleEmailTrigger> GetAllByRole(Role role)
        {
			if (role == null)
			{
				throw new ArgumentNullException("role");
			}
			else if (!role.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "role");
			}
			return GetAllByCompiledQuery(() => CompiledQuery_RoleID(role.ID), string.Concat("RoleID=", role.ID));
        }
		
		
		/// <summary>
		/// Return whether one or more AGSRoleEmailTriggers are found, given the parameters provided.
		/// </summary>
		/// <param name="role">The Role to match.</param>
		/// <returns>True if any amount of AGSRoleEmailTriggers are found, otherwise false</returns>
		public static bool AnyByRole(Role role)
		{
			if (role == null)
			{
				throw new ArgumentNullException("role");
			}
			else if (!role.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "role");
			}
			return AnyByCompiledQuery(() => CompiledExistsQuery_RoleID(role.ID), string.Concat("RoleID=", role.ID));
		}
		
		/// <summary>
		/// Return the number of AGSRoleEmailTriggers found, given the parameters provided.
		/// </summary>
		/// <param name="role">The Role to match.</param>
		/// <returns>The amount of AGSRoleEmailTriggers that are found, 0 if none are found.</returns>
		public static int CountByRole(Role role)
		{
			if (role == null)
			{
				throw new ArgumentNullException("role");
			}
			else if (!role.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "role");
			}
			return CountByCompiledQuery(() => CompiledCountQuery_RoleID(role.ID), string.Concat("RoleID=", role.ID));
		}
		
		/// <summary>
		/// Return an IQueryable of AGSRoleEmailTrigger given the parameters provided.
		/// </summary>
		/// <param name="role">The Role to match.</param>
		/// <returns>An IQueryable of AGSRoleEmailTrigger</returns>
		public static IQueryable<AGSRoleEmailTrigger> GetQueryByRole(Role role)
		{
			if (role == null)
			{
				throw new ArgumentNullException("role");
			}
			else if (!role.IsSavedToDatabase)
			{
				throw new ArgumentException("Must be saved to the database first.", "role");
			}
			return Query.Where(a => a.RoleID == role.ID);
		}
		
		protected override IEnumerable<Tuple<bool, string>> DataAccessorCacheKeys
		{
			get
			{
				yield return Tuple.Create(true, string.Concat("RoleID=", RoleID));
			}
		}
		
        #endregion

		#region Relations
		/// <summary>
		/// The Role of the current AGSRoleEmailTrigger.
		/// This is just an accessor around RoleID.
		/// </summary>
		public Role Role
		{
			get
			{
                return this.GetRelatedEntity<Role>(a => a.RoleID);
			}
            set
            {
				if (value == null)
				{
                    throw new ArgumentNullException("value");
				}
				else if (!value.IsSavedToDatabase)
				{
					Role detached = value;
					AddTemporaryOnSaving(() => {
						if (!detached.IsSavedToDatabase)
						{
							throw new InvalidOperationException("Role must be saved to the database before saving this AGSRoleEmailTrigger.");
						}
						RoleID = detached.ID;
					});
				}
                else
                {
                    RoleID = value.ID;
                }
            }
		}
		
		#endregion
		
		#region Queries
		
		/// <summary>
		/// Get an IQueryable for all EntityRoleRequirements whose EntityTypeID and EntityID match the current AGSRoleEmailTrigger.
		/// </summary>
		public IQueryable<EntityRoleRequirement> RoleRequirementQuery
		{
			get
			{
				return EntityRoleRequirement.GetQueryByEntityTypeIDAndEntityID(AGSRoleEmailTrigger.ModelTypeID, this.ID);				
			}
		}
		
		/// <summary>
		/// Get an IQueryable for all UserAchievements whose EntityTypeID and EntityID match the current AGSRoleEmailTrigger.
		/// </summary>
		public IQueryable<UserAchievement> AchievementsEearnedForEntity
		{
			get
			{
				return UserAchievement.GetQueryByEntityTypeIDAndEntityID(AGSRoleEmailTrigger.ModelTypeID, this.ID);				
			}
		}
		
		/// <summary>
		/// Get an IQueryable for all VotingFraudNotifications whose EntityTypeID and EntityID match the current AGSRoleEmailTrigger.
		/// </summary>
		public IQueryable<VotingFraudNotification> VotingFraudNotificationQuery
		{
			get
			{
				return VotingFraudNotification.GetQueryByEntityTypeIDAndEntityID(AGSRoleEmailTrigger.ModelTypeID, this.ID);				
			}
		}
		
		protected override IEnumerable<string> GetRelationCacheKeys(AGSRoleEmailTrigger original)
		{
			return Enumerable.Empty<string>();
		}
		
		#endregion
        


        #region Model Materialization
		
		protected override void Materialize(IDataReader reader)
		{
			this._id = (int)reader.GetValue(0);
			this._roleID = (int)reader.GetValue(1);
		}
		#endregion
		

	}
}
