﻿using System;
using System.Collections.Generic;
using Curse.Cobalt.Models;
using Curse.Cobalt.RoleAssignments;
using Curse.Cobalt.Users;

namespace Curse.AGS.Roles
{
    public class BulkRoleAssigner : IBulkRoleAssigner
    {
        private readonly IUserRepository _userRepository;
        private readonly IRoleAssignmentRepository _roleAssignmentRepository;
        private readonly BulkRoleAssignmentResult _bulkRoleAssignmentResult;
        public BulkRoleAssigner(IRoleAssignmentRepository roleAssignmentRepository, IUserRepository userRepository)
        {
            _roleAssignmentRepository = roleAssignmentRepository;
            _userRepository = userRepository;
            _bulkRoleAssignmentResult = new BulkRoleAssignmentResult();
        }

        public BulkRoleAssignmentResult BulkAssignRoles(IEnumerable<int> cobaltUserIDs, IEnumerable<IRole> rolesToAssign, ISite site)
        {
            if (site == null)
            {
                throw new ArgumentNullException(nameof(site));
            }

            foreach (var cobaltUserID in cobaltUserIDs ?? new int[0])
            {
                var userToAssign = _userRepository.GetUserByID(cobaltUserID);
                foreach (var role in rolesToAssign ?? new IRole[0])
                {
                    if (_roleAssignmentRepository.IsUserAssignedToARole(userToAssign, site, role))
                    {
                        _bulkRoleAssignmentResult.FailedRoleAssignments.Add($"{userToAssign.Username} is already assigned to '{role.Name}'.");
                        continue;
                    }

                    AssignRole(userToAssign, role, site);
                }
            }

            return _bulkRoleAssignmentResult;
        }

        private void AssignRole(IUser user, IRole role, ISite site)
        {
            _roleAssignmentRepository.AssignUserToARole(user, site, role);
            _bulkRoleAssignmentResult.SuccessfulRoleAssignments.Add($"{user.Username} has been assigned to '{role.Name}'");
        }
    }
}
