﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Cobalt.Identification;
using Curse.Cobalt.Users;

namespace Curse.AGS.Users
{
    public class BulkUserCreator : IBulkUserCreator
    {
        private readonly IUserCreator _userCreator;
        private readonly IExternalUserIdentifier _externalUserIdentifier;
        private readonly BulkUserCreateResult _bulkUserCreateResult = new BulkUserCreateResult();

        public BulkUserCreator(IUserCreator userCreator, IExternalUserIdentifier externalUserIdentifier)
        {
            _userCreator = userCreator;
            _externalUserIdentifier = externalUserIdentifier;
        }

        public BulkUserCreateResult BulkCreateUsers(IEnumerable<UserToCreate> usersToImport)
        {
            if (usersToImport.Any())
            {
                foreach (var user in usersToImport)
                {
                    var cobaltUserID = CreateUser(user);
                    if (cobaltUserID == null)
                    {
                        continue;
                    }

                    _bulkUserCreateResult.CobaltUserIDs.Add((int) cobaltUserID);
                }
            }
            else
            {
                _bulkUserCreateResult.FailedImports.Add("There are no users to import. Be sure the CSV file is formatted correctly.");
            }

            return _bulkUserCreateResult;
        }

        private int? CreateUser(UserToCreate user)
        {
            var idresult = _externalUserIdentifier.IdentifyExternalUser(user.UserID, 2);
            if (idresult.IsIdentified)
            {
                _bulkUserCreateResult.FailedImports.Add($"{user.Username} already exists. Skipping import.");
                return idresult.UserID;
            }

            try
            {
                var cobaltUser = _userCreator.CreateUser(user.Username, string.Empty, user.UserID, 2);
                _bulkUserCreateResult.SuccessfulImports.Add(user.Username);
                return cobaltUser.ID;
            }
            catch (Exception ex)
            {
                _bulkUserCreateResult.FailedImports.Add($"Failed to import '{user.Username}'. {ex.Message}");
                return null;
            }
        }
    }
}
