﻿using System;
using System.Collections.Generic;
using System.IO;
using Curse.AGS.FileReaders;
using Curse.AGS.Roles;
using Curse.Cobalt.Models;

namespace Curse.AGS.Users.Importers
{
    public class AGSAlphaUserImporter : IUserImporter
    {
        private readonly IFileReader _fileReader;
        private readonly IBulkUserCreator _bulkUserCreator;
        private readonly IBulkRoleAssigner _bulkRoleAssigner;
        private readonly UserImportResult _alphaUserImportResult = new UserImportResult();

        public AGSAlphaUserImporter(IFileReader csvReader, IBulkUserCreator bulkUserCreator, IBulkRoleAssigner bulkRoleAssigner)
        {
            _fileReader = csvReader;
            _bulkUserCreator = bulkUserCreator;
            _bulkRoleAssigner = bulkRoleAssigner;
        }
        public UserImportResult ImportAndAssignRoles(Stream stream, IEnumerable<IRole> roles, ISite site)
        {
            if (stream == null)
            {
                throw new ArgumentNullException(nameof(stream));
            }

            if (site == null)
            {
                throw new ArgumentNullException(nameof(site));
            }

            var csvReaderResult = _fileReader.ReadFileDataFromStream<UserToCreate>(stream);
            if (!csvReaderResult.Succeeded)
            {
                _alphaUserImportResult.ImportSucceeded = false;
                _alphaUserImportResult.Message = csvReaderResult.Message;
                return _alphaUserImportResult;
            }

            _alphaUserImportResult.BulkUserCreateResult = _bulkUserCreator.BulkCreateUsers(csvReaderResult.Result);
            _alphaUserImportResult.BulkRoleAssignmentResult = _bulkRoleAssigner.BulkAssignRoles(_alphaUserImportResult.BulkUserCreateResult.CobaltUserIDs, roles, site);
            return _alphaUserImportResult;
        }
    }
}
