---
title: A. Basics
---

## Best Practices
- Tests should be in a `*_test` package – for example, `package server_test` would contain tests for `package server`.
This forces you not to have any hard coupling between your tests and the unexported internals of your packages.
- Tests for file `filename.go` should be contained in `filename_test.go`.
- We do not require 100% test coverage (or have any strict number required) but expect every new method to be unit tested in some manner.
- Do not use testing libraries like Goconvey or Testify/Suite.
They overcomplicate testing and make adding new tests or updating old ones burdensome.
Instead, use only the stdlib testing library, and make liberal use of table-driven tests (examples to follow).
- Only use **one** of [testify/require](https://pkg.go.dev/github.com/stretchr/testify/require) or
[testify/assert](https://pkg.go.dev/github.com/stretchr/testify/assert).
Prefer using **require**, as tests often exhibit undefined behavior after passing a failure case,
making it easier to debug issues if the test errors out immediately at the first failure.

## Fake Redis, Dynamo

For Redis and DynamoDB specifically, we have found excellent libraries that can provide fully-featured in-memory
versions of these databases for use in tests. See:
- [go_test_dynamo](https://git.xarth.tv/common/go_test_dynamo)
- [miniredis](https://github.com/alicebob/miniredis)

These libraries should be used wherever possible, as they make your unit tests much more robust.
For example, you will be able to actually unit test your DynamoDB conditional update logic,
or your Redis LUA script logic.

The one scenario where you would want to use a [Counterfeiter Fake](../fakes) instead of miniredis/go_test_dynamo
is when you need to test unexpected error cases. For example, if your service code reads:
```go
item, err := c.Redis.Get(ctx, key)
if err != nil {
    return err
}
```
You may wish to use a **Fake** Redis instead of Miniredis, so that you can do something like:
```go
fakeRedis.GetReturns("", errors.New("err"))
```