package helpers

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.AntBuildStep

open class PortableScriptBuildStep() : AntBuildStep() {
    constructor(init: helpers.PortableScriptBuildStep.() -> Unit): this() {
        init()
    }

    var entryPoint by stringParameter("entryPoint")
    var scriptContent by stringParameter("scriptContent")
}

fun BuildSteps.portableScript(init: helpers.PortableScriptBuildStep.() -> Unit): PortableScriptBuildStep {
    val result = PortableScriptBuildStep(init)

    if (result.workingDir == null) {
        result.workingDir = ""
    }

    result.mode = result.antScript {
        content = """
                <project name="Portable Executor">
                <tempfile property="temp.config.file"/>
                <echo message="Temp File is at: ${'$'}{temp.config.file}"/>

                <target name="write-file">
                    <echo message="Writing Script Content to Temp File"/>
                    <echo file="${'$'}{temp.config.file}/">
                        <![CDATA[${result.scriptContent}]]>
                    </echo>
                </target>

                <target name="Execute" depends="write-file">
                    <echo message="Executing ${result.entryPoint} ${'$'}{temp.config.file} in: ${result.workingDir}"/>
                    <exec executable="${result.entryPoint}" dir="${result.workingDir}" failonerror="true">
                        <arg line="${'$'}{temp.config.file}"/>
                    </exec>
                </target>

                </project>
            """.trimIndent()
    }
    result.targets = "Execute"
    step(result)
    return result
}
