package helpers

import jetbrains.buildServer.configs.kotlin.v2018_2.*

val requireWindows: Requirements.() -> Unit = {
    contains("teamcity.agent.jvm.os.name", "Windows")
}

val requireMacOS: Requirements.() -> Unit = {
    contains("teamcity.agent.jvm.os.name", "Mac OS X")
}

val requireLinux: Requirements.() -> Unit = {
    contains("teamcity.agent.jvm.os.name", "Linux")
}

val requireNix: Requirements.() -> Unit = {
    doesNotContain("teamcity.agent.jvm.os.name", "Windows")
}

val requireAndroidSDK: Requirements.() -> Unit = {
    equals("env.ANDROIDSDK_AGENT", "1") 
}

val requireTvOS: Requirements.() -> Unit = {
    equals("env.TVOS_AGENT", "1")
}

val requireUWPSDK: Requirements.() -> Unit = {
    equals("env.UWP_AGENT", "1")
}

val requirePS4SDK: Requirements.() -> Unit = {
    equals("env.PS4SDK_AGENT", "1")
}

val requireVS2015: Requirements.() -> Unit = {
    equals("env.VS2015_AGENT", "1")
}

val requireVS2017: Requirements.() -> Unit = {
    equals("env.VS2017_15_8_AGENT", "1")
}

fun BuildType.windowsNpmPathLengthLimitWorkaround() {
    // workaround due to lack of long path support in npm and node-gyp
    vcs {
        checkoutDir = "c:\\tc\\%teamcity.build.default.checkoutDir%"
    }
}
