package helpers

import java.io.File
import jetbrains.buildServer.configs.kotlin.v2018_2.*
import jetbrains.buildServer.configs.kotlin.v2018_2.buildFeatures.CommitStatusPublisher
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.ExecBuildStep
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.ScriptBuildStep
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.exec
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.powerShell
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.script
import jetbrains.buildServer.configs.kotlin.v2018_2.triggers.finishBuildTrigger
import jetbrains.buildServer.configs.kotlin.v2018_2.triggers.schedule
import jetbrains.buildServer.configs.kotlin.v2018_2.vcs.GitVcsRoot
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.builds.initializeBuildChain

val projectBranchSpecification: ParametrizedWithType.() -> Unit = {
    text("git.branch_spec", """
                    +:refs/heads/(*)
                    +:refs/heads/(releases/*)
                    +:refs/(pull/*)/head
                """.trimIndent(), display = ParameterDisplay.HIDDEN)
}

val pullRequestFilter = "+:pull/*"

val initBuildParams: ParametrizedWithType.() -> Unit = {
    text("build.author", "", display = ParameterDisplay.HIDDEN)
    text("build.version", "", display = ParameterDisplay.HIDDEN)
    text("build.version.base", "", display = ParameterDisplay.HIDDEN)
    text("build.version.patch", "", display = ParameterDisplay.HIDDEN)
    text("git.commit.short", "", display = ParameterDisplay.HIDDEN)
}


val windowsParams: ParametrizedWithType.() -> Unit = {
    text("env.SANDSTORM_NO_CREDENTIALS_PROFILE", "", display = ParameterDisplay.HIDDEN, allowEmpty = true)
    text("env.USE_AWS_INSTANCE_PROFILE", "", display = ParameterDisplay.HIDDEN, allowEmpty = true)
}


val buildSdkAndTest: BuildSteps.() -> Unit = {
    exec {
        name = "SDK Build and Test".trim()
        workingDir = ""
        path = "python"
        arguments = "teamcity/build.py --build-type=commit --platform=win32"
    }
}


val clangFormatTest: BuildSteps.() -> Unit = {
    exec {
        name = "Clang Format Test"
        workingDir = ""
        path = "/bin/bash"
        arguments = """
                    -c "apt-get update && apt-get -y install python3 clang-format-7 git && shopt -s globstar && \
                    alias clang-format-7='clang-format' && \
                    python teamcity/clang-format-test.py"
                """.trimIndent()
        dockerImage = "debian:buster"
        dockerImagePlatform = ExecBuildStep.ImagePlatform.Linux
    }
}
