#!/usr/bin/env ruby
# frozen_string_literal: true

tag = `git describe --abbrev=0 --tags 2> /dev/null`.strip
hash = `git rev-parse HEAD 2> /dev/null`.strip[0..6]
platform = "%build.platform%"
buildNumber = "%build.counter%"

version = "#{tag}-#{buildNumber}-#{hash}"

puts "##teamcity[setParameter name='git.version' value='#{version}']"
puts "##teamcity[setParameter name='git.commit.short' value='#{hash}']"
puts "##teamcity[buildNumber '#{version}']"
