import helpers.*
import jetbrains.buildServer.configs.kotlin.v2018_2.*
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.exec
import jetbrains.buildServer.configs.kotlin.v2018_2.vcs.GitVcsRoot
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.build.features.githubStatusPublisher
import twitch.instrumentorum.project.builds.initializeBuildChain

version = "2018.2"

instrum {
    description = "SDK"

    sourceRoot("git@git.xarth.tv:sdk/sdk.git")

    params(projectBranchSpecification)

    subInstrum("Windows", "Windows") {

        val prefix = "windows"

        params {
            text("build.platform", "windows", display = ParameterDisplay.HIDDEN)
        }

        initializeBuildChain {
            requirements(requireNix)
        }

        buildGroup(parallel = true) {
            build("Tests") {
                requirements(requireLinux)
                vcsTrigger { branchFilter = pullRequestFilter }

                githubStatusPublisher()

                steps(clangFormatTest)
            }

            build("Build") {
                requirements(requireWindows)
                requirements(requireVS2017)
                vcsTrigger { branchFilter = pullRequestFilter }

                githubStatusPublisher()
                windowsNpmPathLengthLimitWorkaround()

                steps(buildSdkAndTest)
            }
        }
    }
}
