import os
import build_types
import cmake

class AndroidPlatformSettings:

    def __init__(self):
        self.name = 'android'
        self.shared_lib_extension = '.so'
        self.static_lib_extension = '.a'
        self.min_cmake_version= '3.6.0'

    def requires_monolithic_project(self, options):
        return False

    def link_against_openssl(self, options, fragment):
        # TODO: Link against openssl on android if needed someday
        pass

    def add_platform_preprocessor_definitions(self, options, fragment):
        fragment.add_preprocessor_definition('TTV_INCLUDE_CPPTRANSITIONS')

    def get_cmake_custom_properties(self, options, output_object):
        return {
        }

    def read_cmake_previous_cmakelists_file(self, cmakelists_path):
        """Reads and parses the previous CMake lists file to retain any properties."""
        pass

    def get_c_flags(self, options):
        """Returns platform-specific C compiler flags."""
        flags = {
            'common': [
                '-std=c++14',
                '-g',
                '--serialize-diagnostics',
                '-fmessage-length=0',
                # Enabled Warnings
                '-pedantic',
                '-Wall',
                '-Weverything',
                # Disabled Warnings
                '-Wno-missing-noreturn',
                '-Wno-exit-time-destructors',
                '-Wno-undef',
                '-Wno-c++98-compat-pedantic',
                '-Wno-padded',
                '-Wno-global-constructors',
                '-Wno-covered-switch-default',
                '-Wno-switch-enum',
                '-Wno-weak-vtables',
                '-Wno-documentation',
                '-Wno-documentation-unknown-command',
                '-Wno-deprecated-declarations',
                '-Wno-reserved-id-macro',
                '-Wno-shift-sign-overflow',
                '-Wno-unused-macros',
                '-Wno-unused-member-function',
                '-Wno-missing-prototypes'
            ],
            'debug': [],
            'release': []
        }

        return flags

    def get_static_library_linker_flags(self, options):
        flags = {
            'common': []
        }

        return flags

    def get_dynamic_library_linker_flags(self, options):
        flags = {
            'common': []
        }

        return flags

    def get_executable_linker_flags(self, options):
        flags = {
            'common': []
        }

        return flags

    def write_symbol_exports_file(self, path_prefix, symbols):
        # TODO: Implement symbol exports if needed
        pass

    def get_cmake_custom_params(self, config):
        """Retrieves any custom parameters to pass to CMake"""
        return []

    def create_build_generator(self, options):
        return cmake.CMakeBuildGenerator()

    def write_cmake_custom(self, file, options, project_name):
        pass

    def write_cmake_precompiled_headers(self, file, module, output_object):
        # TODO: Implement precompiled headers in Xcode
        pass

    def sort_cmake_libraries(self, list):
        """Given a flat list of dependencies this sorts them into categories so they can be added properly by CMake"""
        result = {
            'external': [],
            'system': [
                'log',
                'atomic'
            ]
        }

        for x in list:
            if x.startswith('-'):
                result['system'].append(x)
            else:
                result['external'].append(x)

        return result

    def post_process_generated_files(self, directory, options):
        pass

def get_platform_settings():
    return AndroidPlatformSettings()

