#Language Binding Generation Tools

##Environment Setup
* Install Python 2.7
* Build CastXML from source and add it to your path
    * https://github.com/CastXML/CastXML
* Install pygccxml
    * You need to fix the pygccxml source in one place in version 1.7.5 that was tested on Windows.  This fix may not be relevant on other platforms.
    * https://sourceforge.net/p/pygccxml/bugs/37/
    * Update pygccxml\parser\source_reader.py as follows:
        ```
         def __produce_full_file(self, file_path):
             if os.name in ['nt', 'posix']:
                 file_path = file_path.replace(r'\/', os.path.sep)
             file_path = os.path.abspath(file_path)                 <--------- This line added
             if os.path.isabs(file_path):
                 return file_path
             try:
                 abs_file_path = os.path.realpath(
                     os.path.join(
                         self.__config.working_directory,
                         file_path))
                 if os.path.exists(abs_file_path):
                     return os.path.normpath(abs_file_path)
                 return file_path
             except Exception:
                 return file_path
        ```

##Common Command Line Options
* ```--language=<language>```: Specifies the target language to generate bindings for.  This is used to determine which Python module to load dynamically.
* ```--mapping-config=<path>```: Specifies a path to a configuration file that contains types that should be parsed and loaded but not generated in this run.  This is is needed when a module depends on another module (such as core).
* ```--generate-config=<path>```: Specifies a path to a configuration file that contains types to be generated in this execution.
* ```--pch-path=<path>```: Optional and specifies the precompiled header file to include at the top of generated native .cpp files.



##Generating bindings for a module
Configuration files are needed
NOTE: On Windows you will need to run ```vcvarsall.bat``` before running the bindings generation script.  Something like ```"C:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat"``` will work, depending on your version of Visual Studio installed.


```generate_bindings.py --language=java --mapping-config=X:\modules\core\build\bindings\core.bindings.config.json --generate-config=X:\modules\core\core_java\java.core.bindings.config.json --pch-path="twitchsdk/core/internal/pch.h"```
```generate_bindings.py --language=cx --mapping-config=X:\modules\core\build\bindings\core.bindings.config.json --generate-config=X:\modules\core\core_cx\cx.core.bindings.config.json --pch-path="twitchsdk/core/internal/pch.h"```

##Generating the test bindings
There are simple header files which demonstrate the basics of generating bindins for a target language.  They can be run as shown below.

```
generate_bindings.py --language=<language> --generate-config=X:\build\tools\bindings\test\struct.json
generate_bindings.py --language=<language> --generate-config=X:\build\tools\bindings\test\class.json
generate_bindings.py --language=<language> --generate-config=X:\build\tools\bindings\test\union.json
generate_bindings.py --language=<language> --generate-config=X:\build\tools\bindings\test\interface.json
generate_bindings.py --language=<language> --generate-config=X:\build\tools\bindings\test\interface_adapter.json
```
