import abc
import imp
import os
from pprint import pprint

import common.configuration
import common.native_tools


def blah():

    # Determine if we need to use any interface adapters
    native_type_names = {
        "native_types": [],
        "uses_collections": False
    }
    self.gather_native_types(self.type_info, native_type_names)
    native_type_names = native_type_names["native_types"]

    self.interface_adapters = []
    for native_type_name in native_type_names:
        adapter_mapping = self.config.find_interface_adapter(native_type_name)
        if adapter_mapping:
            self.interface_adapters.append(adapter_mapping)


    def get_header_field_lines(self):

        # Get dynamic fields
        lines = cx.common.CxCommonGenerator.get_header_field_lines(self)

        # We keep a reference to the native type
        components = common.native_tools.get_native_type_name_components(self.type_info.type_name)
        line = '::std::shared_ptr<' + self.type_info.type_name + '> m' + components["name"] + ';'
        lines.append(line)

        return lines


    def get_source_method_implementation_lines(self, method_type_info, explicit_body_lines=None, prepend_lines=[], append_lines=[]): # CppClass

        components = common.native_tools.get_native_type_name_components(self.type_info.type_name)

        lines = []

        line = self.get_binding_method_line(method_type_info, is_declaration=False)
        lines.append(line)
        lines.append('{')

        if not explicit_body_lines:
            def get_native_arg_name(arg):
                return '_native_' + arg.name

            # Explicit lines to tack onto the beginning of the function
            if prepend_lines:
                lines.extend(map(lambda x: self.config.indent + x, prepend_lines))
                if len(prepend_lines) > 0:
                    lines.append('')

            native_arg_names = []
            native_impl_var_name = 'm' + components['name']

            # Convert binding types to native types
            for arg_type in method_type_info.arguments:

                native_arg_name = get_native_arg_name(arg_type)
                native_arg_names.append(native_arg_name)
                self.write_convert_binding_input_variable_to_native(arg_type, native_arg_name, lines)

                lines.append('')

            line = self.config.indent

            # Invoke the native method
            self.write_invoke_native_method(method_type_info, native_arg_names, '_native_return_value', native_impl_var_name, lines)

            # Convert native output variables to binding values
            if len(method_type_info.arguments) > 0:
                lines.append('')
                for index, arg_type in enumerate(method_type_info.arguments):
                    if arg_type.out_param:
                        self.write_convert_native_output_variable_to_binding(arg_type, native_arg_names[index], lines)

            # NOTE: Free functions are specific to the context and needs to be specified explicitly using snippets

            # Convert the return value
            if method_type_info.return_type:
                self.write_binding_return_value(method_type_info, '_native_return_value', lines)

            # Explicit lines to tack onto the end of the function (before the return)
            if append_lines:
                if len(append_lines) > 0:
                    lines.append('')
                lines.extend(map(lambda x: self.config.indent + x, append_lines))

            # Return from the function
            if method_type_info.return_type:
                # Return from the function
                lines.append('')
                lines.append( self.config.indent + 'return _binding_return_value;')

        else:
            explicit_body_lines = map(lambda x: self.config.indent + x, explicit_body_lines)
            lines.extend(explicit_body_lines)

        lines.append('}')

        return lines


    def get_native_param_type_name(self, arg_type_info):
        type_name = ''
        if arg_type_info.template_info:
            # Reconstruct the template and args
            type_name = arg_type_info.template_info.template_name + '<'
            for index, arg in enumerate(arg_type_info.template_info.template_args):
                template_param_type_name = self.binding_generator.strip_native_type_modifiers(arg)
                # Fix up strings
                if template_param_type_name == '::std::basic_string':
                    template_param_type_name = '::std::string'

                if index > 0:
                    type_name = type_name + ', '
                type_name = type_name + template_param_type_name

            type_name = type_name + '>'
        else:
            type_name = self.binding_generator.strip_native_type_modifiers(arg_type_info.type_name, remove_ref=True)

        return type_name


    def write_invoke_native_method(self, method_type_info, native_arg_names, native_return_value_var_name, native_impl_var_name, lines):

        line = self.config.indent

        # Return value if non-void
        if method_type_info.return_type:
            line = line + method_type_info.return_type.type_name + ' ' + native_return_value_var_name + ' = '

        # Invoke the native method
        line = line + native_impl_var_name + '->'
        line = line + method_type_info.name + '('
        for index, arg_type in enumerate(method_type_info.arguments):
            if index > 0:
                line = line + ', '
            line = line + native_arg_names[index]
        line = line + ');'
        lines.append(line)


    def write_convert_binding_input_variable_to_native(self, arg_type, native_arg_name, lines):

        # Convert binding type to native type
        native_type_name = self.get_native_param_type_name(arg_type)
        if not arg_type.out_param:
            native_type_name = self.binding_generator.strip_native_type_modifiers(native_type_name)

        lines.append( self.config.indent + native_type_name + ' ' + native_arg_name + ';' )

        if not arg_type.out_param:
            lines.append( self.config.indent + 'ToNative(&' + arg_type.name + ', &' + native_arg_name + ');' )


    def write_convert_native_output_variable_to_binding(self, arg_type, native_arg_name, lines):
        # Convert output values to binding types
        take_native_address = ''
        take_binding_address = ''
        if not self.binding_generator.is_pointer_type(arg_type.type_name):
            take_native_address = '&'
        if not arg_type.out_param:
            take_binding_address = '&'

        lines.append( self.config.indent + 'ToBinding(' + take_native_address + native_arg_name + ', ' + take_binding_address + arg_type.name + ');' )


    def write_binding_return_value(self, method_type_info, native_return_value_var_name, lines):
        # Convert the return type
        lines.append('')
        lines.append( self.config.indent + self.determine_target_type_name_from_variable(method_type_info.return_type, None) + ' _binding_return_value;')
        lines.append( self.config.indent + 'ToBinding(&' + native_return_value_var_name + ', &_binding_return_value);')


    def update(self, template_name, lines):

        # Header file
        if template_name == 'class.cx.h.template':
            lines = self.update_header_file(lines)

        # Source file
        elif template_name == 'class.cx.cpp.template':
            lines = self.update_source_file(lines)

        return lines


    def update_header_file(self, lines):

        # Binding includes
        includes_result = self.gather_header_binding_includes()
        includes = includes_result['includes']
        exclude_mappings = includes_result['included_mappings']

        # Native includes
        header_path = self.type_mapping.context.get_include_path_relative_header(self.type_info.location.header)
        includes.append('#include "' + header_path + '"')

        # shared_ptr
        includes.append('#include <memory>')

        includes.sort()
        lines = self.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

        # Forward declarations
        forward_delaration_lines = self.get_forward_declaration_lines(explicit_target_type_mappings=self.interface_adapters, exclude_type_mappings=exclude_mappings)
        lines = self.file_utils.replace_lines_range('FORWARD_DECLARATIONS', lines, forward_delaration_lines, indent=self.config.indent, must_exist=True)

        # Fields
        replacement_lines = self.get_header_field_lines()
        lines = self.file_utils.replace_lines_range('FIELDS', lines, replacement_lines, indent=self.config.indent)

        # Constructor
        replacement_lines = self.type_mapping.load_custom_value_as_file_path('header.constructors', None)
        if not replacement_lines:
            if self.type_mapping.create_native_in_constructor:
                replacement_lines = [
                    "public: <<SHORT_TYPE_NAME>>();",
                ]
            else:
                replacement_lines = [
                    "internal: <<SHORT_TYPE_NAME>>(::std::shared_ptr<" + self.type_info.type_name + "> impl);",
                ]
            replacement_lines = self.fill_template_common(replacement_lines)

        lines = self.file_utils.replace_lines_range('CONSTRUCTOR', lines, replacement_lines, indent=self.config.indent)

        # Methods
        replacement_lines = self.get_header_binding_method_lines(methods=self.all_methods, virtual_method_names=self.virtual_method_names)

        # Custom methods
        custom_methods = self.type_mapping.load_custom_value_as_file_path('header.extra_methods', [])
        replacement_lines.extend(custom_methods)

        lines = self.file_utils.replace_lines_range('METHODS', lines, replacement_lines, indent=self.config.indent)

        return lines


    def update_source_file(self, lines):

        # Binding includes
        includes = self.gather_source_binding_includes(explicit_target_type_mappings=self.interface_adapters)['includes']
        includes.append('#include "twitchsdk/core/cx_coreutil.h"')

        includes.sort()

        # Precompiled header
        if self.config.precompiled_header_path:
            includes.insert(0, '#include "' + self.config.precompiled_header_path + '"')

        lines = self.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

        # Using namespace
        lines = self.file_utils.replace_lines_range('USING_NAMESPACE', lines, ['using namespace ttv::binding::cx;'], indent=self.config.indent, must_exist=False)

        # Constructor
        replacement_lines = self.type_mapping.load_custom_value_as_file_path('source.constructors', None)
        if not replacement_lines:
            if self.type_mapping.create_native_in_constructor:
                replacement_lines = [
                    "<<FULL_TYPE_NAME>>::<<SHORT_TYPE_NAME>>()",
                    "{",
                    "    m<<SHORT_TYPE_NAME>> = std::make_shared<<<NATIVE_TYPE_NAME>>>();",
                    "}"
                ]
            else:
                replacement_lines = [
                    "<<FULL_TYPE_NAME>>::<<SHORT_TYPE_NAME>>(::std::shared_ptr<" + self.type_info.type_name + "> impl)",
                    ": m<<SHORT_TYPE_NAME>>(impl)",
                    "{",
                    "}"
                ]

        replacement_lines = self.fill_template_common(replacement_lines)

        lines = self.file_utils.replace_lines_range('CONSTRUCTOR', lines, replacement_lines, indent=self.config.indent)

        # Methods
        all_method_lines = []

        custom_method_implementations = self.type_mapping.get_custom_value('source.method_implementations', {})
        prepend_method_implementations = self.type_mapping.get_custom_value('source.prepend_methods', {})
        append_method_implementations = self.type_mapping.get_custom_value('source.append_methods', {})

        for method_type_info in self.all_methods:

            if self.export_method_names is None or method_type_info.name in self.export_method_names:

                explicit_body_lines = None
                if method_type_info.name in custom_method_implementations:
                    explicit_body_lines = self.type_mapping.load_custom_value_as_file_path('source.method_implementations.' + method_type_info.name)

                prepend_lines = None
                if method_type_info.name in prepend_method_implementations:
                    prepend_lines = self.type_mapping.load_custom_value_as_file_path('source.prepend_methods.' + method_type_info.name)

                append_lines = None
                if method_type_info.name in append_method_implementations:
                    append_lines = self.type_mapping.load_custom_value_as_file_path('source.append_methods.' + method_type_info.name)

                method_lines = self.get_source_method_implementation_lines(method_type_info, explicit_body_lines=explicit_body_lines, prepend_lines=prepend_lines, append_lines=append_lines)

                all_method_lines.extend(method_lines)
                all_method_lines.append('')

        # Custom methods
        custom_methods = self.type_mapping.load_custom_value_as_file_path('source.extra_methods', [])
        all_method_lines.extend(custom_methods)

        lines = self.file_utils.replace_lines_range('METHODS', lines, all_method_lines, indent=self.config.indent, must_exist=False)

        return lines
