import abc
import imp
import os
from pprint import pprint

import common.configuration
import common.native_tools


def get_binding_impl_type(type_mapping):
    return type_mapping.target_base_class_mappings[0].target_type_name


def get_header_all_native_interface_method_declaration_lines(generator):
    """Get the native declaration lines so the class can implement the C++ interface methods."""

    lines = []

    # Declare the interface methods
    for interface_type_info in generator.native_interface_type_info_list:
        for method_type_info in interface_type_info.methods:
            line = common.native_tools.get_native_method_line(generator.type_mapping, method_type_info, is_declaration=True, is_virtual=True, is_override=True)
            lines.append(line)

    return lines


    # def get_source_method_implementation_lines(self, method_type_info, explicit_body_lines=None, prepend_lines=[], append_lines=[]): # CppClass

    #     components = common.native_tools.get_native_type_name_components(self.type_info.type_name)

    #     lines = []

    #     line = common.native_tools.get_native_method_line(self.type_mapping, method_type_info, is_declaration=False)
    #     lines.append(line)
    #     lines.append('{')

    #     if not explicit_body_lines:
    #         def get_binding_arg_name(arg):
    #             return '_binding_' + arg.name

    #         binding_arg_names = []
    #         binding_impl_var_name = 'mBindingImpl'

    #         # Explicit lines to tack onto the beginning of the function
    #         if prepend_lines:
    #             lines.extend(map(lambda x: self.config.indent + x, prepend_lines))
    #             if len(prepend_lines) > 0:
    #                 lines.append('')

    #         # Convert native types to binding types
    #         for arg_type in method_type_info.arguments:

    #             binding_arg_name = get_binding_arg_name(arg_type)
    #             binding_arg_names.append(binding_arg_name)
    #             self.write_convert_native_input_variable_to_binding(arg_type, binding_arg_name, lines)

    #             lines.append('')

    #         line = self.config.indent

    #         # Invoke the binding method
    #         self.write_invoke_binding_method(method_type_info, binding_arg_names, '_native_return_value', binding_impl_var_name, lines)

    #         # Convert native output variables to binding values
    #         if len(method_type_info.arguments) > 0:
    #             for index, arg_type in enumerate(method_type_info.arguments):
    #                 if arg_type.out_param:
    #                     lines.append('')
    #                     self.write_convert_binding_output_variable_to_native(arg_type, binding_arg_names[index], lines)

    #         # Convert the return value
    #         if method_type_info.return_type:
    #             self.write_native_return_value(method_type_info, '_native_return_value', lines)

    #         # Explicit lines to tack onto the end of the function (before the return)
    #         if append_lines:
    #             if len(append_lines) > 0:
    #                 lines.append('')
    #             lines.extend(map(lambda x: self.config.indent + x, append_lines))

    #         # Return from the function
    #         if method_type_info.return_type:
    #             lines.append('')
    #             lines.append( self.config.indent + 'return _native_return_value;')

    #     else:
    #         explicit_body_lines = map(lambda x: self.config.indent + x, explicit_body_lines)
    #         lines.extend(explicit_body_lines)

    #     lines.append('}')

    #     return lines


    # def get_binding_output_param_type_name(self, arg_type_info):
    #     type_name = ''
    #     if arg_type_info.template_info:
    #         type_name = arg_type_info.template_info.template_name + '<'
    #         for index, arg in enumerate(arg_type_info.template_info.template_args):
    #             native_type_name = self.binding_generator.strip_native_type_modifiers(arg)
    #             # Fix up strings
    #             if native_type_name == '::std::basic_string':
    #                 native_type_name = '::std::string'

    #             if index > 0:
    #                 type_name = type_name + ', '
    #             type_name = type_name + native_type_name

    #         type_name = type_name + '>'
    #     else:
    #         type_name = self.binding_generator.strip_native_type_modifiers(arg_type_info.type_name, remove_ref=True)

    #     return type_name


    # def write_convert_native_input_variable_to_binding(self, arg_type, binding_arg_name, lines):

    #     # Convert native type to binding type

    #     if arg_type.out_param:
    #         binding_type_name = self.get_native_output_param_type_name(arg_type)
    #     else:
    #         binding_type_name = self.determine_target_type_name_from_variable(arg_type)
    #         #binding_type_name = self.binding_generator.strip_native_type_modifiers(arg_type.type_name)

    #     # Declare the binding variable
    #     lines.append( self.config.indent + binding_type_name + ' ' + binding_arg_name + ';' )

    #     # Convert the value to binding type
    #     if not arg_type.out_param:
    #         lines.append( self.config.indent + 'ToBinding(&' + arg_type.name + ', &' + binding_arg_name + ');' )


    # def write_invoke_binding_method(self, method_type_info, binding_arg_names, binding_return_value_var_name, binding_impl_var_name, lines):

    #     line = self.config.indent

    #     # Return value if non-void
    #     if method_type_info.return_type:
    #         line = line + method_type_info.return_type.type_name + ' ' + binding_return_value_var_name + ' = '

    #     # Invoke the native method
    #     line = line + binding_impl_var_name + '->'
    #     line = line + method_type_info.name + '('
    #     for index, arg_type in enumerate(method_type_info.arguments):
    #         if index > 0:
    #             line = line + ', '
    #         line = line + binding_arg_names[index]
    #     line = line + ');'
    #     lines.append(line)


    # def write_convert_binding_output_variable_to_native(self, arg_type, binding_arg_name, lines):
    #     # Convert output values to binding types
    #     take_address = ''
    #     if not self.binding_generator.is_pointer_type(arg_type.type_name):
    #         take_address = '&'

    #     lines.append( self.config.indent + 'ToNative(' + take_address + binding_arg_name + ', &' + arg_type.name + ');' )


    # def write_native_return_value(self, method_type_info, binding_return_value_var_name, lines):
    #     # Convert the return type
    #     lines.append('')
    #     lines.append( self.config.indent + method_type_info.return_type.type_name + ' _native_return_value;')
    #     lines.append( self.config.indent + 'ToNative(&' + binding_return_value_var_name + ', &_native_return_value);')


    # def get_source_all_native_interface_method_implementation_lines(self):
    #     """Get the interface method implementation lines."""

    #     lines = []

    #     custom_method_implementations = self.type_mapping.get_custom_value('source.method_implementations', {})
    #     prepend_method_implementations = self.type_mapping.get_custom_value('source.prepend_methods', {})
    #     append_method_implementations = self.type_mapping.get_custom_value('source.append_methods', {})

    #     for x in self.native_interfaces:
    #         for method_type_info in x.methods:
    #             if self.export_method_names is None or method_type_info.name in self.export_method_names:

    #                 # Look for an explicity body
    #                 if method_type_info.name in custom_method_implementations:
    #                     explicit_body_lines = self.type_mapping.load_custom_value_as_file_path('source.method_implementations.' + method_type_info.name)
    #                 else:
    #                     explicit_body_lines = None

    #                 prepend_lines = None
    #                 if method_type_info.name in prepend_method_implementations:
    #                     prepend_lines = self.type_mapping.load_custom_value_as_file_path('source.prepend_methods.' + method_type_info.name)

    #                 append_lines = None
    #                 if method_type_info.name in append_method_implementations:
    #                     append_lines = self.type_mapping.load_custom_value_as_file_path('source.append_methods.' + method_type_info.name)

    #                 method_lines = self.get_source_method_implementation_lines(method_type_info, explicit_body_lines=explicit_body_lines, prepend_lines=prepend_lines, append_lines=append_lines)
    #                 lines.extend(method_lines)
    #                 lines.append('')

    #     return lines


    # def update(self, template_name, lines):

    #     # Header file
    #     if template_name == 'interfaceadapter.cx.h.template':
    #         lines = self.update_header_file(lines)

    #     # Source file
    #     elif template_name == 'interfaceadapter.cx.cpp.template':
    #         lines = self.update_source_file(lines)

    #     return lines


    # def update_header_file(self, lines):

    #     # Native includes
    #     includes = []
    #     header_path = self.type_mapping.context.get_include_path_relative_header(self.type_info.location.header)
    #     includes.append('#include "' + header_path + '"')

    #     # Custom includes
    #     custom = self.type_mapping.load_custom_value_as_file_path('header.includes', [])[:]
    #     for x in custom:
    #         if x not in includes:
    #             includes.append(x)

    #     # shared_ptr
    #     includes.append('#include <memory>')

    #     includes.sort()
    #     lines = self.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

    #     # Forward declarations
    #     forward_delaration_lines = self.get_forward_declaration_lines(explicit_target_type_mappings=[self.type_mapping])
    #     lines = self.file_utils.replace_lines_range('FORWARD_DECLARATIONS', lines, forward_delaration_lines, indent=self.config.indent, must_exist=True)

    #     # Constructor
    #     replacement_lines = self.type_mapping.load_custom_value_as_file_path('header.constructors', None)
    #     if not replacement_lines:
    #         replacement_lines = [
    #             'public: <<SHORT_TYPE_NAME>>(<<BINDING_TYPE_NAME>>^ impl);',
    #         ]
    #         replacement_lines = self.fill_template_common(replacement_lines)
    #         replacement_lines = self.file_utils.replace_all(replacement_lines, "<<BINDING_TYPE_NAME>>", self.type_mapping.target_base_class_mappings[0].target_type_name)

    #     lines = self.file_utils.replace_lines_range('CONSTRUCTOR', lines, replacement_lines, indent=self.config.indent)

    #     # Methods
    #     replacement_lines = self.get_header_methods()

    #     # Custom methods
    #     custom_methods = self.type_mapping.load_custom_value_as_file_path('header.extra_methods', [])
    #     replacement_lines.extend(custom_methods)

    #     lines = self.file_utils.replace_lines_range('METHODS', lines, replacement_lines, indent=self.config.indent)

    #     # Fields
    #     explicit_fields = [
    #         self.get_binding_impl_type() + ' mBindingImpl;'
    #     ]
    #     replacement_lines = self.get_header_field_lines(explicit_fields=explicit_fields)
    #     lines = self.file_utils.replace_lines_range('FIELDS', lines, replacement_lines, indent=self.config.indent)

    #     return lines


    # def update_source_file(self, lines):

    #     includes = []

    #     # Binding includes
    #     includes = self.gather_source_binding_includes()['includes']

    #     header_path = self.infer_output_file_path('interfaceadapter.cx.h.template')
    #     header_path = self.fixup_header_include_path(header_path)
    #     includes.append('#include "' + header_path + '"')

    #     # Custom includes
    #     custom = self.type_mapping.load_custom_value_as_file_path('source.includes', [])[:]
    #     for x in custom:
    #         if x not in includes:
    #             includes.append(x)

    #     includes.append('#include "twitchsdk/core/cx_coreutil.h"')

    #     includes.sort()

    #     # Precompiled header
    #     if self.config.precompiled_header_path:
    #         includes.insert(0, '#include "' + self.config.precompiled_header_path + '"')

    #     lines = self.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

    #     # Using namespace
    #     lines = self.file_utils.replace_lines_range('USING_NAMESPACE', lines, ['using namespace ttv::binding::cx;'], indent=self.config.indent, must_exist=False)

    #     # Constructor
    #     replacement_lines = self.type_mapping.load_custom_value_as_file_path('source.constructors', None)

    #     if not replacement_lines:
    #         replacement_lines = [
    #             "<<FULL_TYPE_NAME>>::<<SHORT_TYPE_NAME>>(<<BINDING_TYPE_NAME>>^ impl)",
    #             ": mBindingImpl(impl)",
    #             "{",
    #             "}"
    #         ]
    #         replacement_lines = self.fill_template_common(replacement_lines)
    #         replacement_lines = self.file_utils.replace_all(replacement_lines, "<<BINDING_TYPE_NAME>>", self.type_mapping.target_base_class_mappings[0].target_type_name)

    #     lines = self.file_utils.replace_lines_range('CONSTRUCTOR', lines, replacement_lines, indent=self.config.indent)

    #     # Methods
    #     all_method_lines = self.get_source_all_native_interface_method_implementation_lines()

    #     custom_methods = self.type_mapping.load_custom_value_as_file_path('source.extra_methods', [])
    #     all_method_lines.extend(custom_methods)

    #     lines = self.file_utils.replace_lines_range('METHODS', lines, all_method_lines, indent=self.config.indent, must_exist=False)

    #     return lines
