import abc
import imp
import os
from pprint import pprint

import common.file_utils
import common.configuration
import common.source_tools
import common.enum_utils
import cx.cx_type_generator_base


class CxEnumTypeGenerator(cx.cx_type_generator_base.CxTypeGeneratorBase):

    def __init__(self, binding_generator, type_mapping, type_info):
        cx.cx_type_generator_base.CxTypeGeneratorBase.__init__(self, binding_generator, type_mapping, type_info)


    def get_template_names(self):
        return [ 'enumeration.cx.h.template', 'enumeration.cx.cpp.template' ]


    def fill_template(self, lines):

        lines = self.fill_template_common(lines)

        # Create namespace scopes if needed
        lines = self.fill_template_namespace(lines)

        return lines


    def get_value_lines(self):

        lines = []

        for entry in self.type_info.values:

            line = entry.name + " = " + str(entry.value)

            if len(lines) < len(self.type_info.values) - 1:
                line += ",";

            lines.append(line)

        return lines;


    def update(self, template_name, lines):

        # Header file
        if template_name == 'enumeration.cx.h.template':
            lines = self.update_header_file(lines)

        # Source file
        elif template_name == 'enumeration.cx.cpp.template':
            lines = self.update_source_file(lines)

        return lines


    def update_header_file(self, lines):

        # Update enumeration values
        replacement_lines = self.get_value_lines()
        lines = common.file_utils.replace_lines_range('ENUM', lines, replacement_lines, indent=self.config.indent)

        # Includes
        includes = []
        header_path = self.type_mapping.context.get_include_path_relative_header(self.type_info.location.header)
        includes.append('#include "' + header_path + '"')
        includes.sort()
        lines = common.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=True)

        return lines


    def update_source_file(self, lines):

        # Binding includes
        includes = self.gather_source_binding_includes()['includes']

        # header_path = self.infer_output_file_path('struct.cx.h.template')
        # header_path = self.fixup_header_include_path(header_path)
        # includes.append('#include "' + header_path + '"')
        includes.append('#include "twitchsdk/core/cx_coreutil.h"')

        includes.sort()

        # Precompiled header
        if self.config.precompiled_header_path:
            includes.insert(0, '#include "' + self.config.precompiled_header_path + '"')

        lines = common.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

        return lines
