import abc
import imp
import os
from pprint import pprint

import common.file_utils
import common.configuration
import common.source_tools
import common.interface_utils
import cx.cx_type_generator_base


class CxInterfaceTypeGenerator(cx.cx_type_generator_base.CxTypeGeneratorBase):

    def __init__(self, binding_generator, type_mapping, type_info):
        cx.cx_type_generator_base.CxTypeGeneratorBase.__init__(self, binding_generator, type_mapping, type_info).__init__(self, binding_generator, type_mapping, type_info)

        self.fixup_base_classes()
        self.determine_virtual_methods()


    def get_template_names(self):
        return [ 'interface.cx.h.template' ]


    def fill_template(self, lines):

        lines = self.fill_template_common(lines)

        # Base class inheritance
        lines = self.fill_template_binding_base_classes(lines)

        # Create namespace scopes if needed
        lines = self.fill_template_namespace(lines)

        return lines


    def update(self, template_name, lines):

        # Forward declarations
        forward_delaration_lines = self.get_forward_declaration_lines()
        lines = common.file_utils.replace_lines_range('FORWARD_DECLARATIONS', lines, forward_delaration_lines, indent=self.config.indent, must_exist=True)

        # Binding includes
        includes_result = self.gather_header_binding_includes()
        includes = includes_result['includes']
        includes.sort()

        # Precompiled header
        if self.config.precompiled_header_path:
            includes.insert(0, '#include "' + self.config.precompiled_header_path + '"')

        lines = common.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent)

        # Fill in methods
        replacement_lines = self.get_header_binding_method_lines(self.all_methods, access_modifier=None)
        lines = common.file_utils.replace_lines_range('METHODS', lines, replacement_lines, indent=self.config.indent)

        return lines
