import abc
import argparse
import os
import imp
from pprint import pprint

import common.source_tools
import common.configuration
import common.language_binding_generator_base

import cx.cx_enum_type_generator
import cx.cx_struct_type_generator
import cx.cx_class_type_generator
import cx.cx_interface_type_generator
import cx.cx_interface_adapter_type_generator


class CxLanguageBindingGenerator(common.language_binding_generator_base.LanguageBindingGeneratorBase):

    def __init__(self, config):
        common.language_binding_generator_base.LanguageBindingGeneratorBase.__init__(self, config)

    def get_language(self):
        return 'cx'

    def get_template_dir(self):
        return os.path.realpath(os.path.dirname(__file__)) + '/templates'

    def get_type_map_path(self):
        return os.path.realpath(os.path.dirname(__file__)) + '/cx.typemap.json'

    def create_enum_generator(self, type_mapping, type_info):
        return cx.cx_enum_type_generator.CxEnumTypeGenerator(self, type_mapping, type_info)

    def create_struct_generator(self, type_mapping, type_info):
        return cx.cx_struct_type_generator.CxStructTypeGenerator(self, type_mapping, type_info)

    def create_class_generator(self, type_mapping, type_info):
        return cx.cx_class_type_generator.CxClassTypeGenerator(self, type_mapping, type_info)

    def create_interface_generator(self, type_mapping, type_info):
        return cx.cx_interface_type_generator.CxInterfaceTypeGenerator(self, type_mapping, type_info)

    def create_interface_adapter_generator(self, type_mapping, type_info):
        return cx.cx_interface_adapter_type_generator.CxInterfaceAdapterTypeGenerator(self, type_mapping, type_info)


def process_command_line(command_line_arguments):

    parser = argparse.ArgumentParser(description='Tools for generating C++/CX bindings from C++ source.')

    config = common.configuration.ConfigSettings('cx')
    config = common.configuration.process_command_line(parser, command_line_arguments, config)

    # Generate types in the destination language
    generator = CxLanguageBindingGenerator(config)
    generator.process_config()


# Parse the command line if the main script
if __name__ == "__main__":
    process_command_line(None)
