# Import standard modules
import sys
import os
import argparse
import imp
import shutil

build_dir = os.path.realpath(os.path.dirname(__file__))


def process_command_line(command_line_arguments):

    """Parses the command line for generating language bindings."""

    # First determine which target language we want to generate for
    parser = argparse.ArgumentParser(description='Generate project files for the Twitch SDK.')

    parser.add_argument(
        '--language',
        required=True,
        metavar='<language>',
        help='Specifies the language to generate bindings for.'
    )

    args, unknown = parser.parse_known_args(command_line_arguments)

    # Now that we have the language load the module for the language and run it
    language_module = imp.load_source('language', os.path.join(build_dir, args.language + '/generate.py'))
    language_module.process_command_line(command_line_arguments)


# Process the command line arguments if run as the primary script
if __name__ == "__main__":
    process_command_line(None)
