import abc
import imp
import os
from pprint import pprint

import common.file_utils
import common.configuration
import common.source_tools
import common.enum_utils
import java.java_type_generator_base



class JavaEnumTypeGenerator(java.java_type_generator_base.JavaTypeGeneratorBase):

    """
    Generate the code for exposing C++ enumerations to Java.
    The steps involved are:
      * Parse the C++ code and extract the values
      * Write the .java file for the enumeration
      * Compile the .java file to produce the .class file
      * Run javap on the .class file to extract java class info
      * Write the .h and .cpp files which expose these types to native
    """

    def __init__(self, binding_generator, type_mapping, type_info):
        java.java_type_generator_base.JavaTypeGeneratorBase.__init__(self, binding_generator, type_mapping, type_info)


    def get_template_names(self):
        return [ 'enumeration.java.template' ]


    def fill_template(self, lines):

        lines = self.fill_template_common(lines)

        # Create namespace scopes if needed
        lines = self.fill_template_namespace(lines)

        return lines


    def get_value_lines(self):

        lines = []

        for entry in self.type_info.values:

            line = entry.name + '(' + str(entry.value) + ')'

            if len(lines) < len(self.type_info.values) - 1:
                line = line + ','
            else:
                line = line + ';'

            lines.append(line)

        return lines;


    def update(self, template_name, lines):

        # Java file
        if template_name == 'enumeration.java.template':
            lines = self.update_java_file(lines)

        return lines


    def update_java_file(self, lines):

        components = self.get_target_type_name_components(self.type_mapping.target_type_name)

        # Package
        lines = common.file_utils.replace_all(lines, '<<PACKAGE>>', components['namespace'])

        # Target type name
        lines = common.file_utils.replace_all(lines, '<<TYPE_NAME>>', components['name'])

        # Enumeration values
        replacement_lines = self.get_value_lines()
        lines = common.file_utils.replace_tag_line('ENUMERATION_VALUES', lines, replacement_lines, indent=self.config.indent)

        # Custom methods
        custom_methods = self.type_mapping.load_custom_value_as_file_path('java.extra_methods', [])
        lines = common.file_utils.replace_tag_line('METHODS', lines, custom_methods, indent=self.config.indent, must_exist=False)

        return lines


    def update_header_file(self, lines):

        # Includes
        header_path = self.type_mapping.context.get_include_path_relative_header(self.type_info.location.header)
        includes = ['#include "' + header_path + '"']
        lines = common.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=True)

        # Conversion functions
        conversion_lines = self.get_header_native_conversion_lines(self.type_mapping, indentation=self.config.indent);
        lines = common.file_utils.replace_lines_range('CONVERSIONS', lines, conversion_lines, indent=self.config.indent)

        return lines


    def update_source_file(self, lines):

        # Binding includes
        includes = self.gather_source_binding_includes()['includes']

        # header_path = self.infer_output_file_path('struct.cx.h.template')
        # header_path = self.fixup_header_include_path(header_path)
        # includes.append('#include "' + header_path + '"')
        includes.append('#include "twitchsdk/core/cx_coreutil.h"')

        includes.sort()

        # Precompiled header
        if self.config.precompiled_header_path:
            includes.insert(0, '#include "' + self.config.precompiled_header_path + '"')

        lines = common.file_utils.replace_lines_range('INCLUDES', lines, includes, indent=self.config.indent, must_exist=False)

        return lines
