import abc
import argparse
import os
import imp
from pprint import pprint

import common.source_tools
import common.configuration
import common.language_binding_generator_base

import java.enum
#import java.java_simple_class_type_generator
#import java.java_class_type_generator
#import java.java_interface_type_generator
#import java.java_interface_adapter_type_generator


class JavaLanguageBindingGenerator(common.language_binding_generator_base.LanguageBindingGeneratorBase):

    def __init__(self, config):
        common.language_binding_generator_base.LanguageBindingGeneratorBase.__init__(self, config)

    def get_language(self):
        return 'java'

    def get_template_dir(self):
        return os.path.realpath(os.path.dirname(__file__)) + '/templates'

    def get_type_map_path(self):
        return os.path.realpath(os.path.dirname(__file__)) + '/typemap.xml'

    def create_enum_generator(self, type_mapping, type_info):
        return java.enum.JavaEnumTypeGenerator(self, type_mapping, type_info)

    def infer_target_type_name(self, native_type_name):

        """ Given the native type name determine an appropriate target type name. """

        components = common.native_tools.get_native_type_name_components(native_type_name)
        package = components['namespace'].replace('::', '.')

        return package + '.' + components['name']










    def infer_output_file_path(self, type_mapping, template_name):
        return type_mapping.target_type_name.replace('.', '/') + '.java';


    def fill_template(self, lines, type_mapping):
        index = type_mapping.target_type_name.rfind('.')
        package = type_mapping.target_type_name[0:index]
        name = type_mapping.target_type_name[index+1:]

        lines = file_utils.replace_all(lines, "<<PACKAGE>>", package)
        lines = file_utils.replace_all(lines, "<<TYPE_NAME>>", name)

        if type_mapping.is_abstract:
            abstract = "abstract "
        else:
            abstract= ""
        lines = file_utils.replace_all(lines, "<<ABSTRACT>>", abstract)

        base_classes = ""
        if len(type_mapping.target_base_class_mappings) > 0:
            base_classes = 'extends'
            for base in type_mapping.target_base_class_mappings:
                base_classes = base_classes + ' ' + base.target_type_name
        lines = file_utils.replace_all(lines, "<<BASE_CLASSES>>", base_classes)

        return lines


    def get_enumeration_template_names(self):
        return [ 'enumeration.java.template' ]

    def get_struct_template_names(self):
        return [ 'struct.java.template' ]

    def get_interface_template_names(self):
        return [ 'interface.java.template' ]


    def get_enumeration_lines(self, type_info):

        lines = []

        for entry in type_info.values:

            line = entry.name + "(" + str(entry.value) + ")"

            if len(lines) < len(type_info.values) - 1:
                line += ",";
            else:
                line += ";";

            lines.append(line)

        return lines;


    def get_struct_field_lines(self, type_info):

        lines = []

        for member_info in type_info.members:

            # Skip array length members since we use array objects
            if member_info.name.endswith('ArrayLength'):
                continue

            native_type_name = member_info.type_name
            is_bitfield = self.is_bitfield_member(type_info, native_type_name, member_info.name)
            is_array = self.is_array_member(member_info, type_info)
            if is_array:
                native_type_name = self.strip_rightmost_array_modifier(native_type_name)

            target_type_name = self.find_mapped_type(native_type_name)

            if is_bitfield:
                target_type_name = 'java.util.HashSet<' + target_type_name + '>'
            if is_array:
                target_type_name = target_type_name + '[]'

            #print(member_info.type_name + ' --> ' + native_type_name + ' --> ' + target_type_name)

            line = "public " + target_type_name + ' ' + member_info.name + ";"
            lines.append(line)

        return lines



def process_command_line(command_line_arguments):

    parser = argparse.ArgumentParser(description='Tools for generating Java bindings from C++ source.')

    config = common.configuration.ConfigSettings('java')
    config = common.configuration.process_command_line(parser, command_line_arguments, config)

    # Generate types in the destination language
    generator = JavaLanguageBindingGenerator(config)
    generator.process_config()


# Parse the command line if the main script
if __name__ == "__main__":
    process_command_line(None)
