import os
from graphql_tools import *

# Use this list with names of files to generate the files for. Do not include fragments, the relevant ones will be pulled automatically. Include the file extension.
files_to_generate = []

if not files_to_generate:
    print 'Error: no files to generate'
    quit()

script_dir = os.path.dirname(__file__)
sdk_root_dir = script_dir
while not os.path.isdir(os.path.join(sdk_root_dir, 'modules')):
    sdk_root_dir = os.path.join(sdk_root_dir, '..')
modules_dir = os.path.join(sdk_root_dir, 'modules')

modules = ['core']
output_base_file_name = 'queryinfo.h'

# To update gql_schema.json run the following command
# get-graphql-schema https://api.twitch.tv/gql --json -h Client-ID=14814s5qkvkpxpkts13yx44zf6jlex0 > gql_schema.json
#
# To install get-graphql-schema
# npm install -g get-graphql-schema
schema_file_path = os.path.join(script_dir, 'gql_schema.json')

for module in modules:
    source_graphql_files_dir = os.path.join(modules_dir, module, '{}_common'.format(module), 'graphql')
    header_include_path = os.path.join('twitchsdk', module, 'internal', 'graphql', 'generated')
    output_dir = None # os.path.join(modules_dir, module, '{}_common'.format(module), 'include', header_include_path)

    namespaces = ['ttv', module, 'graphql']
    indentation = '    '

    generate_graphql_query_files(schema_file_path, source_graphql_files_dir, files_to_generate, os.path.join(sdk_root_dir, 'build', 'copyright.txt'), header_include_path, output_dir, output_base_file_name, namespaces, indentation)
