# Adding Support for a New Platform

## Where to Add Support
Support for a new platform can be added into the main core repository (sdk/sdk) if it is a widely used platform.  If it is a custom or proprietary platform then a new repository should be created.

## Platform Configuration
* Add a file called ```<repo>/build/platforms/platform_<platform>.py```.  This will contain custom code that describes how to generate the projects for that platform.  See the other similar files for examples.

## Platform Fragment
* In the root of the repo that will contain the new platform, create a new fragment (a directory) called ```<repo>/modules/core/core_<platform>```.  This will contain its own ```<repo>/core_<platform>/fragment.py``` and any necessary source, includes, tests and samples.

## Project Generation
If a new repository was created for this platform then add the repository to the root paths (using `-root-dir`) or fragment search paths (`--fragments-dir`) when using the project generation scripts.

The build scripts use plugins called *generators* which actually generate the project files.  It's possible that CMake knows how to generate the projects for your platform and you won't need to do much to add support.  However, if CMake isn't sufficient then you can create your own.

## Creating a Custom Generator
* Add a new generator under ```<repo>/build/generators``` similar to what is done for cmake.
* Make sure you return a new instance of this generator in your ```<repo>/build/platforms/platform_<platform>.py```.

For examples of what the platform, generator and fragment python scripts need to contain see the existing implementations.

## Things to Keep in Mind
* *NEVER* add platform-specific defines in common code or code for unrelated platforms.  It's ok to add conditionally compiled code for variations of the platform, such as Mac vs iOS etc.
