# Architecture
This document discusses internal design details for the Twitch SDK.  See [HighLevelDesign](../HighLevelDesign.md) for a high level discussion of the SDK.


## Modules
The ```ttv::IModule``` interface must be implemented by all modules.

There is a helper base class ```ttv::ModuleBase``` which implements common things modules do and this class implements ```ttv::IModule```.

All modules which reply upon ```Core``` must register themselves via ```ttv::CoreAPI::RegisterClient()``` so that CoreAPI knows that it has clients.  Once registerd, the ```ICoreApiClient``` interface provides useful internal events to the module like user login/logout events, language changed, etc.  It also prevents ```CoreAPI``` from being shutdown before all clients have been fully shutdown.  Client modules must unregister themselves via ```ttv::CoreAPI::UnregisterClient()``` when they have finished shutting down.


## Components
```ttv::IComponent``` is the interface used to specify that an object has a lifecycle and must be shut down properly before being destroyed.  Many of the internals of the Twitch SDK are asynchronous.

```ttv::ComponentContainer``` is a helper class which manages IComponent instances and their lifecycle.


## TaskRunner
A ```ttv::TaskRunner``` manages an asynchronous queue of tasks which are run on an internal thread.  The task runner accepts anything which extends ```ttv::Task```.
