# Language Binding Generation

# Types of objects needing export to other languages

## Simple Class
* Used as a one-way marshall of values from native to the target language.
  * Examples: `UserInfo`, `LiveChatMessage`
* Created in native code, passed to the target language.
  * However, the app developer might want to be able to instantiate an instance directly in the target language for mocking, etc.
* Have no methods that can be called (in the target language).
* The native object can be destroyed after the values are marshalled to the target language.

## Proxy Class
* Created in native code or in the target language.  Can be either one depending on the usage and context.
  * Examples: `CoreAPI`, `ChatMessageHandler`
* Have methods that are callable in the target language
* The native object reference must be managed carefully by the target language
  * Some languages have garbage collection, some don't.  The thread this happens on is not guaranteed.
  * Might require target language `Dispose()` methods to clean up the underlying native object
* Requires a target language object reference in native in order to maintain the link between the proxy object and native instance.

## Lambda Proxy
* Implementation in target language of a native lambda.
  * Examples: `CoreAPI::Initialize()`
* Requires a target language object reference in native to the target language interface implementation.
* Lamdas might not be a construct in the target language.

## Interface Proxy
* Implementation in target language of a native interface.
  * Examples: `IChatChannelListener`
* Requires a target language object reference in native to the target language interface implementation.
* Requires a native implementation of the native interface that knows how to call methods in the target language.

## Enumerations
* Expose native enumerations to the target language.
* These need to be passed back and forth between native and the target language so need bidirectional marshalling.
* Not all target languages support enumerations.

## Constants
* Expose constants defined in native to the target language.
