# Process
This document describes some of the process involved when working on code in the SDK itself.


## Unit Testing
* When adding a new feature we write tests that ensure the feature works as expected and doesn't break in the future.  These tests should be submitted as part of the pull request for the feature and all tests should pass before the feature is merged into master.
* When fixing a bug the best way to isolate it is to write a test that reproduces it.  After the bug is fixed there is now a unit test that ensures a regression does not occur.


## Samples
* When adding a new feature exposed via a public API it should be added to the ```cli``` sample.  This needs to be part of the pull request for the feature.  This allows other developers to play with it and see how it works, facilitates manual testing and forces you to use your own API.


## Language Bindings
* Language bindings are generated when possible.
* If a first-party app requires language bindings it is our goal to generate and maintain them.
* We are passively writing the tools to generate:
    * Java
    * Objective-C
* Generated language binding code is generally not code reviewed unless a change to the generation script has been made.
* Depending on how many files have changed in the PR, language binding changes should be done in a branch that is based on the SDK branch that implements the feature/interface change.  If only a handful of files have changed then a separate branch is not needed.  However, if an interface change has caused many language binding files to change then it is important to keep the GitHub pull request for the feature changes isolated to facilitate reviews.  Once the feature PR is approved for merging into master the branch containing the bindings may be merged into the feature branch prior to merging the PR.


## Documentation
* When adding new features or touching old code, add/update the public documentation so that it's useful to a client.  This includes the inline documentation in public source files as well as any other documents (such as these).
