# Error Codes

Each module will define a unique id which is required to be registered with Twitch.  See [Module Registration](Development/ModuleRegistration.md) if you're authoring a new module.

An error code is a 32 bit unsigned integer of the form ```ModuleId(16) | Code(16)```.

* *ModuleId*: 15 bits to represent the module the code comes from.  This is not necessarily the source of the error.  Each module will define the value.
* *ErrorId*:  16 bits to represent the unique error id within the module.  Each module generally has an enumeration which defines them without the flag or module id.

Modules will contain an enumeration which defines all the error codes the module exports.  The value of each error follows the above format.  ```TTV_ErrorCode``` is defined as a ```uint32_t``` and is the general return code type returned from public API and callbacks.

The application should not assume the values of error codes are stable between releases of the SDK and should not hard-code values.

```TTV_SUCCEEDED(ec)``` and ```TTV_FAILED(ec)``` can be used to test the status of an error code.

See ```types/errortypes.h``` for available functions and types related to error checking.
