# High Level Design


## Modules and Fragments
The Twitch SDK is divided up into parts called *modules* and *source fragments*.  Modules are not the same as git submodules.  They are a self-contained piece of functionality like ```Core```, ```Chat```, ```Social```, etc.  Modules contain one or more source fragments.

A source fragment, or just *fragment*, is a directory containing a subset of functionality for a module.  Fragments are used to provide common code, platform-specific code, language bindings or some other slice of functionality that can be conditionally pulled in to generate projects based on intended use.  They generally contain include and source directories but may contain anything needed for the functionality, such as .java files or data.  Each fragment will have a ```fragment.py``` file describing how to pull the files in.  Each module has a common source fragment which is just the name of the module with the suffix ```_common``` (e.g. ```core_common``` for a module named ```Core```) and is always pulled into the project.

The main class of each source module implements ```ttv::IModule```.  For example, ```ttv::CoreAPI```, ```ttv::chat::ChatAPI``` and ```ttv::social::SocialAPI``` all implement IModule.  The ```IModule``` interface can be used to generically initialize, update and shutdown modules.


### Layout of a Module
A module that has the recommended structure to be compatible with the Twitch SDK project generation and build system is as follows.

```
    /
      README.md

      /dependencies
        <third-party dependencies>

      /docs
        <documentation files, like these>

      /samples
        <common sample code>

      /tests
        <common test code>

      <any number of fragment directories>

```

The fragment directories are named according to their function.  More details on fragments are below.

```Core``` is an example of a non-trivial module which has all the directories above.  In practice, most feature modules will not have or need all these directories.


### Layout of a Fragment
A fragment directory is expected to have the following structure:
```
    /
      fragment.py

      /bindings
         <any language specific files, like .java, .cs, etc.>

      /include
        <include files>

      /source
        <source files>

      /samples
        /cli
          <include>
          <source>
        <any samples specific to the fragment>

      /tests
        /unit
          /include
          /source
          /data
        <any other custom tests>

      /tools
        <tools specific to the feature or platform>
```

#### fragment.py
This is the main file that describes the contents of the fragment.  It specifies which header and source files to pull in, which libraries to link against, which preprocessor directives to define in the project, etc.

#### /include, /source
These are the source and header files that will be pulled into the generated project file.

#### /bindings
This directory contains any language-specific files that compliment the generated native library.  For example, if generating a Twitch SDK library with support for Java then the .java files would be put in this directory.

#### /samples
This directory contains the samples specific to the module.  Each sample goes in its own directory.

##### /samples/cli
There is one special sample called *cli* which is the command line interface to the Twitch SDK.  This sample is used to demonstrate and test the features of the generated library without having to build a UI for it.

#### /tests
This directory contains everything related to testing code in the fragment.

#### /tools
This directory contains any tools needed for generating code, bindings or anything else related to the fragment.

### fragment.py Structure
Each fragment directory is expected to contain a fragment.py python script in the root.  The file can contain any of the following optional functions.

####```load_library_fragment(primitives, options)```
Returns a ```build_types.SourceFragment``` instance containing all the parts needed to include the fragment in the generation of the library.

####```load_unittest_fragment(options)```
Returns a ```build_types.SourceFragment``` instance containing all the parts needed to include the fragment in the generation of the unit test executable.

####```load_sample_fragment(sample_name, options)```
Returns a ```build_types.SourceFragment``` instance containing all the parts needed to include the fragment in the generation of the named sample.


## Platform-Primitives and Services
See [Usage](Usage.md) for information on primitives and services.
