# Samples
The ```/samples``` directory contains the common files to be used in the various samples provided in modules.  When generating sample projects be sure you don't specify any modules that you did not specify when generating the library or you will come across linking errors.

## cli
The cli sample is a command line interface to the Twitch SDK library.  It is used primarily for testing and tinkering to see how it works.  Selected fragments which contain a ```samples/cli``` directory will have their source pulled into the generated cli project.

### Project generation examples
These examples assume you have the following command line variables set:
* ```OUTPUT_DIR```: The location you want to output the generated sample project files.
* ```SDK_DIR```: The location you used to output the project files for the sdk library.

#### Windows
This will generate an x86 Visual Studio 2012 project that pulls in ``Core```, ```Chat``` and ```Social```.  This assumes you've already generated the Twitch SDK project and it is located at `$SDK_DIR`.
```
python generate_sample.py --sample=cli --module=core --module=chat --module=social --platform=win32 --compiler=vs2012 --arch=x86 --output-dir=%OUTPUT_DIR% --project-name=sample_cli --twitchsdk-dir=%SDK_DIR%
```

#### Mac OS X
This will generate an x64 Xcode project for Mac OS X that pulls in ```Core```, ```Chat``` and ```Social```.  This assumes you've already generated the Twitch SDK project and it is located at `$SDK_DIR`.
```
python generate_sample.py --sample=cli --module=core --module=chat --module=social --platform=darwin --compiler=xcode --arch=x64 --output-dir=$OUTPUT_DIR --project-name=sample_cli --twitchsdk-dir=$SDK_DIR
```

#### iOS
This will generate an x64 Xcode project for iOS that pulls in ``Core```, ```Chat``` and ```Social```.  This assumes you've already generated the Twitch SDK project and it is located at `$SDK_DIR`.

```
python generate_sample.py --sample=cli --module=core --module=chat --module=social --platform=darwin --compiler=xcode --target=ios --arch=x64 --output-dir=$OUTPUT_DIR --project-name=sample_cli --twitchsdk-dir=$SDK_DIR
```

There is also some manual configuration of the generated project to get the sample running.
* Add a script file containing the commands you want to run under `Resources`
* Add a new `Copy Bundle Resource` `Build Phase` and add the script file above
* Set bundle identifier to `cli`
* Under `Edit Scheme` add an `Argument Passed On Launch` that is the name of the script file
* Setup the provisioning profile as necessary

### Adding New Commands
When adding a new module you can add support for it to the cli sample.

Any fragment that contains commands should put them under ```<fragment_dir>/samples/cli```.  This directory should contain the following directory structure.

```
    /source
        <source files>
```

By default, the ```load_sample_fragment``` function in ```fragment.py``` for the fragment contains code that knows how to pull in the source.  See ```modules/core/core_common/fragment.py``` for an example.

Follow the code in ```modules/chat/chat_common/samples/cli/source/chatcli.cpp``` to see how to add commands for your new module.


## Adding New Samples
Samples are generally arbitrary projects with arbitrary source code.  You can use the same approach as is used for the cli sample.  Your new sample may or may not be platform-specific so details on organization are up to you.  Add common sample files to ```<module_path>/samples/<sample_name>``` or ```<module_path>/<module_name>/samples/<sample_name>``` depending on if it's a cross-module sample or not.  Platform-specific source files for the sample should be put under the appropriate fragment, such as ```<module_path>/<module_name>_win32/samples/<sample_name>``` for ```win32``` support.

NOTE: Arbitrary sample generation hasn't been fully tested and may have issues.  Report them if any are found.
