# Tests
The ```/tests``` directory contains the common files and data needed by the testing code implemented in modules.  When generating tests projects be sure you don't specify any modules that you did not specify when generating the library or you will come across linking errors.

## Unit Tests
The ```modules/core/tests/unit``` module directory contains the common files that to be used by all unit tests provided in modules.

### Project generation examples
These examples assume you have the following command line variables set:
* ```OUTPUT_DIR```: The location you want to output the generated test project files.
* ```SDK_DIR```: The location you used to output the project files for the sdk library.

#### Windows
This will generate an x86 Visual Studio 2012 project that pulls in ```Core```, ```Chat``` and ```Social```.  This example assumes you've already generated the Twitch SDK project and it is located at C:/windows_output.
```
python generate_test.py --test=unit --module=core --module=chat --module=social --platform=win32 --compiler=vs2012 --arch=x86 --output-dir=%OUTPUT_DIR% --project-name=myunittests --twitchsdk-dir=%SDK_DIR%
```

#### Mac OS X
This will generate an x64 Xcode project for Mac OS X that pulls in ```Core```, ```Chat``` and ```Social```.  This assumed you've already generated the Twitch SDK project and it is located at ~/Documents/Output/mac_output
```
python generate_test.py --test=unit --module=core --module=chat --module=social --platform=darwin --compiler=xcode --arch=x64 --output-dir=$OUTPUT_DIR --project-name=myunittests --twitchsdk-dir=$SDK_DIR
```

### Running the Unit Tests
When running the unit tests be sure to set the working directory to be $SDK_DIR/data.


## Adding New Unit Tests
[Google Test](https://github.com/google/googletest) is used to power the unit tests.  A static version is checked into ```Core``` to reduce the number of dependencies needed to get up and running quickly.

Any fragment that contains unit tests should put them under ```<fragment_dir>/tests/unit```.  This directory should contain the following directory structure.

```
    /data
        <optional, any data needed by the tests, such as HTTP response bodies, etc>
    /include
        <include files>
    /source
        <source files>

```

By default, the ```load_unittest_fragment``` function in ```fragment.py``` for the fragment contains code that knows how to pull in these 3 directories.  See ```modules/core/core_common/fragment.py``` for an example.

In terms of adding the new tests, simply adding test cases to unit test source files in the fragment is sufficient to have them pulled in and run automatically.


## Adding Other Kinds of Tests
Tests other than unit tests are not yet handled.  Support for this can be added as needed.
