# Twitch SDK Usage

The generated library exposes two simple functions which take care of initialization and shutdown of the SDK primitives:

* ```TTV_ErrorCode TTV_InitializeLibrary()```
* ```TTV_ErrorCode TTV_ShutdownLibrary()```

If the application requires a versions string for the library the following function is exported:

* ```const char* TTV_GetVersionString()```

At a high level, the application should use the generated library as follows:

* Add the Twitch SDK library project to you header search paths
* ```#include "library.h"``` from your project source
* Call ```TTV_InitializeLibrary()```
* Register any custom primitive factories and services that the application wants to provide, such as sockets and HTTP services (see below for more information)
* Create and initialize ```CoreAPI```
* Create and initialize feature modules such as ```ChatAPI``` or ```SocialAPI```
* ... use the modules as needed according to their documentation ...
* Shutdown all feature modules in the reverse order they were initialized
* Shutdown ```CoreAPI```
* Unregister application provided primitives
* Call ```TTV_LibraryShutdown()```

For more information on implementing primitives and services directly in your application see below.


# Platform support
The goal of the Twitch SDK is to provide support for common platforms.  The following are supported out of the box:
* Windows
* OSX
* iOS
* Android

If you need support for some other platform then support will need to be added to core.


# Language bindings
See [LanguageBindings](LanguageBindings.md) for information about using the SDK with languages other than C++.


# Building the Twitch SDK
The ```/build``` directory contains custom Twitch SDK build generation scripts are used to allow developers to conveniently generate platform-specific projects that contain exactly the set of features that they need for their product.  Once the project files are generated you can use the native IDE to build and debug the Twitch SDK library.

See [Build](Build.md) for details on generating project files and building for specific platforms.


## Platform-Specific Primitives and Services
If you use the project and library generation tools in ```core/build``` then you don't usually need to register primitive factories and services yourself.  If you're providing a custom implementation of any of these services then you will need to register them before initializing any modules in the SDK.  The most common ones to provide are factories for ttv::ISocket and ttv::IWebSocket and a custom ttv::HttpRequest.  This allows the application better control over networking.

Language bindings will also expose some means of providing some service implementations via the ```Library``` object of the language.  See [LanguageBindings](LanguageBindings.md) for more information.

### ttv::ITracer
* A singleton which performs logging.
* Register via ```ttv::SetTracer(obj)```
* Unregister via ```ttv::SetTracer(nullptr)```
* ```#include "twitchsdk/core/tracer.h"```

### ttv::ISystemClock
* A singletone which provides time services.
* Register via ```ttv::SetSystemClock(obj)```
* Unregister via ```ttv::SetSystemClock(nullptr)```
* ```#include "twitchsdk/core/systemclock.h"```

### ttv::HttpRequest
* A singleton which provides HTTP(s) services.
* Register via ```ttv::SetHttpRequest(obj)```
* Unregister via ```ttv::SetHttpRequest(nullptr)```
* ```#include "twitchsdk/core/httprequest.h"```

### ttv::IMutexFactory
* Creates instances of ttv::IMutex and ttv::IConditionMutex.
* Register via ```ttv::SetMutexFactory(obj)```
* Unregister via ```ttv::SetMutexFactory(nullptr)```
* ```#include "twitchsdk/core/mutex.h"```

### ttv::IThreadApi
* A singleton which performs thread actions.
* Register via ```ttv::SetThreadApi(obj)```
* Unregister via ```ttv::SetThreadApi(nullptr)```
* ```#include "twitchsdk/core/thread.h"```

### ttv::IThreadFactory
* Creates instances of ttv::IThread.
* Register via ```ttv::SetThreadFactory(obj)```
* Unregister via ```ttv::SetThreadFactory(nullptr)```
* ```#include "twitchsdk/core/thread.h"```

### ttv::IThreadSyncFactory
* Creates instances of ttv::IThreadSync.
* Register via ```ttv::SetThreadSyncFactory(obj)```
* Unregister via ```ttv::SetThreadSyncFactory(nullptr)```
* ```#include "twitchsdk/core/threadsync.h"```

### ttv::ISocketFactory
* Creates socket instances of ttv::ISocket.
* Multiple factories can be registered to handle different protocols or URLs.
* Register via ```ttv::RegisterSocketFactory(obj)```
* Unregister via ```ttv::UnregisterSocketFactory(obj)```
* ```#include "twitchsdk/core/socket.h"```

### ttv::IWebSocketFactory
* Creates socket instances of ttv::IWebSocket.
* Multiple factories can be registered to handle different protocols or URLs.
* Register via ```ttv::RegisterWebSocketFactory(obj)```
* Unregister via ```ttv::UnregisterWebSocketFactory(obj)```
* ```#include "twitchsdk/core/socket.h"```

### ttv::IMainEventSchedulerFactory
* Creates instances of ttv::IEventScheduler to be used as main event schedulers.
* Register via ```ttv::RegisterMainEventSchedulerFactory(obj)```
* Unregister via ```ttv::UnregisterMainEventSchedulerFactory(obj)```
* ```#include "twitchsdk/core/eventscheduler.h"```

### ttv::IBackgroundEventSchedulerFactory
* Creates instances of ttv::IEventScheduler to be used as background event schedulers.
* Register via ```ttv::RegisterBackgroundEventSchedulerFactory(obj)```
* Unregister via ```ttv::UnregisterBackgroundEventSchedulerFactory(obj)```
* ```#include "twitchsdk/core/eventscheduler.h"```
