import argparse
import os
import subprocess
import sys


# we should move message logging to a shared module for jenkins tests
class TestHarness:
    test_name = ''
    test_step_name = ''

    def __init__(self, test_name):
        self.test_name = test_name

    def Log(self, tag, message=''):
        additional = [self.test_name, self.test_step_name]
        print '[' + tag + '] ' + ''.join([
            '{{{}}} '.format(s) for s in list(filter(None, additional))
        ]) + message

    def StartTest(self):
        self.Log('TEST STARTED')

    def TestSuccess(self):
        self.Log('TEST SUCCESS')
        self.test_name = ''

    def TestFail(self):
        self.Log('TEST FAIL')
        self.test_name = ''

    def StartStep(self, test_step_name):
        self.test_step_name = test_step_name
        self.Log('TEST STEP STARTED')

    def StepSuccess(self):
        self.Log('TEST STEP SUCCESS')
        self.test_step_name = ''

    def StepFail(self):
        self.Log('TEST STEP FAIL')
        self.test_step_name = ''

    def LogInfoMessage(self, message):
        self.Log('INFO', message)

    def LogWarningMessage(self, message):
        self.Log('WARNING', message)

    def LogErrorMessage(self, message):
        self.Log('ERROR', message)


def run_command(input, split=True):
    process = subprocess.Popen(input, stdout=subprocess.PIPE)
    stdout, stderr = process.communicate()
    if process.returncode != 0:
        sys.exit(process.returncode)
    if split == True:
        return stdout.splitlines()
    else:
        return stdout


test_harness = TestHarness('ClangFormat')
test_harness.StartTest()

# set path to current file
os.chdir(os.path.dirname(os.path.realpath(__file__)))

# we can now run git to get root path and set it as our new working path
os.chdir(run_command(['git', 'rev-parse', '--show-toplevel'], True)[0])

files = run_command(
    [sys.executable, './tools/clang/clang-format-git-files.py', '--all'], True)

has_error = False
for f in files[1:]:
    diff_output = run_command(['git', 'diff', '-U0', '--no-color', f], False)
    if diff_output:
        has_error = True
        test_harness.LogErrorMessage('Replacements Needed' + os.linesep +
                                     diff_output)

if has_error:
    test_harness.TestFail()
    sys.exit(1)

test_harness.TestSuccess()
sys.exit(0)
