// Modified from https://git.xarth.tv/release/jenkins-jobs/blob/master/templates/autobuild.groovy
job('TEMPLATE-platforms-sdk-common') {
    concurrentBuild true
    configure { project ->
        project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
        project / publishers / 'org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter' {
            commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource")
            reposSource(class: "org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource")
            contextSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource")
            statusResultSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource")
        }
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }
}


// The regular job that picks up commits in branches
job('platforms-sdk-format-test') {
    label 'platforms-tvapps-windows'
    using 'TEMPLATE-platforms-sdk-common'
    triggers {
        githubPush()
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'sdk/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        batchFile 'python %WORKSPACE%\\jenkins\\clang-format-test.py'
    }
}


// The regular job that picks up commits in branches
job('platforms-sdk-win32-build-commit') {
    label 'platforms-tvapps-windows'
    using 'TEMPLATE-platforms-sdk-common'
    triggers {
        githubPush()
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'sdk/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        batchFile 'python %WORKSPACE%\\jenkins\\build.py --build-type=commit --platform=win32'
    }
}


// The full nightly build

// This test currently does not work, fails
// job('platforms-sdk-win32-build-nightly') {
//     label 'platforms-tvapps-windows'
//     using 'TEMPLATE-platforms-sdk-common'
//     triggers {
//         cron('0 0 * * *')
//     }
//     wrappers {
//         credentialsBinding {
//             file('COURIERD_PRIVATE_KEY', 'courierd')
//             file('AWS_CONFIG_FILE', 'aws_config')
//             string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
//             string 'AWS_SECRET_KEY', 'dta_tools_deploy'
//         }
//     }
//     scm {
//         git {
//             remote {
//                 github 'sdk/sdk', 'ssh', 'git.xarth.tv'
//                 credentials 'git-aws-read-key'
//             }
//             branches('master')
//             clean true
//         }
//     }
//     steps {
//         batchFile 'python %WORKSPACE%\\jenkins\\build.py --build-type=nightly --platform=win32'
//     }
// }


// A manually triggered build of a specific branch
job('platforms-sdk-win32-build-release') {
    label 'platforms-tvapps-windows'
    using 'TEMPLATE-platforms-sdk-common'
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'sdk/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
    }
}


// The regular job that picks up commits in branches
// job('platforms-sdk-commit-build-osx') {
//     using 'TEMPLATE-autobuild'
//     scm {
//         git {
//             remote {
//                 github 'sdk/sdk', 'ssh', 'git.xarth.tv'
//                 credentials 'git-aws-read-key'
//             }
//             clean true
//         }
//     }
//     steps {
//         shell 'echo 1dad'
//     }
// }


// // The full nightly build
// job('platforms-sdk-nightly-build-osx') {
//     using 'TEMPLATE-autobuild'
//     scm {
//         git {
//             remote {
//                 github 'sdk/sdk', 'ssh', 'git.xarth.tv'
//                 credentials 'git-aws-read-key'
//             }
//             clean true
//         }
//     }
//     steps {
//         shell 'echo 1dad'
//     }
// }
