/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include <stdint.h>

#include <map>
#include <string>
#include <vector>

namespace ttv {
namespace ads {
enum class TrackingEventType {
  Unknown,

  CreativeView,
  Start,
  FirstQuartile,
  Midpoint,
  ThirdQuartile,
  Complete,
  Mute,
  Unmute,
  Pause,
  Rewind,
  Resume,
  Fullscreen,
  ExitFullscreen,
  Expand,
  Collapse,
  AcceptInvitation,
  Close,
  Skip,
  Progress
};

struct MediaFile {
  MediaFile() : height(0), width(0), bitrate(0), maintainAspectRatio(false), scalable(false) {}

  std::string resourceUrl;
  std::string type;
  std::string delivery;
  std::string identifier;
  uint32_t height;
  uint32_t width;
  uint32_t bitrate;
  bool maintainAspectRatio;
  bool scalable;
};

struct LinearCreative {
  LinearCreative() : durationSeconds(0) {}

  std::string clickThroughUrl;
  std::vector<std::string> clickTrackingUrls;
  std::vector<MediaFile> mediaFiles;
  std::map<TrackingEventType, std::vector<std::string>> trackingEventUrls;
  std::string adParametersString;
  uint32_t durationSeconds;
};

struct CompanionCreative {
  CompanionCreative() : height(0), width(0) {}

  std::string identifier;
  std::string creativeType;
  std::string resourceUrl;
  std::map<TrackingEventType, std::vector<std::string>> trackingEventUrls;
  uint32_t height;
  uint32_t width;
};

struct Impression {
  std::string identifier;
  std::string resourceUrl;
};

enum class AdPosition { Undefined = 0, Preroll = 1, Midroll = 2, Postroll = 3 };

enum class ContentMode { Live, Vod, Playlist, VodCast };

struct AdFetchRequestInfo {
  AdFetchRequestInfo()
      : contentMode(ContentMode::Live),
        channelId(0),
        lengthInSeconds(0),
        position(AdPosition::Preroll),
        mature(false),
        live(true) {}

  std::string source;
  std::string channelName;
  std::string game;
  std::string vodType;
  std::string vodName;
  std::string vodID;
  std::string ppid;
  ContentMode contentMode;
  ChannelId channelId;
  uint32_t lengthInSeconds;
  AdPosition position;
  bool mature;
  bool live;
};

struct Ad {
  Ad() : sequenceNumber(0) {}

  std::string identifier;
  std::string adSystem;
  std::string adTitle;
  std::string adDescription;
  std::vector<Impression> impressions;
  std::vector<LinearCreative> linearCreatives;
  std::vector<CompanionCreative> companionCreatives;
  std::vector<std::string> errorUrls;
  uint32_t sequenceNumber;
};

struct AdConfiguration {
  std::string languageCode;
  std::string userAgentString;
  std::string adUnit;
  std::string adTrackingIdentifer;
  std::string platform;
  /**
   * This list will be used to filter the media types of the ads.  If empty, no filter wil be applied.
   * For example, if you only support mp4 playback then add "video/mp4" to the list of filters.
   */
  std::vector<std::string> mediaTypeFilters;
};
}  // namespace ads
}  // namespace ttv
