/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include <stdint.h>
#include <string.h>

#include <algorithm>
#include <array>
#include <cassert>
#include <functional>
#include <list>
#include <map>
#include <memory>
#include <string>
#include <vector>

#if TTV_INCLUDE_CPPTRANSITIONS
#include "twitchsdk/core/cpp11transition.h"
#endif

#include "twitchsdk/core/assertion.h"
#include "twitchsdk/core/tracer.h"
#include "twitchsdk/core/types/coretypes.h"

namespace ttv {
namespace ads {
enum class AdError {
  None = 0,

  XMLParseError = 100,
  VASTSchemaValidationError = 101,
  VASTUnsupportedVersion = 102,

  TraffickingError = 200,  // Video player received an Ad type that it was not expecting and/or cannot display.
  UnexpectedLinearity = 201,
  UnexpectedDuration = 202,
  UnexpectedSize = 203,

  WrapperError = 300,      // General wrapper error
  WrapperFailed = 301,     // Fetching wrapper failed or timed out
  WrapperDepth = 302,      // Ad wrappers redirected too many times
  WrapperNoAdFound = 303,  // Ad wrappers never resolved to an actual ad.

  LinearError = 400,  // General linear ad error
  MediaFileNotFound = 401,
  MediaFileTimedout = 402,
  MediaFileIncompatible = 403,  // No compatible media files were found
  MediaFileUnplayable = 405,    // Playback of video failed

  NonLinearAdsError = 500,               // General non-linear ad error
  NonLinearIncompatibleDimension = 501,  // Non-linear with these dimensions is not displayable by the client
  NonLinearResourceFetchFailed = 502,
  NonLinearIncompatibleType = 503,

  CompanionAdsError = 600,
  CompanionIncompatibleDimension = 601,  // Companion with these dimensions is not displayable by the client
  CompanionDisplayError = 602,
  CompanionResourceFetchFailed = 603,

  UndefinedError = 900,  // Generic error, if none of the others fit
  VPAIDError = 901,      // Errors related to VPAID framework

  AdFetchFailed = 1000
};
}
}  // namespace ttv
