#pragma once

#include "twitchsdk/ads/adtypes.h"
#include "twitchsdk/ads/internal/vastparser.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace ads {
class FetchAdsTask;
}
}  // namespace ttv

class ttv::ads::FetchAdsTask : public ttv::HttpTask {
 public:
  struct Context {
    Context() : initialRequest(true) {}

    bool RequiresIteration() const {
      return initialRequest || !adWrappers.empty() || !errorUrls.empty() || !playlistUrls.empty();
    }

    AdConfiguration config;
    AdFetchRequestInfo info;
    std::vector<Ad> ads;
    std::vector<AdWrapper> adWrappers;
    std::vector<std::string> errorUrls;
    std::vector<std::string> playlistUrls;
    bool initialRequest;
  };

  using Callback = std::function<void(FetchAdsTask* source, TTV_ErrorCode ec)>;

 public:
  FetchAdsTask(const std::shared_ptr<Context>& context, const Callback& callback);

  void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "FetchAdsTask"; }
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ResponseCallback(uint statusCode, const std::vector<char>& response) override;

 private:
  enum class RequestType { Initial, Error, Playlist, Wrapper };

  std::string GenerateUrl();

  Callback mCallback;
  std::shared_ptr<Context> mContext;
  AdWrapper mActiveWrapper;  // Valid when mRequestType == Wrapper
  RequestType mRequestType;
};
