#pragma once

#include "twitchsdk/ads/adtypes.h"
#include "twitchsdk/ads/internal/vastparser.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/task/task.h"

#include <map>

namespace ttv {
namespace ads {
class ReportAdEventTask;
}
}  // namespace ttv

class ttv::ads::ReportAdEventTask : public ttv::HttpTask {
 public:
  using Callback = std::function<void(ReportAdEventTask* source, TTV_ErrorCode ec)>;

 public:
  ReportAdEventTask(const std::string& adUrlTemplate, const std::map<std::string, std::string>& macroSubstitutions,
    const std::string& adUserAgent, const Callback& callback);

  void OnComplete() override;

 protected:
  virtual const char* GetTaskName() const override { return "FetchAdsTask"; }
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

 private:
  std::string mUrl;
  std::string mAdUserAgent;
  Callback mCallback;
};
