/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/ads/adtypes.h"

#include <string>
#include <vector>

namespace ttv {
namespace ads {
struct AdWrapper {
  AdWrapper() : depth(0) {}

  std::string nextTagUrl;
  std::vector<Impression> impressions;
  std::vector<std::string> errorUrls;
  std::map<TrackingEventType, std::vector<std::string>> linearTrackingEventUrls;
  std::vector<std::string> linearClickTrackingUrls;
  std::vector<CompanionCreative> companionCreatives;

  uint8_t depth;
};

AdError ParseVASTResponse(const std::string& responseData, std::vector<Ad>& inlineAds,
  std::vector<AdWrapper>& adWrappers, std::vector<std::string>& playlistUrls);
AdError ParseVASTResponseFromWrapper(const std::string& responseData, std::vector<Ad>& inlineAds,
  std::vector<AdWrapper>& adWrappers, AdWrapper& parentWrapper);
}  // namespace ads
}  // namespace ttv
