/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/ads/internal/pch.h"

#include "twitchsdk/ads/internal/task/reportadeventtask.h"

#include "twitchsdk/ads/internal/stringutil.h"

namespace {
using namespace ttv;
using namespace ttv::ads;
}  // namespace

ttv::ads::ReportAdEventTask::ReportAdEventTask(const std::string& adUrlTemplate,
  const std::map<std::string, std::string>& macroSubstitutions, const std::string& adUserAgent,
  const Callback& callback)
    : HttpTask(nullptr, nullptr, nullptr),
      mUrl(SubstituteMacrosInUrl(adUrlTemplate, macroSubstitutions)),
      mAdUserAgent(adUserAgent),
      mCallback(callback) {
  ttv::trace::Message("ReportAdEventTask", MessageLevel::Info, "ReportAdEventTask created");
}

void ttv::ads::ReportAdEventTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  requestInfo.url = mUrl;
  requestInfo.httpReqType = HTTP_GET_REQUEST;

  if (!mAdUserAgent.empty()) {
    requestInfo.requestHeaders.emplace_back("User-Agent", mAdUserAgent);
  }
}

void ttv::ads::ReportAdEventTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mTaskStatus.ec);
  }
}
