/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/sdkbasetest.h"
#include "twitchsdk/ads/adsapi.h"
#include "twitchsdk/core/coreapi.h"

namespace ttv {
namespace ads {
namespace test {
class AdsApiTest;
}
}  // namespace ads
}  // namespace ttv

class ttv::ads::test::AdsApiTest : public ttv::test::SdkBaseTest {
 public:
 protected:
  AdsApiTest();
  virtual ~AdsApiTest();

  virtual void SetUpComponents() override;
  virtual void SetUpStubs() override;

  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::ads::AdsAPI> mAdsApi;
};
