/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/adsapitest.h"

#include "testutilities.h"

using namespace ttv;
using namespace ttv::ads;

ttv::ads::test::AdsApiTest::AdsApiTest() : mCoreApi(std::make_shared<CoreAPI>()), mAdsApi(std::make_shared<AdsAPI>()) {}

ttv::ads::test::AdsApiTest::~AdsApiTest() {}

void ttv::ads::test::AdsApiTest::SetUpComponents() {
  ttv::test::SdkBaseTest::SetUpComponents();

  ttv::test::InitializeModule(mCoreApi);
  mAdsApi->SetCoreApi(mCoreApi);
  ttv::test::InitializeModule(mAdsApi);

  AddModule(mCoreApi);
  AddModule(mAdsApi);
}

void ttv::ads::test::AdsApiTest::SetUpStubs() {
  ttv::test::SdkBaseTest::SetUpStubs();
}
