##########################################################################################################
#
# Fragment: broadcast_common
#
##########################################################################################################

import glob
import os
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'broadcast_common', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp'], 'Source Files/broadcast/common')
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/common')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include'), is_public=True )

    # Precompiled header
    fragment.set_precompiled_header(
        os.path.join('twitchsdk', 'broadcast', 'internal', 'pch.h'),
        os.path.join(fragment.root_path, 'source', 'pch.cpp') )

    return fragment


def load_unittest_fragment(options):
    fragment = build_types.TestSourceFragment('unittest', 'broadcast_common', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'tests/unit/source', ['.cpp'], 'Source Files/broadcast/tests/common')
    build_tools.add_source_files_recursively(fragment, 'tests/unit/include', ['.h'], 'Header Files/broadcast/tests/common')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'tests', 'unit', 'include') )
    fragment.add_header_search_paths( os.path.join(options.gtest_path, 'include') )

    # Test data
    fragment.glob_test_data('broadcast', os.path.join(fragment.root_path, 'tests', 'unit', 'data', 'broadcast', '*.*'))

    return fragment


def load_sample_fragment(sample_name, options):
    fragment = build_types.SampleSourceFragment(sample_name, 'broadcast_common', os.path.dirname(os.path.realpath(__file__)))

    # Add source and header files
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/source', ['.cpp'], 'Source Files/broadcast/samples/' + sample_name + '/common')
    build_tools.add_source_files_recursively(fragment, 'samples/' + sample_name + '/include/twitchsdk/broadcast', ['.h'], 'Header Files/broadcast/samples/' + sample_name + '/common')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'samples', sample_name, 'include') )

    return fragment
