/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/iaudiocapture.h"

namespace ttv {
namespace broadcast {
class AudioCaptureBase;
class IAudioMixer;
}  // namespace broadcast
}  // namespace ttv

/**
 * Common functionality needed by most IAudioCapture implementations.
 */
class ttv::broadcast::AudioCaptureBase : public IAudioCapture {
 public:
  AudioCaptureBase();

 public:
  // IAudioCapture implementation
  virtual void SetAudioMixer(const std::shared_ptr<IAudioMixer>& mixer) override;
  virtual bool GetMuted() const override;
  virtual void SetMuted(bool muted) override;
  virtual void SetAudioLayer(AudioLayerId layer) override;
  virtual AudioLayerId GetAudioLayer() const override;
  virtual void SetInitialTime(uint64_t initialTime) override;

  virtual TTV_ErrorCode Initialize() override;
  virtual TTV_ErrorCode Start() override;
  virtual TTV_ErrorCode Stop() override;
  virtual TTV_ErrorCode Shutdown() override;

  // Helper functions to convert between system time and sample time.
  static uint64_t SamplesToSystemTime(uint64_t samples, uint32_t sampleRate);
  static uint64_t SystemTimeToSamples(uint64_t time, uint32_t sampleRate);

 protected:
  std::shared_ptr<IAudioMixer> mAudioMixer;
  AudioLayerId mAudioLayer;
  uint64_t mInitialSysTime;
  bool mMuted;
  bool mInitialized;
  bool mStarted;
};
