/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/broadcast/iaudioframereceiver.h"

#include <functional>

namespace ttv {
namespace broadcast {
class AudioFrame;
}
}  // namespace ttv

/**
 * The container for audio data to be encoded.  This class will be extended to hold implementation-specific data.
 */
class ttv::broadcast::AudioFrame {
 public:
  using UnlockFunc = std::function<void()>;

 public:
  virtual ~AudioFrame();

  void SetTimeStamp(uint64_t timeStamp) { mTimeStamp = timeStamp; }
  uint64_t GetTimeStamp() const { return mTimeStamp; }

  void SetAudioFormat(AudioFormat format) { mAudioFormat = format; }
  AudioFormat GetAudioFormat() const { return mAudioFormat; }

  void SetNumChannels(uint32_t numChannels) { mNumChannels = numChannels; }
  uint32_t GetNumChannels() const { return mNumChannels; }

  void SetSampleRateHz(uint32_t rate) { mSampleRateHz = rate; }
  uint32_t GetSampleRateHz() const { return mSampleRateHz; }

  /**
   * Returns the type id of the receiver that packaged the AudioFrame.
   */
  IAudioFrameReceiver::ReceiverTypeId GetReceiverTypeId() const { return mReceiverTypeId; }

 protected:
  AudioFrame(IAudioFrameReceiver::ReceiverTypeId receiverTypeId);

  void SetUnlockCallback(UnlockFunc callback) { mUnlockCallback = callback; }

 private:
  UnlockFunc mUnlockCallback;
  IAudioFrameReceiver::ReceiverTypeId mReceiverTypeId;
  AudioFormat mAudioFormat;
  uint64_t mTimeStamp;
  uint32_t mNumChannels;
  uint32_t mSampleRateHz;
};
